/*
 ******************************************************************************
 *
 *	ParcPlace Systems, Inc.
 *	Copyright (c) 1990, ParcPlace Systems, Inc. USA   All rights reserved.
 *
 ****************************************************************************
 *
 *	File:	mlttxt.H
 *
 *	Functions(s):
 *
 *	Description:
 *		OI_multi_text class header
 *
 *	RCSid = "$Id: mlttxt.H,v 4.26.1.1 1993/06/01 22:55:29 mth Exp $"
 *
 ****************************************************************************
 */

#ifndef OI_mlttxt_H
#define OI_mlttxt_H

#ifndef OI_bastxt_H
#include <OI/bastxt.H>
#endif /* OI_bastxt_H */

	// class forward reference declarations
	class	OI_mdl_multi_text;
	class	OI_tabstops;

#define	OI_MT_DEF_NCHAR	80	/* default # chars per line initially */

 /* ctl_bits private bits */
#define		OI_MULTI_TEXT_IN_CONSTRUCTOR	0x1	/* 1 => in constructor for this object */
#define		OI_MULTI_TEXT_KB_INPUT		0x2	/* 1 => keyboard input (modification of data) allowed */
#define		OI_MULTI_TEXT_PAINT_BEVEL	0x4	/* 1 => bevel needs to be painted */
#define		OI_MULTI_TEXT_MOUSE_SELECT	0x8	/* 1 => doing a mouse select */
#define		OI_MULTI_TEXT_DRAG_CURSOR	0x10	/* 1 => move the caret during drag operations */
#define		OI_MULTI_TEXT_PEND_DELETE	0x20	/* 1 => pending delete is active */
#define		OI_MULTI_TEXT_INACT_CURSOR	0x40	/* 1 => show an inactive cursor */
#define		OI_MULTI_TEXT_USER_MODIF	0x80	/* 1 => user action has modified the text */
#define		OI_MULTI_TEXT_PROG_MODIF	0x100	/* 1 => program action has modified the text */
#define		OI_MULTI_TEXT_CLICK_SELECT	0x200	/* 1 => selection by multiple click allowed */
#define		OI_MULTI_TEXT_WRAP		0x8000	/* 1 => wrap at right margin */

	struct	OI_select_coord {
			long		coord;		/* (lin,col) coord for select: -1 => none */
			OI_number	lin;		/* line psn for select: 0 => 1st line */
			OI_number	col;		/* column psn for select 0 => 1st column */
			OI_number	chr;		/* char psn for select 0 => 1st char */
	};

	class OI_multi_text : public OI_base_text {
	 private:
			OI_mdl_multi_text	*mdl_dep ;	/* ptr to model dependent aspects of object */
			unsigned long	ctl_bits ;		/* object specific control bits */
	 protected:
			OI_line		*txtbufp ;	/* ptr to vector of max_lin line descriptors */
			OI_number	max_lin ;	/* max # lines in txtbufp */
			OI_number	max_c ;		/* default max # chars for line */
			OI_number	n_lin ;		/* # active lines in txtbufp */
			OI_number	n_lin_nc_max ;	/* # lines with nc_max chars */
			OI_number	nc_max ;	/* # characters in longest line */
			OI_number	n_lin_pix_max ;	/* # lines with pix_max pixels */
			OI_number	pix_max ;	/* # pixels in longest line */
			OI_number	vw_n_lin ;	/* # lines in viewport */
			OI_number	vw_n_chr ;	/* # chars in viewport */
			OI_number	vw_n_pix ;	/* # pixels in viewport */
			OI_number	nom_vw_n_lin ;	/* nominal # lines in viewport */
			OI_number	nom_vw_n_chr ;	/* nominal # chars in viewport */
			OI_number	ulcwf_lin ;	/* logical origin of line at upper left corner of window, 0-n_lin */
			OI_number	ulcwf_chr ;	/* logical origin of char at upper left corner of window, 0-nc_max */
			OI_number	ulcwf_pix ;	/* logical origin of pixel at upper left corner of window */
			OI_tabstops	*tabs ;		/* horizontal tabs information */
			OI_number	psn_lin ;	/* line cursor is on, 0-n_lin */
			OI_number	psn_chr ;	/* char cursor is on, 0-lp->len */
			OI_number	psn_col ;	/* column cursor is on, 0-lp->exp_len */
			OI_number	psn_pix ;	/* pixel cursor is on, 0-lp->txtp->width() */
			OI_number	ref_col ;	/* reference column for cursor up/down tracking */
			OI_number	ref_pix ;	/* reference pixel position for cursor up/down tracking */
			OI_mt_mode	ins_mode ;	/* insert mode */
			OI_bool		csr_lifted ;	/* OI_yes => cursor has been lifted */
			OI_number	pad_x ;		/* padding for caret cursor */
			OI_number	pad_y ;		/* padding for caret cursor */
			OI_d_tech	*scrl_objp ;	/* scroller object containing this text object, if any */
			char		*init_filep ;	/* ptr to initial contents file name string */
			char		*cur_filep ;	/* ptr to initial contents file name string */
			OI_select_coord	pri_start;	/* starting coords of PRIMARY selection */
			OI_select_coord	pri_end;	/* ending coords of PRIMARY selection */
			char		*pri_bufp ;	/* ptr to PRIMARY selection buffer */
			unsigned long	pri_nchrs ;	/* # chars used in *pri_bufp */
			unsigned long	pri_maxchrs ;	/* max # chars in *pri_bufp */
			OI_select_coord	sec_start;	/* starting coords of SECONDARY selection */
			OI_select_coord	sec_end;	/* ending coords of SECONDARY selection */
			char		*sec_bufp ;	/* ptr to SECONDARY selection buffer */
			unsigned long	sec_nchrs ;	/* # chars used in *sec_bufp */
			unsigned long	sec_maxchrs ;	/* max # chars in *sec_bufp */
			char		*clip_bufp ;	/* ptr to CLIPBOARD selection buffer */
			unsigned long	clip_nchrs ;	/* # chars used in *clip_bufp */
			unsigned long	clip_maxchrs ;	/* max # chars in *clip_bufp */
			OI_number	n_click ;	/* # clicks which have occurred */
			Time		tim ;		/* time of last button press/release event */
			OI_number	rt_mrg ;	/* right margin character position, 0 relative; 0 => viewport size */
			OI_number	lf_mrg ;	/* left margin character position, 0 relative */
	 public:
		static	OI_class	*clsp ;		/* ptr to class record */
		static	OI_bool		processing_data ;	/* flag for OI_wait_done; used by process_select_data */

	 private:
			void		construct(OI_number,OI_number,OI_number,OI_number) ;
			void		set_in_my_constructor()	{ctl_bits|=OI_MULTI_TEXT_IN_CONSTRUCTOR;}
			void		clear_in_my_constructor()	{ctl_bits&= ~OI_MULTI_TEXT_IN_CONSTRUCTOR;}
			OI_bool		in_my_constructor()	{return((ctl_bits&OI_MULTI_TEXT_IN_CONSTRUCTOR) ? OI_yes : OI_no);}
			void		lift_cursor() ;			/* unpaint cursor at the last position */
			OI_number	nominal_view_n_lines() ;
			OI_number	nominal_view_n_chars() ;
			void		paint_cursor() ;		/* paint cursor at current position */
			int		track_reloc(OI_d_tech*) ;				/* relocate object being tracked */
			void		resize(OI_d_tech*,void*) ;				/* resize callback */
			void		internal_set_enhance(OI_number,OI_number,OI_number,OI_enhance) ;	// needed for &set_enhance resolution
			void		wrap_add(OI_number,OI_bool,OI_number*,OI_number*,OI_number*,OI_number*,OI_number*) ;	/* adjust for wordwrap, text added */
			void		wrap_del(OI_number,OI_bool,OI_number*,OI_number*,OI_number*,OI_number*,OI_number*) ;	/* adjust for wordwrap, text removed */

	 protected:
					OI_multi_text(OI_class *clsp, const char *usr_namp, OI_number nln, OI_number nc, OI_number mxln=0,
						OI_number mxc=0);
			void		adj_subobjects() ;					/* adjust position of tracked subobjects */
			void		button_position(const XEvent*,OI_select_coord*) ;	/* set coordinates for btn event position */
			OI_d_tech	*callback_obj();					/* Object to make this callback for. */
			OI_bool		chk_kb_input();						/* chk is_kb_input & give msg if not */
			void		chk_resize() ;						/* check for resize on char set changes */
			OI_number	chr_position(OI_number,OI_number) ;			/* get chr position from cursor column */
			OI_number	col_position(OI_number,OI_number) ;			/* get cursor column from chr position */
			OI_stat		create() ;						/* generate item in X environment */
			OI_bool		decode_extend(const char* const *, const unsigned int *);	/* figure out if extending kb selection */
			OI_number	dsp_len(OI_line*) ;					/* compute length of line w/tabs expanded */
			void		enhance(Atom,OI_bool,const OI_select_coord*,const OI_select_coord*) ;
												/* (un)enhance portion of text */
			void		enhance_eol(OI_bool,OI_enhance,int,int) ;		/* (un)enhance eol to right edge */
			void		enhance_selection(Atom,OI_bool) ;			/* (un)enhance text of selection */
			OI_stat		fill_line(OI_line*,const char*,OI_char_encode_type) ;	/* set text for a line (no paint done) */
			void		gen_boundary(OI_bool fwd, OI_select_coord *pos) ;	/* find general boundary */
			OI_bool		get_clipboard_data(Time,OI_bool) ;			/* common parts of clipboard routines */
			OI_number	horz_padding() ;
			OI_bool		is_blank_line(OI_line *lp, OI_number *nb_chr);		/* OI_yes if empty or only white space */
			OI_bool		is_char_ok(char);					// validate the char before inserting/replacing
			OI_stat		join_line(OI_number) ;					/* join next line to this one */
			void		key_extend(const XEvent *, OI_number, OI_number) ;	/* common parts of key selection routines */
			void		mouse_select_file(Atom);
			void		mouse_select_line(Atom);
			void		mouse_select_paragraph(Atom);
			void		mouse_select_word(Atom);
			void		move_horiz(OI_number) ;					/* check l/r cursor motion */
			void		move_pri_select(OI_select_coord*,Time) ;		/* move primary selection */
			void		move_vert(OI_number) ;					/* check u/d cursor motion */
			OI_line		*new_line(OI_number,OI_bool,OI_bool) ;			/* get ptr to descriptor for new line */
		virtual	void		new_model(OI_model_type) ;
			void		paint_chars(OI_line*,OI_number,OI_number,OI_number) ;   /* draw partial text line */
			void		paint_lines(OI_number,OI_number) ;			/* draw multiple text lines */
			void		paragraph_boundary(OI_bool fwd, OI_bool mv, OI_number *new_lin, OI_number *new_chr) ;
												/* find paragraph_word boundary */
			OI_number	pix_position(OI_number lin, OI_number chr) ;		/* pixel position */
			void		pixel_chr_col(OI_line *, OI_number *, OI_number *);	/* pixel to char and column position */
			OI_bool		process_select_data(Atom,Atom) ;			/* insert selection data requested */
			void		release_select(Atom);
			OI_bool		retrieve_select_data(Atom,Atom) ;			/* copy selection data to clipboard */
			void		save_select(Atom,const OI_select_coord*,const OI_select_coord*) ;	/* save current selection */
			void		scroll_horiz(OI_scroll_event,int) ;			/* scroll left/right */
			void		scroll_vert(OI_scroll_event,int) ;			/* scroll up/down */
			OI_bool		send_select_data(Window,Atom,Atom,Atom) ;		/* send data to requestor */
			OI_bool		selection_convert(OI_d_tech *, void *, const XEvent *);
			void		set_nc_max(OI_line*) ;					/* set # chars in longest line, # lines
												   with this many chars */
			OI_stat		set_position(OI_number,OI_number,OI_psn_type,OI_bool) ;	/* psn csr in view */
			void		set_prog_modified()	{ctl_bits |= OI_MULTI_TEXT_PROG_MODIF;}
			void		set_user_modified()	{ctl_bits |= OI_MULTI_TEXT_USER_MODIF;}
			OI_number	vert_padding() ;
			void		void_select() ;						/*  cancel current selection */
			void		word_boundary(OI_bool fwd, OI_bool mv, OI_number *new_lin, OI_number *new_chr) ;
												/* find word boundary */

	 public:
		//-------------------------------------------------------------------------------------------------		
		//		
		//	RESTRICTED MEMBER FUNCTIONS
		//		Functions in this section are not documented in the programmer's manual and are
		//		restricted to internal use by the toolkit.
		//		Functions not contained in user documentation are subject to change without notice
		//		and should never be used by toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
					OI_multi_text(const char*,OI_number,OI_number,OI_number=0,OI_number=0) ;	/* constructor */
					~OI_multi_text() ;							/* destructor */
			void		allow_drag_cursor() ;
			void		allow_mouse_select() ;
			void		allow_pending_delete() ;
		virtual	void		clone_adjust(OI_d_tech*) ;				/* adjust characteristics to match those of another obj */
			OI_bool		cursor_lifted()		{return(csr_lifted);}
			OI_number	cursor_pixel()		{return(psn_pix);}		/* pixel loc of cursor column */
		virtual	void		disable();
			void		disallow_mouse_select() ;
			void		disallow_drag_cursor() ;
			void		disallow_pending_delete() ;
			void		dragdrop_start(OI_dnd_operation, const XEvent *);
			void		drop_preview(OI_d_tech*,void*,OI_dnd_operation,long,long);
			void		dump_line(OI_number lin) ;	// REB -- DEBUG
		virtual	void		enable();
			void		fix_text(const XEvent*) ;				/* fix text after clearing cursor */
			void		font_resize() ;						/* resize on account of font change */
		virtual	void		handle_drop(OI_dnd_operation , long, long);
			OI_number	horz_fill() ;						/* filler in horz direction */
		static	OI_bool		init(OI_connection*) ;
			char		*initial_file()		{return(init_filep);}		/* name of initial contents file */
		virtual	OI_stat		insert_chars_gen(OI_number,OI_number,OI_number,const char*,OI_number* =NULL,OI_number* =NULL,
						OI_bool=OI_no,OI_char_encode_type=OI_char_encode_none) ;
												/* add char substring to line */
		virtual	OI_stat		insert_line_gen(OI_number,OI_bool,const char*,OI_char_encode_type) ;
												/* insert new line of text */
			OI_bool		is_drag_cursor() ;
			OI_bool		is_mouse_select() ;
			OI_bool		is_pending_delete() ;
			OI_bool		is_write_resq(XrmQuark);
			OI_number	left_offset() ;
 		virtual	OI_line		*line(OI_number lin);
		static	OI_multi_text	*make_minimal(const char*,OI_minimal_type) ;
		virtual	void		min_outside_size(OI_number,OI_number,OI_number*,OI_number*) ;
		virtual	OI_bool		new_right_margin(OI_number) ;
		virtual	OI_stat		new_size(OI_number,OI_number);
			OI_stat		new_view_size(OI_number,OI_number) ;
			int		no_edit(OI_d_tech*,void*,OI_number,OI_number,char) ;	/* read_only char input check procedure */
		virtual	void		nominal_outside_size(OI_number*,OI_number*);
		virtual	void		paint(const XEvent*, void* =NULL) ; 			/* draw contents after X window expose */
 		virtual	OI_string	*ply_text(OI_number lin);
			void		private_font_resize(OI_bool = OI_yes);
			void		graphics_expose(const XEvent*) ; 			/* draw contents after XGraphicsExpose */
			void		process_pending_delete() ;				/* handle pending delete stuff */
			void		select(const XEvent*) ;					/* misc. selection operations */
			void		set_cursor_lifted(OI_bool lifted)	{csr_lifted = lifted;}
			void		set_initial_file(const char*) ;				/* set name of initial contents file */
			void		set_nominal_view_size(OI_number,OI_number) ;		/* establish nominal size for size_trackers */
			void		set_scroll_obj(OI_d_tech *dtp) {scrl_objp=dtp;}		/* set scroller object */
		virtual	OI_stat		set_text_cb(OI_text_fnp fp, OI_callback *objp, OI_text_memfnp mfp) ;	/* set text */
			OI_number	top_offset() ;
			OI_number	vert_fill() ;						/* filler in vertical direcction */
		virtual	OI_number	view_n_pixels() ;					/* # pixels in viewport */

		friend	void		dmpOI_multi_text(OI_multi_text*) ;			/* diagnostic dump procedure */

		//-------------------------------------------------------------------------------------------------		
		//		
		//	OBSOLETE MEMBER FUNCTIONS	
		//		Functions in this section were previously documented, but have been marked as
		//		obsolete.  These functions have been removed from the programmer's manual.
		//		These functions are subject to removal from the toolkit and should NEVER be
		//		used by toolkit users.
		//
		//-------------------------------------------------------------------------------------------------		

		virtual	OI_mt_char_chk_status	def_c_chk(OI_d_tech*,void*,OI_number,OI_number,char) ;	// use def_c_check

		//-------------------------------------------------------------------------------------------------		
		//		
		//	OVERRIDES OF DOCUMENTED PARENT MEMBER FUNCTIONS	
		//		Functions in this section are documented in the programmer's manual under the
		//		parent(s) of this object and are also available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
		virtual	OI_bool		delete_selection(Atom) ;				/* delete text of selection */
		virtual	void		drag_end(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
		virtual	void		drag_copy_start(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
		virtual	void		drag_move_start(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
		virtual	void		pan_paint(OI_panner*,void*,XExposeEvent*) ;		/* paint miniature of object for panner */
		virtual	OI_number	right_margin() ;
		virtual	void		scroll(OI_ctlr_1d*,void*,OI_scroll_event,long) ;	/* scroll text */
		virtual	void		scroll_2d(OI_panner*,void*,OI_scroll_event,long,long) ;	/* scroll text in 2 dimensions */
		virtual char		*selection_data(Atom) ;					/* get selection's data */
		virtual	char		*selection_data(const char *) ;				/* get selection's data */
		virtual	OI_number	size_x() ;
		virtual	OI_number	size_y() ;

		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED MEMBER FUNCTIONS	
		//		Functions below this point are documented in the programmer's manual under this
		//		object and are available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
		virtual	void		allow_click_select() ;
		virtual	void		allow_inactive_cursor() ;
		virtual	void		allow_kb_input() ;
		virtual	void		allow_wrap() ;
		virtual	OI_stat		append_file(const char *fn, OI_bool scroll=OI_no) ;	/* append contents of file to text */
		virtual	OI_stat		append_file(FILE *fp, OI_bool scroll=OI_no) ;		/* append contents of file to text */
		virtual	OI_stat		append_string(const char *str,OI_bool scroll=OI_no) ;	/* append contents of string to text */
		virtual	OI_number	char_width() ;
		virtual	OI_stat		char_xy_position(OI_number,OI_number,long*,long*) ;	/* get xy position for line/char psn */
		virtual	void		clear_enhance(OI_number);				/* clear all enhancements on a line */
		virtual	void		clear_modified() ;
		virtual	void		clear_prog_modified() ;
		virtual	void		clear_user_modified() ;
		virtual	char		*current_file() ;
		virtual	OI_number	cursor_char() ;
		virtual	OI_number	cursor_column() ;
		virtual	OI_number	cursor_line() ;
		virtual	OI_mt_char_chk_status	def_c_check(OI_d_tech*,void*,OI_mt_char_chk_status,OI_number,OI_number,char) ;	/* default char input check fn */
		virtual	OI_stat		delete_chars(OI_number,OI_number,OI_number) ;		/* remove substring from line */
		virtual	OI_stat		delete_line(OI_number) ;				/* remove line */
		virtual	OI_stat		delete_lines(OI_number,OI_number) ;			/* remove lines */
		virtual	void		disallow_click_select() ;
		virtual	void		disallow_inactive_cursor() ;
		virtual	void		disallow_kb_input() ;
		virtual	void		disallow_wrap() ;
		virtual	OI_bool		exec_cmd(const char *str,OI_base_text *outp=NULL,OI_base_text *errp=NULL,OI_bool append=OI_no) ;
												/* exec text or string as commands */
		virtual	OI_bool		find_string(OI_number*,OI_number*,const char*,OI_bool=OI_no,OI_bool=OI_no);
		virtual	OI_enhance	get_enhance(OI_number,OI_number) ;			/* get enhancement for a character */
		virtual	OI_bool		is_click_select() ;
		virtual	OI_bool		is_inactive_cursor() ;
		virtual	OI_bool		is_kb_input() ;
		virtual	OI_bool		is_modified() ;
		virtual	OI_bool		is_prog_modified() ;
		virtual	OI_bool		is_user_modified() ;
		virtual	OI_bool		is_wrap() ;
		virtual	OI_number	line_height() ;
		virtual	OI_number	line_width(OI_number) ;					/* get width of text line */
		virtual	OI_number	max_chars() ;
		virtual	OI_number	max_lines() ;
		virtual	OI_number	max_n_chars() ;						/* max # chars */
		virtual	OI_number	max_n_pixels() ;					/* max # pixels */
		virtual	OI_mt_mode	mode() ;						/* get current insert mode */
		virtual	OI_number	n_lines() ;						/* # active lines */
		virtual	OI_stat		output_text(const char *fn, OI_bool append=OI_no) ;	/* write text to file */
		virtual	OI_stat		output_text(FILE *fp, OI_bool append=OI_no) ;		/* write text to file */
		virtual	void		remove_enhance(OI_number,OI_number,OI_number,OI_enhance) ;
												/* unenhance portion of text */
		virtual	OI_stat		replace_chars(OI_number,OI_number,OI_number,const char*) ;
												/* replace substring of line */
		virtual	OI_stat		replace_line(OI_number,const char*) ;			/* replace text for an existing line */
		virtual	OI_bool		selection_coords(OI_number *slin, OI_number *schr, OI_number *elin, OI_number *echr) ;
												/* return coords of selection */
		virtual	void		set_cols(OI_number mx_c) ;				/* change initial max # chars/line */
		virtual	void		set_enhance(OI_number,OI_number,OI_number,OI_enhance,const char*,const char*,const char* =NULL) ;
												/* enhance portion of text */
		virtual	void		set_enhance(OI_number,OI_number,OI_number,OI_enhance,PIXEL=OI_UNKNOWN_PIXEL,PIXEL=OI_UNKNOWN_PIXEL,
						const char* =NULL) ;				/* enhance portion of text */
		virtual	OI_stat		set_lines(OI_number) ;					/* set max # lines */
		virtual	void		set_mode(OI_mt_mode md)	;				/* set insert mode */
		virtual	OI_stat		set_position(OI_number,OI_number,OI_psn_type=OI_psn_default) ;	/* psn csr in view */
		virtual	OI_bool		set_right_margin(OI_number) ;
		virtual	OI_stat		set_tab_width(OI_number tw) ;				/* set # chars in tab width increment */
		virtual	OI_stat		set_tabs_custom(OI_number *, OI_number, OI_number =8) ;	/* set custom tabstops table */
		virtual	OI_stat		set_text_to_file(const char *fn) ;			/* set text to contents of file */
		virtual	OI_stat		set_text_to_file(FILE *fp) ;				/* set text to contents of file */
		virtual	OI_stat		set_text_to_string(const char *str) ;			/* set text to contents of string */
		virtual	OI_stat		set_view_size(OI_number vln, OI_number vch) ;		/* change viewport size */
		virtual	OI_number	tab_width() ;						/* # chars in tab width increment */
		virtual	char		*text(OI_number) ;					/* get text for a line */
		virtual	void		ulcwf(OI_number *uln, OI_number *uch) ;			/* upper left corner of viewport */
		virtual	OI_number	ulcwf_char() ;						/* char # of ULC of viewport */
		virtual	OI_number	ulcwf_line() ;						/* line # of ULC of viewport */
		virtual	OI_number	ulcwf_pixel() ;						/* pixel of upper left corner of viewport */
		virtual	void		view_size(OI_number *vln, OI_number *vch) ;
		virtual	OI_number	view_n_lines() ;					/* # lines in viewport */
		virtual	OI_number	view_n_chars() ;					/* # chars in viewport */
		virtual	OI_stat		view_char_position(long,long,OI_number*,OI_number*) ;	/* get ln/ch posn for xy posn in viewport */
		virtual	void		wrap(OI_number=0,OI_number=0) ;				/* wrap text */
		virtual	OI_stat		xy_char_position(long,long,OI_number*,OI_number*) ;	/* get line/char position for xy position */

		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED TRANSLATIONS FUNCTIONS	
		//		Functions below this point are documented in the programmer's manual under the
		//		translations available for this object and are available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
			void		backward_character(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void		backward_paragraph(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void		backward_word(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void		backward_view(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void		beginning_of_file(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void		beginning_of_line(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void		beginning_of_pane(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void		cancel_select(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void		clear_focus_frame(OI_d_tech *, const XEvent *, const char* const *, unsigned int *) ;
			void		click_down(OI_d_tech *, const XEvent *, const char* const *, unsigned int *) ;
			void		click_up(OI_d_tech *, const XEvent *, const char* const *, unsigned int *) ;
			void		copy_clipboard(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void		copy_primary(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void		copy_start(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void		cut_clipboard(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void		cut_primary(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void		delete_all_characters(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void		delete_next_character(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void		delete_next_word(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void		delete_previous_character(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void		delete_previous_word(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void		delete_this_line(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void		delete_to_beginning_of_file(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void		delete_to_beginning_of_line(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void		delete_to_end_of_file(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void		delete_to_end_of_line(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void		end_of_file(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void		end_of_line(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void		end_of_pane(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void		extend_start(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
		virtual	void		focus_in(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
		virtual	void		focus_out(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void		forward_character(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void		forward_paragraph(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void		forward_view(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void		forward_word(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void		input_character(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void		input_convert(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void		insert_mode(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void		insert_selection(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void		insert_string(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void		key_select(OI_d_tech *, const XEvent *, const char* const *, unsigned int *) ;
			void		move_insertion(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void		move_selection(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void		newline(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void		next_line(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void		next_page(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void		open_next_line(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void		open_previous_line(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void		paint_focus_frame(OI_d_tech *, const XEvent *, const char* const *, unsigned int *) ;
			void		paste_clipboard(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void		previous_line(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void		previous_page(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void		process_return(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void		quick_paste(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void		replace_mode(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void		scroll_bottom(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void		scroll_down(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void		scroll_left(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void		scroll_left_edge(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void		scroll_right(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void		scroll_right_edge(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void		scroll_top(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void		scroll_up(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void		secondary_adjust(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void		secondary_end(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void		secondary_start(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void		select_adjust(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void		select_all(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void		select_end(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void		select_line(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void		select_start(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void		set_anchor(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void		set_quick_copy(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void		set_quick_cut(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void		start_input_conversion(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void		start_of_pane(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void		stop_input_conversion(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void		take_focus(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void		toggle_mode(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void		unselect_all(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);

	} ;

//-------------------------------------------------------------------------------------------------		
//		
//	RESTRICTED FUNCTIONS
//		Functions in this section are not documented in the programmer's manual and are
//		restricted to internal use by the toolkit.
//		Functions not contained in user documentation are subject to change without notice
//		and should never be used by toolkit users.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		

//-------------------------------------------------------------------------------------------------		
//		
//	DOCUMENTED FUNCTIONS	
//		Functions below this point are documented in the programmer's manual under this
//		object and are available to the toolkit users.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		
	OI_multi_text	*oi_create_multi_text(const char*,OI_number,OI_number,OI_number=0,OI_number=0) ;   /* create text object */

#endif /* OI_mlttxt_H */
