#include <ctype.h>
#include <strings.h>
#include <OI/oi.H>

#include <sys/types.h>		/* for stat() */
#include <sys/stat.h>		/* for stat() */


/*
 *	file browser
 *
 *	This program was created to introduce the programmer to 
 *	the OI_paned_box object and how it can be used.
 *
 *	The reader should refer to the OI documentation for
 *	information on the following member functions.
 *		- OIIntro
 *			OI_init()
 *			OI_begin_interaction()
 *			OI_fini()
 *		- OI_d_tech
 *			set_associated_object()
 *			layout_associated_object()
 *			set_layout()
 *			push_help_str()
 *			app_window()
 *			ancestor_derived_from()
 *			set_size_track()
 *			descendant()
 *			subobject()
 *			set_gravity()
 *		- OI_app_window
 *			oi_create_app_window()
 *			set_main_menu()
 *		- OI_paned_box
 *			oi_create_paned_box()
 *			num_panes()
 *			add_pane()
 *			numbered_pane()
 *		- OI_pane
 *			oi_create_pane()
 *			set_min_size()
 *		- OI_scroll_text
 *			oi_create_scroll_text()
 *		- OI_multi_text
 *			set_text_to_file()
 *			cursor_line()
 *			cursor_char()
 *			fine_string()
 *			set_position()
 *		- OI_menu
 *			oi_create_button_menu()
 *		- OI_menu_cell
 *			change_action()
 *			set_default()
 *		- OI_entry_field
 *			oi_create_entry_field()
 *			set_entry_chk()
 *		- OI_file_dialog_box
 *			oi_create_file_dialog_box()
 *			pathname()
 */

void
add_file(OI_menu_cell *cellp, void*, OI_number)
{
	OI_file_dialog_box	*file_db;
	OI_paned_box		*pbp;
	OI_app_window		*app_win;
	char			*file_to_add;
	OI_pane			*panep;
	OI_scroll_text		*scrl_txtp;
	OI_static_text		*stat_txtp;
	struct stat		stat_struct;

	/*
	 * 	Get pointers to important objects and the
	 *	path to the file we are going to add.
	 */
	app_win = cellp->app_window();
	file_db = (OI_file_dialog_box*)cellp->ancestor_derived_from(OI_file_dialog_box::clsp);
	file_to_add = file_db->pathname();

	/*
	 *	Check that the path is valid.
	 */
	if ( stat(file_to_add, &stat_struct) ) {
		app_win->push_help_str("Bad path name.", OI_yes);
	}
	else {
		/*
		 *	If the paned box does not already exist create it.
		 */
		if ( ! (pbp = (OI_paned_box*)app_win->descendant("pb"))) {
			pbp = oi_create_paned_box("pb", 1, 1, OI_vertical, 0);
			pbp->set_size_track(OI_size_track_full);
			pbp->layout_associated_object(app_win, 1, 10, OI_active);
		}
		
		/*
		 *	Create a pane with a scroll_text and static_text in it.
		 *	The static text will be a label for the user to see the name
		 *	of the file they are looking at.
		 */
		panep = oi_create_pane(file_to_add, 1, 1);
		panep->set_size_track(OI_size_track_full);
		panep->set_layout(OI_layout_row);
	
		stat_txtp = oi_create_static_text("stp", file_to_add);
		stat_txtp->layout_associated_object(panep, 1, 5, OI_active);
	
		scrl_txtp = oi_create_scroll_text("scrl_txtp", OI_scroll_bar_both, 10, 80);
		scrl_txtp->set_text_to_file(file_to_add);
		scrl_txtp->set_size_track(OI_size_track_full);
		scrl_txtp->layout_associated_object(panep, 1, 10, OI_active);
		
		pbp->add_pane(panep, pbp->num_panes());
	
		/*
		 *	Set the minimum size of the pane to the height of the static text
		 *	plus it's top space so that the name of the file is always visible.
		 */
		 panep->set_min_size(stat_txtp->space_y() + stat_txtp->top_space());
	 }
}

OI_ef_entry_chk_status
find_text ( OI_entry_field *find_efp, void*)
{
	OI_paned_box	*pbp;
	OI_scroll_text	*scrl_txt;
	int		i;	
	OI_number	ln_pos, ch_pos;

	if (find_efp->part_text()) {
		if (pbp = (OI_paned_box*)find_efp->app_window()->descendant("pb")) {
			for (i=0; i < pbp->num_panes(); i++) {
				scrl_txt = (OI_scroll_text*)pbp->numbered_pane(i)->descendant("scrl_txtp");
				ln_pos = scrl_txt->cursor_line();
				ch_pos = scrl_txt->cursor_char() + 1;
				if (scrl_txt->find_string( &ln_pos, &ch_pos, find_efp->part_text(), OI_yes)) {
					scrl_txt->set_position(ln_pos, ch_pos);
				}
			}
		}
		else {
			find_efp->push_help_str("No files to search.");
		}
	}
	return (OI_ef_entry_chk_ok);
}

void
main( int argc, char **argv )
{
	static OI_cell_spec	file_cells[] = {
		{ "add_file", "Add File", NULL, NULL, NULL_PMF, NULL, OI_TEXT_CELL, NULL, 0, 0, 0},
	};

	static OI_cell_spec	main_cells[] = {
		{ "file", "File", NULL, NULL, NULL_PMF, NULL, OI_TEXT_CELL, NULL, 0, 0, 0},
	};

	OI_app_window		*win ;
	OI_connection		*conp ;
	OI_menu			*main_mnu ;
	OI_menu			*file_mnu ;
	OI_menu_cell		*cellp ;
	OI_file_dialog_box	*add_file_db;
	OI_entry_field		*find_efp;

	
	/*
	 *	Open a connection.
	 */
	if (conp = OI_init(&argc, argv, "panedBoxDemo")) {
		/*
		 *	create the application window.
		 *	set layout to row major.
		 */
		win = oi_create_app_window( "mainWin", 1, 1, "OI_paned_box Demo" );
		win->set_layout( OI_layout_row );

		/*
		 *	Build main menu.
		 */
		main_mnu = oi_create_button_menu("main_mnu", OI_count(main_cells), main_cells, OI_horizontal, NULL);
		file_mnu = oi_create_button_menu("file_mnu", OI_count(file_cells), file_cells, OI_vertical, NULL);

		cellp = (OI_menu_cell*)main_mnu->subobject("file");
		file_mnu->set_associated_object(cellp, OI_def_loc, OI_def_loc, OI_active_not_displayed);

		win->set_main_menu(main_mnu);

		/*
		 *	Build file_dialog_box and hang it on the add_file button
		 */
		cellp = (OI_menu_cell*)main_mnu->descendant("add_file");
		cellp->set_default();
		add_file_db = oi_create_file_dialog_box( "add_file_db");
		add_file_db->set_associated_object(cellp, OI_def_loc, OI_def_loc, OI_active_not_displayed);

		/*
		 *	Set callback on add_file_db's OK button
		 */
		cellp = (OI_menu_cell*)add_file_db->descendant("OK");
		cellp->change_action(add_file, NULL);

		/*
		 *	Add an entry field that will do searches
		 */
		find_efp = oi_create_entry_field("find_efp", 20, "Find:", NULL, 256);
		find_efp->set_gravity(OI_grav_center);
		find_efp->layout_associated_object(win, 1, 5, OI_active);
		find_efp->set_entry_chk(find_text, NULL);

		/*
		 *	display main window.
		 *	begin interaction.
		 */
		win->set_associated_object( win->root(), OI_DEF_LOC, OI_DEF_LOC, OI_ACTIVE );
		OI_begin_interaction();
	}

	/*
	 *	Cleanup.  Make sure that we cleanup the library.
	 */
	OI_fini();
}
