#include <malloc.h>
#include <string.h>
#include <OI/oi.H>
#include <OI/lmtree.H>

/*
 ******************************************************************************
 *
 *	Function Name:	oi_tree main
 *
 *		Description: 
 *			Read in an arbitrary .cf file and display it's object tree
 *
 *		Returns:
 * 
 *		Side Effects:
 *
 *		Warnings:
 *
 ******************************************************************************
 */
 void
 main( int argc, char ** argv )
{
 /*	External Procedures: */
			void		add_to_tree(OI_d_tech*,OI_d_tech*,OI_scroll_box*) ;
			void		add_connectors(OI_d_tech*) ;
 /*	Local Variables: */
			OI_number	i ;
			OI_d_tech	**top_lvlp ;	/* vector of top level objects */
			OI_app_window	*wp ;		/* main window for object tree display */
			OI_scroll_box	*sbp ;		/* scroll_box containing object tree */

	if (OI_init(&argc,argv,"OITree")) {
		if (argc > 1) {
			argv++ ;
			// Read in the .cf file and display it
			if (OI_def_conp->add_resources(OI_translate_filename(*argv))) {
				top_lvlp = OI_make_top_level();
				for ( i=0 ; top_lvlp[i] ; ++i )
					top_lvlp[i]->set_associated_object(top_lvlp[i]->root(),OI_DEF_LOC,OI_DEF_LOC,OI_ACTIVE);

				// Now build a tree showing the object hierarchy
				wp = oi_create_app_window("tree_main", 10, 10, "Object Tree") ;
				wp->set_layout(OI_layout_row) ;
//				wp->set_associated_object(wp->root(), OI_def_loc, OI_def_loc, OI_active) ;
				sbp = oi_create_scroll_box("object_tree_sb", OI_scroll_bar_both, 300, 300, 300, 300) ;
				sbp->layout_associated_object(wp, 10, 10, OI_active) ;
				sbp->set_size_track(OI_size_track_full) ;
				sbp->set_layout(OI_layout_horz_tree) ;
				sbp->suspend_layout() ;
				for (i=0 ; top_lvlp[i] ; i++) {
					add_to_tree(top_lvlp[i],NULL,sbp) ;
				}
				sbp->resume_layout() ;
				wp->set_associated_object(wp->root(), OI_def_loc, OI_def_loc, OI_active) ;

				free( (char *) top_lvlp );
				OI_begin_interaction() ;
			}
			else
				fprintf(stderr,"ERROR reading read file %s or no TopLevel resource available\n",*argv) ;
			OI_fini() ;
		}
		else {
			fprintf( stderr, "usage: %s config_file.cf\n", argv[0] );
		}
	}
}

/*
 ******************************************************************************
 *
 *	Function Name:	add_to_tree
 *
 *		Description: 
 *			Add object and all descendants to object tree display
 *
 *		Returns:
 * 
 *		Side Effects:
 *			Additional nodes are built for objp and its descendants and added to sbp
 *
 *		Warnings:
 *
 ******************************************************************************
 */
 void add_to_tree(
			OI_d_tech	*objp,		/* ptr to object to descend */
			OI_d_tech	*prntp,		/* ptr to parent node */
			OI_scroll_box	*sbp)		/* scroll box in which to insert tree nodes */
{
 /*	External Procedures: */
			OI_d_tech	*create_node(OI_d_tech*) ;
 /*	Local Variables: */
			OI_d_tech	*obj_bp ;	/* box representing node for objp */
			OI_d_tech	*dtp ;		/* ptr to child of objp */
			OI_number	i ;
			OI_number	nc ;		/* number of children to consider */
			OI_bool		incl_intrnl ;	/* OI_yes => include internal objects */

	incl_intrnl = OI_no ;

	obj_bp = create_node(objp) ;
	obj_bp->layout_associated_object(sbp,prntp,NULL,OI_active) ;
	nc = incl_intrnl ? objp->abs_num_props() : objp->num_props() ;
	for (i=0 ; i<nc ; i++) {
		dtp = incl_intrnl ? objp->abs_numbered_child(i) : objp->numbered_child(i) ;
		add_to_tree(dtp,obj_bp,sbp) ;
	}
	return ;
}

/*
 ******************************************************************************
 *
 *	Function Name:	create_node
 *
 *		Description: 
 *			Create node representing object
 *
 *		Returns:
 *			Ptr to object suitable for display describing objp
 * 
 *		Side Effects:
 *			Box is created and objects containing descriptive information are laid out inside it
 *
 *		Warnings:
 *
 ******************************************************************************
 */
 OI_d_tech *create_node(
			OI_d_tech	*objp)		/* ptr to object to describe */
{
 /*	External Procedures: */
 /*	Local Variables: */
			OI_box		*bp ;		/* box representing node for each child of objp */
			OI_entry_field	*efp ;		/* object name, class */
			char		buff[101] ;

	sprintf(buff,"node_%s",objp->name()) ;
	bp = oi_create_box(buff, 10, 10) ;
	bp->set_layout(OI_layout_row) ;
	efp = oi_create_entry_field("name",strlen(objp->name()),"Name:",objp->name()) ;
	efp->layout_associated_object(bp, 10, 10, OI_active) ;
	efp = oi_create_entry_field("class",strlen(objp->class_object()->name()),"Class:",objp->class_object()->name()) ;
	efp->layout_associated_object(bp, 10, 20, OI_active) ;
	return(bp) ;
}
