#include <OI/oi.H>
#include <stdlib.h>

#define	DENSITY		(2)
#define	LEVELS		(5)

void
populate_tree( OI_d_tech *sbx, OI_d_tech *prntp, OI_number n )
{
	int		i ;
	char		buf[256];
	OI_d_tech	*sibl ;
	OI_static_text	*textP;

	++n ;
	sibl = NULL ;
	for (i=DENSITY; i--; ) {
		sprintf( buf, "Box_%d_%d", n, i );
		textP = oi_create_static_text( buf, buf );
		textP->layout_associated_object( sbx, prntp, sibl, OI_ACTIVE);
		if (n < LEVELS)
			populate_tree( sbx, textP, n );
		sibl = textP ;
	}
}

void
main( int argc, char ** argv )
{
	OI_app_window		*win ;
	OI_scroll_box*		sbx;
	OI_static_text*		textP;
	char			buf[256];

	OI_init( &argc, argv );

	win = oi_create_app_window( "main", 1, 1, "Tree Layout" );
	win->set_layout( OI_layout_row );

	sbx = oi_create_scroll_box( "ScrollBox", OI_SCROLL_BAR_BOTH, 200, 200, 1000, 1000, 1, 1 );
	sbx->set_layout( OI_layout_vert_tree );
	sbx->set_size_track( OI_size_track_full );
	sbx->layout_associated_object( win, 1, 1, OI_ACTIVE );
	textP = oi_create_static_text( "root", "root" );
	textP->layout_associated_object( sbx, (void*) NULL, (void*) NULL, OI_ACTIVE);
	populate_tree( sbx, textP, 0 );

	sbx = oi_create_scroll_box( "ScrollBox", OI_SCROLL_BAR_BOTH, 200, 200, 1000, 1000, 1, 1 );
	sbx->set_layout( OI_layout_horz_tree );
	sbx->set_size_track( OI_size_track_full );
	sbx->layout_associated_object( win, 1, 1, OI_ACTIVE );
	textP = oi_create_static_text( "root", "root" );
	textP->layout_associated_object( sbx, (void*) NULL, (void*) NULL, OI_ACTIVE);
	populate_tree( sbx, textP, 0 );

	win->set_associated_object( win->root(), OI_DEF_LOC, OI_DEF_LOC, OI_ACTIVE );
	OI_begin_interaction();
	OI_fini();
}
