/*
 *  stubs.c -- Stub routines for cinterface.a.  These routines are referenced
 *	       in the library, but should only be called inside the real
 *	       postgres backend.  If anyone else calls them, it's an error
 *	       and we should die.
 */

#include "tmp/postgres.h"
#include "utils/log.h"
#include "rules/prs2locks.h"
#include "rules/prs2stub.h"
#include "utils/fmgr.h"
#include "executor/tuptable.h"

RcsId ( "$Header: /private/postgres/src/support/RCS/stubs.c,v 1.29 1992/08/03 23:05:38 mao Exp $" );

ObjectId	LastOidProcessed;  /* used in real backend for qry rewrite */
int NTupleProcessed;

/*
 *  If you're not the real postgres backend, you don't need to dynamically
 *  load code and you don't need the externally-visible symbols list (it
 *  will be a GREAT day when this just goes away).
 */

FList	ExtSyms[] = {
	NULL, NULL
};

char *
RuleLockToString(locks)
	RuleLock locks;
{
	locks = locks;
	Assert(0);
}

RuleLock
StringToRuleLock(s)
	char *s;
{
	s = s;
	Assert(0);
}

Datum GetAttributeByName() {
	Assert(0);
}

Datum GetAttributeByNum() {
	Assert(0);
}

dynamic_file_load()
{
	Assert(0);
}

Prs2RawStub
stubin(s)
char *s;
{
    Prs2RawStub res;
    long size;
    int n;

    if (s == NULL || !strcmp(s, "-")) {
        size = sizeof(long) + sizeof(int);
        res = (Prs2RawStub) palloc(size);
        VARSIZE(res) = size;
        n=0;
        bcopy((char *)(&n), VARDATA(res), sizeof(int));
        return(res);
    } else {
        elog(WARN,"stubin (in backend) was called with '%s'", s);
    }
}

char *
stubout(relstub)
Prs2RawStub relstub;
{
    char *s;
    int n;

    if (relstub==NULL) {
        n = 0;
    } else {
        bcopy(VARDATA(relstub), (char *)(&n), sizeof(int));
    }

    if (n==0) {
        s = (char *) palloc(2);
        s[0] = '-';
        s[1] = '\0';
        return(s);
    } else {
        elog(WARN,"stubout (in backend) was called with non-null stub");
    }
}

/*--------------------------------------------------------------
 *
 * prs2FreeLocks
 *
 * Yet another routine that is called from code called by backend
 * but it is not included in cinterface.a because it is in a file
 * with other routines that call some other routines also
 * not included in cinterface.a and therefore if we include all these
 * routines in cinterface.a then we might as well include all the 
 * postgres routines there, which might not be such a bad idea after all
 * because it will make things soooo easier, but on the other hand 
 * cinterface.a will become as big as postgres and we don't want that now,
 * do we?, and if you are tired reading all that... well, nobody said
 * that hacking postgres was gonna be easy...
 */
void
prs2FreeLocks(l)
RuleLock l;
{
    if (l!=NULL) {
	pfree(l);
    }
}

/*--------------------------------------------------------------
 * prs2CopyLocks
 *
 * Normally, the backend wiil call this routine only with empty locks.
 */
RuleLock
prs2CopyLocks(l)
RuleLock l;
{
    if (prs2RuleLockIsEmpty(l)) {
        return(NULL);
    }

    elog(WARN, "prs2CopyLocks: Called from backend with NON null lock");
}

RuleLock
prs2RemoveAllLocksOfRule(locks, ruleId)
    RuleLock locks;
    ObjectId ruleId;
{
    locks = locks;
    ruleId = ruleId;
    Assert(0);
}

RuleLock
prs2LockUnion(lock1, lock2)
    RuleLock lock1;
    RuleLock lock2;
{
    lock1 = lock1;
    lock2 = lock2;
    Assert(0);
}

/*-----------------------------------------------------------------
 * create an emtpy lock
 */
RuleLock
prs2MakeLocks()
{
    RuleLock t;

    t = (RuleLock) palloc(sizeof(Prs2LocksData));

    if (t==NULL) {
	elog(WARN, "prs2MakeLocks (stub version): palloc failed.");
    }

    t->numberOfLocks = 0;
    return(t);
}

/* ----------------
 *	be_portalinit() is called from postinit.c and pqtest() is
 *	a backend builtin.  these have no meaning to the cinterface
 *	support programs.
 * ----------------
 */
void
be_portalinit()
{
}

int32
pqtest()
{
    return 1;
}
List StringToPlanWithParams()
{
    elog(FATAL, "StringToPlanWithParams: called stubbed routine");
    return LispNil;		/* make lint happy */
}
int prs2RunOnePlanAndGetValue()
{
    elog(FATAL, "prs2RunOnePlanAndGetValue: called stubbed routine");
    return 0;	       /* make lint happy */
}

int paradj_nextpage(page,dir)
int page,dir;
{
    elog(FATAL, "paradj_nextpage: called stubbed routine");
    return 0;	       /* make lint happy */
}

TupleTable
ExecCreateTupleTable()
{
    elog(FATAL, "ExecCreateTupleTable: called stubbed routine");
    return 0;	       /* make lint happy */
}

void
ExecDestroyTupleTable()
{
    elog(FATAL, "ExecDestroyTupleTable: called stubbed routine");
}

Pointer
ExecGetTableSlot(table, slotnum)
{
    elog(FATAL, "ExecGetTableSlot: called stubbed routine");
    return 0;	       /* make lint happy */
}

int
ExecAllocTableSlot()
{
    elog(FATAL, "ExecAllocTableSlot: called stubbed routine");
    return 0;	       /* make lint happy */
}

bool
ExecQual()
{
    elog(FATAL, "ExecQual: called stubbed routine");
}

void
Async_NotifyAtCommit()
{
    elog(FATAL, "Async_NotifyAtCommit: called stubbed routine");
}

List
typeid_get_relid()
{
    elog(FATAL, "typeid_get_relid: called stubbed routine");
}

List
pg_plan()
{
    elog(FATAL, "pg_plan: called stubbed routine");
}

ObjectId *
funcname_get_funcargtypes ( function_name )
     char *function_name;
{
    elog(FATAL, "funcname_get_funcargtypes: called stubbed routine");     
}

bool
pg_checkretval( typeid, parselist )
    ObjectId typeid;
    List parselist;
{
    elog(FATAL, "pg_checkretval: called stubbed routine");
}

bool	VacuumRunning = false;
void
vc_abort()
{
    elog(FATAL, "vc_abort: called stubbed routine");
}
