#! /bin/sh
# ----------------------------------------------------------------
#	genexterns.sh - generate executor externs.h file
#
#	running this in the src/executor directory generates a file
#	called externs.h which contains extern declarations for
#	the executor source files.  It is intended that people
#	run this script and then move the resulting externs.h file
#	to the src/lib/H/executor directory.  When executor changes
#	are checked in, a new externs.h should be checked in also.
#	-cim 5/31/91
#
#	(pgdecs is a program Jeff Goh got off the net a while ago.)
#
#	$Header: /private/postgres/src/executor/RCS/genexterns.sh,v 1.1 1991/06/18 23:32:31 cimarron Exp $
# ----------------------------------------------------------------
rm -f externs.h
pgdecs *.c | sort +2 | awk '\
BEGIN {
    print "/* this file generated by genexterns.sh -- do not edit */\n";
    print "/* $Header: /private/postgres/src/executor/RCS/genexterns.sh,v 1.1 1991/06/18 23:32:31 cimarron Exp $ */\n";
}
/ARGS((void))/ 	{ print "/* bad extern:" $0 " */"; next; }
$2 ~ /^static/ 	{ print "/* bad extern:" $0 " */"; next; }
/^extern/ 	{ print; next; }
{ print "/* bad extern:" $0 " */"; next; }
END 		{ print "\n"; }
' > externs.h
