.\"unclutter man
.TH UNCLUTTER 1X
.SH NAME
unclutter \- remove idle cursor image from screen
.SH SYNOPSIS
.B
unclutter
.RB [ -display
.IR display ]
.RB [ -idle
.IR seconds ]
.RB [ -jitter
.IR pixels ]
.RB [ -grab ]
.RB [ -reset ]
.RB [ -root ]
.RB [ -not ]
.I "name ...
.SH DESCRIPTION
.B unclutter
removes the cursor image from the screen so that it does not
obstruct the area you are looking at after it has not moved for
a given time.
It does not do this if the cursor is in the root window or a button is down.
It tries to ignore jitter (small movements due to noise)
if you have a mouse that twitches.
.SH OPTIONS
.TP
-display
is followed by the display to open.
.TP
-idle
is followed by the number of seconds between polls for idleness.
The default is 5.
.TP
-jitter
is followed by the amount of movement of the pointer that is to be ignored
and considered as random noise.
The default is 0.
.TP
-grab
means use the original method of grabbing the pointer in order to remove the
cursor. 
This often doesn't interoperate too well with some window managers.
.TP
-reset
resets the timeout for idleness after the cursor is restored for some reason
(such as a window being pushed or popped) even though the x y coordinates
of the cursor have not changed.
Normally, the cursor would immediately be removed again.
.TP
-root
means remove the cursor even if it is on the root background, where in
principle it should not be obscuring anything useful.
.TP
-not
is followed by a list of window names where the cursor should not be
removed.
The first few characters of the WM_NAME property on the window need
to match one the listed names.
This argument must be the last on the command line.
.SH LIMITATIONS
Unfortunately, clients like emacs set different text cursor
shapes depending on whether they have pointer focus or not,
and so not only does the cursor pixture go, but the text cursor image changes.
Even more sadly, some window managers like to remove keyboard focus if pointer
focus is lost.
.SH DIAGNOSTICS
The message
.sp
 someone created a sub-window to my sub-window!
.sp 
means that unclutter thinks a second unclutter is running, and tried
to steal the cursor by creating a sub-window to the sub-window already
used to steal the cursor.
This situation quickly deteriorates into a fight no one can win, so
it is detected when possible and the program gives up.
.SH AUTHOR
Mark M Martin. cetia 24may1991. mmm@cetia.fr
