global errorInfo
set errorInfo {}

global auto_noexec
set auto_noexec 1

proc echo {args} {
  puts stdout $args
  flush stdout
} 

source $tk_library/wish.tcl

set SoundServer [connect -server "" ""]
set SoundServerPort $connect_info($SoundServer)
echo Sound server listening on port $SoundServerPort

filehandler $SoundServer re AcceptSoundConnection

set source_id 0
global source_info

global ResourceDir
set ResourceDir ""

proc StartSound {resourcedir} {
  global ResourceDir
  set ResourceDir $resourcedir
}

proc KillSoundServer {} {
  catch "destroy ."
  echo Sound server exiting.
  exit
}

proc AcceptSoundConnection {type fid} {
  global connect_info
  global source_info
  global source_id

  echo AcceptSoundConnection $type $fid
  if {$type == "e"} then {
    echo Got an exception on server $fid
  } else {
    echo Accepting connection from server fid $fid ...

    set client [accept $fid]

    set host [lindex $connect_info($client) 0]
    set port [lindex $connect_info($client) 1]

    set source socket$source_id
    set source_info($client) $source
    incr source_id

    echo Accepted new connection from host '$host', port $port, id $client source $source...

    sound socket $source
    sound play $source -channel intercom

    filehandler $client re HandleSoundClient
  }
}

proc HandleSoundClient {type fid} {
  global source_info

  set source $source_info($fid)

#  echo HandleSoundClient $type $fid $source

  if {$type == "r"} then {
    set pumped [sound pump $fid $source]
#echo PUMPED $pumped
    if {$pumped <= 0} then {
      set type "e"
    }
  }
  if {$type == "e"} then {
    echo Closing sound client $fid
    filehandler $fid
    shutdown $fid all
    close $fid
    sound forget $source
  }
}

set ResourceDir $tk_library

sound file Rumble $ResourceDir/rumble.au
sound file HeavyTraffic $ResourceDir/traffic.au
sound file Siren $ResourceDir/siren.au
sound file HonkHonk-Low $ResourceDir/honk-low.au
sound file Monster $ResourceDir/monster.au
sound file Explosion-High $ResourceDir/expl-hi.au
sound file HonkHonk-High $ResourceDir/honk-hi.au
sound file HonkHonk-Med $ResourceDir/honk-med.au
sound file Explosion-Low $ResourceDir/expl-low.au
sound file QuackQuack $ResourceDir/quack.au
sound file Ignition $ResourceDir/ignition.au
sound file Whip $ResourceDir/whip.au
sound file Cuckoo $ResourceDir/cuckoo.au
sound file Boing $ResourceDir/boing.au
sound file Skid $ResourceDir/skid.au
sound file Computer $ResourceDir/computer.au
sound file Sorry $ResourceDir/sorry.au
sound file UhUh $ResourceDir/uhuh.au
sound file Woosh $ResourceDir/woosh.au
sound file Aaah $ResourceDir/aaah.au
sound file Oop $ResourceDir/oop.au
sound file Beep $ResourceDir/beep.au
sound file Bop $ResourceDir/bop.au
sound file Zone $ResourceDir/zone.au
sound file Build $ResourceDir/build.au
sound file Res $ResourceDir/res.au
sound file Com $ResourceDir/com.au
sound file Ind $ResourceDir/ind.au
sound file Fire $ResourceDir/fire.au
sound file Query $ResourceDir/query.au
sound file Police $ResourceDir/police.au
sound file Wire $ResourceDir/wire.au
sound file Bulldozer $ResourceDir/bulldoze.au
sound file Rail $ResourceDir/rail.au
sound file Road $ResourceDir/road.au
sound file Chalk $ResourceDir/chalk.au
sound file Eraser $ResourceDir/eraser.au
sound file Stadium $ResourceDir/stadium.au
sound file Park $ResourceDir/park.au
sound file Seaport $ResourceDir/seaport.au
sound file Coal $ResourceDir/coal.au
sound file Nuclear $ResourceDir/nuclear.au
sound file Airport $ResourceDir/airport.au
sound file O $ResourceDir/o.au
sound file A $ResourceDir/a.au
sound file E $ResourceDir/e.au
