///////////////////////////////////////////////////////////////////////////////
// $Id: DrawingArea.cxx,v 1.1 1995/01/08 06:50:45 bmott Exp $
///////////////////////////////////////////////////////////////////////////////
//
// DrawingArea.hxx - DrawingArea widget class
//
//
// Bradford W. Mott
// Copyright (C) 1994
// November 3,1994
//
///////////////////////////////////////////////////////////////////////////////
// $Log: DrawingArea.cxx,v $
// Revision 1.1  1995/01/08  06:50:45  bmott
// Initial revision
//
///////////////////////////////////////////////////////////////////////////////

#include "DrawingArea.hxx"
#include "ContainerWidget.hxx"
#include "UIApplication.hxx"
#include "Sprite.hxx"

///////////////////////////////////////////////////////////////////////////////
// Constructor
///////////////////////////////////////////////////////////////////////////////
DrawingArea::DrawingArea(ContainerWidget* parent, const char *const widgetName, 
        int x, int y, int width, int height)
    : BasicWidget(parent, widgetName, x, y, width, height)
{
  // Create window for widget
  myWindow = XCreateSimpleWindow(application->display(), myParent->window(),
      x, y, width, height,
      0, 0, 0);

  // DrawingAreas have to respond to several event types
  XSelectInput(application->display(), myWindow, 
      ButtonPressMask | ButtonReleaseMask | ExposureMask |
      PointerMotionMask );
}

///////////////////////////////////////////////////////////////////////////////
// Destructor
///////////////////////////////////////////////////////////////////////////////
DrawingArea::~DrawingArea()
{
}

///////////////////////////////////////////////////////////////////////////////
// Called whenever an event arrives for me (I need to override the default)
///////////////////////////////////////////////////////////////////////////////
virtual void DrawingArea::handleEvent(XEvent* event)
{
}

