///////////////////////////////////////////////////////////////////////////////
//
// SpriteCollection.cxx - SpriteCollection class
//
//
// Bradford W. Mott
// Copyright (C) 1994
// November 12,1994
//
///////////////////////////////////////////////////////////////////////////////

#include <assert.h>
#include <string.h>
#include "Sprite.hxx"
#include "SpriteCollection.hxx"

///////////////////////////////////////////////////////////////////////////////
// Constructor
///////////////////////////////////////////////////////////////////////////////
SpriteCollection::SpriteCollection(unsigned char* spriteData[])
{
  // Create a sprite for every "raw" sprite
  for(int t=0; spriteData[t] != (unsigned char*)0; ++t)
  {
    // Create sprite
    Sprite* sprite = new Sprite(spriteData[t]);

    // Add it to my linked list
    ListOfSprites.append(sprite);
  }
}

///////////////////////////////////////////////////////////////////////////////
// Answer the sprite for the given name or (Sprite*)0 if it doesn't exist
///////////////////////////////////////////////////////////////////////////////
Sprite* SpriteCollection::getByName(const char* name)
{
  Sprite* p = ListOfSprites.first();
  while(p != (Sprite*)0)
  {
    if(strcmp(p->name(), name) == 0)
      return(p);

    p = ListOfSprites.next();
  }

  return((Sprite*)0);
}

