/*****************************************************************************
 *                                                                           *
 *  Copyright (c) 1993, 1994, 1995, Elan Feingold (feingold@zko.dec.com)     *
 *                                                                           *
 *     PERMISSION TO USE, COPY, MODIFY, AND TO DISTRIBUTE THIS SOFTWARE      *
 *     AND ITS DOCUMENTATION FOR ANY PURPOSE IS HEREBY GRANTED WITHOUT       *
 *     FEE, PROVIDED THAT THE ABOVE COPYRIGHT NOTICE APPEAR IN ALL           *
 *     COPIES AND MODIFIED COPIES AND THAT BOTH THAT COPYRIGHT NOTICE AND    *
 *     THIS PERMISSION NOTICE APPEAR IN SUPPORTING DOCUMENTATION.  THERE     *
 *     IS NO REPRESENTATIONS ABOUT THE SUITABILITY OF THIS SOFTWARE FOR      *
 *     ANY PURPOSE.  THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS       *
 *     OR IMPLIED WARRANTY.                                                  *
 *                                                                           *
 *****************************************************************************/

#ifndef _COLORMAP
#define _COLORMAP

#include "riskgame.h"
#include "types.h"

/* Data structures */
typedef struct _Color
{
  unsigned char r, g, b;
} Color;

#define BLACK 255
#define WHITE 254

void   COLOR_Init(void);
void   COLOR_SetWorldColormap(Color *cmap);
void   COLOR_SetWorldColors(void);
Int32  COLOR_DieToColor(Int32 iDie);
Int32  COLOR_PlayerToColor(Int32 iPlayer);
void   COLOR_ColorCountry(Int32 iCountry, Int32 iPlayer);
Int32  COLOR_CountryToColor(Int32 iCountry);
Int32  COLOR_ColorToCountry(Int32 iColor);
void   COLOR_CopyColor(Int32 iSrc, Int32 iDst);
void   COLOR_StoreNamedColor(CString strPlayerColor, Int32 iPlayer);
void   COLOR_GetColormap(void *pVisualArgs, Int32 *piNumArgs, 
			 Int32 iNeededColors, Int32 argc, CString *argv);

extern unsigned long   plCountryToColor[MAX_COLORS];
extern Int32           piColorToCountry[MAX_COLORS];
extern Colormap        cmapColormap;
extern Color           pColors[MAX_COLORS];
extern Int32           iNumColors;

#endif
