/*****************************************************************************
 *                                                                           *
 *  Copyright (c) 1993, 1994, 1995, Elan Feingold (feingold@zko.dec.com)     *
 *                                                                           *
 *     PERMISSION TO USE, COPY, MODIFY, AND TO DISTRIBUTE THIS SOFTWARE      *
 *     AND ITS DOCUMENTATION FOR ANY PURPOSE IS HEREBY GRANTED WITHOUT       *
 *     FEE, PROVIDED THAT THE ABOVE COPYRIGHT NOTICE APPEAR IN ALL           *
 *     COPIES AND MODIFIED COPIES AND THAT BOTH THAT COPYRIGHT NOTICE AND    *
 *     THIS PERMISSION NOTICE APPEAR IN SUPPORTING DOCUMENTATION.  THERE     *
 *     IS NO REPRESENTATIONS ABOUT THE SUITABILITY OF THIS SOFTWARE FOR      *
 *     ANY PURPOSE.  THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS       *
 *     OR IMPLIED WARRANTY.                                                  *
 *                                                                           *
 *****************************************************************************/

#include "callbacks.h"
#include "client.h"
#include "colormap.h"
#include "network.h"
#include "riskgame.h"
#include "dice.h"
#include "help.h"
#include "gui-func.h"
#include "debug.h"

/************************************************************************ 
 *  FUNCTION: main
 *  HISTORY: 
 *     01.23.94  ESF  Created.
 *     02.22.94  ESF  Cleaned up a bit, removing warnings.
 *     08.10.94  ESF  Cleanup up to make more OS independant.
 *     08.16.94  ESF  Moved to its own file, cleaned up.
 *     10.30.94  ESF  Fixed a bug, have to init dist. obj. first!
 *     12.30.94  ESF  Added more robust startup checks.
 *  PURPOSE: 
 *  NOTES: 
 ************************************************************************/
void main(int argc, char **argv)
{
  /* Check args */
  if (argc < 2)
    {
      printf("Usage: %s <server_host> [<xargs>]\n", argv[0]);
      exit(-1);
    }

  /* Setup memory debugging library */
  MEM_BootStrap("client-memory.log");

  /* Initialize everything */
  RISK_InitObject(MODE_CLIENT, CBK_ObjectMessage, CLNT_RecoverFailure);
  CLNT_Init(argc, argv);
  GUI_Setup(argc, argv);
  GUI_LoadMap(MAPFILE);
  COLOR_Init();
  GUI_AddCallbacks(CLNT_GetCommLinkOfClient(iThisClient));
  DICE_Init();
  HELP_Init(HELPFILE);

  /* And we're off... */
  GUI_Start();
}
