/*

    3Dc, a game of 3-Dimensional Chess
    Copyright (C) 1995  Paul Hicks

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    E-Mail: P.Hicks@net-cs.ucd.ie
*/
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/socket.h>

#include "machine.h"
#define I_NEED_GFX
#include "3Dc.h"

Colour AutoPlay = -1;
Colour bwToMove = white;
int DontMove = 0;

static void DoMain3DcLoop(void);

int main(int argc, char **argv)
{
  int nRetval;

  printf("3Dc version 0.7, Copyright (C) 1995 Paul Hicks\n");
  printf("3Dc comes with ABSOLUTELY NO WARRANTY: see the COPYLEFT file for details\n");
  printf("This is free software, and you are welcome to redistribute it\n");
  printf("    under certain conditions (see COPYLEFT file).\n");

  Init3Dc();

  if (argc == 3)
    {
      if (!strcmp(argv[1], "-play"))
        {
          if (!strcmp(argv[2], "black"))
            AutoPlay = black;
          else if (!strcmp(argv[2], "white"))
            AutoPlay = white;
          else
            {
              fprintf(stderr, "%s: %s is not a chess colour (must be black or white)\n", argv[0], argv[2]);
              return 1;
            }
        } /* End autoplay setup */
      else
        {
          if (!strcmp(argv[1], "-server"))
            nRetval = SetupServer(atoi(argv[2]));
          else
            nRetval = SetupClient(argv[1], atoi(argv[2]));

          if (nRetval != 0)
            {
              fprintf(stderr, "%s: connection to remote machine not made.  Sorry.\n", argv[0]);
              return 1;
            }
        } /* End net setup */
    }
  else if (argc == 2 | argc > 3)
    {
      fprintf(stderr, "Usage:\n");
      fprintf(stderr, "%s ; play 3Dc\n", argv[0]);
      fprintf(stderr, "%s -server port ; play as server on port port\n", argv[0]);
      fprintf(stderr, "%s server port ; play as client with server server on port port\n", argv[0]);
      fprintf(stderr, "%s -play colour ; play against the computer, who plays colour\n", argv[0]);
      return 1;
    }

  if ((nRetval = Init3DcGFX(argc, argv)))
    return nRetval;

  DoMain3DcLoop();

  Quit3DcGFX();

  return 0;
}

/* This main reason that this function is not in the interface file
 * because this file is so small and the interface is so big.  It also
 * helps that the function has at least as much to do with the net stuff
 * and engine stuff as with the interface stuff */
static void DoMain3DcLoop(void)
{
  int selretval;
  int bufsiz;
  char buf[6];
  fd_set fdset;
  struct timeval timeout;
  Move *automove;
  XEvent event;

  timeout.tv_sec = 0;

  while (gfxInfo.mainWindow)
    {
      if (XtAppPending(XtWidgetToApplicationContext(gfxInfo.mainWindow)))
        {
          XtAppNextEvent(XtWidgetToApplicationContext(gfxInfo.mainWindow),
                         &event);
          XtDispatchEvent(&event);
        }

      /* First thing to do: check for end of game! */
      if (!DontMove &&
          (!((Muster[white][idx(king, 0)])->bVisible) ||
           (!((Muster[white][idx(prince, 0)])->bVisible) &&
            !((Muster[white][idx(prince, 1)])->bVisible))))
        {
          DontMove = 1;
          XtSetSensitive(gfxInfo.undo, False);
          
          Err3Dc("Black player wins!", True);
        }
      else if (!DontMove &&
               (!((Muster[black][idx(king, 0)])->bVisible) ||
                (!((Muster[black][idx(prince, 0)])->bVisible) &&
                 !((Muster[black][idx(prince, 1)])->bVisible))))
        {
          DontMove = 1;
          XtSetSensitive(gfxInfo.undo, False);
          
          Err3Dc("White player wins!", True);
        }


      if ((SERVER && bwToMove == black) ||
          (CLIENT && bwToMove == white))
        {
          FD_ZERO(&fdset);
          FD_SET(TCP_FD, &fdset);
          timeout.tv_usec = 200;
          selretval = select(ulimit(4,0), &fdset, NULL, NULL, &timeout);
          if (selretval == -1)
            {
              fprintf(stderr, "Error: select failed.\n");  
              continue;
            }
          else if (selretval == 0)
            continue; /* Timeout */

          bufsiz = read(TCP_FD, buf, 6);
          if (bufsiz == 6)
            {
              /* First check to see if it is a command */
              if (buf[0] == '!')
                {
                  if (buf[1] == '!')
                    {
                      if (buf[2] == 'U') /* UNDO */
                        {
                          pieceUndo();
                          Err3Dc("Opponent undid move", True);
                        }
                    }
                }
              else
                {
                  char *string;

                  /* Do move */
                  pieceMove(Board[buf[0] - 'X']
                                 [buf[2] - '1']
                                 [buf[1] - 'a'],
                            buf[4] - 'a', buf[5] - '1', buf[3] - 'X');

                  string = strdup("???-??? by opponent");
                  string[0] = buf[0];
                  string[1] = buf[1];
                  string[2] = buf[2];
                  string[4] = buf[3];
                  string[5] = buf[4];
                  string[6] = buf[5];
                  Err3Dc(string, True);
                  free(string);

                  bwToMove = (bwToMove == white ? black : white);
                }
            }
          else
            {
              /* Ooops! Some lost input.  But no error correction yet.. */
            }
        }
      else if (bwToMove == AutoPlay && !DontMove)
        {
          char *string;

          automove = genMove(AutoPlay);

          pieceMove(Board[automove->xyzBefore.zLevel]
                         [automove->xyzBefore.yRank]
                         [automove->xyzBefore.xFile],
                    automove->xyzAfter.xFile,
                    automove->xyzAfter.yRank,
                    automove->xyzBefore.zLevel);
          string = strdup("???-??? by opponent");
          string[0] = automove->xyzBefore.zLevel + 'X';
          string[1] = automove->xyzBefore.xFile + 'a';
          string[2] = automove->xyzBefore.yRank + '1';
          string[4] = automove->xyzAfter.zLevel + 'X';
          string[5] = automove->xyzAfter.xFile + 'a';
          string[6] = automove->xyzAfter.yRank + '1';

          Err3Dc(string, True);
          free(string);
          bwToMove = (AutoPlay == white ? black : white);
        }
    }

  return;
}

/*************************************************************/
/* Utility functions */
extern int idx(const Title name, const int nth)
{
  switch (name)
    {
    case king:
      return 0;
    case queen:
      return 1;
    case bishop:
      return 1 + nth;
    case knight:
      return 3 + nth;
    case rook:
      return 5 + nth;
    case prince:
      return 7 + nth;
    case princess:
      return 9 + nth;
    case abbey:
      return 11 + nth;
    case cannon:
      return 15 + nth;
    case galley:
      return 19 + nth;
    default: /* pawn */
      return 23 + nth;
    }

  return 0; /* To avoid warnings */
}
