#include "myxlib.h"
#include "mymalloc.h"
#include "except.h"
#include <X11/Xlibint.h>

/****************************/
/* Special context function */
/****************************/

#define MAGICCONTEXT  13  /* Some number to get interesting bits at the end */

static Exception NoContext = { "Could not find given context-name pair" };

MyContext MyAllocContext(void)
{
    Display *dpy;

    dpy = mynew(Display);
    WITH_HANDLING {
        dpy->free_funcs = mynew(struct _XFreeFuncs);
        dpy->free_funcs->context_db = 0;
        dpy->context_db = NULL;
    } ON_EXCEPTION {
        myfree(dpy);
        ReRaise();
    } END_HANDLING;
    return (MyContext) dpy;
}

void MyFreeContext(MyContext Context)
{
    Display *dpy;

    dpy = (Display *) Context;
    if (dpy->free_funcs->context_db) (*dpy->free_funcs->context_db)(dpy);
    myfree(dpy->free_funcs);
    myfree(dpy);
}

void MySaveContext(MyContext Context, Widget w, XrmQuark Name, XtPointer Value)
{
    if (XSaveContext((Display *) Context, ((XID) w)/MAGICCONTEXT,
                     Name, Value))
        Raise1(OutOfMemory, "while saving context");
}

/* rc 0 means found */
int MyFindContext(MyContext Context, Widget w, XrmQuark Name, XtPointer *Value)
{
    XPointer data;
    int      rc;
    
    rc = XFindContext((Display *) Context, ((XID) w)/MAGICCONTEXT,
                      Name, &data);
    if (rc == 0) *Value = data;
    return rc;
}

void MyDeleteContext(MyContext Context, Widget w, XrmQuark Name)
{
    if (XDeleteContext((Display *) Context, ((XID) w)/MAGICCONTEXT,
                       Name))
        Raise(NoContext);
}

void MyQSaveContext(MyContext Context, XtPointer q,
                    XrmQuark Name, XtPointer Value)
{
    if (XSaveContext((Display *) Context, (XID) q, Name, Value))
        Raise1(OutOfMemory, "while saving context");
}

int MyQFindContext(MyContext Context, XtPointer q,
                   XrmQuark Name, XtPointer *Value)
{
    XPointer data;
    int      rc;
    
    rc = XFindContext((Display *) Context, (XID) q, Name, &data);
    if (rc == 0) *Value = data;
    return rc;
}

void MyQDeleteContext(MyContext Context, XtPointer q, XrmQuark Name)
{
    if (XDeleteContext((Display *) Context, (XID) q, Name))
        Raise(NoContext);
}
