/***********************************************************
*  Mirror Magic II -- McDuffins Revenge                    *
*----------------------------------------------------------*
*  1994 Artsoft Development                               *
*        Holger Schemel                                    *
*        33659 Bielefeld-Senne                             *
*        Telefon: (0521) 493245                            *
*        eMail: aeglos@valinor.ms.sub.org                  *
*               aeglos@uni-paderborn.de                    *
*               q99492@pbhrzx.uni-paderborn.de             *
*----------------------------------------------------------*
*  sound.h                                                 *
*                                                          *
*  Letzte Aenderung: 29.09.1994                            *
***********************************************************/

#ifndef SOUND_H
#define SOUND_H

#include "global.h"

#define BLOCKSIZE 1024

#ifdef hpux
#include <sys/audio.h>
#define BLOCKSIZE 32768
#endif /* hpux */

struct SoundHeader
{
  unsigned long magic;
  unsigned long hdr_size;
  unsigned long data_size;
  unsigned long encoding;
  unsigned long sample_rate;
  unsigned long channels;
};

struct SoundInfo
{ 
  char *name;
  char *buf;
  unsigned long len;
} Sound[NUM_SOUNDS];

struct SoundCtrl
{
  int nr;
  int channel;
  BOOL loop;
  BOOL stop;
};

void SoundEventLoop(void);
void PlaySound(int, int, int);
void StopSound(int);
void StopSounds(void);
void FadeSound(int);
BOOL LoadSound(int);
void FreeSounds(void);

#endif
