#include "xbill.h"
#include "widgets.h"

#include <X11/Xaw/XawInit.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/AsciiText.h>

#include "DrawingA.h"

extern Display *display;
extern Window rootwindow;
extern Widget toplevel;
extern menutype menu;
extern Pixmap logo;
Widget pausebutton;

Widget CreateMenuBar(char *name, Widget parent, menutype menu) {
	int i,j;
	Arg wargs[3];
	Widget menubar, temp;
	static int loc[MAXMENUS][MAXMENUSIZE][2];
	for (j=0; j<menu.size; j++)
		for (i=0; i<menu.submenu[j].size; i++) {
			loc[j][i][0]=j;
			loc[j][i][1]=i;
		}
	menubar = XtCreateManagedWidget("menubar", boxWidgetClass, parent,
		NULL, 0);
	XtSetArg (wargs[0], XtNorientation, XtEhorizontal);
	XtSetValues (menubar, wargs, 1);
	for (j=0; j<menu.size; j++) {
		temp = XtCreateManagedWidget(menu.submenu[j].name,
			menuButtonWidgetClass, menubar, NULL, 0);
		menu.submenu[j].pshell = XtCreatePopupShell("menu",
			simpleMenuWidgetClass, temp, NULL, 0);
		for (i=0; i<menu.submenu[j].size; i++) {
			if (strlen(menu.submenu[j].button[i].name)) {
				temp = XtCreateManagedWidget(
					menu.submenu[j].button[i].name,
					smeBSBObjectClass,
					menu.submenu[j].pshell, NULL, 0);
	                       if (!strcmp(menu.submenu[j].button[i].name, "Pause game"))
	                                pausebutton=temp;
				XtAddCallback(temp, XtNcallback,
					menu.submenu[j].button[i].callback,
					menu.submenu[j].button[i].arg);
			}
			else temp = XtCreateManagedWidget("",
				smeLineObjectClass, menu.submenu[j].pshell,
				NULL, 0);
		}
	}
	return menubar;
}


void close_window (Widget w, XtPointer client_data, XtPointer call_data) {
	XtPopdown(XtParent(XtParent(w)));
}

void get_xy (Position *x, Position *y) {
	XWindowAttributes wattr;
	Window junk;
	int rx, ry;
	XGetWindowAttributes (display, XtWindow(toplevel), &wattr);
	XTranslateCoordinates (display, XtWindow(toplevel), wattr.root, 
		-wattr.border_width, -wattr.border_width, &rx, &ry, &junk);
	*x=rx+20;
	*y=ry+50;
}

Widget CreatePixmapBox(char *name, Widget parent, Pixmap pixmap,
	char *text)
{
	Widget base, pshell, button;
	Arg wargs[2];
	Position x, y;
	get_xy(&x, &y);

	pshell = XtCreatePopupShell("pshell", transientShellWidgetClass, parent, NULL, 0);
	XtMoveWidget(pshell, x, y);
DPRINTF ("start create pixmap box\n");

	base = CreateRowCol("", pshell);

	XtSetArg(wargs[0], XtNbitmap, logo);
	XtCreateManagedWidget("", labelWidgetClass, base, wargs, 1);

	XtSetArg(wargs[0], XtNbitmap, pixmap);
	XtCreateManagedWidget("", labelWidgetClass, base, wargs, 1);
	if (text) {
		XtSetArg(wargs[0], XtNlabel, text);
		XtCreateManagedWidget("", labelWidgetClass, base, wargs, 1);
	}

	XtSetArg(wargs[0], XtNlabel, "OK");
	button = XtCreateManagedWidget("", commandWidgetClass, base, wargs, 1);
	XtAddCallback(button, XtNcallback, (XtCallbackProc)close_window, NULL);
	return base;
}

void warp_apply (Widget w, Widget text, XtPointer client_data) {
	char *str;
	int i;
	XtVaGetValues(text, XtNstring, &str, NULL);
	i=atoi(str);
	warp_to_level(i);
}

void enter_name (Widget w, Widget text, XtPointer client_data) {
	char *str;
	XtVaGetValues(text, XtNstring, &str, NULL);
	if (!strcmp(str,"")) strcpy(str, "Anonymous");
	str[20] = 0;  /* truncate string if too long */
	recalc_high_scores(str);
}

Widget CreateEnterText
	(char *name, Widget parent, int buttonmask, char *text, XtCallbackProc callback)
{
	Widget base, pshell, button, textfield;
	Arg wargs[2];
	Position x, y;
	char *str;
	get_xy(&x, &y);
	pshell = XtCreatePopupShell("pshell", transientShellWidgetClass, parent, NULL, 0);
	XtMoveWidget(pshell, x, y);
	base = CreateRowCol("", pshell);
	XtSetArg(wargs[0], XtNlabel, text);
	XtCreateManagedWidget("", labelWidgetClass, base, wargs, 1);

	XtSetArg(wargs[0], XtNeditType, XawtextEdit);
	XtSetArg(wargs[1], XtNstring, "");
	textfield = XtCreateManagedWidget("", asciiTextWidgetClass, base, wargs, 2);

	if (buttonmask&OK)
		XtSetArg(wargs[0], XtNlabel, "OK");
		button = XtCreateManagedWidget("", commandWidgetClass, base, wargs, 1);
		XtAddCallback(button, XtNcallback, (XtCallbackProc)callback, textfield);
		XtAddCallback(button, XtNcallback, (XtCallbackProc)close_window, NULL);
	if (buttonmask&CANCEL)
		XtSetArg(wargs[0], XtNlabel, "Cancel");
		button = XtCreateManagedWidget("", commandWidgetClass, base, wargs, 1);
		XtAddCallback(button, XtNcallback, (XtCallbackProc)close_window, NULL);
	return base;
}

Widget CreateDialog (char *name, Widget parent, int buttonmask, Pixmap icon,
	char *text, char *buttonlabel, XtCallbackProc callback)
{
	Widget base, pshell, button;
	Arg wargs[2];
	Position x, y;
	char *ttext=malloc(strlen(text)+5);
	get_xy(&x, &y);
	pshell = XtCreatePopupShell("pshell", transientShellWidgetClass, parent, NULL, 0);
	XtMoveWidget(pshell, x, y);
	base = CreateRowCol("base", pshell);
	strcpy(ttext, text);
	if (strlen(ttext)<10) strcat(ttext, "   ");
	XtSetArg(wargs[0], XtNlabel, ttext);
	XtCreateManagedWidget("label", labelWidgetClass, base, wargs, 1);
	if (icon) {
		XtSetArg(wargs[0], XtNbitmap, icon);
		XtCreateManagedWidget("", labelWidgetClass, base, wargs, 1);
	}
	if (buttonmask&OK) {
		if (buttonlabel)
			XtSetArg(wargs[0], XtNlabel, buttonlabel);
		else 
			XtSetArg(wargs[0], XtNlabel, "OK");
		button = XtCreateManagedWidget("button1", commandWidgetClass, base, wargs, 1);
		if (callback)
			XtAddCallback(button, XtNcallback, (XtCallbackProc)callback, NULL);
		XtAddCallback(button, XtNcallback, (XtCallbackProc)close_window, NULL);
	}
	if (buttonmask&CANCEL) {
		XtSetArg(wargs[0], XtNlabel, "Cancel");
		button = XtCreateManagedWidget("button2", commandWidgetClass, base, wargs, 1);
		XtAddCallback(button, XtNcallback, (XtCallbackProc)close_window, NULL);
	}
	return base;
}

Widget CreateDrawingArea(char *name, Widget parent, int width, int height) {
	Widget area;
        area = XtCreateManagedWidget(name, drawingAreaWidgetClass, parent, NULL, 0);
	XtVaSetValues(area, XtNwidth, width, XtNheight, height, XtNbackground, WhitePixelOfScreen(XtScreen(area)), NULL);
	return area;
}

void update_high_scores(Widget highscorebox, scorelist scores[10]) {
	int n;
	WidgetList t;
	char str[1000], temp[40];
	int i, j;
	strcpy (str,"               High Scores:          \n\n");
	strcat (str, "Name                     Level     Score\n");
	for (i=0; i<10; i++) {
		strcat (str, scores[i].name);
		for (j=strlen(scores[i].name); j<25; j++) strcat (str, " ");
		sprintf (temp, "%5d   %7d\n", scores[i].level, scores[i].score);
		strcat (str, temp);
	}
	XtVaGetValues(highscorebox, XtNchildren, &t, NULL);
	print_to_widget(t[0], str);
}

void update_scorebox(Widget scorebox, int level, int score) {
	WidgetList t;
	char str[40];
	sprintf (str, "After Level %d:     \nYour score: %d\n", level, score);
	XtVaGetValues(scorebox, XtNchildren, &t, NULL);
	print_to_widget(t[0], str);
}


void print_to_widget(Widget w, char *str) {
	XtVaSetValues(w, XtNlabel, str, NULL);
}

Widget CreateLabel(char *name, Widget parent) {
        return XtCreateManagedWidget(name, labelWidgetClass, parent, NULL, 0);
}

Widget CreateSep(char *name, Widget parent) {
        return (Widget)0;
}

Widget CreateRowCol(char *name, Widget parent) {
        return XtCreateManagedWidget(name, boxWidgetClass, parent, NULL, 0);
}

