/****************************************************************************
 * This module is all new
 * by Rob Nation (nation@rocket.sanders.lockheed.com 
 ****************************************************************************/
/***********************************************************************
 *
 * fvwm menu code
 *
 ***********************************************************************/

#include <stdio.h>
#include <signal.h>
#include <string.h>
#include <X11/Xos.h>
#include "fvwm.h"
#include "menus.h"
#include "misc.h"
#include "parse.h"
#include "screen.h"

extern XEvent Event;

XGCValues Globalgcv;
unsigned long Globalgcm;

void DrawPartitionLines();
FvwmWindow *FindCounterpart(Window target);
Bool pagerOn = True;

/****************************************************************************
 * Cause the pager window to be re-drawn
 *
 * Trying to get clever - re-draw the pager by causing an expose event,
 * the really redraw only when an expose arrives. Advantage is that the
 * number of re-draws will be minimized
 ***************************************************************************/
void RedrawPager()
{
#ifndef NO_PAGER
  if(Scr.FvwmPager)
    XClearArea(dpy,Scr.Pager_w, 0, 0, Scr.FvwmPager->frame_width,
	       Scr.FvwmPager->frame_height,True);
#endif
}

Bool EnablePagerRedraw = True;
void ReallyRedrawPager()
{
#ifndef NO_PAGER
  FvwmWindow *t;
  Pixel TextColor,BackColor;

  if(!Scr.FvwmPager)
    return;
  
  if(!EnablePagerRedraw)
    return;

  flush_expose (Scr.Pager_w);
  flush_expose (Scr.CPagerWin);

  if(Scr.PagerFont.height > 0)
    {
      if(Scr.Focus != NULL)
	{
	  if(!(Scr.Focus->flags & STICKY)&&
	     (!(Scr.Focus->flags & ICON)||(!(Scr.flags & SuppressIcons)))&&
	     (!(Scr.Focus->flags & ICON)||(!(Scr.flags & StickyIcons)))&&
	     (Scr.Focus->icon_name != NULL))
	    {
	      TextColor = Scr.HiColors.fore;
	      BackColor = Scr.HiColors.back;
	      NewFontAndColor(Scr.PagerFont.font->fid,TextColor,BackColor);
	      XDrawString (dpy, Scr.Focus->pager_view, Scr.FontGC,
			   2,Scr.PagerFont.y+2, 
			   Scr.Focus->icon_name, strlen(Scr.Focus->icon_name));
	    }
	}

      TextColor = Scr.StdColors.fore;
      BackColor = Scr.StdColors.back;
      NewFontAndColor(Scr.PagerFont.font->fid,TextColor,BackColor);
      for (t = Scr.FvwmRoot.next; t != NULL; t = t->next)
	{
	  if(t != Scr.Focus)
	    {
	      if(!(t->flags & STICKY)&&
		 (!(t->flags & ICON)||(!(Scr.flags & SuppressIcons)))&&
		 (!(t->flags & ICON)||(!(Scr.flags & StickyIcons)))&&
		 (t->icon_name != NULL))
		XDrawString (dpy, t->pager_view, Scr.FontGC,
			     2,Scr.PagerFont.y+2, 
			     t->icon_name, strlen(t->icon_name));
	    }
	}
    }
  DrawPartitionLines();
#endif
}

#ifndef NO_PAGER
void DrawPartitionLines()
{
  int y, y1, y2, x, x1, x2;
  int MaxW,MaxH,width,height;

  MaxW = Scr.VxMax + Scr.MyDisplayWidth;
  MaxH = Scr.VyMax + Scr.MyDisplayHeight;

  width = Scr.FvwmPager->frame_width - 2*Scr.FvwmPager->boundary_width;
  height = Scr.FvwmPager->frame_height - Scr.FvwmPager->title_height 
    - 2*Scr.FvwmPager->boundary_width;

  x = Scr.MyDisplayWidth;
  y1 = 0;
  y2 = height;
  while(x < MaxW)
    {
      x1 = x*width/MaxW;
      XDrawLine(dpy,Scr.Pager_w,Scr.NormalGC,x1,y1,x1,y2);
      x += Scr.MyDisplayWidth;
    }

  y = Scr.MyDisplayHeight;
  x1 = 0;
  x2 = width;
  while(y < MaxH)
    {
      y1 = y*height/MaxH;
      XDrawLine(dpy,Scr.Pager_w,Scr.NormalGC,x1,y1,x2,y1);
      y += Scr.MyDisplayHeight;
    }
}
#endif

void SwitchPages(Bool align, Bool ChangeFocus)
{
#ifndef NO_PAGER
  int x,y;
  unsigned int width,height;
  FvwmWindow *tmp_win;
  Window dumwin;

  if(!Scr.FvwmPager)
    return;

  XTranslateCoordinates (dpy, Event.xbutton.window, Scr.Pager_w,
			 Event.xbutton.x, Event.xbutton.y, &x, &y, &dumwin);

  width = Scr.FvwmPager->frame_width - 2*Scr.FvwmPager->boundary_width;
  height = Scr.FvwmPager->frame_height - Scr.FvwmPager->title_height 
    - 2*Scr.FvwmPager->boundary_width;

  if(x<0)x=0;
  if(y<0)y=0;
  x = x * (Scr.VxMax+Scr.MyDisplayWidth)/width;
  y = y * (Scr.VyMax+Scr.MyDisplayHeight)/height;
  if(align)
    {
      x = (x/Scr.MyDisplayWidth)*Scr.MyDisplayWidth;
      y = (y/Scr.MyDisplayHeight)*Scr.MyDisplayHeight;
    }
  if(x<0)x=0;
  if(y<0)y=0;

  MoveViewport(x,y,True);
  
  if((ChangeFocus)&&(Scr.flags & ClickToFocus))
    {
      tmp_win = FindCounterpart(Event.xbutton.subwindow);
      if(tmp_win)
	{
	  RaiseWindow(tmp_win);
	  SetBorder(tmp_win,True,False,True,None);	
	}
    }
#endif
}


void RaiseWindow(FvwmWindow *t)
{
  XRaiseWindow(dpy,t->lead_w);

  SetTimer(0);

#ifndef NO_PAGER
  if((Scr.Pager_w)&& !(t->flags & STICKY))
    {
      XRaiseWindow(dpy,t->pager_view);
    }
#endif

  if ((t->flags & ICON)&&(!(Scr.flags & SuppressIcons)))
    {
      XRaiseWindow(dpy, t->icon_w);
      XRaiseWindow(dpy, t->icon_pixmap_w);
    }
  Scr.LastWindowRaised = t;
  RedrawPager();
}


void LowerWindow(FvwmWindow *t)
{
  XLowerWindow(dpy,t->lead_w);

  SetTimer(0);

#ifndef NO_PAGER
  if((Scr.Pager_w)&& !(t->flags & STICKY))
    XLowerWindow(dpy,t->pager_view);
#endif

  if((t->flags & ICON)&&(!(Scr.flags & SuppressIcons)))
    {
      XLowerWindow(dpy, t->icon_w);
      XLowerWindow(dpy, t->icon_pixmap_w);
    }
  Scr.LastWindowRaised = (FvwmWindow *)0;
#ifndef NO_PAGER
  XLowerWindow(dpy,Scr.CPagerWin);
#endif
  RedrawPager();
}


void PagerMoveWindow()
{
#ifndef NO_PAGER
  FvwmWindow *tmp_win;
  unsigned int width, height;
  int Xoff,Yoff,x,y,MaxW,MaxH,xl,yt,xl1,yt1;
  Window target;
  Bool done,finished = False;

  if(!Scr.FvwmPager)
    return;

  target = Event.xbutton.subwindow;
  tmp_win = FindCounterpart(target);

  if(tmp_win == NULL)
    return;


  MaxW = Scr.VxMax + Scr.MyDisplayWidth;
  MaxH = Scr.VyMax + Scr.MyDisplayHeight;

  width = Scr.FvwmPager->frame_width - 2*Scr.FvwmPager->boundary_width;
  height = Scr.FvwmPager->frame_height - Scr.FvwmPager->title_height 
    - 2*Scr.FvwmPager->boundary_width;

  XQueryPointer(dpy, target, &JunkRoot, &JunkChild,
		&JunkX, &JunkY,	&Xoff, &Yoff, &JunkMask);

  XQueryPointer(dpy, Scr.Pager_w, &JunkRoot, &JunkChild,
		&JunkX, &JunkY, &xl, &yt, &JunkMask);
  if(xl<0)xl=0;
  if(yt<0)yt=0;
  if(xl>width)xl=width;
  if(yt>height)yt=height;
  xl -= Xoff;
  yt -= Yoff;
  xl1=xl;
  yt1=yt;
  while (!finished)
    {
      /* block until there is an interesting event */
      XMaskEvent(dpy, ButtonPressMask | ButtonReleaseMask | KeyPressMask |
		 PointerMotionMask | ButtonMotionMask |
		 VisibilityChangeMask, &Event);
      if (Event.type == MotionNotify) 
	/* discard any extra motion events before a logical release */
	while(XCheckMaskEvent(dpy, PointerMotionMask | ButtonMotionMask |
			      ButtonRelease|ExposureMask, &Event))
	  if(Event.type == ButtonRelease) break;

      done = FALSE;

      /* Handle a limited number of key press events to allow mouseless
       * operation */
      if(Event.type == KeyPress)
	Keyboard_shortcuts(&Event,ButtonRelease);
      switch(Event.type)
	{
	case ButtonPress:
	case KeyPress:
	  /* throw away enter and leave events until release */
	  done = TRUE;
	  break;
	case ButtonRelease:
	  XQueryPointer(dpy, Scr.Pager_w, &JunkRoot, &JunkChild,
			&JunkX, &JunkY, &xl, &yt, &JunkMask);
	  if(xl<0)xl=0;
	  if(yt<0)yt=0;
	  if(xl>width)xl=width;
	  if(yt>height)yt=height;
	  xl -= Xoff;
	  yt -= Yoff;
	  done = TRUE;
	  finished = TRUE;
	  break;

	case MotionNotify:
	  XQueryPointer(dpy, Scr.Pager_w, &JunkRoot, &JunkChild,
			&JunkX, &JunkY, &xl, &yt, &JunkMask);
	  if(xl<0)xl=0;
	  if(yt<0)yt=0;
	  if(xl>width)xl=width;
	  if(yt>height)yt=height;

	  /* redraw the rubberband */
	  xl -= Xoff;
	  yt -= Yoff;

	  done = TRUE;
	  break;

	default:
	  break;
	}
      if(!done)
	{
	  DispatchEvent();
	}
      XMoveWindow(dpy, target,xl, yt);
      DrawPartitionLines(MaxW,MaxH,width,height);
    }

  x = xl*MaxW/(int)width - Scr.Vx;
  y = yt*MaxH/(int)height - Scr.Vy;

  if((xl1!=xl)||(yt1 != yt))
    {
      if((tmp_win->flags & ICON)&&(!(Scr.flags & SuppressIcons)))
	{
	  tmp_win->icon_x_loc = x;
	  tmp_win->icon_xl_loc = x - 
	    (tmp_win->icon_w_width - tmp_win->icon_p_width)/2;
	  tmp_win->icon_y_loc = y;
	  XMoveWindow (dpy, tmp_win->icon_w, tmp_win->icon_xl_loc, y+tmp_win->icon_p_height);

	  if(tmp_win->icon_pixmap_w != None)
	    XMoveWindow (dpy, tmp_win->icon_pixmap_w, x,y);
	}
      else 
	{
	  /* show the actual window */
	  SetupFrame(tmp_win,x,y, tmp_win->frame_width,tmp_win->frame_height,FALSE);
	}  
    }
  RedrawPager();
#endif      
}



#ifndef NO_PAGER
FvwmWindow *FindCounterpart(Window target)
{
  FvwmWindow *t,*tmp_win=0;

  tmp_win = NULL;
  for (t = Scr.FvwmRoot.next; t != NULL; t = t->next)
    {
      if(t->pager_view == target)
	{
	  tmp_win = t;
	}
    }
  return tmp_win;
}
#endif

/***************************************************************************
 * 
 * Check to see if the pointer is on the edge of the screen, and scroll/page
 * if needed 
 ***************************************************************************/
void HandlePaging(int HorWarpSize, int VertWarpSize, int *xl, int *yt, 
		  int *delta_x, int *delta_y,Bool Grab)
{
  int x,y;
  Bool failed = False;

  *delta_x = 0;
  *delta_y = 0;
  
#ifndef NON_VIRTUAL	  
  if((Scr.ScrollResistance >= 10000)||((HorWarpSize ==0)&&(VertWarpSize==0)))
    return;

  /* need to move the viewport */
  if(( *xl >= SCROLL_REGION)&&( *xl < Scr.MyDisplayWidth-SCROLL_REGION)&&
     ( *yt >= SCROLL_REGION)&&( *yt < Scr.MyDisplayHeight-SCROLL_REGION))
    return;
  
  sleep_a_little(Scr.ScrollResistance*1000);

  while(XCheckMaskEvent(dpy, (PointerMotionMask| ButtonMotionMask),&Event))
    {
      /* check for motion outside of the scroll border */
      if((Event.xmotion.x_root >= SCROLL_REGION)&&
	 ( Event.xmotion.x_root < Scr.MyDisplayWidth-SCROLL_REGION)&&
	 ( Event.xmotion.y_root >= SCROLL_REGION)&&
	 ( Event.xmotion.y_root < Scr.MyDisplayHeight-SCROLL_REGION))
	failed = True;
    }
  if(failed)return;
      

  XQueryPointer(dpy, Scr.Root, &JunkRoot, &JunkChild,
		&x, &y, &JunkX, &JunkY, &JunkMask);   
  if(( x < SCROLL_REGION)||( x >= Scr.MyDisplayWidth-SCROLL_REGION)||
     ( y < SCROLL_REGION)||( y >= Scr.MyDisplayHeight-SCROLL_REGION))
    {
      /* Turn off the rubberband if its on */
      MoveOutline(Scr.Root,0,0,0,0);

      /* Move the viewport */
      /* and/or move the cursor back to the approximate correct location */
      /* that is, the same place on the virtual desktop that it */
      /* started at */
      if( x<SCROLL_REGION)
	*delta_x = -HorWarpSize;
      else if ( x >= Scr.MyDisplayWidth-SCROLL_REGION)
	*delta_x = HorWarpSize;
      else
	*delta_x = 0;
      if( y<SCROLL_REGION)
	*delta_y = -VertWarpSize;
      else if ( y >= Scr.MyDisplayHeight-SCROLL_REGION)
	*delta_y = VertWarpSize;
      else
	*delta_y = 0;

      /* Ouch! lots of bounds checking */
       if(Scr.Vx + *delta_x < 0) 
	 {
	   if (!(Scr.flags & EdgeWrapX ))
	     {
	       *delta_x = -Scr.Vx;
	       *xl = x - *delta_x;
	     }
	   else 
	     {
	       *delta_x += Scr.VxMax + Scr.MyDisplayWidth;
	       *xl = x + *delta_x % Scr.MyDisplayWidth + HorWarpSize;
	     }
	 }
       else if(Scr.Vx + *delta_x > Scr.VxMax)
	 {
	   if (!(Scr.flags & EdgeWrapX))
	     {
	       *delta_x = Scr.VxMax - Scr.Vx;
	       *xl = x - *delta_x;
	     }
	   else 
	     {
	       *delta_x -= Scr.VxMax +Scr.MyDisplayWidth;
	       *xl = x + *delta_x % Scr.MyDisplayWidth - HorWarpSize;
	     }
	 }
       else
	 *xl = x - *delta_x;
 
      if(Scr.Vy + *delta_y < 0) 
	{
	  if (!(Scr.flags & EdgeWrapY))
	    {
	      *delta_y = -Scr.Vy;
	      *yt = y - *delta_y;
	    }
	  else
	    {
	      *delta_y += Scr.VyMax + Scr.MyDisplayHeight;
	      *yt = y + *delta_y % Scr.MyDisplayHeight + VertWarpSize;
	    }
	}
       else if(Scr.Vy + *delta_y > Scr.VyMax) 
	 {
 	if (!(Scr.flags & EdgeWrapY))
	  {
	    *delta_y = Scr.VyMax - Scr.Vy;
	    *yt = y - *delta_y;
	  }
 	else
	  {
	    *delta_y -= Scr.VyMax + Scr.MyDisplayHeight;
	    *yt = y + *delta_y % Scr.MyDisplayHeight - VertWarpSize;
	  }
      }
       else
	 *yt = y - *delta_y;
 	  
      if(*xl < SCROLL_REGION) *xl = SCROLL_REGION;
      if(*yt < SCROLL_REGION) *yt = SCROLL_REGION;
      if(*xl >= Scr.MyDisplayWidth - SCROLL_REGION)
	*xl = Scr.MyDisplayWidth - SCROLL_REGION -1;
      if(*yt >= Scr.MyDisplayHeight - SCROLL_REGION)
	*yt = Scr.MyDisplayHeight - SCROLL_REGION -1;
      
      if((*delta_x != 0)||(*delta_y!=0))
	{
	  if(Grab)
	    XGrabServer(dpy);
	  XWarpPointer(dpy,None,Scr.Root,0,0,0,0,*xl,*yt);
	  MoveViewport(Scr.Vx + *delta_x,Scr.Vy + *delta_y,False);
	  XQueryPointer(dpy, Scr.Root, &JunkRoot, &JunkChild,
			xl, yt, &JunkX, &JunkY, &JunkMask);
	  if(Grab)
	    XUngrabServer(dpy);
	}
    }

#endif	  
}



void MoveResizeViewPortIndicator(void)
{
  int width,height,x1,x2,y1,y2;

#ifndef NO_PAGER
  width = Scr.FvwmPager->frame_width - 2*Scr.FvwmPager->boundary_width;
  height = Scr.FvwmPager->frame_height - Scr.FvwmPager->title_height 
    - 2*Scr.FvwmPager->boundary_width;
  x1 = Scr.Vx * width/(Scr.VxMax+Scr.MyDisplayWidth)+1;
  y1 = Scr.Vy * height/(Scr.VyMax+Scr.MyDisplayHeight)+1;
  x2 = (Scr.MyDisplayWidth) * width/(Scr.VxMax+Scr.MyDisplayWidth)-1;
  y2 = (Scr.MyDisplayHeight) * height/(Scr.VyMax+Scr.MyDisplayHeight)-1;
  if(x1==1)
    {
      x1--;
      x2++;
    }
  if(y1==1)
    {
      y1--;
      y2++;
    }
  XMoveResizeWindow(dpy,Scr.CPagerWin,x1,y1,x2,y2);
#endif
}


void MoveResizePagerView(FvwmWindow *t)
{
#ifndef NO_PAGER
  unsigned int width,height;
  int ww,wh;
  int wx,wy;
  int MaxH,MaxW;

  if((!Scr.FvwmPager)||(!pagerOn))
    return;

  width = Scr.FvwmPager->frame_width - 2*Scr.FvwmPager->boundary_width;
  height = Scr.FvwmPager->frame_height - Scr.FvwmPager->title_height 
    - 2*Scr.FvwmPager->boundary_width;

  MaxW = Scr.VxMax + Scr.MyDisplayWidth;
  MaxH = Scr.VyMax + Scr.MyDisplayHeight;

  if(!(t->flags & STICKY)&&
     (!(t->flags & ICON)||(!(Scr.flags & SuppressIcons)))&&
     (!(t->flags & ICON)||(!(Scr.flags & StickyIcons))))
    {
      if(t->flags & ICON)
	{	      
	  /* show the icon loc */
	  wx = (t->icon_x_loc + Scr.Vx)*(int)width/MaxW;;
	  wy = (t->icon_y_loc + Scr.Vy)*(int)height/MaxH;
	  ww = t->icon_w_width*(int)width/MaxW;
	  wh = (t->icon_w_height+t->icon_p_height)*(int)height/MaxH;
	}
      else 
	{
	  /* show the actual window */
	  wx = (t->frame_x + Scr.Vx)*(int)width/MaxW;
	  wy = (t->frame_y + Scr.Vy)*(int)height/MaxH;
	  ww = t->frame_width*(int)width/MaxW;
	  wh = t->frame_height*(int)height/MaxH;
	}
      if(ww<2)ww=2;
      if(wh<2)wh=2;
      XMoveResizeWindow(dpy, t->pager_view, wx, wy, ww, wh);
    }
  else
    {
      /* window is sticky - make sure that the pager_view window is not 
       * visible */
      XMoveResizeWindow(dpy, t->pager_view, -10, -10, 5, 5);
    }
  RedrawPager();
#endif
}
