/****************************************************************************
 * This module is based on Twm, but has been siginificantly modified 
 * by Rob Nation (nation@rocket.sanders.lockheed.com 
 ****************************************************************************/
/*****************************************************************************/
/**       Copyright 1988 by Evans & Sutherland Computer Corporation,        **/
/**                          Salt Lake City, Utah                           **/
/**  Portions Copyright 1989 by the Massachusetts Institute of Technology   **/
/**                        Cambridge, Massachusetts                         **/
/**                                                                         **/
/**                           All Rights Reserved                           **/
/**                                                                         **/
/**    Permission to use, copy, modify, and distribute this software and    **/
/**    its documentation  for  any  purpose  and  without  fee is hereby    **/
/**    granted, provided that the above copyright notice appear  in  all    **/
/**    copies and that both  that  copyright  notice  and  this  permis-    **/
/**    sion  notice appear in supporting  documentation,  and  that  the    **/
/**    names of Evans & Sutherland and M.I.T. not be used in advertising    **/
/**    in publicity pertaining to distribution of the  software  without    **/
/**    specific, written prior permission.                                  **/
/**                                                                         **/
/**    EVANS & SUTHERLAND AND M.I.T. DISCLAIM ALL WARRANTIES WITH REGARD    **/
/**    TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES  OF  MERCHANT-    **/
/**    ABILITY  AND  FITNESS,  IN  NO  EVENT SHALL EVANS & SUTHERLAND OR    **/
/**    M.I.T. BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL  DAM-    **/
/**    AGES OR  ANY DAMAGES WHATSOEVER  RESULTING FROM LOSS OF USE, DATA    **/
/**    OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER    **/
/**    TORTIOUS ACTION, ARISING OUT OF OR IN  CONNECTION  WITH  THE  USE    **/
/**    OR PERFORMANCE OF THIS SOFTWARE.                                     **/
/*****************************************************************************/


/***********************************************************************
 *
 * fvwm window border drawing code
 *
 ***********************************************************************/

#include <stdio.h>
#include <signal.h>
#include <string.h>
#include <X11/Xos.h>

#include "fvwm.h"
#include "menus.h"
#include "misc.h"
#include "parse.h"
#include "screen.h"

#ifdef SHAPE
#include <X11/extensions/shape.h>
#endif


#ifdef NO_INLINE
#define inline ""
#endif
inline void DrawPattern(Window, GC, GC, int, int,int);

/* macro to change window background color/pixmap */
#define ChangeWindowColor(window) {\
        if(NewColor)\
           {\
             XChangeWindowAttributes(dpy,window,valuemask, &attributes);\
             XClearWindow(dpy,window);\
           }\
         }

/****************************************************************************
 *
 * Redraws the windows borders
 *
 ****************************************************************************/
void SetBorder (FvwmWindow *t, Bool onoroff,Bool force,Bool Mapped, 
		Window expose_win)
{
  Window w=None;
  int y, i;
  XSegment seg[8];
  GC ReliefGC,ShadowGC;
  Pixel BorderColor,BackColor;
  Pixmap BackPixmap,TextColor;
  Bool NewColor = False;
  XSetWindowAttributes attributes;
  unsigned long valuemask;
  int lower_corner, lower_border, right_corner, right_border;

  if(!t)
    return;

  if (onoroff) 
    {
      /* don't re-draw just for kicks */
      if((!force)&&(Scr.Focus == t))
	return;

      
      if(Scr.Focus != t)
	NewColor = True;

      /* make sure that the previously highlighted window got unhighlighted */
      if((Scr.Focus != t)&&(Scr.Focus != NULL))
	SetBorder(Scr.Focus,False,False,True,None);

      /* if we do click to focus, remove the grab on mouse events that
       * was made to detect the focus change */
      if(Scr.flags & ClickToFocus)
	{
	  for(i=0;i<3;i++)
	    if(Scr.buttons2grab & (1<<i))
	      XUngrabButton(dpy,(i+1),0,t->lead_w);
	}

      /* set the keyboard focus */
      if((Mapped)&&(t->flags&MAPPED)&&(Scr.Focus != t))
	w = t->w;
      else if((t->flags&ICON)&&(Scr.Focus !=t)&&(!(Scr.flags &SuppressIcons)))
	w = t->icon_w;
      if (w)
	{
	  SetFocus(w);
	}
      Scr.Focus = t;
      if (t->flags & DoesWmTakeFocus)    
	send_clientmessage (t->w,_XA_WM_TAKE_FOCUS, CurrentTime);

      TextColor = Scr.HiColors.fore;
      BackPixmap= Scr.gray_pixmap;
      BackColor = Scr.HiColors.back;
      ReliefGC = Scr.HiReliefGC;
      ShadowGC = Scr.HiShadowGC;
      BorderColor = Scr.HiRelief.back;
    }
  else
    {
      /* don't re-draw just for kicks */
      if((!force)&&(Scr.Focus != t))
	return;

      if(Scr.Focus == t)
	NewColor = True;

      /* remove keyboard focus */
      if((Scr.Focus == t)&&(t!= NULL))
	{
	  if (w)
	    {
	      SetFocus(Scr.NoFocusWin);
	    }
	  if(Scr.flags & ClickToFocus)
	    {
	      /* need to grab all buttons for window that we are about to
	       * unhighlight */
	      for(i=0;i<3;i++)
		if(Scr.buttons2grab & (1<<i))
		  XGrabButton(dpy,(i+1),0,Scr.Focus->lead_w,True,
			      ButtonPressMask, GrabModeSync,GrabModeAsync,None,
			      Scr.FvwmCursors[FRAME]);
	    }
	  Scr.Focus = NULL;
	}
      TextColor = Scr.StdColors.fore;
      BackPixmap = Scr.light_gray_pixmap;
      BackColor = Scr.StdColors.back;
      ReliefGC = Scr.StdReliefGC;
      ShadowGC = Scr.StdShadowGC;
      BorderColor = Scr.StdRelief.back;

    }

#ifndef NO_PAGER
  if((Scr.Pager_w) && !(t->flags & STICKY))
    {
      if(NewColor)
	{
	  if(Scr.d_depth < 2)
	    XSetWindowBackgroundPixmap(dpy,t->pager_view,BackPixmap);
	  else
	    XSetWindowBackground(dpy,t->pager_view,BackColor);
	  XClearWindow(dpy,t->pager_view);
	}
      if((t->icon_name != NULL)&&(Scr.PagerFont.height > 0))
	{
	  NewFontAndColor(Scr.PagerFont.font->fid,TextColor,BackColor);
	  XDrawString (dpy, t->pager_view, Scr.FontGC, 2,Scr.PagerFont.y+2,
		       t->icon_name, strlen(t->icon_name));
	}
    }
#endif

  if(t->flags & ICON)
    {
      DrawIconWindow(t);
      return;
    }

  valuemask = CWBorderPixel;
  attributes.border_pixel = BorderColor;
  if(Scr.d_depth < 2)
    {
      attributes.background_pixmap = BackPixmap;
      valuemask |= CWBackPixmap;
    }
  else
    {
      attributes.background_pixel = BackColor;
      valuemask |= CWBackPixel;
    }
	
  if(t->flags & (BORDER|TITLE))
    {
/*      flush_expose (t->w);  */
      XSetWindowBorder(dpy,t->w,BorderColor);

      if(t->flags & BORDER)
	{
	  /* draw relief lines */
	  ChangeWindowColor(t->bottom_w);
	  if((flush_expose (t->bottom_w))||(expose_win == t->bottom_w)||
	     (expose_win == None))
	    RelieveWindow(t->bottom_w,0,0,t->frame_width-
			  2*t->corner_width +1,t->boundary_width,
			  ReliefGC, ShadowGC);

	  ChangeWindowColor(t->top_w);
	  if((flush_expose (t->top_w))||(expose_win == t->top_w)||
	     (expose_win == None))
	    RelieveWindow(t->top_w,0,0,t->frame_width-
			  2*t->corner_width +1,t->boundary_width,
			  ReliefGC, ShadowGC);
      
	  y= t->frame_height - 2*t->corner_width - 2*t->frame_bw+2;

	  ChangeWindowColor(t->left_side_w);
	  if((flush_expose (t->left_side_w))||(expose_win == t->left_side_w)||
	     (expose_win == None))
	    RelieveWindow(t->left_side_w,0,0,t->boundary_width,y,
			  ReliefGC, ShadowGC);

	  ChangeWindowColor(t->right_side_w);
	  if((flush_expose(t->right_side_w))||(expose_win == t->right_side_w)||
	     (expose_win == None))
	    RelieveWindow(t->right_side_w,0,0,t->boundary_width,y,
			  ReliefGC, ShadowGC);
	}
      if(t->flags & TITLE)
	{
	  ChangeWindowColor(t->title_w);
	  for(i=0;i<Scr.nr_left_buttons;i++)
	    {
	      ChangeWindowColor(t->left_w[i]);
	      if(flush_expose(t->left_w[i])||(expose_win == t->left_w[i])||
		 (expose_win == None))
		{
		  RelieveWindow(t->left_w[i],0,0,t->title_height,
				t->title_height,ReliefGC, ShadowGC);
		  DrawPattern(t->left_w[i],ReliefGC,ShadowGC,
			      Scr.left_button_styles[1][i],
			      Scr.left_button_styles[0][i],t->title_height);
		}

	    }	     
	  for(i=0;i<Scr.nr_right_buttons;i++)
	    {
	      ChangeWindowColor(t->right_w[i]);
	      if(flush_expose(t->right_w[i])||(expose_win == t->right_w[i])||
		 (expose_win == None))
		{
		  RelieveWindow(t->right_w[i],0,0,t->title_height,
				t->title_height,ReliefGC, ShadowGC);	     
		  DrawPattern(t->right_w[i],ReliefGC,ShadowGC,
			      Scr.right_button_styles[1][i],
			      Scr.right_button_styles[0][i],t->title_height);
		}
	    }
	  SetTitleBar(t,onoroff, False);
	}

      if(t->flags & BORDER)
	{
	  ChangeWindowColor(t->frame);
	  if((flush_expose(t->frame))||(expose_win == t->frame)||
		 (expose_win == None))
	     {
	       /* Need to relieve the window frame */
	       RelieveWindow(t->frame,0,0,t->frame_width+1,t->frame_height+1,
			     ReliefGC,ShadowGC);
	       RelieveWindow(t->frame,t->boundary_width-2,t->boundary_width-2,
			     t->frame_width-2*(t->boundary_width)+5,
			     t->frame_height-2*(t->boundary_width)+5,ShadowGC,
			     ReliefGC);
	  
	       /* Now, need to fill in with a handful of segments */
	       /* draw white hilites */
	       lower_corner = t->frame_height - t->corner_width;
	       lower_border = t->frame_height - t->boundary_width;
	       right_corner = t->frame_width - t->corner_width;
	       right_border = t->frame_width - t->boundary_width;

	       i=0;
	       seg[i].x1 = 0;                  seg[i].y1 = lower_corner;
	       seg[i].x2=t->boundary_width-2;  seg[i++].y2 = lower_corner;
	  
	       seg[i].x1 = 1;                  seg[i].y1=lower_corner+1;
	       seg[i].x2=t->boundary_width-3;  seg[i++].y2=lower_corner +1;


	       seg[i].x1 = right_border + 2;   seg[i].y1 = lower_corner;
	       seg[i].x2 = t->frame_width - 1; seg[i++].y2 = lower_corner;

	       seg[i].x1 = right_border + 3;   seg[i].y1 = lower_corner+1;
	       seg[i].x2 = t->frame_width-2;   seg[i++].y2 =lower_corner+1;

	       seg[i].x1 = right_corner + 1;   seg[i].y1 = 0;
	       seg[i].x2 = right_corner + 1;   seg[i++].y2=t->boundary_width-2;

	       seg[i].x1 = right_corner+2;     seg[i].y1 = 1;
	       seg[i].x2 = right_corner+2;     seg[i++].y2=t->boundary_width-3;


	       seg[i].x1 = right_corner + 1;   seg[i].y1 = lower_border + 1;
	       seg[i].x2 = right_corner + 1;   seg[i++].y2=t->frame_height-1;

	       seg[i].x1 = right_corner+2;     seg[i].y1 = lower_border + 2;
	       seg[i].x2 = right_corner+2;     seg[i++].y2=t->frame_height - 2;

	       XDrawSegments(dpy,t->frame,ReliefGC,seg,i);

	       i=0;
	       seg[i].x1 = t->corner_width-1;  seg[i].y1 = 0;
	       seg[i].x2 = t->corner_width-1;  seg[i++].y2=t->boundary_width-1;

	       seg[i].x1 = t->corner_width-2;  seg[i].y1 = 1;
	       seg[i].x2 = t->corner_width-2;  seg[i++].y2=t->boundary_width-2;

	       seg[i].x1 = t->corner_width-1;  seg[i].y1 = lower_border + 1;
	       seg[i].x2 = t->corner_width-1;  seg[i++].y2 = t->frame_height-1;

	       seg[i].x1 = t->corner_width-2;  seg[i].y1 = lower_border + 2;
	       seg[i].x2 = t->corner_width-2;  seg[i++].y2 = t->frame_height-2;

	       seg[i].x1 = 0;   	       seg[i].y1 = t->corner_width - 1;
	       seg[i].x2 =t->boundary_width-1; seg[i++].y2 = t->corner_width-1;
	  
	       seg[i].x1 = 1;  	               seg[i].y1 = t->corner_width - 2;
	       seg[i].x2 =t->boundary_width-2; seg[i++].y2 = t->corner_width-2;

	       seg[i].x1 = t->frame_width;     seg[i].y1 = t->corner_width - 1;
	       seg[i].x2 = right_border + 1;   seg[i++].y2=t->corner_width - 1;
	  
	       seg[i].x1 = t->frame_width -1;   seg[i].y1 =t->corner_width-2;
	       seg[i].x2 = right_border + 2;    seg[i++].y2=t->corner_width-2;

	       XDrawSegments(dpy, t->frame, ShadowGC, seg, i);
	     }
	}
    }
  else      /* no decorative border */
    {
      flush_expose (t->lead_w);
      /* for mono - put a black border on 
       * for color, make it the color of the decoration background */
      if(Scr.d_depth <2)
	XSetWindowBorder(dpy,t->lead_w,TextColor);
      else
	XSetWindowBorder(dpy,t->lead_w,BackColor);
    }
}


/****************************************************************************
 *
 *  Redraws just the title bar
 *
 ****************************************************************************/
void SetTitleBar (FvwmWindow *t,Bool onoroff, Bool NewTitle)
{
  int hor_off, w;
  GC ReliefGC,ShadowGC;
  Pixel Forecolor, BackColor;

  if(!(t->flags & TITLE))
    return;

  if (onoroff) 
    {
      Forecolor = Scr.HiColors.fore;
      BackColor = Scr.HiColors.back;
      ReliefGC = Scr.HiReliefGC;
      ShadowGC = Scr.HiShadowGC;
    }
  else
    {
      Forecolor = Scr.StdColors.fore;
      BackColor = Scr.StdColors.back;
      ReliefGC = Scr.StdReliefGC;
      ShadowGC = Scr.StdShadowGC;
    }
  flush_expose(t->title_w);

  w=XTextWidth(Scr.WindowFont.font,t->name,strlen(t->name));
  hor_off = (t->title_width - w)/2;
  
  NewFontAndColor(Scr.WindowFont.font->fid,Forecolor, BackColor);

  if(NewTitle)
    XClearWindow(dpy,t->title_w);

  /* for mono, we clear an area in the title bar where the window
   * title goes, so that its more legible. For color, no need */
  if(Scr.d_depth<2)
    {
      RelieveWindow(t->title_w,0,0,hor_off-2,t->title_height,
		    ReliefGC, ShadowGC);
      RelieveWindow(t->title_w,hor_off+w+2,0,
		    t->title_width - w - hor_off-2,t->title_height,
		    ReliefGC, ShadowGC);
      XFillRectangle(dpy,t->title_w,ReliefGC,hor_off - 2, 0,
		     w+4,t->title_height);
      XDrawLine(dpy,t->title_w,ShadowGC,hor_off+w+1,0,hor_off+w+1,
		t->title_height);
    }
  else
    RelieveWindow(t->title_w,0,0,t->title_width,t->title_height,
		  ReliefGC, ShadowGC);
  
  XDrawString (dpy, t->title_w,Scr.FontGC,hor_off, Scr.WindowFont.y+1, 
	       t->name, strlen(t->name));
  XFlush(dpy);
}




/****************************************************************************
 *
 *  Draws the relief pattern around a window
 *
 ****************************************************************************/
inline void RelieveWindow(Window win,int x,int y,int w,int h,
		   GC ReliefGC,GC ShadowGC)
{
  XSegment seg[4];
  int i;

  i=0;
  seg[i].x1 = x;        seg[i].y1   = y;
  seg[i].x2 = w+x-1;    seg[i++].y2 = y;

  seg[i].x1 = x;        seg[i].y1   = y;
  seg[i].x2 = x;        seg[i++].y2 = h+y-1;

  seg[i].x1 = x+1;      seg[i].y1   = y+1;
  seg[i].x2 = x+w-2;    seg[i++].y2 = y+1;

  seg[i].x1 = x+1;      seg[i].y1   = y+1;
  seg[i].x2 = x+1;      seg[i++].y2 = y+h-2;
  XDrawSegments(dpy, win, ReliefGC, seg, i);

  i=0;
  seg[i].x1 = x;        seg[i].y1   = y+h-1;
  seg[i].x2 = w+x-1;    seg[i++].y2 = y+h-1;

  seg[i].x1 = x+1;      seg[i].y1   = y+h-2;
  seg[i].x2 = x+w-2;    seg[i++].y2 = y+h-2;

  seg[i].x1 = x+w-1;    seg[i].y1   = y;
  seg[i].x2 = x+w-1;    seg[i++].y2 = y+h-1;

  seg[i].x1 = x+w-2;    seg[i].y1   = y+1;
  seg[i].x2 = x+w-2;    seg[i++].y2 = y+h-2;
  XDrawSegments(dpy, win, ShadowGC, seg, i);
}

/****************************************************************************
 *
 *  Draws a little pattern within a window
 *
 ****************************************************************************/
inline void DrawPattern(Window win, GC ShadowGC, GC ReliefGC, int h1, int w1, int t1)
{
  XSegment seg[2];
  int i,h,b,u,w,r,l;

  h = t1*h1/200;
  b = (t1>>1) + h;
  u = t1 - b-1;
  w = t1*w1/200;
  r = (t1>>1) + w;
  l = t1 - r-1;  

  i=0;
  seg[i].x1 = l;    seg[i].y1   = u;
  seg[i].x2 = r;    seg[i++].y2 =  u;

  seg[i].x1 = l;    seg[i].y1   = u;
  seg[i].x2 = l;    seg[i++].y2 = b;
  XDrawSegments(dpy, win, ShadowGC, seg, i);

  i=0;
  seg[i].x1 = l;    seg[i].y1   = b;
  seg[i].x2 = r;    seg[i++].y2 =  b;

  seg[i].x1 = r;    seg[i].y1   = u;
  seg[i].x2 = r;    seg[i++].y2 = b;
  XDrawSegments(dpy, win, ReliefGC, seg, i);
}



/***********************************************************************
 *
 *  Procedure:
 *      Setupframe - set window sizes, this was called from either
 *              AddWindow, EndResize, or HandleConfigureNotify.
 *
 *  Inputs:
 *      tmp_win - the FvwmWindow pointer
 *      x       - the x coordinate of the upper-left outer corner of the frame
 *      y       - the y coordinate of the upper-left outer corner of the frame
 *      w       - the width of the frame window w/o border
 *      h       - the height of the frame window w/o border
 *
 *  Special Considerations:
 *      This routine will check to make sure the window is not completely
 *      off the display, if it is, it'll bring some of it back on.
 *
 *      The tmp_win->frame_XXX variables should NOT be updated with the
 *      values of x,y,w,h prior to calling this routine, since the new
 *      values are compared against the old to see whether a synthetic
 *      ConfigureNotify event should be sent.  (It should be sent if the
 *      window was moved but not resized.)
 *
 ************************************************************************/

void SetupFrame(FvwmWindow *tmp_win,int x,int y,int w,int h,Bool sendEvent)
{
  XEvent client_event;
  XWindowChanges frame_wc, xwc;
  unsigned long frame_mask, xwcm;
  int bw,cx,cy,i;
  Bool Resized = False;
  FvwmWindow *t;

  /* if windows is not being maximized, save size in case of maximization */
  if (!(tmp_win->flags & MAXIMIZED))
    {
      tmp_win->orig_x = x;
      tmp_win->orig_y = y;
      tmp_win->orig_wd = w;
      tmp_win->orig_ht = h;
    }
  if(Scr.flags & DontMoveOff)
    {
      if (x + Scr.Vx + w < 16)
	x = 16 - Scr.Vx - w;
      if (y + Scr.Vy + h < 16)
	y = 16 - Scr.Vy - h;
    }
  if (x >= Scr.MyDisplayWidth + Scr.VxMax - Scr.Vx-16)
    x = Scr.MyDisplayWidth + Scr.VxMax -Scr.Vx - 16;
  if (y >= Scr.MyDisplayHeight+Scr.VyMax - Scr.Vy -16)
    y = Scr.MyDisplayHeight + Scr.VyMax - Scr.Vy - 16;

  bw = tmp_win->frame_bw;		/* -1 means current frame width */
  
  /*
   * According to the July 27, 1988 ICCCM draft, we should send a
   * "synthetic" ConfigureNotify event to the client if the window
   * was moved but not resized.
   */
  if ((x != tmp_win->frame_x || y != tmp_win->frame_y) &&
      (w == tmp_win->frame_width && h == tmp_win->frame_height))
    sendEvent = TRUE;

  if((w != tmp_win->frame_width) || (h != tmp_win->frame_height))
    Resized = True;

  if(Resized)
    {
      tmp_win->title_width= w- 
	(Scr.nr_left_buttons+Scr.nr_right_buttons)*tmp_win->title_height 
	  -2*tmp_win->boundary_width+1;


      if(tmp_win->title_width < 1) 
	tmp_win->title_width = 1;

      if (tmp_win->flags & TITLE) 
	{
	  xwcm = CWWidth | CWX | CWY;
	  tmp_win->title_x = tmp_win->boundary_width+
	    (Scr.nr_left_buttons)*tmp_win->title_height;
	  if(tmp_win->title_x >=  w - tmp_win->boundary_width)
	    tmp_win->title_x = -10;
	  tmp_win->title_y = tmp_win->boundary_width;
	  
	  xwc.width = tmp_win->title_width;
	  xwc.x = tmp_win->title_x;
	  xwc.y = tmp_win->title_y;
	  XConfigureWindow(dpy, tmp_win->title_w, xwcm, &xwc);


	  xwcm = CWX | CWY;
	  xwc.y = tmp_win->boundary_width;
	  
	  for(i=0;i<Scr.nr_left_buttons;i++)
	    {
	      xwc.x = tmp_win->boundary_width+tmp_win->title_height*i;
	      if(xwc.x + tmp_win->title_height < w - tmp_win->boundary_width)
		XConfigureWindow(dpy, tmp_win->left_w[i], xwcm, &xwc);
	      else
		{
		  xwc.x = -tmp_win->title_height;
		  XConfigureWindow(dpy, tmp_win->left_w[i], xwcm, &xwc);
		}
	    }
	  
	  for(i=0;i<Scr.nr_right_buttons;i++)
	    {
	      xwc.x=w-tmp_win->boundary_width-(i+1)*tmp_win->title_height+1;
	      if(xwc.x > tmp_win->boundary_width)
		XConfigureWindow(dpy, tmp_win->right_w[i], xwcm, &xwc);
	      else
		{
		  xwc.x = -tmp_win->title_height;
		  XConfigureWindow(dpy, tmp_win->right_w[i], xwcm, &xwc);
		}
	    }
	}

      if(tmp_win->flags & BORDER)
	{
	  xwcm = CWWidth | CWX | CWY;
	  xwc.x = tmp_win->corner_width;
	  xwc.y = 0;
	  xwc.width = w- 2*tmp_win->corner_width+1;
	  if(xwc.width < 1)
	    {
	      xwc.width = 1;
	      xwc.x = -10;
	    }
	  XConfigureWindow(dpy, tmp_win->top_w, xwcm, &xwc);
	  
	  xwc.y = h - tmp_win->boundary_width+1;
	  XConfigureWindow(dpy, tmp_win->bottom_w, xwcm, &xwc);
	  
	  xwcm = CWHeight | CWX | CWY;
	  xwc.x = w - tmp_win->boundary_width+1;
	  xwc.y = tmp_win->corner_width;
	  xwc.height = h - 2*tmp_win->corner_width;
	  XConfigureWindow(dpy, tmp_win->right_side_w, xwcm, &xwc);
      
	  xwc.x = 0;
	  XConfigureWindow(dpy, tmp_win->left_side_w, xwcm, &xwc);
	}

      tmp_win->attr.width = w - 2*tmp_win->boundary_width;
      tmp_win->attr.height = h - tmp_win->title_height 
	- 2*tmp_win->boundary_width;
      /* may need to omit the -1 for shaped windows, next two lines*/
      cx = tmp_win->boundary_width-1;
      cy = tmp_win->title_height + tmp_win->boundary_width-1;
      
      if(tmp_win->flags & (TITLE|BORDER))
	{
	  XMoveResizeWindow(dpy, tmp_win->w, cx, cy,
			    tmp_win->attr.width, tmp_win->attr.height);
	}
    }

  /* 
   * fix up frame and assign size/location values in tmp_win
   */
  frame_wc.x = tmp_win->frame_x = x;
  frame_wc.y = tmp_win->frame_y = y;
  frame_wc.width = tmp_win->frame_width = w;
  frame_wc.height = tmp_win->frame_height = h;
  frame_mask = (CWX | CWY | CWWidth | CWHeight);
  XConfigureWindow (dpy, tmp_win->lead_w, frame_mask, &frame_wc);
  
#ifdef SHAPE
  if ((Resized)&&(tmp_win->wShaped))
    {
      SetShape(tmp_win,w);
    }
#endif /* SHAPE */
  if (sendEvent)
    {
      client_event.type = ConfigureNotify;
      client_event.xconfigure.display = dpy;
      client_event.xconfigure.event = tmp_win->w;
      client_event.xconfigure.window = tmp_win->w;
      
      client_event.xconfigure.x = x + tmp_win->boundary_width;
      client_event.xconfigure.y = y + tmp_win->title_height+
	tmp_win->boundary_width;
      client_event.xconfigure.width = w-2*tmp_win->boundary_width;
      client_event.xconfigure.height =h-2*tmp_win->boundary_width -
	tmp_win->title_height;

      client_event.xconfigure.border_width = tmp_win->frame_bw;

      /* Real ConfigureNotify events say we're above title window, so ... */
      /* what if we don't have a title ????? */
      client_event.xconfigure.above = tmp_win->frame;
      client_event.xconfigure.override_redirect = False;
      XSendEvent(dpy, tmp_win->w, False, StructureNotifyMask, &client_event);
    }

#ifndef NO_PAGER
  if(tmp_win == Scr.FvwmPager)
    {
      MoveResizeViewPortIndicator();
      for (t = Scr.FvwmRoot.next; t != NULL; t = t->next)
	MoveResizePagerView(t);
    }
  else
    MoveResizePagerView(tmp_win);
#endif
}


/****************************************************************************
 *
 * Sets up the shaped window borders 
 * 
 ****************************************************************************/
void SetShape(FvwmWindow *tmp_win, int w)
{
  XRectangle rect;

#ifdef SHAPE
  if (tmp_win->title_w) 
    {
      /* windows w/ titles */
      rect.x = tmp_win->boundary_width;
      rect.y = tmp_win->title_y;
      rect.width = w - 2*tmp_win->boundary_width+1;
      rect.height = tmp_win->title_height;
      
      XShapeCombineShape (dpy, tmp_win->frame, ShapeBounding,
			  tmp_win->boundary_width,
			  tmp_win->title_height+tmp_win->boundary_width,
			  tmp_win->w,
			  ShapeBounding, ShapeSet);
      XShapeCombineRectangles(dpy,tmp_win->frame,ShapeBounding,
			      0,0,&rect,1,ShapeUnion,Unsorted);
    }
  else
    /* windows w/o titles */
    if(tmp_win->flags & BORDER)
      XShapeCombineShape (dpy, tmp_win->frame, ShapeBounding,
			  tmp_win->boundary_width, tmp_win->boundary_width,
			  tmp_win->w,ShapeBounding, ShapeSet);
#endif
}




inline void SetFocus(Window w)
{
  if(Scr.NumberOfScreens > 1)
    {
      XQueryPointer(dpy, Scr.Root, &JunkRoot, &JunkChild,
		    &JunkX, &JunkY, &JunkX, &JunkY, &JunkMask);
      if(JunkRoot == Scr.Root)
	XSetInputFocus (dpy, w, RevertToParent, CurrentTime);
    }
  else
    XSetInputFocus (dpy, w, RevertToParent, CurrentTime);
}
