/* File htmltext.ch created by Ward Nelson
    (c) Copyright IBM Corp.  (This work is unpublished).  All rights reserved.

    htmltext, an object for reading and writing HTML+ formatted files. */

enum ListType { listtype_UNORDERED, listtype_ORDERED, listtype_DEFINITION };


struct htmltaginfo {
    struct style *thestyle;
    struct attlist *atts;
    long startpos;
    long arrayidx;
    char *tagid;
};


struct namelist {
    char *name;
    struct namelist *next;
};


class htmltext: text {

  overrides:
    Read(FILE *file, long id) returns long;
    Write(FILE *file, long writeID, int level) returns long;
    Clear();
    ClearCompletely();

  methods:
    AddImage(long pos, char *file) returns struct htmlenv *;
    RenumberList(long pos, enum ListType ltype, struct htmlenv *env);
    AddDingbat(long pos, enum ListType ltype, struct htmlenv *env) returns struct htmlenv *;
    FindDestId(char *dest) returns long;
    GetAnchor(long pos) returns char *;
    ShowComments(boolean viewcomments);
    ShowRaw(boolean viewraw);

  classprocedures:
    InitializeObject(struct htmltext *self) returns boolean;
    InitializeClass() returns boolean;
    FinalizeObject(struct htmltext *self);

  data:
    struct namelist *renderlist;    
    boolean readonly;
};
