/* File hidden.ch created by Ward Nelson
   (c) Copyright IBM Corp.  (This work is unpublished).  All rights reserved.

   hidden, an inset for stashing non-displayed text inside of */

enum visibility { hidden_HIDDEN, hidden_EXPOSED, hidden_FULLSCREEN };

class hidden : text {
  overrides:
    ViewName() returns char *;

  macromethods:
    IsVisible() ((self)->Visibility != hidden_HIDDEN)
    IsFullScreen() ((self)->Visibility == hidden_FULLSCREEN)
    SetVisibility(enum visibility v) ((self)->Visibility = ((self)->Visibility == hidden_FULLSCREEN)?hidden_FULLSCREEN:v)

  classprocedures:
    InitializeObject(struct hidden *self) returns boolean;
    InitializeClass() returns boolean;
    FinalizeObject(struct hidden *self);
  
  data:
    enum visibility Visibility;
};
