

/*
	$Disclaimer: This software is part of version 6.1 of the 
 * Andrew User Interface System and is 
 * the property of IBM, Carnegie Mellon University, 
 * and the other copyright holders.  The source 
 * code of this version is for the sole use of 
 * the individual named in ./config/allsys.h.  
 * This source code is not to be redistributed.  
 * Binary object code compiled or derived from 
 * these sources is not to be distributed to non-
 * members.  Members may have additional 
 * distribution rights granted by prior written 
 * permission of Carnegie Mellon University.
 * 
 * IBM, CARNEGIE MELLON UNIVERSITY, 
 * AND THE OTHER COPYRIGHT HOLDERS
 *  DISCLAIM ALL WARRANTIES WITH 
 * REGARD TO THIS SOFTWARE, INCLUDING 
 * ALL IMPLIED WARRANTIES OF MERCHANT-
 * ABILITY AND FITNESS. IN 
 * NO EVENT SHALL  IBM, CARNEGIE 
 * MELLON UNIVERSITY, OR ANY OTHER 
 * COPYRIGHT HOLDER BE LIABLE FOR 
 * ANY SPECIAL, INDIRECT OR CONSE-
 * QUENTIAL DAMAGES OR ANY DAMAGES 
 * WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT 
 * OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *  $
*/
#ifndef ANSITEXT_H
#define ANSITEXT_H

#define ansitext_BaseFactor		(2.0)
#define ansitext_AscenderFactor		(1.0)
#define ansitext_DescenderFactor	(1.0)

#define ansitext_CapitalFactor \
	(ansitext_BaseFactor + ansitext_AscenderFactor)
#define ansitext_DescentRatio \
	(ansitext_DescenderFactor / ansitext_CapitalFactor)

#define ansitext_ComputeAscent(fontsize)  (fontsize)
#define ansitext_ComputeDescent(fontsize) ((fontsize) * ansitext_DescentRatio)

#define ansitext_ComputeDelta(fontsize, spacing) \
	((((spacing) / 4.0) - (1.0 / 6.0)) * (fontsize))

#define ansitext_SlantFontSlope		(2.5)

#endif
