/* warn.h - handling of warn clauses */

/* Written 1994,1995 by Werner Almesberger */


#ifndef WARN_H
#define WARN_H

#include "expr.h"


typedef struct _warning {
    const char *msg;
    EXPR *trigger;
    int ignore;
    const char *help;
    struct _warning *next;
} WARNING;


void warn_parse(void);

/* Parses one warn clause. */

void warn_begin(WARNING **ctx);

/* Begins processing of warnings. Initializes *CTX. */

const char *warn_check(WARNING **ctx);

/* Looks for the next problem. Returns NULL of no further problems are found
   or a pointer to the warning message. */

void warn_skip(WARNING **ctx);

/* Skips the current warning. */

void warn_ignore(WARNING **ctx);

/* Ignores the current warning. */

#endif
