/* warn.c - handling of warn clauses */

/* Written 1994,1995 by Werner Almesberger */


#include <string.h>

#include "common.h"
#include "parse.h"
#include "expr.h"
#include "warn.h"


static WARNING *warnings = NULL,*last = NULL;


void warn_parse(void)
{
    WARNING *n;

    n = alloc_t(WARNING);
    n->msg = stralloc(string());
    n->trigger = expr_parse();
    n->help = parse_help();
    n->ignore = 0;
    n->next = NULL;
    if (last) last->next = n;
    else warnings = n;
    last = n;
}


void warn_begin(WARNING **ctx)
{
    *ctx = warnings;
}


const char *warn_check(WARNING **ctx)
{
    while (*ctx) {
	if (!(*ctx)->ignore)
	    if (eval((*ctx)->trigger)) return (*ctx)->msg;
	*ctx = (*ctx)->next;
    }
    return NULL;
}


void warn_skip(WARNING **ctx)
{
    if (*ctx) (*ctx) = (*ctx)->next;
}


void warn_ignore(WARNING **ctx)
{
    if (*ctx) (*ctx)->ignore = 1;
}
