/* expr.h - expression parsing and evaluation */

/* Written 1994,1995 by Werner Almesberger */


#ifndef EXPR_H
#define EXPR_H

typedef enum { et_var,et_const,et_plus,et_minus,et_mult,et_div,et_mod,et_eq,
  et_ne,et_gt,et_ge,et_lt,et_le,et_sign,et_not,et_and,et_or,et_xor }
  EXPR_TYPE;

typedef struct _expr {
    EXPR_TYPE type;
    union {
	struct {
	    struct _expr *a,*b;
	} op;
	int num;
	struct {
	    const char *name;
	    void *item;	/* NULL unless cached */
	} var;
    } u;
} EXPR;


EXPR *expr_parse(void);

/* Parses an expression and returns a pointer to it. */

int eval(EXPR *this);

/* Evaluates the expression pointed to by THIS. */

#endif
