/* Kernel includes */
#define __NO_VERSION__
#include <linux/config.h>
#include <linux/errno.h>
#include <asm/segment.h>
#include <linux/kernel.h>
#include <linux/signal.h>
#include <linux/module.h>
#include <linux/version.h>

extern int base(int, char *);

void
dummy_base(int level, char *s)
{
	printk("calling base from level %d with string='%s'\n", level +1, s);
	base(level + 1, s);
	printk("returned from base, at level %d\n", level + 1);
}

char kernel_version[] = UTS_RELEASE;

int
init_module( void) {
#ifdef __ELF__
	rename_module_symbol("dummy_base", "base");
#else
	rename_module_symbol("_dummy_base", "_base");
#endif
	return 0;
}

void
cleanup_module( void) {
	if (MOD_IN_USE)
		printk("mid: busy, remove delayed\n");
}
