#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <linux/fd.h>
#include <linux/fdreg.h>
#include <sys/ioctl.h>
#include <fcntl.h>

struct lookup_table
{
  char *name;
  int cmd;
  int flags;
} tabl[]= {
  { "read",		FD_READ,	       	FD_RAW_READ | FD_RAW_INTR },
  { "write",		FD_WRITE,      		FD_RAW_WRITE | FD_RAW_INTR },
  { "intr",		0,			FD_RAW_INTR },
#ifdef FD_RAW_NO_MOTOR
  { "no_motor",		0,			FD_RAW_NO_MOTOR },
  { "no_motor_after",  	0,			FD_RAW_NO_MOTOR_AFTER },
#endif
  { "sensei",		FD_SENSEI,	     	0 },
  { "disk",		0,			FD_RAW_NEED_DISK },
  { "need_seek",       	0,			FD_RAW_NEED_SEEK },
  { "spin",		0,			FD_RAW_SPIN },
  { "sense",		FD_GETSTATUS,		0},
  { "recalibrate",	FD_RECALIBRATE,		FD_RAW_INTR },
  { "seek",		FD_SEEK,		FD_RAW_INTR },
#ifdef FD_RSEEK_OUT
  { "seek_out",		FD_RSEEK_OUT,		FD_RAW_INTR },
#endif
#ifdef FD_RSEEK_IN
  { "seek_in",		FD_RSEEK_IN,		FD_RAW_INTR },
#endif
#ifdef FD_LOCK
  { "lock",		FD_LOCK,		0 },
  { "unlock",		FD_UNLOCK,		0 },
#endif
  { "specify",		FD_SPECIFY,		0 },
  { "format",		FD_FORMAT,		FD_RAW_WRITE | FD_RAW_INTR },
  { "version",		FD_VERSION,		0 },
  { "configure",	FD_CONFIGURE,		0 },
  { "perpendicular",	FD_PERPENDICULAR,	0 },
  { "readid",	        FD_READID,     		FD_RAW_INTR },
  { "dumpregs",	        FD_DUMPREGS,   		0 },
  { 0,			0,			0 }
};

int lookup(char *name, int *cmd, int *flags)
{
  struct lookup_table *ptr;  

  ptr = tabl;

  while ( ptr->name && strcmp(ptr->name, name) )
    ptr++;

  if ( ! ptr->name)
    return 0;

  *cmd = ptr->cmd;
  *flags = ptr->flags;
  return 1;
}

void main(int argc, char **argv)
{
  int i,tmp, flags, cmd, size, fd;
  char *drive,*s,*end;
  int repeat=1;
  struct floppy_raw_cmd raw_cmd;
  char r_flags;
  
  char buffer[ 512 * 2 * 24 ];

  raw_cmd.length= 512 * 2 * 24;
  raw_cmd.data = buffer;
  r_flags = 0;
  raw_cmd.rate = 0;
  raw_cmd.track = 0;
  raw_cmd.cmd_count = 0;

  drive="/dev/fd0";

  if (( s=getenv("length") ) || (s = getenv("LENGTH")) )
    raw_cmd.length= strtoul( s,0,0);
  
  if ((s = getenv("rate") ) || (s = getenv("RATE")) )
    raw_cmd.rate = strtoul( s,0,0);

  if ((s = getenv("track") ) || (s = getenv("TRACK")) )
    raw_cmd.track = strtoul( s,0,0);

  if ((s = getenv("drive") ) || (s = getenv("DRIVE")) )
    drive = s;

  for ( i= 1; i<argc; i++){
    if ((lookup( argv[i], &cmd, &flags ))){
      if ( !cmd || r_flags == 0 )
        r_flags |= flags;
      if ( raw_cmd.cmd_count == 0 )
	raw_cmd.cmd[raw_cmd.cmd_count++] = cmd;
      continue;
    }

    if ( strncmp( "length=", argv[i], 7 ) == 0 ){
      raw_cmd.length= strtoul( argv[i]+7,0,0);
      continue;
    }

    if ( strncmp( "rate=", argv[i], 5 ) == 0 ){
      raw_cmd.rate= strtoul( argv[i]+5,0,0);
      continue;
    }

    if ( strncmp( "track=", argv[i], 5 ) == 0 ){
      raw_cmd.track= strtoul( argv[i]+6,0,0);
      continue;
    }

    if ( strncmp( "repeat=", argv[i], 7 ) == 0 ){
      repeat= strtoul( argv[i]+7,0,0);
      continue;
    }

    if ( strncmp( "drive=", argv[i], 6 ) == 0){
      drive=argv[i]+6;
      continue;
    }

    if ( argv[i][0] == '/' ){
      drive = argv[i];
      continue;
    }

    cmd = strtoul( argv[i], &end, 0);
    if ( *end ){
      fprintf(stderr,"Unrecognized keyword: %s\n", argv[i] );
      exit(1);
    }
    
    if ( end == argv[i] )
      continue;

    raw_cmd.cmd[raw_cmd.cmd_count++] = cmd;
  }

  if ( r_flags & FD_RAW_WRITE ){
    size = 0;
    while(1){
      tmp=read(0, buffer+size, raw_cmd.length - size );
      if ( tmp == 0 ){
	raw_cmd.length = size ;
	break;
      }

      if ( tmp < 0 ){
	perror("read");
	exit(1);
      }
      size += tmp;
      if ( size == raw_cmd.length )
	break;
    }
  } else
    size = raw_cmd.length;

  fd = strtoul(drive, &end, 0);

  if ( *end ){
    fd = open( drive, O_ACCMODE | O_NDELAY);
    if ( fd < 0 ){
      perror("open floppy");
      exit(1);
    }
  }

  while ( repeat > 0 ){
    raw_cmd.flags = r_flags;
    tmp = ioctl( fd, FDRAWCMD, & raw_cmd );
    if ( tmp < 0 ){
      perror("raw cmd");
      exit(1);
    }

  if ( r_flags & ( FD_RAW_READ ))
    write(1, buffer, size );
    
    fprintf(stderr,"\n");
    if ( raw_cmd.flags & ( FD_RAW_READ | FD_RAW_WRITE ))
      fprintf(stderr,"remaining= %lu\n", raw_cmd.length );
    
    for( i=0; i< raw_cmd.reply_count; i++ )
      fprintf(stderr,"%d: %x\n", i, raw_cmd.reply[i] );
#ifdef FD_RAW_DISK_CHANGE
    if( raw_cmd.flags & FD_RAW_DISK_CHANGE)
      fprintf(stderr,"disk change\n");
    else
      fprintf(stderr,"no disk change\n");
#endif
    repeat--;
  }

  close(fd);

  exit(0);
}
