/*
 * Display contents of an MSDOS file
 *
 * Emmet P. Gray			US Army, HQ III Corps & Fort Hood
 * ...!uunet!uiucuxc!fthood!egray	Attn: AFZF-DE-ENV
 * fthood!egray@uxc.cso.uiuc.edu	Directorate of Engineering & Housing
 * 					Environmental Management Office
 * 					Fort Hood, TX 76544-5057
 */

#include <sys/types.h>
#include <sys/fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include "getopt.h"
#include "msdos.h"

void
mtype(argc, argv)
int argc;
char *argv[];
{
	int i, ismatch, entry, c, oops, textmode, stripmode, got_one;
	int missed_one;
	unsigned int fat;
	long size;
	char *filename, *newfile, *pathname;
	char drive, last_drive;
	struct directory *dir;

					/* get command line options */
	oops = 0;
	stripmode = 0;
	textmode = 0;
	got_one = 0;
	missed_one = 0;
	while ((c = getopt(argc, argv, "st")) != EOF) {
		switch (c) {
			case 's':
				stripmode = 1;
				break;
			case 't':
				textmode = 1;
				break;
			default:
				oops = 1;
				break;
		}
	}

	if (oops || (argc - optind) < 1) {
		fprintf(stderr, "Mtools version %s, dated %s\n", mversion, mdate);
		fprintf(stderr, "Usage: %s [-st] msdosfile [msdosfiles...]\n", argv[0]);
		exit(1);
	}
	last_drive = 'x';
	mcwd = fix_mcwd();

	for (i = optind; i < argc; i++) {
		drive = get_drive(argv[i]);
		if (drive != last_drive) {
			if (init(drive, O_RDONLY)) {
				fprintf(stderr, "%s: Cannot initialize '%c:'\n", argv[0], drive);
				missed_one++;
				continue;
			}
			last_drive = drive;
		}
		filename = get_name(argv[i]);
		pathname = get_path(argv[i]);
		if (subdir(drive, pathname)) {
			missed_one++;
			continue;
		}

		ismatch = 0;
		for (entry = 0; entry < dir_entries; entry++) {
			dir = dir_read(entry);
					/* if empty */
			if (dir->name[0] == 0x0)
				break;
					/* if erased */
			if (dir->name[0] == 0xe5)
				continue;
					/* if dir or volume label */
			if ((dir->attr & 0x10) || (dir->attr & 0x08))
				continue;

			newfile = unix_name(dir->name, dir->ext);

					/* see it if matches the pattern */
			if (match(newfile, filename)) {
				fat = dir->start[1] * 0x100 + dir->start[0];
				size = dir->size[3] * 0x1000000L + dir->size[2] * 0x10000L + dir->size[1] * 0x100 + dir->size[0];
				if (file_read(stdout, fat, textmode, stripmode, size))
					break;
				ismatch = 1;
				got_one++;
			}
		}
		if (fat_error) {
			missed_one++;
			break;
		}

		if (!ismatch) {
			fprintf(stderr, "%s: File \"%s\" not found\n", argv[0], filename);
			missed_one++;
		}
	}
	close(fd);
	if (got_one && missed_one)
		exit(2);
	if (missed_one)
		exit(1);
	exit(0);
}
