#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include "msdos.h"
#include "patchlevel.h"

int fd = -1;				/* the file descriptor for the device */
unsigned int dir_start;			/* starting sector for directory */
unsigned int dir_len;			/* length of directory (in sectors) */
unsigned int dir_entries;		/* number of directory entries */
unsigned int clus_size;			/* cluster size (in sectors) */
unsigned int msector_size=512;		/* sector size (in bytes) */
char *mcwd;				/* the Current Working Directory */
int fat_error;				/* FAT error detected? */

char *mversion = VERSION;
char *mdate = DATE;

#define DISPATCH(cmd,fn) if (!strcmp(name,cmd)) { extern void fn(); \
  fn(argc, argv); exit(0); }


void
main(int argc,char **argv)
{
    char *name;

#ifdef LOADDEVS
    load_devices();
#endif

    if ((name = strrchr(argv[0],'/')))
         name++;
    else name = argv[0];

    DISPATCH("mattrib",mattrib)
    DISPATCH("mbadblocks",mbadblocks)
    DISPATCH("mcd",mcd)
    DISPATCH("mcopy",mcopy)
    DISPATCH("mdel",mdel)
    DISPATCH("mdir",mdir)
    DISPATCH("mformat",mformat)
    DISPATCH("mlabel",mlabel)
    DISPATCH("mmd",mmd)
    DISPATCH("mmount",mmount)
    DISPATCH("mrd",mrd)
    DISPATCH("mread",mread)
    DISPATCH("mren",mren)
    DISPATCH("mtype",mtype)
    DISPATCH("mwrite",mwrite)

    fprintf(stderr,"Unknown mtools command '%s'\n",name);

    exit(1);
}

/*
 * Do a graceful exit if the program is interrupted.  This will reduce
 * (but not eliminate) the risk of generating a corrupted disk on
 * a user abort.
 */

void
got_signal()
{
	if (fd < 0)
		exit(1);
	fat_write();
	dir_flush();
	disk_flush();
	close(fd);
	exit(1);
}
