/*
 * msdos common header file
 */

#define MAX_SECTOR	8192   		/* largest sector size */
#define MDIR_SIZE	32		/* MSDOS directory entry size in bytes*/
#define MAX_CLUSTER	8192		/* largest cluster size */
#define MAX_PATH	128		/* largest MSDOS path length */
#define MAX_DIR_SECS	64		/* largest directory (in sectors) */
#define MSECTOR_SIZE    msector_size

#ifdef USE_2M
#define PAR_2M ,&use_2m
#ifndef MULTISIZE
#define MULTISIZE
#endif
#else
#define PAR_2M /**/
#endif

#ifdef MULTISIZE
#define PAR_SIZE ,&ssize
#else
#define PAR_SIZE /**/
#endif

#define FAT_SIZE (((num_clus+2) * (fat_bits/4) -1 )/ 2 / MSECTOR_SIZE + 1)

#define NEW		1
#define OLD		0

struct directory {
	unsigned char name[8];		/* file name */
	unsigned char ext[3];		/* file extension */
	unsigned char attr;		/* attribute byte */
	unsigned char reserved[10];	/* ?? */
	unsigned char time[2];		/* time stamp */
	unsigned char date[2];		/* date stamp */
	unsigned char start[2];		/* starting cluster number */
	unsigned char size[4];		/* size of the file */
};

struct device {
	char drive;			/* the drive letter */
	char *name;			/* full path to device */
	long offset;			/* skip this many bytes */
	int fat_bits;			/* FAT encoding scheme */
	int mode;			/* any special open() flags */
	int (*gioctl) ();		/* gioctl() function if needed */
	int tracks;			/* tracks */
	int heads;			/* heads */
	int sectors;			/* sectors */
};

struct bootsector {
	unsigned char jump[3];		/* 0  Jump to boot code */
	unsigned char banner[8];	/* 3  OEM name & version */
	unsigned char secsiz[2];	/* 11 Bytes per sector hopefully 512 */
	unsigned char clsiz;		/* 13 Cluster size in sectors */
	unsigned char nrsvsect[2];	/* 14 Number of reserved (boot) sectors */
	unsigned char nfat;		/* 16 Number of FAT tables hopefully 2 */
	unsigned char dirents[2];	/* 17 Number of directory slots */
	unsigned char psect[2];		/* 19 Total sectors on disk */
	unsigned char descr;		/* 21 Media descriptor=first byte of FAT */
	unsigned char fatlen[2];	/* 22 Sectors in FAT */
	unsigned char nsect[2];		/* 24 Sectors/track */
	unsigned char nheads[2];	/* 26 Heads */
	unsigned char nhs[4];		/* 28 number of hidden sectors */
	unsigned char bigsect[4];	/* 32 big total sectors */
	unsigned char physdrive;	/* 36 physical drive ? */
	unsigned char reserved;		/* 37 reserved */
	unsigned char dos4;		/* 38 dos > 4.0 diskette */
	unsigned char serial[4];       	/* 39 serial number */
	unsigned char label[11];	/* 43 disk label */
	unsigned char fat_type[8];	/* 54 FAT type */
#ifdef USE_2M
	unsigned char res_2m;		/* 62 reserved by 2M */
	unsigned char CheckSum;		/* 63 2M checksum (not used) */
	unsigned char fmt_2mf;		/* 64 2MF format version */
	unsigned char wt;		/* 65 1 if write track after format */
	unsigned char rate_0;		/* 66 data transfer rate on track 0 */
	unsigned char rate_any;		/* 67 data transfer rate on track<>0 */
	unsigned char BootP[2];		/* 68 offset to boot program */
	unsigned char Infp0[2];		/* 70 T1: information for track 0 */
	unsigned char InfpX[2];		/* 72 T2: information for track<>0 */
	unsigned char InfTm[2];		/* 74 T3: track sectors size table */
	unsigned char junk[128 - 76];	/* 76 remaining data */
#endif
};

typedef void SIG_TYPE;
/* typedef int SIG_TYPE; */

#ifdef BSD
#define strchr index
#define strrchr rindex
#endif /* BSD */

#define FAT12 4086 /* max. number of clusters described by a 12 bit FAT */

extern int fd;				/* the file descriptor for the device */
extern unsigned int dir_start;	       	/* starting sector for directory */
extern unsigned int dir_len;   		/* length of directory (in sectors) */
extern unsigned int dir_entries;	/* number of directory entries */
extern unsigned int clus_size;		/* cluster size (in sectors) */
extern unsigned int msector_size;      	/* sector size (in bytes) */
extern char *mcwd;			/* the Current Working Directory */
extern int fat_error;			/* FAT error detected? */

extern char *mversion;
extern char *mdate;

#ifdef USE_SERIAL
extern int serialized;
extern unsigned long serial_number;
#endif

/*
 * Function Prototypes
 */

int ask_confirmation();
char *get_homedir();
char *expand();
char *fix_mcwd();
char *get_name();
char *get_path();
char get_drive();

void reset_chain();
void fat_read();
void chain();
int fill_chain();
int match(), subdir(), init(), is_dir(), fat_free(), fat_encode();
int dir_grow(), file_read();
void fat_write(), dir_write(), disk_flush(), dir_flush();
unsigned int fat_decode();
unsigned int next_fat();

char *unix_name(), *unixname();
unsigned char *dos_name();

struct directory *dir_read();
struct directory *mk_entry();
void dir_flush();
void dir_write();

int disk_read();
void disk_write();
void disk_flush();

long file_write();

void load_devices();

void got_signal();


/*
 * Global Variables
 */

extern long disk_offset;
extern unsigned int disk_size;
extern int disk_dirty;
extern long disk_current;
extern long disk_cur_size;

extern unsigned int num_clus;

extern unsigned char *disk_buf;
extern unsigned char *fat_buf;
extern unsigned char *dir_buf;

extern long dir_chain[MAX_DIR_SECS];
extern int dir_dirty;

extern int fat_error;
extern unsigned int last_fat;
extern int fat_bits;
extern unsigned end_fat;
extern int fat_error;
extern int fat_len;
extern int num_fat;

extern int full;
extern char *mcwd;
extern struct device devices[];
extern char ans[];
extern int fd;

extern int is_2m;

#ifdef SPARC_ODD
/* fix brain-dead Sun-Os include files */
void fflush();
int printf(), fprintf(), fclose(),open(), mkdir();
char toupper(), tolower();
int close(), pclose(), system();
int perror(), ungetc();
long time();
int _flsbuf();
int fgetc();
int fread(), fwrite();
int sscanf();
void bcopy();
int ioctl();
int utime();
#endif

#ifdef BOS
/* fix Bull-Os include files */
int printf(), fprintf(), fclose(),open(), mkdir();
int close(), pclose(), system();
int perror(), ungetc();
int _flsbuf();
int fgetc();
int fread(), fwrite();
int sscanf();
void bcopy();
int utime();
int read(), write(),lseek();
int fork(), execvp(), wait();
int access(),geteuid(), isatty();
char *getlogin();
#endif

