/*
 * Miscellaneous routines.
 */

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <limits.h>
#include <string.h>
#include <stdlib.h>
#include <pwd.h>
#include <sys/param.h>
/*#undef _SYSV				fix silly DPX/20 include files */
#include <unistd.h>
#include "msdos.h"

char *get_homedir()
{
  struct passwd *pw;
  int uid;
  char *homedir;
  char *username;
  
  homedir = getenv ("HOME");    
  /* 
   * first we call getlogin. 
   * There might be several accounts sharing one uid 
   */
  if ( homedir )
    return homedir;

  pw = 0;
  
  username = getenv("LOGNAME");
  if ( !username )
    username = getlogin();
  if ( username )
    pw = getpwnam( username);
  
  if ( pw == 0 ){
    /* if we can't getlogin, look up the pwent by uid */
    uid = geteuid();
    pw = getpwuid(uid);
  }
  
  /* we might still get no entry */
  if ( pw )
    return pw->pw_dir;
  return 0;
}

int ask_confirmation(format, p1, p2)
char *format, *p1, *p2;
{
  static FILE *tty=NULL;
  char ans[10];

  if ( tty == NULL )
    tty = fopen("/dev/tty","r");
  if ( tty == NULL ){
    if ( !isatty(0) )
      return 0;
    tty = stdin;
  }

  while (1) {
    fprintf(stderr, format, p1, p2);
    fflush(stderr);
    fgets(ans,9, tty);
    if (ans[0] == 'y' || ans[0] == 'Y')
      return 0;
    if (ans[0] == 'n' || ans[0] == 'N')
      return -1;
  }
}

