/*
 * Copyright (c) 1990 Jan-Simon Pendry
 * Copyright (c) 1990 Imperial College of Science, Technology & Medicine
 * Copyright (c) 1990 The Regents of the University of California.
 * All rights reserved.
 *
 * This code is derived from software contributed to Berkeley by
 * Jan-Simon Pendry at Imperial College, London.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the University of
 *      California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	%W% (Berkeley) %G%
 *
 * $Id: hsfs_ops.c,v 5.2.2.1 1992/02/09 15:09:08 jsp beta $
 *
 */

#include "am.h"

#ifdef HAS_HSFS

#ifndef HSFS
#define HSFS
#endif /* !HSFS */

#include <sys/stat.h>
#include <sys/mount.h>

/*
 * High Sierra (CD-ROM) file system
 */

/*
 * HSFS needs remote filesystem.
 */
static char *hsfs_match P((am_opts *fo));
static char *hsfs_match(fo)
am_opts *fo;
{
	if (!fo->opt_dev) {
		plog(XLOG_USER, "hsfs: no source device specified");
		return 0;
	}

#ifdef DEBUG
	dlog("HSFS: mounting device \"%s\" on \"%s\"",
		fo->opt_dev, fo->opt_fs);
#endif /* DEBUG */

	/*
	 * Determine magic cookie to put in mtab
	 */
	return strdup(fo->opt_dev);
}

static mount_hsfs(dir, fs_name, opts)
char *dir;
char *fs_name;
char *opts;
{
	struct hsfs_args hsfs_args;
	struct mntent mnt;
	int flags;

	/*
	 * Figure out the name of the file system type.
	 */
#ifdef M_NEWTYPE
	char *type = MOUNT_TYPE_HSFS;
#else
	int type = MOUNT_TYPE_HSFS;
#endif /* M_NEWTYPE */

	bzero((voidp) &hsfs_args, sizeof(hsfs_args));	/* Paranoid */

	/*
	 * Fill in the mount structure
	 */
	mnt.mnt_dir = dir;
	mnt.mnt_fsname = fs_name;
	mnt.mnt_type = MTAB_TYPE_HSFS;
	mnt.mnt_opts = opts;
	mnt.mnt_freq = 0;
	mnt.mnt_passno = 0;

	flags = compute_mount_flags(&mnt);

	hsfs_args.fspec = fs_name;
	hsfs_args.norrip = 0;	/* use Rock-Ridge Protocol extensions */
				/* XXX: need to provide norrip mount opt */
	/*
	 * Call generic mount routine
	 */
	return mount_fs(&mnt, flags, (caddr_t) &hsfs_args, 0, type);
}

/*ARGSUSED*/
static int hsfs_fmount(mf)
mntfs *mf;
{
	int error;

	error = mount_hsfs(mf->mf_mount, mf->mf_info, mf->mf_mopts);
	if (error) {
		errno = error;
		plog(XLOG_ERROR, "mount_hsfs: %m");
		return error;
	}

	return 0;
}

static int hsfs_fumount(mf)
mntfs *mf;
{
	return UMOUNT_FS(mf->mf_mount);
}

/*
 * Ops structure
 */
am_ops hsfs_ops = {
	"hsfs",
	hsfs_match,
	0, /* hsfs_init */
	auto_fmount,
	hsfs_fmount,
	auto_fumount,
	hsfs_fumount,
	efs_lookuppn,
	efs_readdir,
	0, /* hsfs_readlink */
	0, /* hsfs_mounted */
	0, /* hsfs_umounted */
	find_afs_srvr,
	FS_MKMNT|FS_NOTIMEOUT|FS_UBACKGROUND|FS_AMQINFO
};

#endif /* HAS_HSFS */
