To remedy XSS vulnerabilities, it is important to never use untrusted
or unfiltered data within the code of a HTML page.

Untrusted data can originate not only form the client but potentially
a third party or previously uploaded file etc. Filtering of untrusted
data typically involves converting special characters to their HTML
entity encoded counterparts (however, other methods do exist, see
references). These special characters include:


* `&`
* `<`
* `>`
* `"`
* `'`
* `/`

An example of HTML entity encoding is converting `<` to `&lt;`. Although
it is possible to filter untrusted input, there are five locations
within an HTML page where untrusted input (even if it has been
filtered) should never be placed:


1. Directly in a script.
2. Inside an HTML comment.
3. In an attribute name.
4. In a tag name.
5. Directly in CSS.

Each of these locations have their own form of escaping and filtering.

_Because many browsers attempt to implement XSS protection, any manual
verification of this finding should be conducted using multiple different
browsers and browser versions._