/// We speed up compilation by using the expanded output and then deselecting the macro feature
/// of pyo3, removing syn and proc macros from the dependencies
use pyo3::prelude::*;

fn add(x: usize, y: usize) -> usize {
    let sum = some_path_dep::add(x, y);
    debug_assert!(some_path_dep::is_sum(x, y, sum));
    sum
}

unsafe extern "C" fn __pyo3_raw_add(
    _slf: *mut pyo3::ffi::PyObject,
    _args: *mut pyo3::ffi::PyObject,
    _kwargs: *mut pyo3::ffi::PyObject,
) -> *mut pyo3::ffi::PyObject {
    const _LOCATION: &'static str = "add()";

    let pool = ::pyo3::GILPool::new();
    let unwind_safe_py = std::panic::AssertUnwindSafe(pool.python());
    let result = match std::panic::catch_unwind(move || -> ::pyo3::PyResult<_> {
        let _py = *unwind_safe_py;
        ::pyo3::callback::convert(_py, {
            let _args = _py.from_borrowed_ptr::<pyo3::types::PyTuple>(_args);
            let _kwargs: Option<&pyo3::types::PyDict> = _py.from_borrowed_ptr_or_opt(_kwargs);
            {
                const PARAMS: &'static [pyo3::derive_utils::ParamDescription] = &[
                    pyo3::derive_utils::ParamDescription {
                        name: "x",
                        is_optional: false,
                        kw_only: false,
                    },
                    pyo3::derive_utils::ParamDescription {
                        name: "y",
                        is_optional: false,
                        kw_only: false,
                    },
                ];
                let mut output = [None; 2usize];
                let mut _args = _args;
                let mut _kwargs = _kwargs;
                let (_args, _kwargs) = pyo3::derive_utils::parse_fn_args(
                    Some(_LOCATION),
                    PARAMS,
                    _args,
                    _kwargs,
                    false,
                    false,
                    &mut output,
                )?;
                let arg0 = match output[0usize] {
                    Some(_obj) => _obj
                        .extract()
                        .map_err(|e| pyo3::derive_utils::argument_extraction_error(_py, "x", e))?,
                    None => {
                        panic!("Failed to extract required method argument")
                    }
                };
                let arg1 = match output[1usize] {
                    Some(_obj) => _obj
                        .extract()
                        .map_err(|e| pyo3::derive_utils::argument_extraction_error(_py, "y", e))?,
                    None => {
                        panic!("Failed to extract required method argument")
                    }
                };
                add(arg0, arg1)
            }
        })
    }) {
        Ok(result) => result,
        Err(e) => {
            if let Some(string) = e.downcast_ref::<String>() {
                Err(::pyo3::panic::PanicException::new_err((string.clone(),)))
            } else if let Some(s) = e.downcast_ref::<&str>() {
                Err(::pyo3::panic::PanicException::new_err((s.to_string(),)))
            } else {
                Err(::pyo3::panic::PanicException::new_err((
                    "panic from Rust code",
                )))
            }
        }
    };
    result.unwrap_or_else(|e| {
        e.restore(pool.python());
        ::pyo3::callback::callback_error()
    })
}
pub(crate) fn __pyo3_get_function_add<'a>(
    args: impl Into<pyo3::derive_utils::PyFunctionArguments<'a>>,
) -> pyo3::PyResult<&'a pyo3::types::PyCFunction> {
    let name = "add\u{0}";
    let name = std::ffi::CStr::from_bytes_with_nul(name.as_bytes()).unwrap();
    let doc = std::ffi::CStr::from_bytes_with_nul(b"\x00").unwrap();
    pyo3::types::PyCFunction::internal_new(
        name,
        doc,
        pyo3::class::PyMethodType::PyCFunctionWithKeywords(__pyo3_raw_add),
        pyo3::ffi::METH_VARARGS | pyo3::ffi::METH_KEYWORDS,
        args.into(),
    )
}

fn pyo3_pure(_py: Python, m: &PyModule) -> PyResult<()> {
    m.add_wrapped(&__pyo3_get_function_add)?;
    Ok(())
}

#[no_mangle]
#[allow(non_snake_case)]
#[doc = r" This autogenerated function is called by the python interpreter when importing"]
#[doc = r" the module."]
pub unsafe extern "C" fn PyInit_sdist_with_path_dep() -> *mut pyo3::ffi::PyObject {
    use pyo3::derive_utils::ModuleDef;
    const NAME: &'static str = "pyo3_pure\u{0}";
    static MODULE_DEF: ModuleDef = unsafe { ModuleDef::new(NAME) };
    let pool = ::pyo3::GILPool::new();
    let unwind_safe_py = std::panic::AssertUnwindSafe(pool.python());
    let result = match std::panic::catch_unwind(move || -> ::pyo3::PyResult<_> {
        let _py = *unwind_safe_py;
        ::pyo3::callback::convert(_py, MODULE_DEF.make_module("", pyo3_pure))
    }) {
        Ok(result) => result,
        Err(e) => {
            if let Some(string) = e.downcast_ref::<String>() {
                Err(::pyo3::panic::PanicException::new_err((string.clone(),)))
            } else if let Some(s) = e.downcast_ref::<&str>() {
                Err(::pyo3::panic::PanicException::new_err((s.to_string(),)))
            } else {
                Err(::pyo3::panic::PanicException::new_err((
                    "panic from Rust code",
                )))
            }
        }
    };
    result.unwrap_or_else(|e| {
        e.restore(pool.python());
        ::pyo3::callback::callback_error()
    })
}
