---
page_type: sample
languages:
  - python
products:
  - azure
---

# Azure Core Library Python Developer Samples

These are some code snippets that show the way in which you can set up some functionalities used in new SDKs such as logging, pipelines, etc.

They are not intended to be run as standalone application, but show you how these functionalities can be configured.

[test_example_sync.py](https://github.com/Azure/azure-sdk-for-python/blob/main/sdk/core/azure-core/samples/test_example_sync.py) - samples of how to create a sync pipeline

[test_example_async.py](https://github.com/Azure/azure-sdk-for-python/blob/main/sdk/core/azure-core/samples/test_example_async.py) - samples of how to create an async pipeline

[test_example_sansio.py](https://github.com/Azure/azure-sdk-for-python/blob/main/sdk/core/azure-core/samples/test_example_sansio.py) - samples of how to config policies

# Azure Core Library Python End User Samples

These are some code snippets that show the way in which end users can customize the behavior.

[example_shared_transport.py](https://github.com/Azure/azure-sdk-for-python/blob/main/sdk/core/azure-core/samples/example_shared_transport.py) - samples of how to use a shared sync transport

[example_shared_transport_async.py](https://github.com/Azure/azure-sdk-for-python/blob/main/sdk/core/azure-core/samples/example_shared_transport_async.py) - samples of how to use a shared async transport

[example_truststore_injection.py](https://github.com/Azure/azure-sdk-for-python/blob/main/sdk/core/azure-core/samples/example_truststore_injection.py) - samples of how to use the `truststore` library to leverage OS certificate stores via global injection

[example_truststore_ssl_context.py](https://github.com/Azure/azure-sdk-for-python/blob/main/sdk/core/azure-core/samples/example_truststore_ssl_context.py) - samples of how to use `truststore.SSLContext` directly with custom transport sessions
