# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.azurestackhcivm.aio import AzureStackHCIVmClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestAzureStackHCIVmLogicalNetworksOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(AzureStackHCIVmClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_logical_networks_get(self, resource_group):
        response = await self.client.logical_networks.get(
            resource_group_name=resource_group.name,
            logical_network_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_logical_networks_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.logical_networks.begin_create_or_update(
                resource_group_name=resource_group.name,
                logical_network_name="str",
                resource={
                    "location": "str",
                    "extendedLocation": {"name": "str", "type": "str"},
                    "id": "str",
                    "name": "str",
                    "properties": {
                        "dhcpOptions": {"dnsServers": ["str"]},
                        "networkType": "str",
                        "provisioningState": "str",
                        "status": {
                            "errorCode": "str",
                            "errorMessage": "str",
                            "provisioningStatus": {"operationId": "str", "status": "str"},
                        },
                        "subnets": [
                            {
                                "name": "str",
                                "properties": {
                                    "addressPrefix": "str",
                                    "addressPrefixes": ["str"],
                                    "ipAllocationMethod": "str",
                                    "ipConfigurationReferences": [{"ID": "str"}],
                                    "ipPools": [
                                        {
                                            "end": "str",
                                            "info": {"available": "str", "used": "str"},
                                            "ipPoolType": "str",
                                            "name": "str",
                                            "start": "str",
                                        }
                                    ],
                                    "networkSecurityGroup": {"id": "str"},
                                    "routeTable": {
                                        "etag": "str",
                                        "name": "str",
                                        "properties": {
                                            "routes": [
                                                {
                                                    "name": "str",
                                                    "properties": {"addressPrefix": "str", "nextHopIpAddress": "str"},
                                                }
                                            ]
                                        },
                                        "type": "str",
                                    },
                                    "vlan": 0,
                                },
                            }
                        ],
                        "vmSwitchName": "str",
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "tags": {"str": "str"},
                    "type": "str",
                },
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_logical_networks_begin_update(self, resource_group):
        response = await (
            await self.client.logical_networks.begin_update(
                resource_group_name=resource_group.name,
                logical_network_name="str",
                properties={"tags": {"str": "str"}},
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_logical_networks_begin_delete(self, resource_group):
        response = await (
            await self.client.logical_networks.begin_delete(
                resource_group_name=resource_group.name,
                logical_network_name="str",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_logical_networks_list_by_resource_group(self, resource_group):
        response = self.client.logical_networks.list_by_resource_group(
            resource_group_name=resource_group.name,
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_logical_networks_list_all(self, resource_group):
        response = self.client.logical_networks.list_all()
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...
