#nec_ground.py

#header generated by SWIG

import _PyNEC

def _swig_setattr_nondynamic(self,class_type,name,value,static=1):
    if (name == "this"):
        if isinstance(value, class_type):
            self.__dict__[name] = value.this
            if hasattr(value,"thisown"): self.__dict__["thisown"] = value.thisown
            del value.thisown
            return
    method = class_type.__swig_setmethods__.get(name,None)
    if method: return method(self,value)
    if (not static) or hasattr(self,name) or (name == "thisown"):
        self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)

def _swig_setattr(self,class_type,name,value):
    return _swig_setattr_nondynamic(self,class_type,name,value,0)

def _swig_getattr(self,class_type,name):
    method = class_type.__swig_getmethods__.get(name,None)
    if method: return method(self)
    raise AttributeError,name

import types
try:
    _object = types.ObjectType
    _newclass = 1
except AttributeError:
    class _object : pass
    _newclass = 0
del types

#end of the header generated by SWIG



import exceptions

#class "nec_ground"

class nec_ground(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, nec_ground, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, nec_ground, name)
    def __repr__(self):
        return "<%s.%s; proxy of C++ nec_ground instance at %s>" % (self.__class__.__module__, self.__class__.__name__, self.this,)
    def __init__(self, *args):
        _swig_setattr(self, nec_ground, 'this', _PyNEC.new_nec_ground(*args))
        _swig_setattr(self, nec_ground, 'thisown', 1)
	self._ifar=0
    
    
    def get_relative_dielectric_constant(*args):
    	"""
	Returns the relative dielectric constant (no units) of the ground medium 1.
	"""
    	return _PyNEC.nec_ground_get_relative_dielectric_constant(*args)
	
	
    def get_conductivity(*args):
    	"""
	Returns the conductivity in Siemens/meter of the ground medium 1.
	"""
    	return _PyNEC.nec_ground_get_conductivity(*args)
    
    
    def get_radial_wire_count(self,*args):
    	"""
	Returns the number of radial wires in the ground screen approximation, provided it has been used.
	"""
    	_ifar=self._ifar
	if _ifar>3 and _ifar<7 :
    		return _PyNEC.nec_ground_get_radial_wire_count(*args)
	else :
		error_msg="The count of radial wires is not available : there is no radial wire ground screen."
		raise exceptions.Warning(error_msg)


    def get_radial_wire_length(self,*args):
    	"""
	Returns the length of radial wires used in the ground screen approximation - provided this approximation has been used.
	"""		  
    	_ifar=self._ifar
	if _ifar >3 and _ifar<7 :
    		return _PyNEC.nec_ground_get_radial_wire_length(*args)
	else :
		error_msg="The length of radial wires is not available : there is no radial wire ground screen."
		raise exceptions.Warning(error_msg)
		
		
    def get_radial_wire_radius(self,*args):
     	"""
	Returns the radius of radial wires used in the ground screen approximation - provided this approximation has been used.
	"""
	_ifar=self._ifar
	if _ifar >3 and _ifar<7 :
    		return _PyNEC.nec_ground_get_radial_wire_radius(*args)
	else :
		error_msg="The radius of radial wires is not available : there is no radial wire ground screen."
		raise exceptions.Warning(error_msg)
    
    
    def get_cliff_type(self):
    	"""
	Returns the type of cliff provided there's a cliff problem.
	"""
    	_ifar=self._ifar
	if _ifar == 2 or _ifar == 5 :
		return "Linear"
	elif _ifar == 3 or _ifar == 6 :
		return "Circular"
	else :
		error_msg = "Unknown cliff type."
		raise exceptions.Warining(error_msg)
    
    
    def get_cliff_edge_distance(self):
    	"""
	If there's a cliff problem, returns the distance from the origin of the coordinate system to join between medium 1 and 2.
		This distance is either	the radius of the circle where the two media join or the distance from the X axis to where
		the two media join in a line parallel to the Y axis. Specification of the circular or linear option is on the RP card.
	"""
    	_ifar=self._ifar
	if _ifar>1 and _ifar!=4 and _ifar<7 :
		return _PyNEC.nec_ground_get_cliff_edge_distance(self)
	else :
		error_msg = "The edge distance of the cliff is not available : there is no cliff."
		raise exceptions.Warning(error_msg)
		
		
    def get_cliff_height(self):
    	"""
	If there's a cliff problem, returns the distance (positive or zero) by which the surface of medium 2 is below medium 1.
	"""
    	_ifar=self._ifar
	if _ifar>1 and _ifar!=4 and _ifar<7 :
		return _PyNEC.nec_ground_get_cliff_height(self)
	else :
		error_msg = "The height of the cliff is not available : there is no cliff."
		raise exceptions.Warning(error_msg)
		
		
    def get_relative_dielectric_constant2(self):
    	"""
	If there's a cliff problem, returns the relative dielectric constant (no units) of the ground medium 2.
	"""	
	_ifar=self._ifar
	if _ifar>1 and _ifar!=4 and _ifar<7 :
		return _PyNEC.nec_ground_get_relative_dielectric_constant2(self)
	else :
		error_msg = "The relative dielectric constant of medium 2 is not available : there is no cliff."
		raise exceptions.Warning(error_msg)
	
		
    def get_conductivity2(self):
    	"""
	If there's a cliff problem, returns the conductivity in Siemens/meter of the ground medium 2.
	"""
    	_ifar=self._ifar
	if _ifar>1 and _ifar!=4 and _ifar<7 :
		return _PyNEC.nec_ground_get_conductivity2(self)
	else :
		error_msg = "The conductivity of medium 2 is not available : there is no cliff."
		raise exceptions.Warning(error_msg)
		
    

class nec_groundPtr(nec_ground):
    def __init__(self, this):
        _swig_setattr(self, nec_ground, 'this', this)
        if not hasattr(self,"thisown"): _swig_setattr(self, nec_ground, 'thisown', 0)
        _swig_setattr(self, nec_ground,self.__class__,nec_ground)
_PyNEC.nec_ground_swigregister(nec_groundPtr)
