/*
 * Decompiled with CFR 0.152.
 */
package java.util.jar;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.jar.Manifest;

public class Attributes
implements Map,
Cloneable {
    protected Map map;

    public Attributes() {
        this(11);
    }

    public Attributes(int n) {
        this.map = new HashMap(n);
    }

    public Attributes(Attributes attributes) {
        this.map = new HashMap(attributes);
    }

    public Object get(Object object) {
        return this.map.get(object);
    }

    public String getValue(String string) {
        return (String)this.get(new Name(string));
    }

    public String getValue(Name name) {
        return (String)this.get(name);
    }

    public Object put(Object object, Object object2) {
        return this.map.put((Name)object, (String)object2);
    }

    public String putValue(String string, String string2) {
        return (String)this.put(new Name(string), string2);
    }

    public Object remove(Object object) {
        return this.map.remove(object);
    }

    public boolean containsValue(Object object) {
        return this.map.containsValue(object);
    }

    public boolean containsKey(Object object) {
        return this.map.containsKey(object);
    }

    public void putAll(Map map) {
        this.map.putAll((Attributes)map);
    }

    public void clear() {
        this.map.clear();
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Set keySet() {
        return this.map.keySet();
    }

    public Collection values() {
        return this.map.values();
    }

    public Set entrySet() {
        return this.map.entrySet();
    }

    public boolean equals(Object object) {
        return ((Object)this.map).equals(object);
    }

    public int hashCode() {
        return ((Object)this.map).hashCode();
    }

    public Object clone() {
        return new Attributes(this);
    }

    void write(DataOutputStream dataOutputStream) throws IOException {
        Iterator iterator = this.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            StringBuffer stringBuffer = new StringBuffer(((Name)entry.getKey()).toString());
            stringBuffer.append(": ");
            String string = (String)entry.getValue();
            if (string != null) {
                byte[] byArray = string.getBytes("UTF8");
                string = new String(byArray, 0, byArray.length);
            }
            stringBuffer.append(string);
            stringBuffer.append("\r\n");
            Manifest.make72Safe(stringBuffer);
            dataOutputStream.writeBytes(stringBuffer.toString());
        }
        dataOutputStream.writeBytes("\r\n");
    }

    void writeMain(DataOutputStream dataOutputStream) throws IOException {
        String string = Name.MANIFEST_VERSION.toString();
        String string2 = this.getValue(string);
        if (string2 == null) {
            string = Name.SIGNATURE_VERSION.toString();
            string2 = this.getValue(string);
        }
        if (string2 != null) {
            dataOutputStream.writeBytes(string + ": " + string2 + "\r\n");
        }
        Iterator iterator = this.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            String string3 = ((Name)entry.getKey()).toString();
            if (string2 == null || string3.equalsIgnoreCase(string)) continue;
            StringBuffer stringBuffer = new StringBuffer(string3);
            stringBuffer.append(": ");
            String string4 = (String)entry.getValue();
            if (string4 != null) {
                byte[] byArray = string4.getBytes("UTF8");
                string4 = new String(byArray, 0, byArray.length);
            }
            stringBuffer.append(string4);
            stringBuffer.append("\r\n");
            Manifest.make72Safe(stringBuffer);
            dataOutputStream.writeBytes(stringBuffer.toString());
        }
        dataOutputStream.writeBytes("\r\n");
    }

    void read(Manifest.FastInputStream fastInputStream, byte[] byArray) throws IOException {
        int n;
        String string = null;
        String string2 = null;
        byte[] byArray2 = null;
        while ((n = fastInputStream.readLine(byArray)) != -1) {
            boolean bl = false;
            if (byArray[--n] != 10) {
                throw new IOException("line too long");
            }
            if (n > 0 && byArray[n - 1] == 13) {
                --n;
            }
            if (n == 0) break;
            int n2 = 0;
            if (byArray[0] == 32) {
                if (string == null) {
                    throw new IOException("misplaced continuation line");
                }
                bl = true;
                byte[] byArray3 = new byte[byArray2.length + n - 1];
                System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
                System.arraycopy(byArray, 1, byArray3, byArray2.length, n - 1);
                if (fastInputStream.peek() == 32) {
                    byArray2 = byArray3;
                    continue;
                }
                string2 = new String(byArray3, 0, byArray3.length, "UTF8");
                byArray2 = null;
            } else {
                while (byArray[n2++] != 58) {
                    if (n2 < n) continue;
                    throw new IOException("invalid header field");
                }
                if (byArray[n2++] != 32) {
                    throw new IOException("invalid header field");
                }
                string = new String(byArray, 0, n2 - 2);
                if (fastInputStream.peek() == 32) {
                    byArray2 = new byte[n - n2];
                    System.arraycopy(byArray, n2, byArray2, 0, n - n2);
                    continue;
                }
                string2 = new String(byArray, n2, n - n2, "UTF8");
            }
            try {
                if (this.putValue(string, string2) != null && bl) continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IOException("invalid header field name: " + string);
            }
        }
    }

    public static class Name {
        private String name;
        private int hashCode = -1;
        public static final Name MANIFEST_VERSION = new Name("Manifest-Version");
        public static final Name SIGNATURE_VERSION = new Name("Signature-Version");
        public static final Name CONTENT_TYPE = new Name("Content-Type");
        public static final Name CLASS_PATH = new Name("Class-Path");
        public static final Name MAIN_CLASS = new Name("Main-Class");
        public static final Name SEALED = new Name("Sealed");
        public static final Name EXTENSION_LIST = new Name("Extension-List");
        public static final Name EXTENSION_NAME = new Name("Extension-Name");
        public static final Name EXTENSION_INSTALLATION = new Name("Extension-Installation");
        public static final Name IMPLEMENTATION_TITLE = new Name("Implementation-Title");
        public static final Name IMPLEMENTATION_VERSION = new Name("Implementation-Version");
        public static final Name IMPLEMENTATION_VENDOR = new Name("Implementation-Vendor");
        public static final Name IMPLEMENTATION_VENDOR_ID = new Name("Implementation-Vendor-Id");
        public static final Name IMPLEMENTATION_URL = new Name("Implementation-URL");
        public static final Name SPECIFICATION_TITLE = new Name("Specification-Title");
        public static final Name SPECIFICATION_VERSION = new Name("Specification-Version");
        public static final Name SPECIFICATION_VENDOR = new Name("Specification-Vendor");

        public Name(String string) {
            if (string == null) {
                throw new NullPointerException("name");
            }
            if (!Name.isValid(string)) {
                throw new IllegalArgumentException(string);
            }
            this.name = string.intern();
        }

        private static boolean isValid(String string) {
            int n = string.length();
            if (n > 70 || n == 0) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (Name.isValid(string.charAt(i))) continue;
                return false;
            }
            return true;
        }

        private static boolean isValid(char c) {
            return Name.isAlpha(c) || Name.isDigit(c) || c == '_' || c == '-';
        }

        private static boolean isAlpha(char c) {
            return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
        }

        private static boolean isDigit(char c) {
            return c >= '0' && c <= '9';
        }

        public boolean equals(Object object) {
            if (object instanceof Name) {
                return this.name.equalsIgnoreCase(((Name)object).name);
            }
            return false;
        }

        public int hashCode() {
            if (this.hashCode == -1) {
                this.hashCode = this.name.toLowerCase().hashCode();
            }
            return this.hashCode;
        }

        public String toString() {
            return this.name;
        }
    }
}

