package org.jboss.cache.commands.read;

import static org.easymock.EasyMock.*;
import org.testng.annotations.Test;

/**
 * Tester class for {@link org.jboss.cache.commands.read.ExistsCommand}
 * @author Mircea.Markus@jboss.com
 * @since 2.2
 */
@Test(groups="unit")
public class ExistsCommandTest extends AbstractDataCommandTest
{
   private ExistsCommand command;

   protected void moreSetup()
   {
      command = new ExistsCommand(testFqn);
      command.initialize(container);
   }

   public void testPerform()
   {
      expect(container.exists(testFqn)).andReturn(Boolean.FALSE);
      replay(container);
      assert Boolean.FALSE == command.perform(null);
      reset(container);
      
      expect(container.exists(testFqn)).andReturn(Boolean.TRUE);
      replay(container);
      assert Boolean.TRUE == command.perform(null);
   }
}
