/* 
 * E-XML Library:  For XML, XML-RPC, HTTP, and related.
 * Copyright (C) 2002-2008  Elias Ross
 * 
 * genman@noderunner.net
 * http://noderunner.net/~genman
 * 
 * 1025 NE 73RD ST
 * SEATTLE WA 98115
 * USA
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * $Id$
 */

package net.noderunner.http;

import junit.framework.TestCase;

public class StatusLineTest extends TestCase {

	public void testVarious() throws HttpException {
		try {
			new StatusLine((String)null);
			fail("NPE");
		} catch (IllegalArgumentException e) {}
		try {
			StatusLine.parseStatusLine((String)null);
			fail("NPE");
		} catch (IllegalArgumentException e) {}
		try {
			new StatusLine("HTTP/1.1 1000");
			fail("NPE");
		} catch (HttpException e) {}
		try {
			new StatusLine("HTTP/1.1 -404");
			fail("NPE");
		} catch (HttpException e) {}
		try {
			new StatusLine("HTTP/1.1");
			fail("NPE");
		} catch (HttpException e) {}
		StatusLine sl = new StatusLine("HTTP/1.2 400 Oh no");
		assertEquals(400, sl.getStatusCode());
		assertEquals("Oh no", sl.getReasonPhrase());
	}
}
