/* 
 * E-XML Library:  For XML, XML-RPC, HTTP, and related.
 * Copyright (C) 2002-2008  Elias Ross
 * 
 * genman@noderunner.net
 * http://noderunner.net/~genman
 * 
 * 1025 NE 73RD ST
 * SEATTLE WA 98115
 * USA
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * $Id$
 */

package net.noderunner.exml;

/**
 * Stores data belonging to a processing instruction.
 * A processing instruction looks like this:
 * <pre>
 * &lt;?pi something here ?&gt; 
 * </pre>
 *
 * @version 1.0
 * @author Elias Ross
 */
public class PI 
	implements Node
{
	private XmlCharArrayWriter w;
	private String name;

	/**
	 * Constructs an empty processing instruction.
	 * @param name processing instruction name, for example
	 * <code>php</code> or <code>foo</code>
	 */
	public PI(String name) {
		this.name = name;
		w = new XmlCharArrayWriter();
	}

	/**
	 * Returns the underlying <code>XmlCharArrayWriter</code>.
	 */
	public XmlCharArrayWriter getWriter() {
		return w;
	}

	/**
	 * Returns the value <code>PI_NODE</code>.
	 */
	public short getNodeType() {
		return PI_NODE;
	}

	/**
	 * Returns the name of the processing instruction.
	 */
	public String getName() {
		return name;
	}

	/**
	 * Returns the underlying data as a newly constructed
	 * string.
	 */
	public String getData() {
		return w.toString();
	}

	/**
	 * Returns a string representation of this object.
	 * Wraps the data in &lt;? ?&gt; strings.
	 */
	public String toString() {
		StringBuffer sb = new StringBuffer(w.size() + 16);
		sb.append(XmlTags.PI_BEGIN);
		sb.append(name);
		sb.append(' ');
		// sb.append(XmlWriter.escape(getData()));
		// I don't think you're suppose to escape this
		sb.append(w.getBuffer(), 0, w.size());
		sb.append(XmlTags.PI_END);
		return sb.toString();
	}
}

