<?php

//    showsource.php
//    Shows the source of a retrieved URL
//
//    Part of the ht://Check package
//
//    Copyright (c) 1999-2004 Comune di Prato - Prato - Italy
//    Author: Gabriele Bartolini - Prato - Italy <angusgb@users.sourceforge.net>
//
//    For copyright details, see the file COPYING in your distribution
//    or the GNU General Public License version 2 or later 
//    <http://www.gnu.org/copyleft/gpl.html>
//
//    $Id: showsource.php,v 1.9 2003/12/30 09:39:23 angusgb Exp $

///////
   //    Global settings
///////

include ("./include/global.inc.php");


include ("./include/header.inc.php"); 

if (!isset($dbname))
{
   // Error
   DisplayErrMsg($strErrorNoDBSelected);
   die;
}
else
{
   if (!isset($IDUrl))
   {
      DisplayErrMsg($strErrorNoUrlSelected);
      die;
   }

   // Retrieve Information from the DB
   $strSQL = "Select Url, Contents" .
      " FROM Url" .
      " WHERE IDUrl=" . $IDUrl . ' AND Contents IS NOT NULL';

   $result=$MyDB->Query($dbname, $strSQL);
   
   if ($result)
   {
      DisplayErrMsg($MyDB->errmsg);
      die;
   }
   
   if ($MyDB->NumRows()>1)
   {
      DisplayErrMsg($strErrorDuplicateKey);
      die;
   }
   else if ($MyDB->NumRows()==0)
   {
?>
<p><?php echo $strNoOccurrencies; ?></p>
<?php
   }
   else
   {

      // Information retrieved
      $row = $MyDB->FetchArray();
      $MyDB->Free();

      $URLName = WriteHTML($row["Url"]);
      $pagetitle = "Database: $dbname - " . $strShowUrlSource . ": " . $URLName;
      
?>
<?php

      // A database and a URL have been selected

?>
<h3><?php echo $URLName; ?></h3>

<table>
<?php
	$row_number = 1;
    $oldpos=0;

	while ( $newtok = substr($row['Contents'], $oldpos) )
	{
       $newpos = strpos($newtok, "\n");
       if ($newpos)
          $str_row = WriteHTML(substr($newtok, 0, $newpos));
       else
          $str_row = '&nbsp;';

       $oldpos += $newpos + 1;

       if ($row_number == $RowNumber)
          $trclass='row';
       else
          ($row_number % 2)? $trclass='odd':$trclass='even';

?>
 <tr class="<?php echo $trclass; ?>">
 <td align="center"><a name="<?php echo $row_number; ?>"><?php echo $row_number; ?></a></td>
 <td><?php echo $str_row; ?></td>
 </tr>
<?php
		++$row_number;
	}
?>
</table>
<?php
   }
}
?>
<?php include ("./include/footer.inc.php"); ?>
