/*
 *  dancer-XML parser
 *  Copyright (C) 2000,2002 Junichi Uekawa
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
/*
 * Helper functions for loaded XML file ... $Id: loadxmlhelper.c,v 1.4 2006/01/24 09:58:32 dancer Exp $
 * 8 Sep MM Junichi Uekawa ... created
 * 11 Sep MM Junichi Uekawa adding get_element_byname and simplepath
 * copyright 2000 Junichi Uekawa
 */

/**
   @file loadxmlhelper.c
   @brief Helper functions for processing the loaded XML file
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "dancer-xml.h"

dxml_element * 
dxml_next_notPCDATA(dxml_element * e)
{
  if (!e) return NULL ;
  if (e->element_type == element_type_pcdata)
    return dxml_next_notPCDATA(e->next);
  return e;
}

dxml_element * 
dxml_get_element_byname(dxml_element * e, const char * name)
{
  while (e)
    {
      if ((e->element_type == element_type_element)&&
	  (!strcmp(e->element_name, name)))
	return e;      
      e=e->next;
    }
  return NULL;  
}

static dxml_element * 
dxml_get_element_bysimplepath_internal(dxml_element * e, char*path)
{
  /*
   * search for /asds/asdg/adhahaf/ae  kind of path
   * should never end with a slash.
   */
  char * slash = strchr(path, '/');

  if (slash == path)
    {				/* skip the extra / */
      return dxml_get_element_bysimplepath(e, path + 1 );
    }
  else if (slash)
    {
      *slash=0;
      if (!(e = dxml_get_element_byname(e,path)))
	return NULL;
      if (!(e = e -> child))
	return NULL;      
      
      return dxml_get_element_bysimplepath(e, slash+1);
    }
  else
    return dxml_get_element_byname(e, path);
}

dxml_element * 
dxml_get_element_bysimplepath(dxml_element * e, const char*path)
{
  char * buf=strdup(path);
  dxml_element * e2 ;
  
  if (!buf) return NULL;
  e2 = dxml_get_element_bysimplepath_internal(e, buf);
  free (buf);
  return e2;
}

char * 
dxml_get_PCDATA_bysimplepath(dxml_element * e, const char * path)
{
  /*
   * get PCDATA from simplepath
   */
  dxml_element * e2;
  char * buf = strdup (path);
  if (!buf) return NULL;
  e2 = dxml_get_element_bysimplepath_internal(e, buf);
  free(buf);  
  if (!e2) return NULL;  
  if (!(e2=e2->child)) return NULL;
  while (e2->element_type!= element_type_pcdata && e2)
    {
      e2=e2->next;      
    }  
  if (!e2) return NULL;
  return e2->element_name;  
}

static void
space(int i)
{
  while (i--)
    printf(" ");  
}

static void
recurse_attribute(dxml_attribute * a )
{
  printf(" %s=\"%s\"", a->attribute_name, a->attribute_data);
  if (a->next) 
    recurse_attribute(a->next);  
}

static void
recurse_element(dxml_element * e, int level)
{
  if (e->element_type == element_type_element)
    {
      space(level);
      printf("<%s", e->element_name);
      if (e->element_attribute) 
	recurse_attribute(e->element_attribute);      
      printf(">\n");      
      if (e->child) 
	recurse_element (e->child, level+1);
      space(level);printf("</%s>\n", e->element_name);      
    }
  else
    {
      space(level);      
      printf("%s\n", e->element_name);
    }
  if (e->next) recurse_element(e->next, level);  
}

void
dxml_dump_element (dxml_element * e)
{
  recurse_element(e,0);
}
