/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.auth.identity.cli.controller;

import com.amazonaws.services.auth.identity.cli.common.Utils;
import com.amazonaws.services.auth.identity.cli.controller.IAMDriver;
import com.amazonaws.services.auth.identity.cli.model.CLIRequest;
import com.amazonaws.services.auth.identity.cli.model.RoleCreateRequest;
import com.amazonaws.services.auth.identity.cli.policy.PolicyBuilder;
import com.amazonaws.services.identitymanagement.model.CreateRoleRequest;
import com.amazonaws.services.identitymanagement.model.CreateRoleResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IAMRoleCreateDriver
extends IAMDriver {
    private static final Log LOG = LogFactory.getLog(IAMRoleCreateDriver.class);

    protected void invokeRequestImpl(CLIRequest request) {
        if (request instanceof RoleCreateRequest) {
            RoleCreateRequest req = (RoleCreateRequest)request;
            String policy = null;
            if (req.getPolicyFile() == null && req.getService() == null) {
                Utils.exit(1, "must specify a service or a policy document to upload", null);
            } else if (!(req.getPolicyFile() == null ^ req.getService() == null)) {
                Utils.exit(1, "can specify only one of -f -s", null);
            }
            CreateRoleRequest createRoleRequest = new CreateRoleRequest();
            createRoleRequest.setRoleName(req.getRoleName());
            createRoleRequest.setPath(this.verifyPathAndAddSlashSuffix(req.getPath()));
            if (req.getService() != null) {
                policy = PolicyBuilder.buildAssumeRolePolicy(req.getService());
            } else {
                policy = Utils.readFile(req.getPolicyFile());
                LOG.debug((Object)("Policy document from file is: " + policy));
            }
            createRoleRequest.setAssumeRolePolicyDocument(policy);
            LOG.debug((Object)("Creating role with request: " + request));
            CreateRoleResult result = this.getClient().createRole(createRoleRequest);
            if (req.isVerbose()) {
                LOG.info((Object)result.getRole().getArn());
                LOG.info((Object)result.getRole().getRoleId());
                LOG.info((Object)policy);
            }
        } else {
            Utils.exit(1, "request " + request + " is of an incorrect type.", null);
        }
    }
}

