//
// Author: Ian Reinhart Geiser <geiseri@kde.org>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include <kjsembed/kjsembedpart.h>
#include <kjsembed/jsconsolewidget.h>
#include <kjsembed/jsbinding.h>

#include "embedviewimp.h"
#include <klineedit.h>
#include <qgroupbox.h>

#include <qdatetime.h>
#include <qcolor.h>

EmbedViewImp::EmbedViewImp(QWidget *parent, const char *name)
    :EmbedView(parent, name)
{
    m_part = new KJSEmbed::KJSEmbedPart(0, "kjsembed_part", this,"JSEmbed");
    m_part->addObject(m_name, "Name");
    m_part->addObject(m_dept, "Dept");
    m_part->addObject(m_title, "Title");
    m_part->addObject(m_customOptions, "CustomOptions");
    m_part->addObject(this, "EmbedInterface");
}

void EmbedViewImp::okClicked()
{
    KJS::List args;
    KJS::Value val = m_part->callMethod("handleOk", args);
    QMap<QString, QVariant> personalData = KJSEmbed::convertToVariant(m_part->globalExec(), val).toMap();
    QDate birthday = personalData["birthday"].toDate();
    QColor eyecolor = personalData["eyeColor"].toColor();
    QString notes = personalData["notes"].toString();
    
    kdDebug() << "birthday: " << birthday << endl;
    kdDebug() << "eyecolor: " << eyecolor << endl;
    kdDebug() << "notes: " << notes << endl;
    
}

void EmbedViewImp::cancelClicked()
{
    m_name->setText("");
    m_title->setText("");
    m_dept->setText("");
}

void EmbedViewImp::consoleClicked()
{
    m_part->view()->setHidden(!m_part->view()->isHidden());
}

bool EmbedViewImp::runScript( const QString &file )
{
    return m_part->runFile(file, m_part->globalObject() );
}

QVariant EmbedViewImp::someValue() const
{
    QMap<QString,QVariant> returnMap;
    returnMap["name"] = m_name->text();	
    returnMap["title"] = m_title->text();	
    returnMap["dept"] = m_dept->text();	
    return QVariant(returnMap);
}

void EmbedViewImp::setSomeValue( const QVariant &val )
{
    QMap<QString,QVariant> map = val.toMap();
    m_name->setText(map["name"].toString());
    m_title->setText(map["title"].toString());
    m_dept->setText(map["dept"].toString());
}

#include "embedviewimp.moc"
