/* Generated by re2c */
#line 1 "real_world/parse_date.re"
// re2c $INPUT -o $OUTPUT 
/*
   +----------------------------------------------------------------------+
   | PHP Version 5                                                        |
   +----------------------------------------------------------------------+
   | Copyright (c) 1997-2006 The PHP Group                                |
   +----------------------------------------------------------------------+
   | This source file is subject to version 3.01 of the PHP license,      |
   | that is bundled with this package in the file LICENSE, and is        |
   | available through the world-wide-web at the following url:           |
   | http://www.php.net/license/3_01.txt                                  |
   | If you did not receive a copy of the PHP license and are unable to   |
   | obtain it through the world-wide-web, please send a note to          |
   | license@php.net so we can mail you a copy immediately.               |
   +----------------------------------------------------------------------+
   | Authors: Derick Rethans <derick@derickrethans.nl>                    |
   +----------------------------------------------------------------------+
 */



#include "timelib.h"

#include <stdio.h>
#include <ctype.h>

#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#else
#include <strings.h>
#endif

#if defined(_MSC_VER)
# define strtoll(s, f, b) _atoi64(s)
#elif !defined(HAVE_STRTOLL)
# if defined(HAVE_ATOLL)
#  define strtoll(s, f, b) atoll(s)
# else
#  define strtoll(s, f, b) strtol(s, f, b)
# endif
#endif

#define TIMELIB_SECOND  1
#define TIMELIB_MINUTE  2
#define TIMELIB_HOUR    3
#define TIMELIB_DAY     4
#define TIMELIB_MONTH   5
#define TIMELIB_YEAR    6
#define TIMELIB_WEEKDAY 7

#define EOI      257
#define TIME     258
#define DATE     259

#define TIMELIB_XMLRPC_SOAP    260
#define TIMELIB_TIME12         261
#define TIMELIB_TIME24         262
#define TIMELIB_GNU_NOCOLON    263
#define TIMELIB_GNU_NOCOLON_TZ 264
#define TIMELIB_ISO_NOCOLON    265

#define TIMELIB_AMERICAN       266
#define TIMELIB_ISO_DATE       267
#define TIMELIB_DATE_FULL      268
#define TIMELIB_DATE_TEXT      269
#define TIMELIB_DATE_NOCOLON   270
#define TIMELIB_PG_YEARDAY     271
#define TIMELIB_PG_TEXT        272
#define TIMELIB_PG_REVERSE     273
#define TIMELIB_CLF            274
#define TIMELIB_DATE_NO_DAY    275
#define TIMELIB_SHORTDATE_WITH_TIME 276
#define TIMELIB_DATE_FULL_POINTED 277
#define TIMELIB_TIME24_WITH_ZONE 278
#define TIMELIB_ISO_WEEK       279

#define TIMELIB_TIMEZONE       300
#define TIMELIB_AGO            301

#define TIMELIB_RELATIVE       310

#define TIMELIB_ERROR          999

typedef unsigned char uchar;

#define   BSIZE	   8192

#define   YYCTYPE      uchar
#define   YYCURSOR     cursor
#define   YYLIMIT      s->lim
#define   YYMARKER     s->ptr
#define   YYFILL(n)    return EOI;

#define   RET(i)       {s->cur = cursor; return i;}

#define timelib_string_free free

#define TIMELIB_HAVE_TIME() { if (s->time->have_time) { return TIMELIB_ERROR; } else { s->time->have_time = 1; s->time->h = 0; s->time->i = 0; s->time->s = 0; s->time->f = 0; } }
#define TIMELIB_UNHAVE_TIME() { s->time->have_time = 0; s->time->h = 0; s->time->i = 0; s->time->s = 0; s->time->f = 0; }
#define TIMELIB_HAVE_DATE() { if (s->time->have_date) { return TIMELIB_ERROR; } else { s->time->have_date = 1; } }
#define TIMELIB_UNHAVE_DATE() { s->time->have_date = 0; s->time->d = 0; s->time->m = 0; s->time->y = 0; }
#define TIMELIB_HAVE_RELATIVE() { s->time->have_relative = 1; s->time->relative.weekday_behavior = 0; }
#define TIMELIB_HAVE_WEEKDAY_RELATIVE() { s->time->have_weekday_relative = 1; }
#define TIMELIB_HAVE_TZ() { s->cur = cursor; if (s->time->have_zone) { return TIMELIB_ERROR; } else { s->time.have_zone = 1; } }

#define TIMELIB_INIT  s->cur = cursor; str = timelib_string(s); ptr = str
#define TIMELIB_DEINIT timelib_string_free(str)
#define TIMELIB_ADJUST_RELATIVE_WEEKDAY() if (in->time.have_weekday_relative && (in.rel.d > 0)) { in.rel.d -= 7; }

#define TIMELIB_PROCESS_YEAR(x) { \
	if ((x) == -1) {         \
	/*	(x) = 0; */          \
	} else if ((x) < 100) {  \
		if ((x) < 70) {      \
			(x) += 2000;     \
		} else {             \
			(x) += 1900;     \
		}                    \
	}                        \
}

#ifdef DEBUG_PARSER
#define DEBUG_OUTPUT(s) printf("%s\n", s);
#define YYDEBUG(s,c) { if (s != -1) { printf("state: %d ", s); printf("[%c]\n", c); } }
#else
#define DEBUG_OUTPUT(s)
#define YYDEBUG(s,c)
#endif

#include "timelib_structs.h"

typedef struct timelib_elems {
	unsigned int   c; /* Number of elements */
	char         **v; /* Values */
} timelib_elems;

typedef struct Scanner {
	int           fd;
	uchar        *lim, *str, *ptr, *cur, *tok, *pos;
	unsigned int  line, len;
	int           errors;

	struct timelib_time *time;
	timelib_tzdb        *tzdb;
} Scanner;

typedef struct _timelib_lookup_table {
    const char *name;
    int         type;
    int         value;
} timelib_lookup_table;

typedef struct _timelib_relunit {
	const char *name;
	int         unit;
	int         multiplier;
} timelib_relunit;

#define HOUR(a) (int)(a * 60)

/* The timezone table. */
static timelib_tz_lookup_table timelib_timezone_lookup[] = {
#include "timezonemap.h"
	{ NULL, 0, 0, NULL },
};

static timelib_tz_lookup_table timelib_timezone_fallbackmap[] = {
#include "fallbackmap.h"
	{ NULL, 0, 0, NULL },
};

static timelib_tz_lookup_table timelib_timezone_utc[] = {
	{ "utc", 0, 0, "UTC" },
};

static timelib_relunit const timelib_relunit_lookup[] = {
	{ "sec",         TIMELIB_SECOND,  1 },
	{ "secs",        TIMELIB_SECOND,  1 },
	{ "second",      TIMELIB_SECOND,  1 },
	{ "seconds",     TIMELIB_SECOND,  1 },
	{ "min",         TIMELIB_MINUTE,  1 },
	{ "mins",        TIMELIB_MINUTE,  1 },
	{ "minute",      TIMELIB_MINUTE,  1 },
	{ "minutes",     TIMELIB_MINUTE,  1 },
	{ "hour",        TIMELIB_HOUR,    1 },
	{ "hours",       TIMELIB_HOUR,    1 },
	{ "day",         TIMELIB_DAY,     1 },
	{ "days",        TIMELIB_DAY,     1 },
	{ "week",        TIMELIB_DAY,     7 },
	{ "weeks",       TIMELIB_DAY,     7 },
	{ "fortnight",   TIMELIB_DAY,    14 },
	{ "fortnights",  TIMELIB_DAY,    14 },
	{ "forthnight",  TIMELIB_DAY,    14 },
	{ "forthnights", TIMELIB_DAY,    14 },
	{ "month",       TIMELIB_MONTH,   1 },
	{ "months",      TIMELIB_MONTH,   1 },
	{ "year",        TIMELIB_YEAR,    1 },
	{ "years",       TIMELIB_YEAR,    1 },

	{ "monday",      TIMELIB_WEEKDAY, 1 },
	{ "mon",         TIMELIB_WEEKDAY, 1 },
	{ "tuesday",     TIMELIB_WEEKDAY, 2 },
	{ "tue",         TIMELIB_WEEKDAY, 2 },
	{ "wednesday",   TIMELIB_WEEKDAY, 3 },
	{ "wed",         TIMELIB_WEEKDAY, 3 },
	{ "thursday",    TIMELIB_WEEKDAY, 4 },
	{ "thu",         TIMELIB_WEEKDAY, 4 },
	{ "friday",      TIMELIB_WEEKDAY, 5 },
	{ "fri",         TIMELIB_WEEKDAY, 5 },
	{ "saturday",    TIMELIB_WEEKDAY, 6 },
	{ "sat",         TIMELIB_WEEKDAY, 6 },
	{ "sunday",      TIMELIB_WEEKDAY, 0 },
	{ "sun",         TIMELIB_WEEKDAY, 0 },

	{ NULL,          0,          0 }
};

/* The relative text table. */
static timelib_lookup_table const timelib_reltext_lookup[] = {
	{ "first",    0,  1 },
	{ "next",     0,  1 },
	{ "second",   0,  2 },
	{ "third",    0,  3 },
	{ "fourth",   0,  4 },
	{ "fifth",    0,  5 },
	{ "sixth",    0,  6 },
	{ "seventh",  0,  7 },
	{ "eight",    0,  8 },
	{ "ninth",    0,  9 },
	{ "tenth",    0, 10 },
	{ "eleventh", 0, 11 },
	{ "twelfth",  0, 12 },
	{ "last",     0, -1 },
	{ "previous", 0, -1 },
	{ "this",     1,  0 },
	{ NULL,       1,  0 }
};

/* The month table. */
static timelib_lookup_table const timelib_month_lookup[] = {
	{ "jan",  0,  1 },
	{ "feb",  0,  2 },
	{ "mar",  0,  3 },
	{ "apr",  0,  4 },
	{ "may",  0,  5 },
	{ "jun",  0,  6 },
	{ "jul",  0,  7 },
	{ "aug",  0,  8 },
	{ "sep",  0,  9 },
	{ "sept", 0,  9 },
	{ "oct",  0, 10 },
	{ "nov",  0, 11 },
	{ "dec",  0, 12 },
	{ "i",    0,  1 },
	{ "ii",   0,  2 },
	{ "iii",  0,  3 },
	{ "iv",   0,  4 },
	{ "v",    0,  5 },
	{ "vi",   0,  6 },
	{ "vii",  0,  7 },
	{ "viii", 0,  8 },
	{ "ix",   0,  9 },
	{ "x",    0, 10 },
	{ "xi",   0, 11 },
	{ "xii",  0, 12 },

	{ "january",   0,  1 },
	{ "february",  0,  2 },
	{ "march",     0,  3 },
	{ "april",     0,  4 },
	{ "may",       0,  5 },
	{ "june",      0,  6 },
	{ "july",      0,  7 },
	{ "august",    0,  8 },
	{ "september", 0,  9 },
	{ "october",   0, 10 },
	{ "november",  0, 11 },
	{ "december",  0, 12 },
	{  NULL,       0,  0 }
};

#if 0
static char* timelib_ltrim(char *s)
{
	char *ptr = s;
	while (ptr[0] == ' ') {
		ptr++;
	}
	return ptr;
}
#endif

#if 0
uchar *fill(Scanner *s, uchar *cursor){
	if(!s->eof){
		unsigned int cnt = s->tok - s->bot;
		if(cnt){
			memcpy(s->bot, s->tok, s->lim - s->tok);
			s->tok = s->bot;
			s->ptr -= cnt;
			cursor -= cnt;
			s->pos -= cnt;
			s->lim -= cnt;
		}
		if((s->top - s->lim) < BSIZE){
			uchar *buf = (uchar*) malloc(((s->lim - s->bot) + BSIZE)*sizeof(uchar));
			memcpy(buf, s->tok, s->lim - s->tok);
			s->tok = buf;
			s->ptr = &buf[s->ptr - s->bot];
			cursor = &buf[cursor - s->bot];
			s->pos = &buf[s->pos - s->bot];
			s->lim = &buf[s->lim - s->bot];
			s->top = &s->lim[BSIZE];
			free(s->bot);
			s->bot = buf;
		}
		if((cnt = read(s->fd, (char*) s->lim, BSIZE)) != BSIZE){
			s->eof = &s->lim[cnt]; *(s->eof)++ = '\n';
		}
		s->lim += cnt;
	}
	return cursor;
}
#endif

static timelib_sll timelib_meridian(char **ptr, timelib_sll h)
{
	timelib_sll retval = 0;

	while (!strchr("AaPp", **ptr)) {
		++*ptr;
	}
	if (**ptr == 'a' || **ptr == 'A') {
		if (h == 12) {
			retval = -12;
		}
	} else if (h != 12) {
		retval = 12;
	}
	++*ptr;
	if (**ptr == '.') {
		*ptr += 3;
	} else {
		++*ptr;
	}
	return retval;
}

static char *timelib_string(Scanner *s)
{
	char *tmp = calloc(1, s->cur - s->tok + 1);
	memcpy(tmp, s->tok, s->cur - s->tok);

	return tmp;
}

static timelib_sll timelib_get_nr(char **ptr, int max_length)
{
	char *begin, *end, *str;
	timelib_sll tmp_nr = -1;
	int len = 0;

	while ((**ptr < '0') || (**ptr > '9')) {
		if (**ptr == '\0') {
			return -1;
		}
		++*ptr;
	}
	begin = *ptr;
	while ((**ptr >= '0') && (**ptr <= '9') && len < max_length) {
		++*ptr;
		++len;
	}
	end = *ptr;
	str = calloc(1, end - begin + 1);
	memcpy(str, begin, end - begin);
	tmp_nr = strtoll(str, NULL, 10);
	free(str);
	return tmp_nr;
}

static void timelib_skip_day_suffix(char **ptr)
{
	if (isspace(**ptr)) {
		return;
	}
	if (!strncasecmp(*ptr, "nd", 2) || !strncasecmp(*ptr, "rd", 2) ||!strncasecmp(*ptr, "st", 2) || !strncasecmp(*ptr, "th", 2)) {
		*ptr += 2;
	}
}

static double timelib_get_frac_nr(char **ptr, int max_length)
{
	char *begin, *end, *str;
	double tmp_nr = -1;
	int len = 0;

	while ((**ptr != '.') && ((**ptr < '0') || (**ptr > '9'))) {
		if (**ptr == '\0') {
			return -1;
		}
		++*ptr;
	}
	begin = *ptr;
	while (((**ptr == '.') || ((**ptr >= '0') && (**ptr <= '9'))) && len < max_length) {
		++*ptr;
		++len;
	}
	end = *ptr;
	str = calloc(1, end - begin + 1);
	memcpy(str, begin, end - begin);
	tmp_nr = strtod(str, NULL);
	free(str);
	return tmp_nr;
}

static timelib_ull timelib_get_unsigned_nr(char **ptr, int max_length)
{
	timelib_ull dir = 1;

	while (((**ptr < '0') || (**ptr > '9')) && (**ptr != '+') && (**ptr != '-')) {
		if (**ptr == '\0') {
			return -1;
		}
		++*ptr;
	}
	if (**ptr == '+') {
		++*ptr;
	} else if (**ptr == '-') {
		dir = -1;
		++*ptr;
	}
	return dir * timelib_get_nr(ptr, max_length);
}

static long timelib_parse_tz_cor(char **ptr)
{
	char *begin = *ptr, *end;
	long  tmp;

	while (**ptr != '\0') {
		++*ptr;
	}
	end = *ptr;
	switch (end - begin) {
		case 1:
		case 2:
			return HOUR(strtol(begin, NULL, 10));
			break;
		case 3:
		case 4:
			if (begin[1] == ':') {
				tmp = HOUR(strtol(begin, NULL, 10)) + strtol(begin + 2, NULL, 10);
				return tmp;
			} else if (begin[2] == ':') {
				tmp = HOUR(strtol(begin, NULL, 10)) + strtol(begin + 3, NULL, 10);
				return tmp;
			} else {
				tmp = strtol(begin, NULL, 10);
				return HOUR(tmp / 100) + tmp % 100;
			}
		case 5:
			tmp = HOUR(strtol(begin, NULL, 10)) + strtol(begin + 3, NULL, 10);
			return tmp;
	}
	return 0;
}

static timelib_sll timelib_lookup_relative_text(char **ptr, int *behavior)
{
	char *word;
	char *begin = *ptr, *end;
	timelib_sll  value = 0;
	const timelib_lookup_table *tp;

	while ((**ptr >= 'A' && **ptr <= 'Z') || (**ptr >= 'a' && **ptr <= 'z')) {
		++*ptr;
	}
	end = *ptr;
	word = calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_reltext_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			value = tp->value;
			*behavior = tp->type;
		}
	}

	free(word);
	return value;
}

static timelib_sll timelib_get_relative_text(char **ptr, int *behavior)
{
	while (**ptr == ' ' || **ptr == '-' || **ptr == '/') {
		++*ptr;
	}
	return timelib_lookup_relative_text(ptr, behavior);
}

static long timelib_lookup_month(char **ptr)
{
	char *word;
	char *begin = *ptr, *end;
	long  value = 0;
	const timelib_lookup_table *tp;

	while ((**ptr >= 'A' && **ptr <= 'Z') || (**ptr >= 'a' && **ptr <= 'z')) {
		++*ptr;
	}
	end = *ptr;
	word = calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_month_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			value = tp->value;
		}
	}

	free(word);
	return value;
}

static long timelib_get_month(char **ptr)
{
	while (**ptr == ' ' || **ptr == '-' || **ptr == '.' || **ptr == '/') {
		++*ptr;
	}
	return timelib_lookup_month(ptr);
}

static void timelib_eat_spaces(char **ptr)
{
	while (**ptr == ' ') {
		++*ptr;
	}
}

static const timelib_relunit* timelib_lookup_relunit(char **ptr)
{
	char *word;
	char *begin = *ptr, *end;
	const timelib_relunit *tp, *value = NULL;

	while (**ptr != '\0' && **ptr != ' ') {
		++*ptr;
	}
	end = *ptr;
	word = calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_relunit_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			value = tp;
			break;
		}
	}

	free(word);
	return value;
}

static void timelib_set_relative(char **ptr, timelib_sll amount, int behavior, Scanner *s)
{
	const timelib_relunit* relunit;

	relunit = timelib_lookup_relunit(ptr);
	switch (relunit->unit) {
		case TIMELIB_SECOND: s->time->relative.s += amount * relunit->multiplier; break;
		case TIMELIB_MINUTE: s->time->relative.i += amount * relunit->multiplier; break;
		case TIMELIB_HOUR:   s->time->relative.h += amount * relunit->multiplier; break;
		case TIMELIB_DAY:    s->time->relative.d += amount * relunit->multiplier; break;
		case TIMELIB_MONTH:  s->time->relative.m += amount * relunit->multiplier; break;
		case TIMELIB_YEAR:   s->time->relative.y += amount * relunit->multiplier; break;

		case TIMELIB_WEEKDAY:
			TIMELIB_HAVE_WEEKDAY_RELATIVE();
			TIMELIB_UNHAVE_TIME();
			s->time->relative.d += (amount > 0 ? amount - 1 : amount) * 7;
			s->time->relative.weekday = relunit->multiplier;
			s->time->relative.weekday_behavior = behavior;
			break;
	}
}

static timelib_tz_lookup_table* zone_search(const char *word, long gmtoffset, int isdst)
{
	int first_found = 0;
	timelib_tz_lookup_table  *tp, *first_found_elem;
	timelib_tz_lookup_table  *fmp;

	if (strcasecmp("utc", word) == 0 || strcasecmp("gmt", word) == 0) {
		return timelib_timezone_utc;
	}
	
	for (tp = timelib_timezone_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			if (!first_found) {
				first_found = 1;
				first_found_elem = tp;
				if (gmtoffset == -1) {
					return tp;
				}
			}
			if (tp->gmtoffset == gmtoffset) {
				return tp;
			}
		}
	}
	if (first_found) {
		return first_found_elem;
	}

	/* Still didn't find anything, let's find the zone solely based on
	 * offset/isdst then */
	for (fmp = timelib_timezone_fallbackmap; fmp->name; fmp++) {
		if ((fmp->gmtoffset * 3600) == gmtoffset && fmp->type == isdst) {
			return fmp;
		}
	}
	return NULL;
}

static long timelib_lookup_zone(char **ptr, int *dst, char **tz_abbr, int *found)
{
	char *word;
	char *begin = *ptr, *end;
	long  value = 0;
	timelib_tz_lookup_table *tp;

	while (**ptr != '\0' && **ptr != ')') {
		++*ptr;
	}
	end = *ptr;
	word = calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	if ((tp = zone_search(word, -1, 0))) {
		value = -tp->gmtoffset / 60;
		*dst = tp->type;
		value += tp->type * 60;
		*found = 1;
	} else {
		*found = 0;
	}

	*tz_abbr = word;
	return value;
}

static long timelib_get_zone(char **ptr, int *dst, timelib_time *t, int *tz_not_found, timelib_tzdb *tzdb)
{
	timelib_tzinfo *res;
	long            retval = 0;

	*tz_not_found = 0;

	while (**ptr == ' ' || **ptr == '(') {
		++*ptr;
	}
	if (**ptr == '+') {
		++*ptr;
		t->is_localtime = 1;
		t->zone_type = TIMELIB_ZONETYPE_OFFSET;
		*tz_not_found = 0;
		t->dst = 0;

		retval = -1 * timelib_parse_tz_cor(ptr);
	} else if (**ptr == '-') {
		++*ptr;
		t->is_localtime = 1;
		t->zone_type = TIMELIB_ZONETYPE_OFFSET;
		*tz_not_found = 0;
		t->dst = 0;

		retval = timelib_parse_tz_cor(ptr);
	} else {
		int found = 0;
		long offset;
		char *tz_abbr;

		t->is_localtime = 1;
		t->zone_type = TIMELIB_ZONETYPE_ABBR;

		offset = timelib_lookup_zone(ptr, dst, &tz_abbr, &found);
#if 0
		/* If we found a TimeZone identifier, use it */
		if (tz_name) {
			t->tz_info = timelib_parse_tzfile(tz_name);
			t->zone_type = TIMELIB_ZONETYPE_ID;
		}
#endif
		/* If we have a TimeZone identifier to start with, use it */
		if (strstr(tz_abbr, "/")) {
			if ((res = timelib_parse_tzfile(tz_abbr, tzdb)) != NULL) {
				t->tz_info = res;
				t->zone_type = TIMELIB_ZONETYPE_ID;
				found++;
			}
		}
		if (t->zone_type != TIMELIB_ZONETYPE_ID) {
			timelib_time_tz_abbr_update(t, tz_abbr);
		}
		free(tz_abbr);
		*tz_not_found = (found == 0);
		retval = offset;
	}
	while (**ptr == ')') {
		++*ptr;
	}
	return retval;
}

#define timelib_split_free(arg) {       \
	int i;                         \
	for (i = 0; i < arg.c; i++) {  \
		free(arg.v[i]);            \
	}                              \
	if (arg.v) {                   \
		free(arg.v);               \
	}                              \
}

static int scan(Scanner *s)
{
	uchar *cursor = s->cur;
	char *str, *ptr = NULL;
		
std:
	s->tok = cursor;
	s->len = 0;
#line 846 "real_world/parse_date.re"



#line 744 "real_world/parse_date.c"
{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	if ((YYLIMIT - YYCURSOR) < 26) YYFILL(26);
	yych = *YYCURSOR;
	switch (yych) {
	case 0x00:
	case '\n':	goto yy2;
	case ' ':	goto yy6;
	case '(':	goto yy8;
	case '+':
	case '-':	goto yy9;
	case ',':
	case '.':	goto yy10;
	case '0':	goto yy11;
	case '1':	goto yy12;
	case '2':	goto yy13;
	case '3':	goto yy14;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy15;
	case '@':	goto yy16;
	case 'A':	goto yy17;
	case 'B':
	case 'C':
	case 'G':
	case 'H':
	case 'K':
	case 'Q':
	case 'R':
	case 'U':
	case 'Z':	goto yy19;
	case 'D':	goto yy20;
	case 'E':	goto yy21;
	case 'F':	goto yy22;
	case 'I':	goto yy23;
	case 'J':	goto yy24;
	case 'L':	goto yy25;
	case 'M':	goto yy26;
	case 'N':	goto yy27;
	case 'O':	goto yy28;
	case 'P':	goto yy29;
	case 'S':	goto yy30;
	case 'T':	goto yy31;
	case 'V':	goto yy32;
	case 'W':	goto yy33;
	case 'X':	goto yy34;
	case 'Y':	goto yy35;
	case 'a':	goto yy36;
	case 'b':
	case 'c':
	case 'g':
	case 'h':
	case 'i':
	case 'k':
	case 'q':
	case 'r':
	case 'u':
	case 'v':
	case 'x':
	case 'z':	goto yy37;
	case 'd':	goto yy38;
	case 'e':	goto yy39;
	case 'f':	goto yy40;
	case 'j':	goto yy41;
	case 'l':	goto yy42;
	case 'm':	goto yy43;
	case 'n':	goto yy44;
	case 'o':	goto yy45;
	case 'p':	goto yy46;
	case 's':	goto yy47;
	case 't':	goto yy48;
	case 'w':	goto yy49;
	case 'y':	goto yy50;
	default:	goto yy4;
	}
yy2:
	++YYCURSOR;
#line 1401 "real_world/parse_date.re"
	{
		s->pos = cursor; s->line++;
		goto std;
	}
#line 831 "real_world/parse_date.c"
yy4:
	++YYCURSOR;
yy5:
#line 1407 "real_world/parse_date.re"
	{
/*		printf("unexpected character: #%d, %c ", *s->tok, *s->tok); */
		s->errors++;
		goto std;
	}
#line 841 "real_world/parse_date.c"
yy6:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':	goto yy51;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy54;
	default:	goto yy7;
	}
yy7:
#line 1396 "real_world/parse_date.re"
	{
		goto std;
	}
#line 864 "real_world/parse_date.c"
yy8:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy37;
	default:	goto yy5;
	}
yy9:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':	goto yy51;
	case '0':
	case '1':	goto yy56;
	case '2':	goto yy57;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy58;
	default:	goto yy5;
	}
yy10:
	++YYCURSOR;
	goto yy7;
yy11:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'o':
	case 'w':
	case 'y':	goto yy60;
	case '-':	goto yy63;
	case '.':	goto yy64;
	case '/':	goto yy65;
	case '0':	goto yy66;
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy67;
	case ':':	goto yy68;
	case 'n':	goto yy85;
	case 'r':	goto yy86;
	case 's':	goto yy87;
	case 't':	goto yy88;
	default:	goto yy5;
	}
yy12:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'o':
	case 'p':
	case 'w':
	case 'y':	goto yy90;
	case '-':	goto yy63;
	case '.':	goto yy91;
	case '/':	goto yy65;
	case '0':
	case '1':
	case '2':	goto yy67;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy92;
	case ':':	goto yy93;
	case 'n':	goto yy85;
	case 'r':	goto yy86;
	case 's':	goto yy87;
	case 't':	goto yy88;
	default:	goto yy5;
	}
yy13:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'o':
	case 'p':
	case 'w':
	case 'y':	goto yy90;
	case '-':	goto yy63;
	case '.':	goto yy91;
	case '/':	goto yy65;
	case '0':
	case '1':
	case '2':
	case '3':	goto yy92;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy96;
	case ':':	goto yy93;
	case 'n':	goto yy85;
	case 'r':	goto yy86;
	case 's':	goto yy87;
	case 't':	goto yy88;
	default:	goto yy5;
	}
yy14:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'o':
	case 'p':
	case 'w':
	case 'y':	goto yy90;
	case '-':	goto yy63;
	case '.':	goto yy91;
	case '/':	goto yy65;
	case '0':
	case '1':	goto yy96;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy97;
	case ':':	goto yy93;
	case 'n':	goto yy85;
	case 'r':	goto yy86;
	case 's':	goto yy87;
	case 't':	goto yy88;
	default:	goto yy5;
	}
yy15:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'o':
	case 'p':
	case 'w':
	case 'y':	goto yy90;
	case '-':	goto yy63;
	case '.':	goto yy91;
	case '/':	goto yy65;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy97;
	case ':':	goto yy93;
	case 'n':	goto yy85;
	case 'r':	goto yy86;
	case 's':	goto yy87;
	case 't':	goto yy88;
	default:	goto yy5;
	}
yy16:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '-':	goto yy98;
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy99;
	default:	goto yy5;
	}
yy17:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy102;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy103;
	case 'G':	goto yy104;
	case 'P':	goto yy105;
	case 'U':	goto yy106;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy107;
	case 'g':	goto yy108;
	case 'p':	goto yy109;
	case 'u':	goto yy110;
	default:	goto yy18;
	}
yy18:
#line 1341 "real_world/parse_date.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("tzcorrection | tz");
		TIMELIB_INIT;
		s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
		s->errors += tz_not_found;
		TIMELIB_DEINIT;
		return TIMELIB_TIMEZONE;
	}
#line 1340 "real_world/parse_date.c"
yy19:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy102;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy103;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy107;
	default:	goto yy18;
	}
yy20:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy102;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy103;
	case 'E':	goto yy111;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy107;
	case 'e':	goto yy112;
	default:	goto yy18;
	}
yy21:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy102;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'J':
	case 'K':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy103;
	case 'I':	goto yy113;
	case 'L':	goto yy114;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'j':
	case 'k':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy107;
	case 'i':	goto yy115;
	case 'l':	goto yy116;
	default:	goto yy18;
	}
yy22:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy102;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy103;
	case 'E':	goto yy117;
	case 'I':	goto yy118;
	case 'O':	goto yy119;
	case 'R':	goto yy120;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy107;
	case 'e':	goto yy121;
	case 'i':	goto yy122;
	case 'o':	goto yy123;
	case 'r':	goto yy124;
	default:	goto yy18;
	}
yy23:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy126;
	case ')':	goto yy127;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'W':
	case 'Y':
	case 'Z':	goto yy103;
	case 'I':	goto yy132;
	case 'V':
	case 'X':	goto yy133;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy107;
	default:	goto yy18;
	}
yy24:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy102;
	case 'A':	goto yy134;
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy103;
	case 'U':	goto yy135;
	case 'a':	goto yy136;
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy107;
	case 'u':	goto yy137;
	default:	goto yy18;
	}
yy25:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy102;
	case 'A':	goto yy138;
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy103;
	case 'a':	goto yy139;
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy107;
	default:	goto yy18;
	}
yy26:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy102;
	case 'A':	goto yy140;
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy103;
	case 'I':	goto yy141;
	case 'O':	goto yy142;
	case 'a':	goto yy143;
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy107;
	case 'i':	goto yy144;
	case 'o':	goto yy145;
	default:	goto yy18;
	}
yy27:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy102;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy103;
	case 'E':	goto yy146;
	case 'I':	goto yy147;
	case 'O':	goto yy148;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy107;
	case 'e':	goto yy149;
	case 'i':	goto yy150;
	case 'o':	goto yy151;
	default:	goto yy18;
	}
yy28:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy102;
	case 'A':
	case 'B':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy103;
	case 'C':	goto yy152;
	case 'a':
	case 'b':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy107;
	case 'c':	goto yy153;
	default:	goto yy18;
	}
yy29:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy102;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy103;
	case 'R':	goto yy154;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy107;
	case 'r':	goto yy155;
	default:	goto yy18;
	}
yy30:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy102;
	case 'A':	goto yy156;
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy103;
	case 'E':	goto yy157;
	case 'I':	goto yy158;
	case 'U':	goto yy142;
	case 'a':	goto yy159;
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy107;
	case 'e':	goto yy160;
	case 'i':	goto yy161;
	case 'u':	goto yy145;
	default:	goto yy18;
	}
yy31:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy102;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'X':
	case 'Y':
	case 'Z':	goto yy103;
	case 'E':	goto yy147;
	case 'H':	goto yy162;
	case 'O':	goto yy163;
	case 'U':	goto yy164;
	case 'W':	goto yy165;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'x':
	case 'y':
	case 'z':	goto yy107;
	case 'e':	goto yy150;
	case 'h':	goto yy166;
	case 'o':	goto yy167;
	case 'u':	goto yy168;
	case 'w':	goto yy169;
	default:	goto yy18;
	}
yy32:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy126;
	case ')':	goto yy127;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy103;
	case 'I':	goto yy170;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy107;
	default:	goto yy18;
	}
yy33:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy102;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy103;
	case 'E':	goto yy171;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy107;
	case 'e':	goto yy172;
	default:	goto yy18;
	}
yy34:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy126;
	case ')':	goto yy127;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy103;
	case 'I':	goto yy132;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy107;
	default:	goto yy18;
	}
yy35:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy102;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy103;
	case 'E':	goto yy173;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy107;
	case 'e':	goto yy174;
	default:	goto yy18;
	}
yy36:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy102;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy103;
	case 'G':
	case 'g':	goto yy104;
	case 'P':
	case 'p':	goto yy105;
	case 'U':
	case 'u':	goto yy106;
	default:	goto yy18;
	}
yy37:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy102;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy103;
	default:	goto yy18;
	}
yy38:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy102;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy103;
	case 'E':
	case 'e':	goto yy111;
	default:	goto yy18;
	}
yy39:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy102;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'J':
	case 'K':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'j':
	case 'k':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy103;
	case 'I':
	case 'i':	goto yy113;
	case 'L':
	case 'l':	goto yy114;
	default:	goto yy18;
	}
yy40:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy102;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy103;
	case 'E':
	case 'e':	goto yy117;
	case 'I':
	case 'i':	goto yy118;
	case 'O':
	case 'o':	goto yy119;
	case 'R':
	case 'r':	goto yy120;
	default:	goto yy18;
	}
yy41:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy102;
	case 'A':
	case 'a':	goto yy134;
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy103;
	case 'U':
	case 'u':	goto yy135;
	default:	goto yy18;
	}
yy42:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy102;
	case 'A':
	case 'a':	goto yy138;
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy103;
	default:	goto yy18;
	}
yy43:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy102;
	case 'A':
	case 'a':	goto yy140;
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy103;
	case 'I':
	case 'i':	goto yy141;
	case 'O':
	case 'o':	goto yy142;
	default:	goto yy18;
	}
yy44:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy102;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy103;
	case 'E':
	case 'e':	goto yy146;
	case 'I':
	case 'i':	goto yy147;
	case 'O':
	case 'o':	goto yy148;
	default:	goto yy18;
	}
yy45:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy102;
	case 'A':
	case 'B':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy103;
	case 'C':
	case 'c':	goto yy152;
	default:	goto yy18;
	}
yy46:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy102;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy103;
	case 'R':
	case 'r':	goto yy154;
	default:	goto yy18;
	}
yy47:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy102;
	case 'A':
	case 'a':	goto yy156;
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy103;
	case 'E':
	case 'e':	goto yy157;
	case 'I':
	case 'i':	goto yy158;
	case 'U':
	case 'u':	goto yy142;
	default:	goto yy18;
	}
yy48:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy102;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'x':
	case 'y':
	case 'z':	goto yy103;
	case 'E':
	case 'e':	goto yy147;
	case 'H':
	case 'h':	goto yy162;
	case 'O':
	case 'o':	goto yy163;
	case 'U':
	case 'u':	goto yy164;
	case 'W':
	case 'w':	goto yy165;
	default:	goto yy18;
	}
yy49:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy102;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy103;
	case 'E':
	case 'e':	goto yy171;
	default:	goto yy18;
	}
yy50:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy102;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy103;
	case 'E':
	case 'e':	goto yy173;
	default:	goto yy18;
	}
yy51:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	switch (yych) {
	case ' ':	goto yy51;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy54;
	default:	goto yy53;
	}
yy53:
	YYCURSOR = YYMARKER;
	switch (yyaccept) {
	case 0:
		goto yy7;
	case 1:
		goto yy5;
	case 2:
		goto yy18;
	case 3:
		goto yy74;
	case 4:
		goto yy192;
	case 5:
		goto yy197;
	case 6:
		goto yy256;
	case 7:
		goto yy275;
	case 8:
		goto yy129;
	case 9:
		goto yy304;
	case 10:
		goto yy357;
	case 11:
		goto yy359;
	case 12:
		goto yy363;
	case 13:
		goto yy443;
	case 14:
		goto yy474;
	case 15:
		goto yy583;
	case 16:
		goto yy586;
	case 17:
		goto yy622;
	case 18:
		goto yy663;
	case 19:
		goto yy775;
	case 20:
		goto yy505;
	case 21:
		goto yy803;
	case 22:
		goto yy855;
	case 23:
		goto yy860;
	case 24:
		goto yy900;
	case 25:
		goto yy947;
	default:
		goto yy1020;
	}
yy54:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
	yych = *YYCURSOR;
	switch (yych) {
	case ' ':	goto yy175;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy54;
	case 'D':
	case 'd':	goto yy177;
	case 'F':
	case 'f':	goto yy178;
	case 'H':
	case 'h':	goto yy72;
	case 'M':
	case 'm':	goto yy179;
	case 'S':
	case 's':	goto yy180;
	case 'T':
	case 't':	goto yy80;
	case 'W':
	case 'w':	goto yy82;
	case 'Y':
	case 'y':	goto yy84;
	default:	goto yy53;
	}
yy56:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case 'D':
	case 'F':
	case 'H':
	case 'M':
	case 'S':
	case 'T':
	case 'W':
	case 'Y':
	case 'd':
	case 'f':
	case 'h':
	case 'm':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy176;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy58;
	case ':':	goto yy181;
	default:	goto yy18;
	}
yy57:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case 'D':
	case 'F':
	case 'H':
	case 'M':
	case 'S':
	case 'T':
	case 'W':
	case 'Y':
	case 'd':
	case 'f':
	case 'h':
	case 'm':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy176;
	case '0':
	case '1':
	case '2':
	case '3':	goto yy58;
	case '4':
	case '5':	goto yy182;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy183;
	case ':':	goto yy181;
	default:	goto yy18;
	}
yy58:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case 'D':
	case 'F':
	case 'H':
	case 'M':
	case 'S':
	case 'T':
	case 'W':
	case 'Y':
	case 'd':
	case 'f':
	case 'h':
	case 'm':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy176;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy182;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy183;
	case ':':	goto yy181;
	default:	goto yy18;
	}
yy59:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
yy60:
	switch (yych) {
	case ' ':	goto yy59;
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':	goto yy61;
	case 'A':
	case 'a':	goto yy69;
	case 'D':
	case 'd':	goto yy70;
	case 'F':
	case 'f':	goto yy71;
	case 'H':
	case 'h':	goto yy72;
	case 'I':	goto yy73;
	case 'J':
	case 'j':	goto yy75;
	case 'M':
	case 'm':	goto yy76;
	case 'N':
	case 'n':	goto yy77;
	case 'O':
	case 'o':	goto yy78;
	case 'S':
	case 's':	goto yy79;
	case 'T':
	case 't':	goto yy80;
	case 'V':	goto yy81;
	case 'W':
	case 'w':	goto yy82;
	case 'X':	goto yy83;
	case 'Y':
	case 'y':	goto yy84;
	default:	goto yy53;
	}
yy61:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
yy62:
	switch (yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':	goto yy61;
	case 'A':
	case 'a':	goto yy69;
	case 'D':
	case 'd':	goto yy184;
	case 'F':
	case 'f':	goto yy185;
	case 'I':	goto yy73;
	case 'J':
	case 'j':	goto yy75;
	case 'M':
	case 'm':	goto yy186;
	case 'N':
	case 'n':	goto yy77;
	case 'O':
	case 'o':	goto yy78;
	case 'S':
	case 's':	goto yy187;
	case 'V':	goto yy81;
	case 'X':	goto yy83;
	default:	goto yy53;
	}
yy63:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy188;
	case '1':	goto yy189;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy190;
	default:	goto yy62;
	}
yy64:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy191;
	case '1':	goto yy193;
	case '2':
	case '3':
	case '4':
	case '5':	goto yy194;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy195;
	default:	goto yy62;
	}
yy65:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':	goto yy196;
	case '3':	goto yy198;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy199;
	case 'A':
	case 'a':	goto yy200;
	case 'D':
	case 'd':	goto yy201;
	case 'F':
	case 'f':	goto yy202;
	case 'J':
	case 'j':	goto yy203;
	case 'M':
	case 'm':	goto yy204;
	case 'N':
	case 'n':	goto yy205;
	case 'O':
	case 'o':	goto yy206;
	case 'S':
	case 's':	goto yy207;
	default:	goto yy53;
	}
yy66:
	yych = *++YYCURSOR;
	switch (yych) {
	case '-':	goto yy63;
	case '.':	goto yy64;
	case '/':	goto yy65;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy208;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy209;
	case ':':	goto yy68;
	case 'n':	goto yy85;
	case 'r':	goto yy86;
	case 's':	goto yy87;
	case 't':	goto yy88;
	default:	goto yy60;
	}
yy67:
	yych = *++YYCURSOR;
	switch (yych) {
	case '-':	goto yy63;
	case '.':	goto yy91;
	case '/':	goto yy65;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy208;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy209;
	case ':':	goto yy93;
	case 'n':	goto yy85;
	case 'r':	goto yy86;
	case 's':	goto yy87;
	case 't':	goto yy88;
	default:	goto yy90;
	}
yy68:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy210;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy211;
	default:	goto yy53;
	}
yy69:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'P':
	case 'p':	goto yy212;
	case 'U':
	case 'u':	goto yy213;
	default:	goto yy53;
	}
yy70:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy214;
	case 'E':
	case 'e':	goto yy215;
	default:	goto yy53;
	}
yy71:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'E':
	case 'e':	goto yy216;
	case 'O':
	case 'o':	goto yy217;
	case 'R':
	case 'r':	goto yy218;
	default:	goto yy53;
	}
yy72:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'O':
	case 'o':	goto yy219;
	default:	goto yy53;
	}
yy73:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':	goto yy220;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy222;
	case 'I':	goto yy224;
	case 'V':
	case 'X':	goto yy225;
	default:	goto yy74;
	}
yy74:
#line 1140 "real_world/parse_date.re"
	{
		DEBUG_OUTPUT("datenoyearrev");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		timelib_skip_day_suffix((char **) &ptr);
		s->time->m = timelib_get_month((char **) &ptr);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_TEXT;
	}
#line 3780 "real_world/parse_date.c"
yy75:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy226;
	case 'U':
	case 'u':	goto yy227;
	default:	goto yy53;
	}
yy76:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy228;
	case 'I':
	case 'i':	goto yy229;
	case 'O':
	case 'o':	goto yy230;
	default:	goto yy53;
	}
yy77:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'O':
	case 'o':	goto yy231;
	default:	goto yy53;
	}
yy78:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'C':
	case 'c':	goto yy232;
	default:	goto yy53;
	}
yy79:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy233;
	case 'E':
	case 'e':	goto yy234;
	case 'U':
	case 'u':	goto yy235;
	default:	goto yy53;
	}
yy80:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'H':
	case 'h':	goto yy236;
	case 'U':
	case 'u':	goto yy237;
	default:	goto yy53;
	}
yy81:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':	goto yy220;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy222;
	case 'I':	goto yy83;
	default:	goto yy74;
	}
yy82:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'E':
	case 'e':	goto yy238;
	default:	goto yy53;
	}
yy83:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':	goto yy220;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy222;
	case 'I':	goto yy224;
	default:	goto yy74;
	}
yy84:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'E':
	case 'e':	goto yy239;
	default:	goto yy53;
	}
yy85:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'O':
	case 'o':	goto yy231;
	case 'd':	goto yy240;
	default:	goto yy53;
	}
yy86:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'd':	goto yy240;
	default:	goto yy53;
	}
yy87:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy233;
	case 'E':
	case 'e':	goto yy234;
	case 'U':
	case 'u':	goto yy235;
	case 't':	goto yy240;
	default:	goto yy53;
	}
yy88:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'H':	goto yy236;
	case 'U':
	case 'u':	goto yy237;
	case 'h':	goto yy241;
	default:	goto yy53;
	}
yy89:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
yy90:
	switch (yych) {
	case ' ':	goto yy89;
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':	goto yy61;
	case 'A':
	case 'a':	goto yy94;
	case 'D':
	case 'd':	goto yy70;
	case 'F':
	case 'f':	goto yy71;
	case 'H':
	case 'h':	goto yy72;
	case 'I':	goto yy73;
	case 'J':
	case 'j':	goto yy75;
	case 'M':
	case 'm':	goto yy76;
	case 'N':
	case 'n':	goto yy77;
	case 'O':
	case 'o':	goto yy78;
	case 'P':
	case 'p':	goto yy95;
	case 'S':
	case 's':	goto yy79;
	case 'T':
	case 't':	goto yy80;
	case 'V':	goto yy81;
	case 'W':
	case 'w':	goto yy82;
	case 'X':	goto yy83;
	case 'Y':
	case 'y':	goto yy84;
	default:	goto yy53;
	}
yy91:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy242;
	case '1':	goto yy243;
	case '2':
	case '3':
	case '4':
	case '5':	goto yy244;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy245;
	default:	goto yy62;
	}
yy92:
	yych = *++YYCURSOR;
	switch (yych) {
	case '-':	goto yy63;
	case '.':	goto yy64;
	case '/':	goto yy246;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy208;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy209;
	case ':':	goto yy68;
	case 'n':	goto yy85;
	case 'r':	goto yy86;
	case 's':	goto yy87;
	case 't':	goto yy88;
	default:	goto yy60;
	}
yy93:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy247;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy248;
	default:	goto yy53;
	}
yy94:
	yych = *++YYCURSOR;
	switch (yych) {
	case '.':	goto yy249;
	case 'M':
	case 'm':	goto yy250;
	case 'P':
	case 'p':	goto yy212;
	case 'U':
	case 'u':	goto yy213;
	default:	goto yy53;
	}
yy95:
	yych = *++YYCURSOR;
	switch (yych) {
	case '.':	goto yy249;
	case 'M':
	case 'm':	goto yy250;
	default:	goto yy53;
	}
yy96:
	yych = *++YYCURSOR;
	switch (yych) {
	case '-':	goto yy63;
	case '.':	goto yy252;
	case '/':	goto yy246;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy209;
	case 'n':	goto yy85;
	case 'r':	goto yy86;
	case 's':	goto yy87;
	case 't':	goto yy88;
	default:	goto yy60;
	}
yy97:
	yych = *++YYCURSOR;
	switch (yych) {
	case '-':	goto yy253;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy209;
	default:	goto yy176;
	}
yy98:
	yych = *++YYCURSOR;
	switch (yych) {
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy99;
	default:	goto yy53;
	}
yy99:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy99;
	default:	goto yy101;
	}
yy101:
#line 906 "real_world/parse_date.re"
	{
		timelib_ull i;

		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_DATE();
		TIMELIB_UNHAVE_TIME();

		i = timelib_get_unsigned_nr((char **) &ptr, 24);
		s->time->y = 1970;
		s->time->m = 1;
		s->time->d = 1;
		s->time->h = s->time->i = s->time->s = 0;
		s->time->f = 0.0;
		s->time->relative.s += i;
		s->time->is_localtime = 1;
		s->time->zone_type = TIMELIB_ZONETYPE_OFFSET;
		s->time->z = 0;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 4166 "real_world/parse_date.c"
yy102:
	++YYCURSOR;
	goto yy18;
yy103:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy102;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy254;
	default:	goto yy18;
	}
yy104:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy102;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy254;
	case 'O':
	case 'o':	goto yy255;
	default:	goto yy18;
	}
yy105:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy102;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy254;
	case 'R':
	case 'r':	goto yy257;
	default:	goto yy18;
	}
yy106:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy102;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy254;
	case 'G':
	case 'g':	goto yy258;
	default:	goto yy18;
	}
yy107:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case '/':
	case '_':	goto yy259;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy254;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy260;
	default:	goto yy18;
	}
yy108:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case '/':
	case '_':	goto yy259;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy254;
	case 'O':	goto yy255;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy260;
	case 'o':	goto yy261;
	default:	goto yy18;
	}
yy109:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case '/':
	case '_':	goto yy259;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy254;
	case 'R':	goto yy257;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy260;
	case 'r':	goto yy262;
	default:	goto yy18;
	}
yy110:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case '/':
	case '_':	goto yy259;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy254;
	case 'G':	goto yy258;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy260;
	case 'g':	goto yy263;
	default:	goto yy18;
	}
yy111:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy102;
	case 'A':
	case 'B':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy254;
	case 'C':
	case 'c':	goto yy264;
	default:	goto yy18;
	}
yy112:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case '/':
	case '_':	goto yy259;
	case 'A':
	case 'B':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy254;
	case 'C':	goto yy264;
	case 'a':
	case 'b':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy260;
	case 'c':	goto yy265;
	default:	goto yy18;
	}
yy113:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy102;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy254;
	case 'G':
	case 'g':	goto yy266;
	default:	goto yy18;
	}
yy114:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy102;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy254;
	case 'E':
	case 'e':	goto yy267;
	default:	goto yy18;
	}
yy115:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case '/':
	case '_':	goto yy259;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy254;
	case 'G':	goto yy266;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy260;
	case 'g':	goto yy268;
	default:	goto yy18;
	}
yy116:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case '/':
	case '_':	goto yy259;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy254;
	case 'E':	goto yy267;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy260;
	case 'e':	goto yy269;
	default:	goto yy18;
	}
yy117:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy102;
	case 'A':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy254;
	case 'B':
	case 'b':	goto yy270;
	default:	goto yy18;
	}
yy118:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy102;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy254;
	case 'F':
	case 'f':	goto yy271;
	case 'R':
	case 'r':	goto yy272;
	default:	goto yy18;
	}
yy119:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy102;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy254;
	case 'U':
	case 'u':	goto yy273;
	default:	goto yy18;
	}
yy120:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy102;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy254;
	case 'I':
	case 'i':	goto yy274;
	default:	goto yy18;
	}
yy121:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case '/':
	case '_':	goto yy259;
	case 'A':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy254;
	case 'B':	goto yy270;
	case 'a':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy260;
	case 'b':	goto yy276;
	default:	goto yy18;
	}
yy122:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case '/':
	case '_':	goto yy259;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy254;
	case 'F':	goto yy271;
	case 'R':	goto yy272;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy260;
	case 'f':	goto yy277;
	case 'r':	goto yy278;
	default:	goto yy18;
	}
yy123:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case '/':
	case '_':	goto yy259;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy254;
	case 'U':	goto yy273;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy260;
	case 'u':	goto yy279;
	default:	goto yy18;
	}
yy124:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case '/':
	case '_':	goto yy259;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy254;
	case 'I':	goto yy274;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy260;
	case 'i':	goto yy280;
	default:	goto yy18;
	}
yy125:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 17) YYFILL(17);
	yych = *YYCURSOR;
yy126:
	switch (yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':	goto yy125;
	case '0':
	case '1':
	case '2':	goto yy128;
	case '3':	goto yy130;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy131;
	default:	goto yy53;
	}
yy127:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy126;
	default:	goto yy18;
	}
yy128:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy283;
	default:	goto yy282;
	}
yy129:
#line 1127 "real_world/parse_date.re"
	{
		DEBUG_OUTPUT("datetextual | datenoyear");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_TEXT;
	}
#line 5571 "real_world/parse_date.c"
yy130:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':	goto yy283;
	case '2':	goto yy284;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy285;
	default:	goto yy282;
	}
yy131:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':	goto yy286;
	case '2':	goto yy284;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy285;
	default:	goto yy282;
	}
yy132:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy126;
	case ')':	goto yy127;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy254;
	case 'I':	goto yy287;
	default:	goto yy18;
	}
yy133:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy126;
	case ')':	goto yy127;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy254;
	default:	goto yy18;
	}
yy134:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy102;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy254;
	case 'N':
	case 'n':	goto yy288;
	default:	goto yy18;
	}
yy135:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy102;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'M':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'm':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy254;
	case 'L':
	case 'l':	goto yy289;
	case 'N':
	case 'n':	goto yy290;
	default:	goto yy18;
	}
yy136:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case '/':
	case '_':	goto yy259;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy254;
	case 'N':	goto yy288;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy260;
	case 'n':	goto yy291;
	default:	goto yy18;
	}
yy137:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case '/':
	case '_':	goto yy259;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'M':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy254;
	case 'L':	goto yy289;
	case 'N':	goto yy290;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'm':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy260;
	case 'l':	goto yy292;
	case 'n':	goto yy293;
	default:	goto yy18;
	}
yy138:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy102;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy254;
	case 'S':
	case 's':	goto yy294;
	default:	goto yy18;
	}
yy139:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case '/':
	case '_':	goto yy259;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy254;
	case 'S':	goto yy294;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy260;
	case 's':	goto yy295;
	default:	goto yy18;
	}
yy140:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy102;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'z':	goto yy254;
	case 'R':
	case 'r':	goto yy296;
	case 'Y':
	case 'y':	goto yy297;
	default:	goto yy18;
	}
yy141:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy102;
	case 'A':
	case 'B':
	case 'C':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy254;
	case 'D':
	case 'd':	goto yy298;
	default:	goto yy18;
	}
yy142:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy102;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy254;
	case 'N':
	case 'n':	goto yy274;
	default:	goto yy18;
	}
yy143:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case '/':
	case '_':	goto yy259;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Z':	goto yy254;
	case 'R':	goto yy296;
	case 'Y':	goto yy297;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'z':	goto yy260;
	case 'r':	goto yy299;
	case 'y':	goto yy300;
	default:	goto yy18;
	}
yy144:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case '/':
	case '_':	goto yy259;
	case 'A':
	case 'B':
	case 'C':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy254;
	case 'D':	goto yy298;
	case 'a':
	case 'b':
	case 'c':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy260;
	case 'd':	goto yy301;
	default:	goto yy18;
	}
yy145:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case '/':
	case '_':	goto yy259;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy254;
	case 'N':	goto yy274;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy260;
	case 'n':	goto yy280;
	default:	goto yy18;
	}
yy146:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy102;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'y':
	case 'z':	goto yy254;
	case 'X':
	case 'x':	goto yy294;
	default:	goto yy18;
	}
yy147:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy102;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy254;
	case 'N':
	case 'n':	goto yy271;
	default:	goto yy18;
	}
yy148:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy102;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'x':
	case 'y':
	case 'z':	goto yy254;
	case 'O':
	case 'o':	goto yy302;
	case 'V':
	case 'v':	goto yy264;
	case 'W':
	case 'w':	goto yy303;
	default:	goto yy18;
	}
yy149:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case '/':
	case '_':	goto yy259;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'Y':
	case 'Z':	goto yy254;
	case 'X':	goto yy294;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'y':
	case 'z':	goto yy260;
	case 'x':	goto yy295;
	default:	goto yy18;
	}
yy150:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case '/':
	case '_':	goto yy259;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy254;
	case 'N':	goto yy271;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy260;
	case 'n':	goto yy277;
	default:	goto yy18;
	}
yy151:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case '/':
	case '_':	goto yy259;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'X':
	case 'Y':
	case 'Z':	goto yy254;
	case 'O':	goto yy302;
	case 'V':	goto yy264;
	case 'W':	goto yy303;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'x':
	case 'y':
	case 'z':	goto yy260;
	case 'o':	goto yy305;
	case 'v':	goto yy265;
	case 'w':	goto yy306;
	default:	goto yy18;
	}
yy152:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy102;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy254;
	case 'T':
	case 't':	goto yy307;
	default:	goto yy18;
	}
yy153:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case '/':
	case '_':	goto yy259;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy254;
	case 'T':	goto yy307;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy260;
	case 't':	goto yy308;
	default:	goto yy18;
	}
yy154:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy102;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy254;
	case 'E':
	case 'e':	goto yy309;
	default:	goto yy18;
	}
yy155:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case '/':
	case '_':	goto yy259;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy254;
	case 'E':	goto yy309;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy260;
	case 'e':	goto yy310;
	default:	goto yy18;
	}
yy156:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy102;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy254;
	case 'T':
	case 't':	goto yy311;
	default:	goto yy18;
	}
yy157:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy102;
	case 'A':
	case 'B':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy254;
	case 'C':
	case 'c':	goto yy312;
	case 'P':
	case 'p':	goto yy313;
	case 'V':
	case 'v':	goto yy314;
	default:	goto yy18;
	}
yy158:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy102;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'y':
	case 'z':	goto yy254;
	case 'X':
	case 'x':	goto yy271;
	default:	goto yy18;
	}
yy159:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case '/':
	case '_':	goto yy259;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy254;
	case 'T':	goto yy311;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy260;
	case 't':	goto yy315;
	default:	goto yy18;
	}
yy160:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case '/':
	case '_':	goto yy259;
	case 'A':
	case 'B':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy254;
	case 'C':	goto yy312;
	case 'P':	goto yy313;
	case 'V':	goto yy314;
	case 'a':
	case 'b':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy260;
	case 'c':	goto yy316;
	case 'p':	goto yy317;
	case 'v':	goto yy318;
	default:	goto yy18;
	}
yy161:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case '/':
	case '_':	goto yy259;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'Y':
	case 'Z':	goto yy254;
	case 'X':	goto yy271;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'y':
	case 'z':	goto yy260;
	case 'x':	goto yy277;
	default:	goto yy18;
	}
yy162:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy102;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy254;
	case 'I':
	case 'i':	goto yy319;
	case 'U':
	case 'u':	goto yy320;
	default:	goto yy18;
	}
yy163:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy102;
	case 'A':
	case 'B':
	case 'C':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy254;
	case 'D':
	case 'd':	goto yy321;
	case 'M':
	case 'm':	goto yy322;
	default:	goto yy18;
	}
yy164:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy102;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy254;
	case 'E':
	case 'e':	goto yy323;
	default:	goto yy18;
	}
yy165:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy102;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy254;
	case 'E':
	case 'e':	goto yy324;
	default:	goto yy18;
	}
yy166:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case '/':
	case '_':	goto yy259;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy254;
	case 'I':	goto yy319;
	case 'U':	goto yy320;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy260;
	case 'i':	goto yy325;
	case 'u':	goto yy326;
	default:	goto yy18;
	}
yy167:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case '/':
	case '_':	goto yy259;
	case 'A':
	case 'B':
	case 'C':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy254;
	case 'D':	goto yy321;
	case 'M':	goto yy322;
	case 'a':
	case 'b':
	case 'c':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy260;
	case 'd':	goto yy327;
	case 'm':	goto yy328;
	default:	goto yy18;
	}
yy168:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case '/':
	case '_':	goto yy259;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy254;
	case 'E':	goto yy323;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy260;
	case 'e':	goto yy329;
	default:	goto yy18;
	}
yy169:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case '/':
	case '_':	goto yy259;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy254;
	case 'E':	goto yy324;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy260;
	case 'e':	goto yy330;
	default:	goto yy18;
	}
yy170:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy126;
	case ')':	goto yy127;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy254;
	case 'I':	goto yy331;
	default:	goto yy18;
	}
yy171:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy102;
	case 'A':
	case 'B':
	case 'C':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy254;
	case 'D':
	case 'd':	goto yy332;
	default:	goto yy18;
	}
yy172:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case '/':
	case '_':	goto yy259;
	case 'A':
	case 'B':
	case 'C':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy254;
	case 'D':	goto yy332;
	case 'a':
	case 'b':
	case 'c':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy260;
	case 'd':	goto yy333;
	default:	goto yy18;
	}
yy173:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy102;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy254;
	case 'S':
	case 's':	goto yy334;
	default:	goto yy18;
	}
yy174:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case '/':
	case '_':	goto yy259;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy254;
	case 'S':	goto yy334;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy260;
	case 's':	goto yy335;
	default:	goto yy18;
	}
yy175:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
	yych = *YYCURSOR;
yy176:
	switch (yych) {
	case ' ':	goto yy175;
	case 'D':
	case 'd':	goto yy177;
	case 'F':
	case 'f':	goto yy178;
	case 'H':
	case 'h':	goto yy72;
	case 'M':
	case 'm':	goto yy179;
	case 'S':
	case 's':	goto yy180;
	case 'T':
	case 't':	goto yy80;
	case 'W':
	case 'w':	goto yy82;
	case 'Y':
	case 'y':	goto yy84;
	default:	goto yy53;
	}
yy177:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy214;
	default:	goto yy53;
	}
yy178:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'O':
	case 'o':	goto yy217;
	case 'R':
	case 'r':	goto yy218;
	default:	goto yy53;
	}
yy179:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'I':
	case 'i':	goto yy229;
	case 'O':
	case 'o':	goto yy230;
	default:	goto yy53;
	}
yy180:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy233;
	case 'E':
	case 'e':	goto yy336;
	case 'U':
	case 'u':	goto yy235;
	default:	goto yy53;
	}
yy181:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy337;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy102;
	default:	goto yy18;
	}
yy182:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case 'D':
	case 'F':
	case 'H':
	case 'M':
	case 'S':
	case 'T':
	case 'W':
	case 'Y':
	case 'd':
	case 'f':
	case 'h':
	case 'm':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy176;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy183;
	default:	goto yy18;
	}
yy183:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case 'D':
	case 'F':
	case 'H':
	case 'M':
	case 'S':
	case 'T':
	case 'W':
	case 'Y':
	case 'd':
	case 'f':
	case 'h':
	case 'm':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy176;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy54;
	default:	goto yy18;
	}
yy184:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'E':
	case 'e':	goto yy215;
	default:	goto yy53;
	}
yy185:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'E':
	case 'e':	goto yy216;
	default:	goto yy53;
	}
yy186:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy228;
	default:	goto yy53;
	}
yy187:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'E':
	case 'e':	goto yy338;
	default:	goto yy53;
	}
yy188:
	yych = *++YYCURSOR;
	switch (yych) {
	case '-':	goto yy339;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy190;
	default:	goto yy53;
	}
yy189:
	yych = *++YYCURSOR;
	switch (yych) {
	case '-':	goto yy339;
	case '0':
	case '1':
	case '2':	goto yy190;
	default:	goto yy53;
	}
yy190:
	yych = *++YYCURSOR;
	switch (yych) {
	case '-':	goto yy339;
	default:	goto yy53;
	}
yy191:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':	goto yy340;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy195;
	case ':':	goto yy341;
	default:	goto yy192;
	}
yy192:
#line 947 "real_world/parse_date.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("timeshort24 | timelong24 | iso8601long");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->s = timelib_get_nr((char **) &ptr, 2);

			if (*ptr == '.') {
				s->time->f = timelib_get_frac_nr((char **) &ptr, 8);
			}
		}

		if (*ptr != '\0') {
			s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
			s->errors += tz_not_found;
		}
		TIMELIB_DEINIT;
		return TIMELIB_TIME24_WITH_ZONE;
	}
#line 8474 "real_world/parse_date.c"
yy193:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':	goto yy340;
	case '0':
	case '1':
	case '2':	goto yy195;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy211;
	case ':':	goto yy341;
	default:	goto yy192;
	}
yy194:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':	goto yy340;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy211;
	case ':':	goto yy341;
	default:	goto yy192;
	}
yy195:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':	goto yy340;
	case ':':	goto yy341;
	default:	goto yy192;
	}
yy196:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '/':	goto yy342;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy199;
	case 'n':
	case 'r':	goto yy343;
	case 's':	goto yy344;
	case 't':	goto yy345;
	default:	goto yy197;
	}
yy197:
#line 1034 "real_world/parse_date.re"
	{
		DEBUG_OUTPUT("americanshort | american");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == '/') {
			s->time->y = timelib_get_nr((char **) &ptr, 4);
			TIMELIB_PROCESS_YEAR(s->time->y);
		}
		TIMELIB_DEINIT;
		return TIMELIB_AMERICAN;
	}
#line 8555 "real_world/parse_date.c"
yy198:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '/':	goto yy342;
	case '0':
	case '1':	goto yy199;
	case 'n':
	case 'r':	goto yy343;
	case 's':	goto yy344;
	case 't':	goto yy345;
	default:	goto yy197;
	}
yy199:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '/':	goto yy342;
	case 'n':
	case 'r':	goto yy343;
	case 's':	goto yy344;
	case 't':	goto yy345;
	default:	goto yy197;
	}
yy200:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'P':
	case 'p':	goto yy346;
	case 'U':
	case 'u':	goto yy347;
	default:	goto yy53;
	}
yy201:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'E':
	case 'e':	goto yy348;
	default:	goto yy53;
	}
yy202:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'E':
	case 'e':	goto yy349;
	default:	goto yy53;
	}
yy203:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy350;
	case 'U':
	case 'u':	goto yy351;
	default:	goto yy53;
	}
yy204:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy352;
	default:	goto yy53;
	}
yy205:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'O':
	case 'o':	goto yy353;
	default:	goto yy53;
	}
yy206:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'C':
	case 'c':	goto yy354;
	default:	goto yy53;
	}
yy207:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'E':
	case 'e':	goto yy355;
	default:	goto yy53;
	}
yy208:
	yych = *++YYCURSOR;
	switch (yych) {
	case '-':	goto yy253;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy356;
	default:	goto yy176;
	}
yy209:
	yych = *++YYCURSOR;
	switch (yych) {
	case '-':	goto yy253;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy358;
	default:	goto yy176;
	}
yy210:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':
	case ':':	goto yy341;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy211;
	default:	goto yy192;
	}
yy211:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':
	case ':':	goto yy341;
	default:	goto yy192;
	}
yy212:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'R':
	case 'r':	goto yy360;
	default:	goto yy53;
	}
yy213:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'G':
	case 'g':	goto yy361;
	default:	goto yy53;
	}
yy214:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'Y':
	case 'y':	goto yy362;
	default:	goto yy53;
	}
yy215:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'C':
	case 'c':	goto yy364;
	default:	goto yy53;
	}
yy216:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'B':
	case 'b':	goto yy365;
	default:	goto yy53;
	}
yy217:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'R':
	case 'r':	goto yy366;
	default:	goto yy53;
	}
yy218:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'I':
	case 'i':	goto yy367;
	default:	goto yy53;
	}
yy219:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'U':
	case 'u':	goto yy368;
	default:	goto yy53;
	}
yy220:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 4) YYFILL(4);
	yych = *YYCURSOR;
	switch (yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':	goto yy220;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy222;
	default:	goto yy53;
	}
yy222:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy369;
	default:	goto yy223;
	}
yy223:
#line 1074 "real_world/parse_date.re"
	{
		DEBUG_OUTPUT("datefull");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		timelib_skip_day_suffix((char **) &ptr);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_FULL;
	}
#line 8815 "real_world/parse_date.c"
yy224:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':	goto yy220;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy222;
	case 'I':	goto yy225;
	default:	goto yy74;
	}
yy225:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':	goto yy220;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy222;
	default:	goto yy74;
	}
yy226:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'N':
	case 'n':	goto yy370;
	default:	goto yy53;
	}
yy227:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'L':
	case 'l':	goto yy371;
	case 'N':
	case 'n':	goto yy372;
	default:	goto yy53;
	}
yy228:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'R':
	case 'r':	goto yy373;
	case 'Y':
	case 'y':	goto yy225;
	default:	goto yy53;
	}
yy229:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'N':
	case 'n':	goto yy374;
	default:	goto yy53;
	}
yy230:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'N':
	case 'n':	goto yy375;
	default:	goto yy53;
	}
yy231:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'V':
	case 'v':	goto yy364;
	default:	goto yy53;
	}
yy232:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'T':
	case 't':	goto yy376;
	default:	goto yy53;
	}
yy233:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'T':
	case 't':	goto yy377;
	default:	goto yy53;
	}
yy234:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'C':
	case 'c':	goto yy378;
	case 'P':
	case 'p':	goto yy379;
	default:	goto yy53;
	}
yy235:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'N':
	case 'n':	goto yy367;
	default:	goto yy53;
	}
yy236:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'U':
	case 'u':	goto yy380;
	default:	goto yy53;
	}
yy237:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'E':
	case 'e':	goto yy381;
	default:	goto yy53;
	}
yy238:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'D':
	case 'd':	goto yy382;
	case 'E':
	case 'e':	goto yy383;
	default:	goto yy53;
	}
yy239:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy368;
	default:	goto yy53;
	}
yy240:
	yych = *++YYCURSOR;
	switch (yych) {
	case '.':	goto yy252;
	case '/':	goto yy246;
	default:	goto yy62;
	}
yy241:
	yych = *++YYCURSOR;
	switch (yych) {
	case '.':	goto yy252;
	case '/':	goto yy246;
	case 'U':
	case 'u':	goto yy380;
	default:	goto yy62;
	}
yy242:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':	goto yy384;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy385;
	case ':':	goto yy386;
	default:	goto yy192;
	}
yy243:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':	goto yy384;
	case '0':
	case '1':
	case '2':	goto yy385;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy387;
	case ':':	goto yy386;
	default:	goto yy192;
	}
yy244:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':	goto yy384;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy387;
	case ':':	goto yy386;
	default:	goto yy192;
	}
yy245:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':	goto yy384;
	case ':':	goto yy386;
	default:	goto yy192;
	}
yy246:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy200;
	case 'D':
	case 'd':	goto yy201;
	case 'F':
	case 'f':	goto yy202;
	case 'J':
	case 'j':	goto yy203;
	case 'M':
	case 'm':	goto yy204;
	case 'N':
	case 'n':	goto yy205;
	case 'O':
	case 'o':	goto yy206;
	case 'S':
	case 's':	goto yy207;
	default:	goto yy53;
	}
yy247:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':
	case ':':	goto yy386;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy387;
	default:	goto yy192;
	}
yy248:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':
	case ':':	goto yy386;
	default:	goto yy192;
	}
yy249:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'M':
	case 'm':	goto yy250;
	default:	goto yy53;
	}
yy250:
	yych = *++YYCURSOR;
	switch (yych) {
	case '.':	goto yy388;
	default:	goto yy251;
	}
yy251:
#line 930 "real_world/parse_date.re"
	{
		DEBUG_OUTPUT("timetiny12 | timeshort12 | timelong12");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->i = timelib_get_nr((char **) &ptr, 2);
			if (*ptr == ':' || *ptr == '.') {
				s->time->s = timelib_get_nr((char **) &ptr, 2);
			}
		}
		s->time->h += timelib_meridian((char **) &ptr, s->time->h);
		TIMELIB_DEINIT;
		return TIMELIB_TIME12;
	}
#line 9140 "real_world/parse_date.c"
yy252:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy389;
	case '1':	goto yy390;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy391;
	default:	goto yy62;
	}
yy253:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy188;
	case '1':	goto yy189;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy190;
	case 'A':
	case 'a':	goto yy392;
	case 'D':
	case 'd':	goto yy393;
	case 'F':
	case 'f':	goto yy394;
	case 'J':
	case 'j':	goto yy395;
	case 'M':
	case 'm':	goto yy396;
	case 'N':
	case 'n':	goto yy397;
	case 'O':
	case 'o':	goto yy398;
	case 'S':
	case 's':	goto yy399;
	default:	goto yy53;
	}
yy254:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy102;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy400;
	default:	goto yy18;
	}
yy255:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy102;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy400;
	default:	goto yy256;
	}
yy256:
#line 1293 "real_world/parse_date.re"
	{
		DEBUG_OUTPUT("ago");
		TIMELIB_INIT;
		s->time->relative.y = 0 - s->time->relative.y;
		s->time->relative.m = 0 - s->time->relative.m;
		s->time->relative.d = 0 - s->time->relative.d;
		s->time->relative.h = 0 - s->time->relative.h;
		s->time->relative.i = 0 - s->time->relative.i;
		s->time->relative.s = 0 - s->time->relative.s;
		s->time->relative.weekday = 0 - s->time->relative.weekday;
		TIMELIB_DEINIT;
		return TIMELIB_AGO;
	}
#line 9318 "real_world/parse_date.c"
yy257:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case '*':
	case '+':
	case ',':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy126;
	case ')':	goto yy127;
	case '-':	goto yy401;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy400;
	case 'I':
	case 'i':	goto yy402;
	default:	goto yy18;
	}
yy258:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case '*':
	case '+':
	case ',':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy126;
	case ')':	goto yy127;
	case '-':	goto yy401;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy400;
	case 'U':
	case 'u':	goto yy403;
	default:	goto yy18;
	}
yy259:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	switch (yych) {
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy404;
	default:	goto yy53;
	}
yy260:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case '/':
	case '_':	goto yy259;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy400;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy405;
	default:	goto yy18;
	}
yy261:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case '/':
	case '_':	goto yy259;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy400;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy405;
	default:	goto yy256;
	}
yy262:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case '*':
	case '+':
	case ',':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy126;
	case ')':	goto yy127;
	case '-':	goto yy401;
	case '/':
	case '_':	goto yy259;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy400;
	case 'I':	goto yy402;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy405;
	case 'i':	goto yy406;
	default:	goto yy18;
	}
yy263:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case '*':
	case '+':
	case ',':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy126;
	case ')':	goto yy127;
	case '-':	goto yy401;
	case '/':
	case '_':	goto yy259;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy400;
	case 'U':	goto yy403;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy405;
	case 'u':	goto yy407;
	default:	goto yy18;
	}
yy264:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case '*':
	case '+':
	case ',':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy126;
	case ')':	goto yy127;
	case '-':	goto yy401;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy400;
	case 'E':
	case 'e':	goto yy408;
	default:	goto yy18;
	}
yy265:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case '*':
	case '+':
	case ',':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy126;
	case ')':	goto yy127;
	case '-':	goto yy401;
	case '/':
	case '_':	goto yy259;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy400;
	case 'E':	goto yy408;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy405;
	case 'e':	goto yy409;
	default:	goto yy18;
	}
yy266:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy102;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy400;
	case 'H':
	case 'h':	goto yy410;
	default:	goto yy18;
	}
yy267:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy102;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy400;
	case 'V':
	case 'v':	goto yy411;
	default:	goto yy18;
	}
yy268:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case '/':
	case '_':	goto yy259;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy400;
	case 'H':	goto yy410;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy405;
	case 'h':	goto yy412;
	default:	goto yy18;
	}
yy269:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case '/':
	case '_':	goto yy259;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy400;
	case 'V':	goto yy411;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy405;
	case 'v':	goto yy413;
	default:	goto yy18;
	}
yy270:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case '*':
	case '+':
	case ',':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy126;
	case ')':	goto yy127;
	case '-':	goto yy401;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy400;
	case 'R':
	case 'r':	goto yy414;
	default:	goto yy18;
	}
yy271:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy102;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy400;
	case 'T':
	case 't':	goto yy415;
	default:	goto yy18;
	}
yy272:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy102;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy400;
	case 'S':
	case 's':	goto yy410;
	default:	goto yy18;
	}
yy273:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy102;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy400;
	case 'R':
	case 'r':	goto yy416;
	default:	goto yy18;
	}
yy274:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy102;
	case 'A':
	case 'B':
	case 'C':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy400;
	case 'D':
	case 'd':	goto yy417;
	default:	goto yy275;
	}
yy275:
#line 1308 "real_world/parse_date.re"
	{
		const timelib_relunit* relunit;
		DEBUG_OUTPUT("daytext");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_HAVE_WEEKDAY_RELATIVE();
		TIMELIB_UNHAVE_TIME();
		relunit = timelib_lookup_relunit((char**) &ptr);
		s->time->relative.weekday = relunit->multiplier;
		s->time->relative.weekday_behavior = 1;
		
		TIMELIB_DEINIT;
		return TIMELIB_WEEKDAY;
	}
#line 10547 "real_world/parse_date.c"
yy276:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case '*':
	case '+':
	case ',':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy126;
	case ')':	goto yy127;
	case '-':	goto yy401;
	case '/':
	case '_':	goto yy259;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy400;
	case 'R':	goto yy414;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy405;
	case 'r':	goto yy418;
	default:	goto yy18;
	}
yy277:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case '/':
	case '_':	goto yy259;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy400;
	case 'T':	goto yy415;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy405;
	case 't':	goto yy419;
	default:	goto yy18;
	}
yy278:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case '/':
	case '_':	goto yy259;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy400;
	case 'S':	goto yy410;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy405;
	case 's':	goto yy412;
	default:	goto yy18;
	}
yy279:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case '/':
	case '_':	goto yy259;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy400;
	case 'R':	goto yy416;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy405;
	case 'r':	goto yy420;
	default:	goto yy18;
	}
yy280:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case '/':
	case '_':	goto yy259;
	case 'A':
	case 'B':
	case 'C':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy400;
	case 'D':	goto yy417;
	case 'a':
	case 'b':
	case 'c':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy405;
	case 'd':	goto yy421;
	default:	goto yy275;
	}
yy281:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 14) YYFILL(14);
	yych = *YYCURSOR;
yy282:
	switch (yych) {
	case ' ':
	case ',':
	case '.':
	case 'd':
	case 'h':
	case 'n':
	case 'r':
	case 's':
	case 't':	goto yy281;
	case '0':
	case '1':	goto yy422;
	case '2':	goto yy423;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy424;
	default:	goto yy129;
	}
yy283:
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':	goto yy425;
	case '0':
	case '1':	goto yy426;
	case '2':	goto yy427;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy428;
	case ':':	goto yy429;
	default:	goto yy282;
	}
yy284:
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':
	case ':':	goto yy429;
	case '0':
	case '1':
	case '2':
	case '3':	goto yy430;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy431;
	default:	goto yy129;
	}
yy285:
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':
	case ':':	goto yy429;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy431;
	default:	goto yy129;
	}
yy286:
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':
	case ':':	goto yy429;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy430;
	default:	goto yy129;
	}
yy287:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy126;
	case ')':	goto yy127;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy400;
	default:	goto yy18;
	}
yy288:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case '*':
	case '+':
	case ',':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy126;
	case ')':	goto yy127;
	case '-':	goto yy401;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy400;
	case 'U':
	case 'u':	goto yy432;
	default:	goto yy18;
	}
yy289:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case '*':
	case '+':
	case ',':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy126;
	case ')':	goto yy127;
	case '-':	goto yy401;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'z':	goto yy400;
	case 'Y':
	case 'y':	goto yy433;
	default:	goto yy18;
	}
yy290:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case '*':
	case '+':
	case ',':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy126;
	case ')':	goto yy127;
	case '-':	goto yy401;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy400;
	case 'E':
	case 'e':	goto yy433;
	default:	goto yy18;
	}
yy291:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case '*':
	case '+':
	case ',':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy126;
	case ')':	goto yy127;
	case '-':	goto yy401;
	case '/':
	case '_':	goto yy259;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy400;
	case 'U':	goto yy432;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy405;
	case 'u':	goto yy434;
	default:	goto yy18;
	}
yy292:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case '*':
	case '+':
	case ',':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy126;
	case ')':	goto yy127;
	case '-':	goto yy401;
	case '/':
	case '_':	goto yy259;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Z':	goto yy400;
	case 'Y':	goto yy433;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'z':	goto yy405;
	case 'y':	goto yy435;
	default:	goto yy18;
	}
yy293:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case '*':
	case '+':
	case ',':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy126;
	case ')':	goto yy127;
	case '-':	goto yy401;
	case '/':
	case '_':	goto yy259;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy400;
	case 'E':	goto yy433;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy405;
	case 'e':	goto yy435;
	default:	goto yy18;
	}
yy294:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy102;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy400;
	case 'T':
	case 't':	goto yy436;
	default:	goto yy18;
	}
yy295:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case '/':
	case '_':	goto yy259;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy400;
	case 'T':	goto yy436;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy405;
	case 't':	goto yy437;
	default:	goto yy18;
	}
yy296:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case '*':
	case '+':
	case ',':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy126;
	case ')':	goto yy127;
	case '-':	goto yy401;
	case 'A':
	case 'B':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy400;
	case 'C':
	case 'c':	goto yy438;
	default:	goto yy18;
	}
yy297:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case '*':
	case '+':
	case ',':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy126;
	case ')':	goto yy127;
	case '-':	goto yy401;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy400;
	default:	goto yy18;
	}
yy298:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy102;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy400;
	case 'N':
	case 'n':	goto yy439;
	default:	goto yy18;
	}
yy299:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case '*':
	case '+':
	case ',':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy126;
	case ')':	goto yy127;
	case '-':	goto yy401;
	case '/':
	case '_':	goto yy259;
	case 'A':
	case 'B':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy400;
	case 'C':	goto yy438;
	case 'a':
	case 'b':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy405;
	case 'c':	goto yy440;
	default:	goto yy18;
	}
yy300:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case '*':
	case '+':
	case ',':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy126;
	case ')':	goto yy127;
	case '-':	goto yy401;
	case '/':
	case '_':	goto yy259;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy400;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy405;
	default:	goto yy18;
	}
yy301:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case '/':
	case '_':	goto yy259;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy400;
	case 'N':	goto yy439;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy405;
	case 'n':	goto yy441;
	default:	goto yy18;
	}
yy302:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy102;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy400;
	case 'N':
	case 'n':	goto yy442;
	default:	goto yy18;
	}
yy303:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy102;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy400;
	default:	goto yy304;
	}
yy304:
#line 863 "real_world/parse_date.re"
	{
		DEBUG_OUTPUT("now");
		TIMELIB_INIT;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 12262 "real_world/parse_date.c"
yy305:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case '/':
	case '_':	goto yy259;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy400;
	case 'N':	goto yy442;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy405;
	case 'n':	goto yy444;
	default:	goto yy18;
	}
yy306:
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case '/':
	case '_':	goto yy259;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy400;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy405;
	default:	goto yy304;
	}
yy307:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case '*':
	case '+':
	case ',':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy126;
	case ')':	goto yy127;
	case '-':	goto yy401;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy400;
	case 'O':
	case 'o':	goto yy445;
	default:	goto yy18;
	}
yy308:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case '*':
	case '+':
	case ',':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy126;
	case ')':	goto yy127;
	case '-':	goto yy401;
	case '/':
	case '_':	goto yy259;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy400;
	case 'O':	goto yy445;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy405;
	case 'o':	goto yy446;
	default:	goto yy18;
	}
yy309:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy102;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy400;
	case 'V':
	case 'v':	goto yy447;
	default:	goto yy18;
	}
yy310:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case '/':
	case '_':	goto yy259;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy400;
	case 'V':	goto yy447;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy405;
	case 'v':	goto yy448;
	default:	goto yy18;
	}
yy311:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy102;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy400;
	case 'U':
	case 'u':	goto yy449;
	default:	goto yy275;
	}
yy312:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy102;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy400;
	case 'O':
	case 'o':	goto yy450;
	default:	goto yy18;
	}
yy313:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case '*':
	case '+':
	case ',':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy126;
	case ')':	goto yy127;
	case '-':	goto yy401;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy400;
	case 'T':
	case 't':	goto yy451;
	default:	goto yy18;
	}
yy314:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy102;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy400;
	case 'E':
	case 'e':	goto yy452;
	default:	goto yy18;
	}
yy315:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case '/':
	case '_':	goto yy259;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy400;
	case 'U':	goto yy449;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy405;
	case 'u':	goto yy453;
	default:	goto yy275;
	}
yy316:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case '/':
	case '_':	goto yy259;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy400;
	case 'O':	goto yy450;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy405;
	case 'o':	goto yy454;
	default:	goto yy18;
	}
yy317:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case '*':
	case '+':
	case ',':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy126;
	case ')':	goto yy127;
	case '-':	goto yy401;
	case '/':
	case '_':	goto yy259;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy400;
	case 'T':	goto yy451;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy405;
	case 't':	goto yy455;
	default:	goto yy18;
	}
yy318:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case '/':
	case '_':	goto yy259;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy400;
	case 'E':	goto yy452;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy405;
	case 'e':	goto yy456;
	default:	goto yy18;
	}
yy319:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy102;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy400;
	case 'R':
	case 'r':	goto yy457;
	case 'S':
	case 's':	goto yy436;
	default:	goto yy18;
	}
yy320:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy102;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy400;
	case 'R':
	case 'r':	goto yy458;
	default:	goto yy275;
	}
yy321:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy102;
	case 'A':
	case 'a':	goto yy459;
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy400;
	default:	goto yy18;
	}
yy322:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy102;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy400;
	case 'O':
	case 'o':	goto yy460;
	default:	goto yy18;
	}
yy323:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy102;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy400;
	case 'S':
	case 's':	goto yy461;
	default:	goto yy275;
	}
yy324:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy102;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy400;
	case 'L':
	case 'l':	goto yy462;
	default:	goto yy18;
	}
yy325:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case '/':
	case '_':	goto yy259;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy400;
	case 'R':	goto yy457;
	case 'S':	goto yy436;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy405;
	case 'r':	goto yy463;
	case 's':	goto yy437;
	default:	goto yy18;
	}
yy326:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case '/':
	case '_':	goto yy259;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy400;
	case 'R':	goto yy458;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy405;
	case 'r':	goto yy464;
	default:	goto yy275;
	}
yy327:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case '/':
	case '_':	goto yy259;
	case 'A':	goto yy459;
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy400;
	case 'a':	goto yy465;
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy405;
	default:	goto yy18;
	}
yy328:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case '/':
	case '_':	goto yy259;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy400;
	case 'O':	goto yy460;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy405;
	case 'o':	goto yy466;
	default:	goto yy18;
	}
yy329:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case '/':
	case '_':	goto yy259;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy400;
	case 'S':	goto yy461;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy405;
	case 's':	goto yy467;
	default:	goto yy275;
	}
yy330:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case '/':
	case '_':	goto yy259;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy400;
	case 'L':	goto yy462;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy405;
	case 'l':	goto yy468;
	default:	goto yy18;
	}
yy331:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy126;
	case ')':	goto yy127;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy400;
	case 'I':	goto yy433;
	default:	goto yy18;
	}
yy332:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy102;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy400;
	case 'N':
	case 'n':	goto yy469;
	default:	goto yy275;
	}
yy333:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case '/':
	case '_':	goto yy259;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy400;
	case 'N':	goto yy469;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy405;
	case 'n':	goto yy470;
	default:	goto yy275;
	}
yy334:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy102;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy400;
	case 'T':
	case 't':	goto yy471;
	default:	goto yy18;
	}
yy335:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case '/':
	case '_':	goto yy259;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy400;
	case 'T':	goto yy471;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy405;
	case 't':	goto yy472;
	default:	goto yy18;
	}
yy336:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'C':
	case 'c':	goto yy378;
	default:	goto yy53;
	}
yy337:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy102;
	default:	goto yy18;
	}
yy338:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'P':
	case 'p':	goto yy379;
	default:	goto yy53;
	}
yy339:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':	goto yy473;
	case '3':	goto yy475;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy476;
	default:	goto yy53;
	}
yy340:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy477;
	case '6':	goto yy478;
	case '7':
	case '8':
	case '9':	goto yy479;
	default:	goto yy53;
	}
yy341:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy480;
	case '6':	goto yy481;
	case '7':
	case '8':
	case '9':	goto yy482;
	default:	goto yy53;
	}
yy342:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy483;
	default:	goto yy53;
	}
yy343:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'd':	goto yy484;
	default:	goto yy53;
	}
yy344:
	yych = *++YYCURSOR;
	switch (yych) {
	case 't':	goto yy484;
	default:	goto yy53;
	}
yy345:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'h':	goto yy484;
	default:	goto yy53;
	}
yy346:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'R':
	case 'r':	goto yy485;
	default:	goto yy53;
	}
yy347:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'G':
	case 'g':	goto yy485;
	default:	goto yy53;
	}
yy348:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'C':
	case 'c':	goto yy485;
	default:	goto yy53;
	}
yy349:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'B':
	case 'b':	goto yy485;
	default:	goto yy53;
	}
yy350:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'N':
	case 'n':	goto yy485;
	default:	goto yy53;
	}
yy351:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'L':
	case 'N':
	case 'l':
	case 'n':	goto yy485;
	default:	goto yy53;
	}
yy352:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'R':
	case 'Y':
	case 'r':
	case 'y':	goto yy485;
	default:	goto yy53;
	}
yy353:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'V':
	case 'v':	goto yy485;
	default:	goto yy53;
	}
yy354:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'T':
	case 't':	goto yy485;
	default:	goto yy53;
	}
yy355:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'P':
	case 'p':	goto yy486;
	default:	goto yy53;
	}
yy356:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'S':
	case 'T':
	case 'V':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'n':
	case 'o':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy488;
	case '-':	goto yy491;
	case '.':	goto yy492;
	case '/':	goto yy493;
	case '0':	goto yy494;
	case '1':	goto yy495;
	case '2':	goto yy496;
	case '3':	goto yy497;
	case '4':
	case '5':	goto yy498;
	case '6':	goto yy499;
	case '7':
	case '8':
	case '9':	goto yy54;
	case ':':	goto yy500;
	case 'W':	goto yy512;
	default:	goto yy357;
	}
yy357:
#line 971 "real_world/parse_date.re"
	{
		DEBUG_OUTPUT("gnunocolon");
		TIMELIB_INIT;
		switch (s->time->have_time) {
			case 0:
				s->time->h = timelib_get_nr((char **) &ptr, 2);
				s->time->i = timelib_get_nr((char **) &ptr, 2);
				s->time->s = 0;
				break;
			case 1:
				s->time->y = timelib_get_nr((char **) &ptr, 4);
				break;
			default:
				TIMELIB_DEINIT;
				return TIMELIB_ERROR;
		}
		s->time->have_time++;
		TIMELIB_DEINIT;
		return TIMELIB_GNU_NOCOLON;
	}
#line 14495 "real_world/parse_date.c"
yy358:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'S':
	case 'T':
	case 'V':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'n':
	case 'o':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy488;
	case '-':	goto yy491;
	case '.':	goto yy492;
	case '/':	goto yy493;
	case '0':	goto yy514;
	case '1':	goto yy515;
	case '2':	goto yy516;
	case '3':	goto yy517;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy54;
	case ':':	goto yy500;
	case 'W':	goto yy512;
	default:	goto yy359;
	}
yy359:
#line 1284 "real_world/parse_date.re"
	{
		DEBUG_OUTPUT("year4");
		TIMELIB_INIT;
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_DEINIT;
		return TIMELIB_CLF;
	}
#line 14565 "real_world/parse_date.c"
yy360:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':	goto yy220;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy222;
	case 'I':
	case 'i':	goto yy518;
	default:	goto yy74;
	}
yy361:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':	goto yy220;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy222;
	case 'U':
	case 'u':	goto yy519;
	default:	goto yy74;
	}
yy362:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'S':
	case 's':	goto yy520;
	default:	goto yy363;
	}
yy363:
#line 1380 "real_world/parse_date.re"
	{
		timelib_ull i;
		DEBUG_OUTPUT("relative");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		while(*ptr) {
			i = timelib_get_unsigned_nr((char **) &ptr, 24);
			timelib_eat_spaces((char **) &ptr);
			timelib_set_relative((char **) &ptr, i, 0, s);
		}
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 14655 "real_world/parse_date.c"
yy364:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':	goto yy220;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy222;
	case 'E':
	case 'e':	goto yy521;
	default:	goto yy74;
	}
yy365:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':	goto yy220;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy222;
	case 'R':
	case 'r':	goto yy522;
	default:	goto yy74;
	}
yy366:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'T':
	case 't':	goto yy523;
	default:	goto yy53;
	}
yy367:
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case 'D':
	case 'd':	goto yy524;
	default:	goto yy363;
	}
yy368:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'R':
	case 'r':	goto yy362;
	default:	goto yy53;
	}
yy369:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy525;
	default:	goto yy223;
	}
yy370:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':	goto yy220;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy222;
	case 'U':
	case 'u':	goto yy526;
	default:	goto yy74;
	}
yy371:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':	goto yy220;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy222;
	case 'Y':
	case 'y':	goto yy225;
	default:	goto yy74;
	}
yy372:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':	goto yy220;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy222;
	case 'E':
	case 'e':	goto yy225;
	default:	goto yy74;
	}
yy373:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':	goto yy220;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy222;
	case 'C':
	case 'c':	goto yy527;
	default:	goto yy74;
	}
yy374:
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case 'S':
	case 's':	goto yy520;
	case 'U':
	case 'u':	goto yy528;
	default:	goto yy363;
	}
yy375:
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case 'D':
	case 'd':	goto yy524;
	case 'T':
	case 't':	goto yy529;
	default:	goto yy363;
	}
yy376:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':	goto yy220;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy222;
	case 'O':
	case 'o':	goto yy530;
	default:	goto yy74;
	}
yy377:
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case 'U':
	case 'u':	goto yy531;
	default:	goto yy363;
	}
yy378:
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case 'O':
	case 'o':	goto yy532;
	case 'S':
	case 's':	goto yy520;
	default:	goto yy363;
	}
yy379:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':	goto yy220;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy222;
	case 'T':
	case 't':	goto yy364;
	default:	goto yy74;
	}
yy380:
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case 'R':
	case 'r':	goto yy533;
	default:	goto yy363;
	}
yy381:
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case 'S':
	case 's':	goto yy534;
	default:	goto yy363;
	}
yy382:
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case 'N':
	case 'n':	goto yy535;
	default:	goto yy363;
	}
yy383:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'K':
	case 'k':	goto yy362;
	default:	goto yy53;
	}
yy384:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy536;
	case '6':	goto yy537;
	case '7':
	case '8':
	case '9':	goto yy479;
	default:	goto yy53;
	}
yy385:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':	goto yy538;
	case '.':	goto yy384;
	case ':':	goto yy386;
	case 'A':
	case 'P':
	case 'a':
	case 'p':	goto yy95;
	default:	goto yy192;
	}
yy386:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy540;
	case '6':	goto yy541;
	case '7':
	case '8':
	case '9':	goto yy482;
	default:	goto yy53;
	}
yy387:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':	goto yy538;
	case '.':
	case ':':	goto yy386;
	case 'A':
	case 'P':
	case 'a':
	case 'p':	goto yy95;
	default:	goto yy192;
	}
yy388:
	++YYCURSOR;
	goto yy251;
yy389:
	yych = *++YYCURSOR;
	switch (yych) {
	case '.':	goto yy542;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy391;
	default:	goto yy53;
	}
yy390:
	yych = *++YYCURSOR;
	switch (yych) {
	case '.':	goto yy542;
	case '0':
	case '1':
	case '2':	goto yy391;
	default:	goto yy53;
	}
yy391:
	yych = *++YYCURSOR;
	switch (yych) {
	case '.':	goto yy542;
	default:	goto yy53;
	}
yy392:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'P':
	case 'p':	goto yy543;
	case 'U':
	case 'u':	goto yy544;
	default:	goto yy53;
	}
yy393:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'E':
	case 'e':	goto yy545;
	default:	goto yy53;
	}
yy394:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'E':
	case 'e':	goto yy546;
	default:	goto yy53;
	}
yy395:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy547;
	case 'U':
	case 'u':	goto yy548;
	default:	goto yy53;
	}
yy396:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy549;
	default:	goto yy53;
	}
yy397:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'O':
	case 'o':	goto yy550;
	default:	goto yy53;
	}
yy398:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'C':
	case 'c':	goto yy551;
	default:	goto yy53;
	}
yy399:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'E':
	case 'e':	goto yy552;
	default:	goto yy53;
	}
yy400:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy102;
	default:	goto yy18;
	}
yy401:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy553;
	case '1':
	case '2':	goto yy554;
	case '3':	goto yy555;
	default:	goto yy126;
	}
yy402:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case 'L':
	case 'l':	goto yy125;
	default:	goto yy18;
	}
yy403:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case 'S':
	case 's':	goto yy556;
	default:	goto yy18;
	}
yy404:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	switch (yych) {
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy557;
	default:	goto yy53;
	}
yy405:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case '/':
	case '_':	goto yy259;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy559;
	default:	goto yy18;
	}
yy406:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case '/':
	case '_':	goto yy259;
	case 'L':	goto yy125;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy559;
	case 'l':	goto yy561;
	default:	goto yy18;
	}
yy407:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case '/':
	case '_':	goto yy259;
	case 'S':	goto yy556;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy559;
	case 's':	goto yy562;
	default:	goto yy18;
	}
yy408:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case 'M':
	case 'm':	goto yy563;
	default:	goto yy18;
	}
yy409:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case '/':
	case '_':	goto yy259;
	case 'M':	goto yy563;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy559;
	case 'm':	goto yy564;
	default:	goto yy18;
	}
yy410:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case 'T':
	case 't':	goto yy565;
	default:	goto yy18;
	}
yy411:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case 'E':
	case 'e':	goto yy567;
	default:	goto yy18;
	}
yy412:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case '/':
	case '_':	goto yy259;
	case 'T':	goto yy565;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy559;
	case 't':	goto yy568;
	default:	goto yy18;
	}
yy413:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case '/':
	case '_':	goto yy259;
	case 'E':	goto yy567;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy559;
	case 'e':	goto yy569;
	default:	goto yy18;
	}
yy414:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case 'U':
	case 'u':	goto yy570;
	default:	goto yy18;
	}
yy415:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case 'H':
	case 'h':	goto yy565;
	default:	goto yy18;
	}
yy416:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case 'T':
	case 't':	goto yy571;
	default:	goto yy18;
	}
yy417:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case 'A':
	case 'a':	goto yy572;
	default:	goto yy18;
	}
yy418:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case '/':
	case '_':	goto yy259;
	case 'U':	goto yy570;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy559;
	case 'u':	goto yy573;
	default:	goto yy18;
	}
yy419:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case '/':
	case '_':	goto yy259;
	case 'H':	goto yy565;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy559;
	case 'h':	goto yy568;
	default:	goto yy18;
	}
yy420:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case '/':
	case '_':	goto yy259;
	case 'T':	goto yy571;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy559;
	case 't':	goto yy574;
	default:	goto yy18;
	}
yy421:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case '/':
	case '_':	goto yy259;
	case 'A':	goto yy572;
	case 'a':	goto yy575;
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy559;
	default:	goto yy18;
	}
yy422:
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':
	case ':':	goto yy429;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy576;
	default:	goto yy129;
	}
yy423:
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':
	case ':':	goto yy429;
	case '0':
	case '1':
	case '2':
	case '3':	goto yy576;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy577;
	default:	goto yy129;
	}
yy424:
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':
	case ':':	goto yy429;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy577;
	default:	goto yy129;
	}
yy425:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':	goto yy578;
	case '2':	goto yy579;
	case '3':
	case '4':
	case '5':	goto yy580;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy581;
	default:	goto yy282;
	}
yy426:
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':
	case ':':	goto yy429;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy582;
	default:	goto yy129;
	}
yy427:
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':
	case ':':	goto yy429;
	case '0':
	case '1':
	case '2':
	case '3':	goto yy582;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy584;
	default:	goto yy129;
	}
yy428:
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':
	case ':':	goto yy429;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy584;
	default:	goto yy129;
	}
yy429:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy585;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy587;
	default:	goto yy53;
	}
yy430:
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':
	case ':':	goto yy429;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy588;
	default:	goto yy129;
	}
yy431:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy588;
	default:	goto yy129;
	}
yy432:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case 'A':
	case 'a':	goto yy589;
	default:	goto yy18;
	}
yy433:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy126;
	case ')':	goto yy127;
	default:	goto yy18;
	}
yy434:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case '/':
	case '_':	goto yy259;
	case 'A':	goto yy589;
	case 'a':	goto yy590;
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy559;
	default:	goto yy18;
	}
yy435:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy126;
	case ')':	goto yy127;
	case '/':
	case '_':	goto yy259;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy559;
	default:	goto yy18;
	}
yy436:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case 'D':
	case 'F':
	case 'H':
	case 'M':
	case 'S':
	case 'T':
	case 'W':
	case 'Y':
	case 'd':
	case 'f':
	case 'h':
	case 'm':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy566;
	case ')':	goto yy102;
	default:	goto yy18;
	}
yy437:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case 'D':
	case 'F':
	case 'H':
	case 'M':
	case 'S':
	case 'T':
	case 'W':
	case 'Y':	goto yy566;
	case ')':	goto yy102;
	case '/':
	case '_':	goto yy259;
	case 'a':
	case 'b':
	case 'c':
	case 'e':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 'u':
	case 'v':
	case 'x':
	case 'z':	goto yy559;
	case 'd':	goto yy599;
	case 'f':	goto yy600;
	case 'h':	goto yy601;
	case 'm':	goto yy602;
	case 's':	goto yy603;
	case 't':	goto yy604;
	case 'w':	goto yy605;
	case 'y':	goto yy606;
	default:	goto yy18;
	}
yy438:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case 'H':
	case 'h':	goto yy125;
	default:	goto yy18;
	}
yy439:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case 'I':
	case 'i':	goto yy607;
	default:	goto yy18;
	}
yy440:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case '/':
	case '_':	goto yy259;
	case 'H':	goto yy125;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy559;
	case 'h':	goto yy561;
	default:	goto yy18;
	}
yy441:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case '/':
	case '_':	goto yy259;
	case 'I':	goto yy607;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy559;
	case 'i':	goto yy608;
	default:	goto yy18;
	}
yy442:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy102;
	default:	goto yy443;
	}
yy443:
#line 872 "real_world/parse_date.re"
	{
		DEBUG_OUTPUT("noon");
		TIMELIB_INIT;
		TIMELIB_UNHAVE_TIME();
		TIMELIB_HAVE_TIME();
		s->time->h = 12;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 16146 "real_world/parse_date.c"
yy444:
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case '/':
	case '_':	goto yy259;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy559;
	default:	goto yy443;
	}
yy445:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case 'B':
	case 'b':	goto yy609;
	default:	goto yy18;
	}
yy446:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case '/':
	case '_':	goto yy259;
	case 'B':	goto yy609;
	case 'a':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy559;
	case 'b':	goto yy610;
	default:	goto yy18;
	}
yy447:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case 'I':
	case 'i':	goto yy611;
	default:	goto yy18;
	}
yy448:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case '/':
	case '_':	goto yy259;
	case 'I':	goto yy611;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy559;
	case 'i':	goto yy612;
	default:	goto yy18;
	}
yy449:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case 'R':
	case 'r':	goto yy613;
	default:	goto yy18;
	}
yy450:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case 'N':
	case 'n':	goto yy614;
	default:	goto yy18;
	}
yy451:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case '*':
	case '+':
	case ',':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy126;
	case ')':	goto yy127;
	case '-':	goto yy401;
	case 'E':
	case 'e':	goto yy615;
	default:	goto yy18;
	}
yy452:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case 'N':
	case 'n':	goto yy616;
	default:	goto yy18;
	}
yy453:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case '/':
	case '_':	goto yy259;
	case 'R':	goto yy613;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy559;
	case 'r':	goto yy617;
	default:	goto yy18;
	}
yy454:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case '/':
	case '_':	goto yy259;
	case 'N':	goto yy614;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy559;
	case 'n':	goto yy618;
	default:	goto yy18;
	}
yy455:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case '*':
	case '+':
	case ',':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy126;
	case ')':	goto yy127;
	case '-':	goto yy401;
	case '/':
	case '_':	goto yy259;
	case 'E':	goto yy615;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy559;
	case 'e':	goto yy619;
	default:	goto yy18;
	}
yy456:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case '/':
	case '_':	goto yy259;
	case 'N':	goto yy616;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy559;
	case 'n':	goto yy620;
	default:	goto yy18;
	}
yy457:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case 'D':
	case 'd':	goto yy565;
	default:	goto yy18;
	}
yy458:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case 'S':
	case 's':	goto yy613;
	default:	goto yy18;
	}
yy459:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy102;
	case 'Y':
	case 'y':	goto yy621;
	default:	goto yy18;
	}
yy460:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case 'R':
	case 'r':	goto yy623;
	default:	goto yy18;
	}
yy461:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case 'D':
	case 'd':	goto yy624;
	default:	goto yy18;
	}
yy462:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case 'F':
	case 'f':	goto yy616;
	default:	goto yy18;
	}
yy463:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case '/':
	case '_':	goto yy259;
	case 'D':	goto yy565;
	case 'a':
	case 'b':
	case 'c':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy559;
	case 'd':	goto yy568;
	default:	goto yy18;
	}
yy464:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case '/':
	case '_':	goto yy259;
	case 'S':	goto yy613;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy559;
	case 's':	goto yy617;
	default:	goto yy18;
	}
yy465:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case '/':
	case '_':	goto yy259;
	case 'Y':	goto yy621;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'z':	goto yy559;
	case 'y':	goto yy625;
	default:	goto yy18;
	}
yy466:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case '/':
	case '_':	goto yy259;
	case 'R':	goto yy623;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy559;
	case 'r':	goto yy626;
	default:	goto yy18;
	}
yy467:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case '/':
	case '_':	goto yy259;
	case 'D':	goto yy624;
	case 'a':
	case 'b':
	case 'c':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy559;
	case 'd':	goto yy627;
	default:	goto yy18;
	}
yy468:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case '/':
	case '_':	goto yy259;
	case 'F':	goto yy616;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy559;
	case 'f':	goto yy620;
	default:	goto yy18;
	}
yy469:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case 'E':
	case 'e':	goto yy628;
	default:	goto yy18;
	}
yy470:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case '/':
	case '_':	goto yy259;
	case 'E':	goto yy628;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy559;
	case 'e':	goto yy629;
	default:	goto yy18;
	}
yy471:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case 'E':
	case 'e':	goto yy630;
	default:	goto yy18;
	}
yy472:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy102;
	case '/':
	case '_':	goto yy259;
	case 'E':	goto yy630;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy559;
	case 'e':	goto yy631;
	default:	goto yy18;
	}
yy473:
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy476;
	case 'n':
	case 'r':	goto yy632;
	case 's':	goto yy633;
	case 't':	goto yy634;
	default:	goto yy474;
	}
yy474:
#line 1061 "real_world/parse_date.re"
	{
		DEBUG_OUTPUT("gnudateshort");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
#line 16892 "real_world/parse_date.c"
yy475:
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '0':
	case '1':	goto yy476;
	case 'n':
	case 'r':	goto yy632;
	case 's':	goto yy633;
	case 't':	goto yy634;
	default:	goto yy474;
	}
yy476:
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case 'n':
	case 'r':	goto yy632;
	case 's':	goto yy633;
	case 't':	goto yy634;
	default:	goto yy474;
	}
yy477:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':	goto yy635;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy636;
	default:	goto yy192;
	}
yy478:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':	goto yy635;
	case '0':	goto yy636;
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy637;
	default:	goto yy192;
	}
yy479:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':	goto yy635;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy637;
	default:	goto yy192;
	}
yy480:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':	goto yy635;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy482;
	default:	goto yy192;
	}
yy481:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':	goto yy635;
	case '0':	goto yy482;
	default:	goto yy192;
	}
yy482:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':	goto yy635;
	default:	goto yy192;
	}
yy483:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy639;
	default:	goto yy197;
	}
yy484:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '/':	goto yy342;
	default:	goto yy197;
	}
yy485:
	yych = *++YYCURSOR;
	switch (yych) {
	case '/':	goto yy640;
	default:	goto yy53;
	}
yy486:
	yych = *++YYCURSOR;
	switch (yych) {
	case '/':	goto yy640;
	case 'T':
	case 't':	goto yy485;
	default:	goto yy53;
	}
yy487:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
	yych = *YYCURSOR;
yy488:
	switch (yych) {
	case ' ':	goto yy487;
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':	goto yy489;
	case 'A':
	case 'a':	goto yy501;
	case 'D':
	case 'd':	goto yy502;
	case 'F':
	case 'f':	goto yy503;
	case 'H':
	case 'h':	goto yy72;
	case 'I':	goto yy504;
	case 'J':
	case 'j':	goto yy506;
	case 'M':
	case 'm':	goto yy507;
	case 'N':
	case 'n':	goto yy508;
	case 'O':
	case 'o':	goto yy509;
	case 'S':
	case 's':	goto yy510;
	case 'T':
	case 't':	goto yy80;
	case 'V':	goto yy511;
	case 'W':
	case 'w':	goto yy82;
	case 'X':	goto yy513;
	case 'Y':
	case 'y':	goto yy84;
	default:	goto yy53;
	}
yy489:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
yy490:
	switch (yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':	goto yy489;
	case 'A':
	case 'a':	goto yy501;
	case 'D':
	case 'd':	goto yy641;
	case 'F':
	case 'f':	goto yy642;
	case 'I':	goto yy504;
	case 'J':
	case 'j':	goto yy506;
	case 'M':
	case 'm':	goto yy643;
	case 'N':
	case 'n':	goto yy508;
	case 'O':
	case 'o':	goto yy509;
	case 'S':
	case 's':	goto yy644;
	case 'V':	goto yy511;
	case 'X':	goto yy513;
	default:	goto yy53;
	}
yy491:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy645;
	case '1':	goto yy646;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy647;
	case 'A':
	case 'a':	goto yy648;
	case 'D':
	case 'd':	goto yy649;
	case 'F':
	case 'f':	goto yy650;
	case 'J':
	case 'j':	goto yy651;
	case 'M':
	case 'm':	goto yy652;
	case 'N':
	case 'n':	goto yy653;
	case 'O':
	case 'o':	goto yy654;
	case 'S':
	case 's':	goto yy655;
	default:	goto yy490;
	}
yy492:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy656;
	case '1':
	case '2':	goto yy657;
	case '3':	goto yy658;
	default:	goto yy490;
	}
yy493:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy659;
	case '1':	goto yy660;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy661;
	default:	goto yy53;
	}
yy494:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy662;
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy664;
	default:	goto yy176;
	}
yy495:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':	goto yy664;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy665;
	default:	goto yy176;
	}
yy496:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy665;
	default:	goto yy176;
	}
yy497:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy665;
	case '6':	goto yy666;
	case '7':
	case '8':
	case '9':	goto yy667;
	default:	goto yy176;
	}
yy498:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy667;
	default:	goto yy176;
	}
yy499:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy667;
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy54;
	default:	goto yy176;
	}
yy500:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy668;
	case '1':	goto yy669;
	default:	goto yy53;
	}
yy501:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'P':
	case 'p':	goto yy670;
	case 'U':
	case 'u':	goto yy671;
	default:	goto yy53;
	}
yy502:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy214;
	case 'E':
	case 'e':	goto yy672;
	default:	goto yy53;
	}
yy503:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'E':
	case 'e':	goto yy673;
	case 'O':
	case 'o':	goto yy217;
	case 'R':
	case 'r':	goto yy218;
	default:	goto yy53;
	}
yy504:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'I':	goto yy674;
	case 'V':
	case 'X':	goto yy675;
	default:	goto yy505;
	}
yy505:
#line 1114 "real_world/parse_date.re"
	{
		DEBUG_OUTPUT("datenodayrev");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = 1;
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NO_DAY;
	}
#line 17328 "real_world/parse_date.c"
yy506:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy676;
	case 'U':
	case 'u':	goto yy677;
	default:	goto yy53;
	}
yy507:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy678;
	case 'I':
	case 'i':	goto yy229;
	case 'O':
	case 'o':	goto yy230;
	default:	goto yy53;
	}
yy508:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'O':
	case 'o':	goto yy679;
	default:	goto yy53;
	}
yy509:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'C':
	case 'c':	goto yy680;
	default:	goto yy53;
	}
yy510:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy233;
	case 'E':
	case 'e':	goto yy681;
	case 'U':
	case 'u':	goto yy235;
	default:	goto yy53;
	}
yy511:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'I':	goto yy513;
	default:	goto yy505;
	}
yy512:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy682;
	case '1':
	case '2':
	case '3':
	case '4':	goto yy683;
	case '5':	goto yy684;
	case 'E':
	case 'e':	goto yy238;
	default:	goto yy53;
	}
yy513:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'I':	goto yy674;
	default:	goto yy505;
	}
yy514:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy685;
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy686;
	default:	goto yy176;
	}
yy515:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':	goto yy686;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy687;
	default:	goto yy176;
	}
yy516:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy687;
	default:	goto yy176;
	}
yy517:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy687;
	case '6':	goto yy688;
	case '7':
	case '8':
	case '9':	goto yy54;
	default:	goto yy176;
	}
yy518:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'L':
	case 'l':	goto yy225;
	default:	goto yy53;
	}
yy519:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'S':
	case 's':	goto yy689;
	default:	goto yy53;
	}
yy520:
	++YYCURSOR;
	goto yy363;
yy521:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'M':
	case 'm':	goto yy530;
	default:	goto yy53;
	}
yy522:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'U':
	case 'u':	goto yy526;
	default:	goto yy53;
	}
yy523:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'H':
	case 'h':	goto yy690;
	case 'N':
	case 'n':	goto yy691;
	default:	goto yy53;
	}
yy524:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy692;
	default:	goto yy53;
	}
yy525:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy693;
	default:	goto yy223;
	}
yy526:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy694;
	default:	goto yy53;
	}
yy527:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'H':
	case 'h':	goto yy225;
	default:	goto yy53;
	}
yy528:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'T':
	case 't':	goto yy695;
	default:	goto yy53;
	}
yy529:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'H':
	case 'h':	goto yy362;
	default:	goto yy53;
	}
yy530:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'B':
	case 'b':	goto yy696;
	default:	goto yy53;
	}
yy531:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'R':
	case 'r':	goto yy534;
	default:	goto yy53;
	}
yy532:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'N':
	case 'n':	goto yy697;
	default:	goto yy53;
	}
yy533:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'S':
	case 's':	goto yy534;
	default:	goto yy53;
	}
yy534:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'D':
	case 'd':	goto yy524;
	default:	goto yy53;
	}
yy535:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'E':
	case 'e':	goto yy533;
	default:	goto yy53;
	}
yy536:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':	goto yy635;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy698;
	default:	goto yy192;
	}
yy537:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':	goto yy635;
	case '0':	goto yy698;
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy637;
	default:	goto yy192;
	}
yy538:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 4) YYFILL(4);
	yych = *YYCURSOR;
	switch (yych) {
	case ' ':	goto yy538;
	case 'A':
	case 'P':
	case 'a':
	case 'p':	goto yy95;
	default:	goto yy53;
	}
yy540:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':	goto yy635;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy699;
	default:	goto yy192;
	}
yy541:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':	goto yy635;
	case '0':	goto yy699;
	default:	goto yy192;
	}
yy542:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy700;
	default:	goto yy53;
	}
yy543:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'R':
	case 'r':	goto yy701;
	default:	goto yy53;
	}
yy544:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'G':
	case 'g':	goto yy701;
	default:	goto yy53;
	}
yy545:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'C':
	case 'c':	goto yy701;
	default:	goto yy53;
	}
yy546:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'B':
	case 'b':	goto yy701;
	default:	goto yy53;
	}
yy547:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'N':
	case 'n':	goto yy701;
	default:	goto yy53;
	}
yy548:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'L':
	case 'N':
	case 'l':
	case 'n':	goto yy701;
	default:	goto yy53;
	}
yy549:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'R':
	case 'Y':
	case 'r':
	case 'y':	goto yy701;
	default:	goto yy53;
	}
yy550:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'V':
	case 'v':	goto yy701;
	default:	goto yy53;
	}
yy551:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'T':
	case 't':	goto yy701;
	default:	goto yy53;
	}
yy552:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'P':
	case 'p':	goto yy702;
	default:	goto yy53;
	}
yy553:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy283;
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy703;
	default:	goto yy282;
	}
yy554:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy703;
	default:	goto yy282;
	}
yy555:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':	goto yy703;
	case '2':	goto yy284;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy285;
	default:	goto yy282;
	}
yy556:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'T':
	case 't':	goto yy125;
	default:	goto yy53;
	}
yy557:
	yyaccept = 2;
	YYMARKER = ++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	switch (yych) {
	case '/':
	case '_':	goto yy259;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy557;
	default:	goto yy18;
	}
yy559:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
yy560:
	switch (yych) {
	case '/':
	case '_':	goto yy259;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy559;
	default:	goto yy53;
	}
yy561:
	yych = *++YYCURSOR;
	switch (yych) {
	case '/':
	case '_':	goto yy259;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy559;
	default:	goto yy126;
	}
yy562:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'T':	goto yy125;
	case 't':	goto yy561;
	default:	goto yy560;
	}
yy563:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'B':
	case 'b':	goto yy609;
	default:	goto yy53;
	}
yy564:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'B':	goto yy609;
	case 'b':	goto yy610;
	default:	goto yy560;
	}
yy565:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
	yych = *YYCURSOR;
yy566:
	switch (yych) {
	case ' ':	goto yy565;
	case 'D':
	case 'd':	goto yy591;
	case 'F':
	case 'f':	goto yy592;
	case 'H':
	case 'h':	goto yy593;
	case 'M':
	case 'm':	goto yy594;
	case 'S':
	case 's':	goto yy595;
	case 'T':
	case 't':	goto yy596;
	case 'W':
	case 'w':	goto yy597;
	case 'Y':
	case 'y':	goto yy598;
	default:	goto yy53;
	}
yy567:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'N':
	case 'n':	goto yy616;
	default:	goto yy53;
	}
yy568:
	yych = *++YYCURSOR;
	switch (yych) {
	case '/':
	case '_':	goto yy259;
	case 'a':
	case 'b':
	case 'c':
	case 'e':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 'u':
	case 'v':
	case 'x':
	case 'z':	goto yy559;
	case 'd':	goto yy599;
	case 'f':	goto yy600;
	case 'h':	goto yy601;
	case 'm':	goto yy602;
	case 's':	goto yy603;
	case 't':	goto yy604;
	case 'w':	goto yy605;
	case 'y':	goto yy606;
	default:	goto yy566;
	}
yy569:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'N':	goto yy616;
	case 'n':	goto yy620;
	default:	goto yy560;
	}
yy570:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy589;
	default:	goto yy53;
	}
yy571:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'H':
	case 'h':	goto yy565;
	default:	goto yy53;
	}
yy572:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'Y':
	case 'y':	goto yy704;
	default:	goto yy53;
	}
yy573:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':	goto yy589;
	case 'a':	goto yy590;
	default:	goto yy560;
	}
yy574:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'H':	goto yy565;
	case 'h':	goto yy568;
	default:	goto yy560;
	}
yy575:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'Y':	goto yy704;
	case 'y':	goto yy705;
	default:	goto yy560;
	}
yy576:
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':
	case ':':	goto yy429;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy706;
	default:	goto yy129;
	}
yy577:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy706;
	default:	goto yy129;
	}
yy578:
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':
	case ':':	goto yy707;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy708;
	default:	goto yy129;
	}
yy579:
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':
	case ':':	goto yy707;
	case '0':
	case '1':
	case '2':
	case '3':	goto yy708;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy709;
	default:	goto yy129;
	}
yy580:
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':
	case ':':	goto yy707;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy709;
	default:	goto yy129;
	}
yy581:
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':
	case ':':	goto yy707;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy577;
	default:	goto yy129;
	}
yy582:
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':
	case ':':	goto yy429;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy706;
	default:	goto yy583;
	}
yy583:
#line 1101 "real_world/parse_date.re"
	{
		DEBUG_OUTPUT("datenoday");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->d = 1;
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NO_DAY;
	}
#line 18179 "real_world/parse_date.c"
yy584:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy706;
	default:	goto yy583;
	}
yy585:
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':
	case ':':	goto yy710;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy587;
	default:	goto yy586;
	}
yy586:
#line 1352 "real_world/parse_date.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("dateshortwithtimeshort | dateshortwithtimelong | dateshortwithtimelongtz");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);

		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':') {
			s->time->s = timelib_get_nr((char **) &ptr, 2);

			if (*ptr == '.') {
				s->time->f = timelib_get_frac_nr((char **) &ptr, 8);
			}
		}

		if (*ptr != '\0') {
			s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
			s->errors += tz_not_found;
		}
		TIMELIB_DEINIT;
		return TIMELIB_SHORTDATE_WITH_TIME;
	}
#line 18241 "real_world/parse_date.c"
yy587:
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':
	case ':':	goto yy710;
	default:	goto yy586;
	}
yy588:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy711;
	default:	goto yy583;
	}
yy589:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'R':
	case 'r':	goto yy712;
	default:	goto yy53;
	}
yy590:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'R':	goto yy712;
	case 'r':	goto yy713;
	default:	goto yy560;
	}
yy591:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy714;
	default:	goto yy53;
	}
yy592:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'O':
	case 'o':	goto yy715;
	case 'R':
	case 'r':	goto yy716;
	default:	goto yy53;
	}
yy593:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'O':
	case 'o':	goto yy717;
	default:	goto yy53;
	}
yy594:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'I':
	case 'i':	goto yy718;
	case 'O':
	case 'o':	goto yy719;
	default:	goto yy53;
	}
yy595:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy720;
	case 'E':
	case 'e':	goto yy721;
	case 'U':
	case 'u':	goto yy722;
	default:	goto yy53;
	}
yy596:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'H':
	case 'h':	goto yy723;
	case 'U':
	case 'u':	goto yy724;
	default:	goto yy53;
	}
yy597:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'E':
	case 'e':	goto yy725;
	default:	goto yy53;
	}
yy598:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'E':
	case 'e':	goto yy726;
	default:	goto yy53;
	}
yy599:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':	goto yy714;
	case 'a':	goto yy727;
	default:	goto yy560;
	}
yy600:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'O':	goto yy715;
	case 'R':	goto yy716;
	case 'o':	goto yy728;
	case 'r':	goto yy729;
	default:	goto yy560;
	}
yy601:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'O':	goto yy717;
	case 'o':	goto yy730;
	default:	goto yy560;
	}
yy602:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'I':	goto yy718;
	case 'O':	goto yy719;
	case 'i':	goto yy731;
	case 'o':	goto yy732;
	default:	goto yy560;
	}
yy603:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':	goto yy720;
	case 'E':	goto yy721;
	case 'U':	goto yy722;
	case 'a':	goto yy733;
	case 'e':	goto yy734;
	case 'u':	goto yy735;
	default:	goto yy560;
	}
yy604:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'H':	goto yy723;
	case 'U':	goto yy724;
	case 'h':	goto yy736;
	case 'u':	goto yy737;
	default:	goto yy560;
	}
yy605:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'E':	goto yy725;
	case 'e':	goto yy738;
	default:	goto yy560;
	}
yy606:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'E':	goto yy726;
	case 'e':	goto yy739;
	default:	goto yy560;
	}
yy607:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'G':
	case 'g':	goto yy740;
	default:	goto yy53;
	}
yy608:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'G':	goto yy740;
	case 'g':	goto yy741;
	default:	goto yy560;
	}
yy609:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'E':
	case 'e':	goto yy742;
	default:	goto yy53;
	}
yy610:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'E':	goto yy742;
	case 'e':	goto yy743;
	default:	goto yy560;
	}
yy611:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'O':
	case 'o':	goto yy744;
	default:	goto yy53;
	}
yy612:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'O':	goto yy744;
	case 'o':	goto yy745;
	default:	goto yy560;
	}
yy613:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'D':
	case 'd':	goto yy624;
	default:	goto yy53;
	}
yy614:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'D':
	case 'd':	goto yy565;
	default:	goto yy53;
	}
yy615:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'M':
	case 'm':	goto yy563;
	default:	goto yy53;
	}
yy616:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'T':
	case 't':	goto yy571;
	default:	goto yy53;
	}
yy617:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'D':	goto yy624;
	case 'd':	goto yy627;
	default:	goto yy560;
	}
yy618:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'D':	goto yy565;
	case 'd':	goto yy568;
	default:	goto yy560;
	}
yy619:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'M':	goto yy563;
	case 'm':	goto yy564;
	default:	goto yy560;
	}
yy620:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'T':	goto yy571;
	case 't':	goto yy574;
	default:	goto yy560;
	}
yy621:
	++YYCURSOR;
yy622:
#line 884 "real_world/parse_date.re"
	{
		DEBUG_OUTPUT("midnight | today");
		TIMELIB_INIT;
		TIMELIB_UNHAVE_TIME();

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 18521 "real_world/parse_date.c"
yy623:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'R':
	case 'r':	goto yy746;
	default:	goto yy53;
	}
yy624:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy572;
	default:	goto yy53;
	}
yy625:
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '/':
	case '_':	goto yy259;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy559;
	default:	goto yy622;
	}
yy626:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'R':	goto yy746;
	case 'r':	goto yy747;
	default:	goto yy560;
	}
yy627:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':	goto yy572;
	case 'a':	goto yy575;
	default:	goto yy560;
	}
yy628:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'S':
	case 's':	goto yy613;
	default:	goto yy53;
	}
yy629:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'S':	goto yy613;
	case 's':	goto yy617;
	default:	goto yy560;
	}
yy630:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'R':
	case 'r':	goto yy748;
	default:	goto yy53;
	}
yy631:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'R':	goto yy748;
	case 'r':	goto yy749;
	default:	goto yy560;
	}
yy632:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'd':	goto yy750;
	default:	goto yy53;
	}
yy633:
	yych = *++YYCURSOR;
	switch (yych) {
	case 't':	goto yy750;
	default:	goto yy53;
	}
yy634:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'h':	goto yy750;
	default:	goto yy53;
	}
yy635:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy751;
	default:	goto yy53;
	}
yy636:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':	goto yy635;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy753;
	default:	goto yy192;
	}
yy637:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy753;
	default:	goto yy638;
	}
yy638:
#line 1088 "real_world/parse_date.re"
	{
		DEBUG_OUTPUT("pointed date");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_FULL_POINTED;
	}
#line 18690 "real_world/parse_date.c"
yy639:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy754;
	default:	goto yy197;
	}
yy640:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy755;
	default:	goto yy53;
	}
yy641:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'E':
	case 'e':	goto yy672;
	default:	goto yy53;
	}
yy642:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'E':
	case 'e':	goto yy673;
	default:	goto yy53;
	}
yy643:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy678;
	default:	goto yy53;
	}
yy644:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'E':
	case 'e':	goto yy756;
	default:	goto yy53;
	}
yy645:
	yych = *++YYCURSOR;
	switch (yych) {
	case '-':	goto yy757;
	case '0':	goto yy647;
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy758;
	default:	goto yy53;
	}
yy646:
	yych = *++YYCURSOR;
	switch (yych) {
	case '-':	goto yy757;
	case '0':
	case '1':
	case '2':	goto yy758;
	default:	goto yy53;
	}
yy647:
	yych = *++YYCURSOR;
	switch (yych) {
	case '-':	goto yy757;
	default:	goto yy53;
	}
yy648:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'P':
	case 'p':	goto yy759;
	case 'U':
	case 'u':	goto yy760;
	default:	goto yy53;
	}
yy649:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'E':
	case 'e':	goto yy761;
	default:	goto yy53;
	}
yy650:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'E':
	case 'e':	goto yy762;
	default:	goto yy53;
	}
yy651:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy763;
	case 'U':
	case 'u':	goto yy764;
	default:	goto yy53;
	}
yy652:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy765;
	default:	goto yy53;
	}
yy653:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'O':
	case 'o':	goto yy766;
	default:	goto yy53;
	}
yy654:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'C':
	case 'c':	goto yy767;
	default:	goto yy53;
	}
yy655:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'E':
	case 'e':	goto yy768;
	default:	goto yy53;
	}
yy656:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy769;
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy770;
	default:	goto yy53;
	}
yy657:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy770;
	default:	goto yy53;
	}
yy658:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy770;
	case '6':	goto yy771;
	default:	goto yy53;
	}
yy659:
	yych = *++YYCURSOR;
	switch (yych) {
	case '/':	goto yy772;
	case '0':	goto yy661;
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy773;
	default:	goto yy53;
	}
yy660:
	yych = *++YYCURSOR;
	switch (yych) {
	case '/':	goto yy772;
	case '0':
	case '1':
	case '2':	goto yy773;
	default:	goto yy53;
	}
yy661:
	yych = *++YYCURSOR;
	switch (yych) {
	case '/':	goto yy772;
	default:	goto yy53;
	}
yy662:
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case 'D':
	case 'F':
	case 'H':
	case 'M':
	case 'S':
	case 'T':
	case 'W':
	case 'Y':
	case 'd':
	case 'f':
	case 'h':
	case 'm':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy176;
	case '0':	goto yy54;
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy774;
	default:	goto yy663;
	}
yy663:
#line 1016 "real_world/parse_date.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("iso8601nocolon");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		s->time->s = timelib_get_nr((char **) &ptr, 2);

		if (*ptr != '\0') {
			s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
			s->errors += tz_not_found;
		}
		TIMELIB_DEINIT;
		return TIMELIB_ISO_NOCOLON;
	}
#line 18964 "real_world/parse_date.c"
yy664:
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case 'D':
	case 'F':
	case 'H':
	case 'M':
	case 'S':
	case 'T':
	case 'W':
	case 'Y':
	case 'd':
	case 'f':
	case 'h':
	case 'm':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy176;
	case '0':	goto yy776;
	case '1':
	case '2':	goto yy777;
	case '3':	goto yy778;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy774;
	default:	goto yy663;
	}
yy665:
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case 'D':
	case 'F':
	case 'H':
	case 'M':
	case 'S':
	case 'T':
	case 'W':
	case 'Y':
	case 'd':
	case 'f':
	case 'h':
	case 'm':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy176;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy774;
	default:	goto yy663;
	}
yy666:
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case 'D':
	case 'F':
	case 'H':
	case 'M':
	case 'S':
	case 'T':
	case 'W':
	case 'Y':
	case 'd':
	case 'f':
	case 'h':
	case 'm':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy176;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':	goto yy774;
	case '7':
	case '8':
	case '9':	goto yy54;
	default:	goto yy663;
	}
yy667:
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case 'D':
	case 'F':
	case 'H':
	case 'M':
	case 'S':
	case 'T':
	case 'W':
	case 'Y':
	case 'd':
	case 'f':
	case 'h':
	case 'm':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy176;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy54;
	default:	goto yy663;
	}
yy668:
	yych = *++YYCURSOR;
	switch (yych) {
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy779;
	default:	goto yy53;
	}
yy669:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':	goto yy779;
	default:	goto yy53;
	}
yy670:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'R':
	case 'r':	goto yy780;
	default:	goto yy53;
	}
yy671:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'G':
	case 'g':	goto yy781;
	default:	goto yy53;
	}
yy672:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'C':
	case 'c':	goto yy782;
	default:	goto yy53;
	}
yy673:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'B':
	case 'b':	goto yy783;
	default:	goto yy53;
	}
yy674:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'I':	goto yy675;
	default:	goto yy505;
	}
yy675:
	++YYCURSOR;
	goto yy505;
yy676:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'N':
	case 'n':	goto yy784;
	default:	goto yy53;
	}
yy677:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'L':
	case 'l':	goto yy785;
	case 'N':
	case 'n':	goto yy786;
	default:	goto yy53;
	}
yy678:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'R':
	case 'r':	goto yy787;
	case 'Y':
	case 'y':	goto yy675;
	default:	goto yy53;
	}
yy679:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'V':
	case 'v':	goto yy782;
	default:	goto yy53;
	}
yy680:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'T':
	case 't':	goto yy788;
	default:	goto yy53;
	}
yy681:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'C':
	case 'c':	goto yy378;
	case 'P':
	case 'p':	goto yy789;
	default:	goto yy53;
	}
yy682:
	yych = *++YYCURSOR;
	switch (yych) {
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy790;
	default:	goto yy53;
	}
yy683:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy790;
	default:	goto yy53;
	}
yy684:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':	goto yy790;
	default:	goto yy53;
	}
yy685:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy54;
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy774;
	default:	goto yy176;
	}
yy686:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy776;
	case '1':
	case '2':	goto yy777;
	case '3':	goto yy778;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy774;
	default:	goto yy176;
	}
yy687:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy774;
	default:	goto yy176;
	}
yy688:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':	goto yy774;
	case '7':
	case '8':
	case '9':	goto yy54;
	default:	goto yy176;
	}
yy689:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'T':
	case 't':	goto yy225;
	default:	goto yy53;
	}
yy690:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'N':
	case 'n':	goto yy691;
	default:	goto yy53;
	}
yy691:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'I':
	case 'i':	goto yy792;
	default:	goto yy53;
	}
yy692:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'Y':
	case 'y':	goto yy520;
	default:	goto yy53;
	}
yy693:
	++YYCURSOR;
	goto yy223;
yy694:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'R':
	case 'r':	goto yy793;
	default:	goto yy53;
	}
yy695:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'E':
	case 'e':	goto yy362;
	default:	goto yy53;
	}
yy696:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'E':
	case 'e':	goto yy794;
	default:	goto yy53;
	}
yy697:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'D':
	case 'd':	goto yy362;
	default:	goto yy53;
	}
yy698:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':	goto yy538;
	case '.':	goto yy635;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy753;
	case 'A':
	case 'P':
	case 'a':
	case 'p':	goto yy95;
	default:	goto yy192;
	}
yy699:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':	goto yy538;
	case '.':	goto yy635;
	case 'A':
	case 'P':
	case 'a':
	case 'p':	goto yy95;
	default:	goto yy192;
	}
yy700:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy637;
	default:	goto yy638;
	}
yy701:
	yych = *++YYCURSOR;
	switch (yych) {
	case '-':	goto yy795;
	default:	goto yy53;
	}
yy702:
	yych = *++YYCURSOR;
	switch (yych) {
	case '-':	goto yy795;
	case 'T':
	case 't':	goto yy701;
	default:	goto yy53;
	}
yy703:
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '-':	goto yy796;
	case '.':	goto yy425;
	case '0':
	case '1':	goto yy426;
	case '2':	goto yy427;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy428;
	case ':':	goto yy429;
	default:	goto yy282;
	}
yy704:
	++YYCURSOR;
	goto yy275;
yy705:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '/':
	case '_':	goto yy259;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy559;
	default:	goto yy275;
	}
yy706:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy711;
	default:	goto yy129;
	}
yy707:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy797;
	case '6':	goto yy798;
	case '7':
	case '8':
	case '9':	goto yy587;
	default:	goto yy53;
	}
yy708:
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':
	case ':':	goto yy707;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy706;
	default:	goto yy129;
	}
yy709:
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':
	case ':':	goto yy710;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy706;
	default:	goto yy129;
	}
yy710:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy799;
	case '6':	goto yy800;
	case '7':
	case '8':
	case '9':	goto yy801;
	default:	goto yy53;
	}
yy711:
	++YYCURSOR;
	goto yy129;
yy712:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'Y':
	case 'y':	goto yy125;
	default:	goto yy53;
	}
yy713:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'Y':	goto yy125;
	case 'y':	goto yy561;
	default:	goto yy560;
	}
yy714:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'Y':
	case 'y':	goto yy802;
	default:	goto yy53;
	}
yy715:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'R':
	case 'r':	goto yy804;
	default:	goto yy53;
	}
yy716:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'I':
	case 'i':	goto yy805;
	default:	goto yy53;
	}
yy717:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'U':
	case 'u':	goto yy806;
	default:	goto yy53;
	}
yy718:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'N':
	case 'n':	goto yy807;
	default:	goto yy53;
	}
yy719:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'N':
	case 'n':	goto yy808;
	default:	goto yy53;
	}
yy720:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'T':
	case 't':	goto yy809;
	default:	goto yy53;
	}
yy721:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'C':
	case 'c':	goto yy810;
	default:	goto yy53;
	}
yy722:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'N':
	case 'n':	goto yy805;
	default:	goto yy53;
	}
yy723:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'U':
	case 'u':	goto yy811;
	default:	goto yy53;
	}
yy724:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'E':
	case 'e':	goto yy812;
	default:	goto yy53;
	}
yy725:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'D':
	case 'd':	goto yy813;
	case 'E':
	case 'e':	goto yy814;
	default:	goto yy53;
	}
yy726:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy806;
	default:	goto yy53;
	}
yy727:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'Y':	goto yy802;
	case 'y':	goto yy815;
	default:	goto yy560;
	}
yy728:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'R':	goto yy804;
	case 'r':	goto yy816;
	default:	goto yy560;
	}
yy729:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'I':	goto yy805;
	case 'i':	goto yy817;
	default:	goto yy560;
	}
yy730:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'U':	goto yy806;
	case 'u':	goto yy818;
	default:	goto yy560;
	}
yy731:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'N':	goto yy807;
	case 'n':	goto yy819;
	default:	goto yy560;
	}
yy732:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'N':	goto yy808;
	case 'n':	goto yy820;
	default:	goto yy560;
	}
yy733:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'T':	goto yy809;
	case 't':	goto yy821;
	default:	goto yy560;
	}
yy734:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'C':	goto yy810;
	case 'c':	goto yy822;
	default:	goto yy560;
	}
yy735:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'N':	goto yy805;
	case 'n':	goto yy817;
	default:	goto yy560;
	}
yy736:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'U':	goto yy811;
	case 'u':	goto yy823;
	default:	goto yy560;
	}
yy737:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'E':	goto yy812;
	case 'e':	goto yy824;
	default:	goto yy560;
	}
yy738:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'D':	goto yy813;
	case 'E':	goto yy814;
	case 'd':	goto yy825;
	case 'e':	goto yy826;
	default:	goto yy560;
	}
yy739:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':	goto yy806;
	case 'a':	goto yy818;
	default:	goto yy560;
	}
yy740:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'H':
	case 'h':	goto yy827;
	default:	goto yy53;
	}
yy741:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'H':	goto yy827;
	case 'h':	goto yy828;
	default:	goto yy560;
	}
yy742:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'R':
	case 'r':	goto yy125;
	default:	goto yy53;
	}
yy743:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'R':	goto yy125;
	case 'r':	goto yy561;
	default:	goto yy560;
	}
yy744:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'U':
	case 'u':	goto yy829;
	default:	goto yy53;
	}
yy745:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'U':	goto yy829;
	case 'u':	goto yy830;
	default:	goto yy560;
	}
yy746:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'O':
	case 'o':	goto yy831;
	default:	goto yy53;
	}
yy747:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'O':	goto yy831;
	case 'o':	goto yy832;
	default:	goto yy560;
	}
yy748:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'D':
	case 'd':	goto yy833;
	default:	goto yy53;
	}
yy749:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'D':	goto yy833;
	case 'd':	goto yy834;
	default:	goto yy560;
	}
yy750:
	++YYCURSOR;
	goto yy474;
yy751:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy751;
	default:	goto yy192;
	}
yy753:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy835;
	default:	goto yy638;
	}
yy754:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy836;
	default:	goto yy197;
	}
yy755:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy837;
	default:	goto yy53;
	}
yy756:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'P':
	case 'p':	goto yy789;
	default:	goto yy53;
	}
yy757:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':	goto yy838;
	case '3':	goto yy839;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy840;
	default:	goto yy53;
	}
yy758:
	yych = *++YYCURSOR;
	switch (yych) {
	case '-':	goto yy841;
	default:	goto yy53;
	}
yy759:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'R':
	case 'r':	goto yy842;
	default:	goto yy53;
	}
yy760:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'G':
	case 'g':	goto yy843;
	default:	goto yy53;
	}
yy761:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'C':
	case 'c':	goto yy844;
	default:	goto yy53;
	}
yy762:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'B':
	case 'b':	goto yy845;
	default:	goto yy53;
	}
yy763:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'N':
	case 'n':	goto yy846;
	default:	goto yy53;
	}
yy764:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'L':
	case 'l':	goto yy847;
	case 'N':
	case 'n':	goto yy848;
	default:	goto yy53;
	}
yy765:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'R':
	case 'r':	goto yy849;
	case 'Y':
	case 'y':	goto yy850;
	default:	goto yy53;
	}
yy766:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'V':
	case 'v':	goto yy844;
	default:	goto yy53;
	}
yy767:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'T':
	case 't':	goto yy851;
	default:	goto yy53;
	}
yy768:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'P':
	case 'p':	goto yy852;
	default:	goto yy53;
	}
yy769:
	yych = *++YYCURSOR;
	switch (yych) {
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy853;
	default:	goto yy53;
	}
yy770:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy853;
	default:	goto yy53;
	}
yy771:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':	goto yy853;
	default:	goto yy53;
	}
yy772:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':	goto yy854;
	case '3':	goto yy856;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy857;
	default:	goto yy53;
	}
yy773:
	yych = *++YYCURSOR;
	switch (yych) {
	case '/':	goto yy858;
	default:	goto yy53;
	}
yy774:
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case 'D':
	case 'F':
	case 'H':
	case 'M':
	case 'S':
	case 'T':
	case 'W':
	case 'Y':
	case 'd':
	case 'f':
	case 'h':
	case 'm':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy176;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy54;
	default:	goto yy775;
	}
yy775:
#line 1188 "real_world/parse_date.re"
	{
		DEBUG_OUTPUT("pgydotd");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->d = timelib_get_nr((char **) &ptr, 3);
		s->time->m = 1;
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_PG_YEARDAY;
	}
#line 20109 "real_world/parse_date.c"
yy776:
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case 'D':
	case 'F':
	case 'H':
	case 'M':
	case 'S':
	case 'T':
	case 'W':
	case 'Y':
	case 'd':
	case 'f':
	case 'h':
	case 'm':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy176;
	case '0':	goto yy54;
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy859;
	default:	goto yy775;
	}
yy777:
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case 'D':
	case 'F':
	case 'H':
	case 'M':
	case 'S':
	case 'T':
	case 'W':
	case 'Y':
	case 'd':
	case 'f':
	case 'h':
	case 'm':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy176;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy859;
	default:	goto yy775;
	}
yy778:
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case 'D':
	case 'F':
	case 'H':
	case 'M':
	case 'S':
	case 'T':
	case 'W':
	case 'Y':
	case 'd':
	case 'f':
	case 'h':
	case 'm':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy176;
	case '0':
	case '1':	goto yy859;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy54;
	default:	goto yy775;
	}
yy779:
	yych = *++YYCURSOR;
	switch (yych) {
	case ':':	goto yy861;
	default:	goto yy53;
	}
yy780:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case 'I':
	case 'i':	goto yy862;
	default:	goto yy505;
	}
yy781:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case 'U':
	case 'u':	goto yy863;
	default:	goto yy505;
	}
yy782:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case 'E':
	case 'e':	goto yy864;
	default:	goto yy505;
	}
yy783:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case 'R':
	case 'r':	goto yy865;
	default:	goto yy505;
	}
yy784:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case 'U':
	case 'u':	goto yy866;
	default:	goto yy505;
	}
yy785:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'Y':
	case 'y':	goto yy675;
	default:	goto yy505;
	}
yy786:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'E':
	case 'e':	goto yy675;
	default:	goto yy505;
	}
yy787:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case 'C':
	case 'c':	goto yy867;
	default:	goto yy505;
	}
yy788:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case 'O':
	case 'o':	goto yy868;
	default:	goto yy505;
	}
yy789:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'T':
	case 't':	goto yy782;
	default:	goto yy505;
	}
yy790:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':	goto yy869;
	default:	goto yy791;
	}
yy791:
#line 1220 "real_world/parse_date.re"
	{
		timelib_sll w, d;
		DEBUG_OUTPUT("isoweek");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		TIMELIB_HAVE_RELATIVE();
		
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		w = timelib_get_nr((char **) &ptr, 2);
		d = 1;
		s->time->m = 1;
		s->time->d = 1;
		s->time->relative.d = timelib_daynr_from_weeknr(s->time->y, w, d);

		TIMELIB_DEINIT;
		return TIMELIB_ISO_WEEK;
	}
#line 20324 "real_world/parse_date.c"
yy792:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'G':
	case 'g':	goto yy871;
	default:	goto yy53;
	}
yy793:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'Y':
	case 'y':	goto yy225;
	default:	goto yy53;
	}
yy794:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'R':
	case 'r':	goto yy225;
	default:	goto yy53;
	}
yy795:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy872;
	case '1':
	case '2':	goto yy873;
	case '3':	goto yy874;
	default:	goto yy53;
	}
yy796:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy875;
	default:	goto yy53;
	}
yy797:
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':
	case ':':	goto yy710;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy877;
	default:	goto yy586;
	}
yy798:
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':
	case ':':	goto yy710;
	case '0':	goto yy878;
	default:	goto yy586;
	}
yy799:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy878;
	default:	goto yy586;
	}
yy800:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy878;
	default:	goto yy586;
	}
yy801:
	++YYCURSOR;
	goto yy586;
yy802:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'S':
	case 's':	goto yy879;
	default:	goto yy803;
	}
yy803:
#line 1324 "real_world/parse_date.re"
	{
		timelib_sll i;
		int         behavior;
		DEBUG_OUTPUT("relativetext");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		while(*ptr) {
			i = timelib_get_relative_text((char **) &ptr, &behavior);
			timelib_eat_spaces((char **) &ptr);
			timelib_set_relative((char **) &ptr, i, behavior, s);
		}
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 20445 "real_world/parse_date.c"
yy804:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'T':
	case 't':	goto yy880;
	default:	goto yy53;
	}
yy805:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case 'D':
	case 'd':	goto yy881;
	default:	goto yy803;
	}
yy806:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'R':
	case 'r':	goto yy802;
	default:	goto yy53;
	}
yy807:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case 'S':
	case 's':	goto yy879;
	case 'U':
	case 'u':	goto yy882;
	default:	goto yy803;
	}
yy808:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case 'D':
	case 'd':	goto yy881;
	case 'T':
	case 't':	goto yy883;
	default:	goto yy803;
	}
yy809:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case 'U':
	case 'u':	goto yy884;
	default:	goto yy803;
	}
yy810:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case 'O':
	case 'o':	goto yy885;
	case 'S':
	case 's':	goto yy879;
	default:	goto yy803;
	}
yy811:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case 'R':
	case 'r':	goto yy886;
	default:	goto yy803;
	}
yy812:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case 'S':
	case 's':	goto yy887;
	default:	goto yy803;
	}
yy813:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case 'N':
	case 'n':	goto yy888;
	default:	goto yy803;
	}
yy814:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'K':
	case 'k':	goto yy802;
	default:	goto yy53;
	}
yy815:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '/':
	case '_':	goto yy259;
	case 'S':	goto yy879;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy559;
	case 's':	goto yy889;
	default:	goto yy803;
	}
yy816:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'T':	goto yy880;
	case 't':	goto yy890;
	default:	goto yy560;
	}
yy817:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '/':
	case '_':	goto yy259;
	case 'D':	goto yy881;
	case 'a':
	case 'b':
	case 'c':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy559;
	case 'd':	goto yy891;
	default:	goto yy803;
	}
yy818:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'R':	goto yy802;
	case 'r':	goto yy815;
	default:	goto yy560;
	}
yy819:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '/':
	case '_':	goto yy259;
	case 'S':	goto yy879;
	case 'U':	goto yy882;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 't':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy559;
	case 's':	goto yy889;
	case 'u':	goto yy892;
	default:	goto yy803;
	}
yy820:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '/':
	case '_':	goto yy259;
	case 'D':	goto yy881;
	case 'T':	goto yy883;
	case 'a':
	case 'b':
	case 'c':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy559;
	case 'd':	goto yy891;
	case 't':	goto yy893;
	default:	goto yy803;
	}
yy821:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '/':
	case '_':	goto yy259;
	case 'U':	goto yy884;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy559;
	case 'u':	goto yy894;
	default:	goto yy803;
	}
yy822:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '/':
	case '_':	goto yy259;
	case 'O':	goto yy885;
	case 'S':	goto yy879;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy559;
	case 'o':	goto yy895;
	case 's':	goto yy889;
	default:	goto yy803;
	}
yy823:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '/':
	case '_':	goto yy259;
	case 'R':	goto yy886;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy559;
	case 'r':	goto yy896;
	default:	goto yy803;
	}
yy824:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '/':
	case '_':	goto yy259;
	case 'S':	goto yy887;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy559;
	case 's':	goto yy897;
	default:	goto yy803;
	}
yy825:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '/':
	case '_':	goto yy259;
	case 'N':	goto yy888;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy559;
	case 'n':	goto yy898;
	default:	goto yy803;
	}
yy826:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'K':	goto yy802;
	case 'k':	goto yy815;
	default:	goto yy560;
	}
yy827:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'T':
	case 't':	goto yy621;
	default:	goto yy53;
	}
yy828:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'T':	goto yy621;
	case 't':	goto yy625;
	default:	goto yy560;
	}
yy829:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'S':
	case 's':	goto yy565;
	default:	goto yy53;
	}
yy830:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'S':	goto yy565;
	case 's':	goto yy568;
	default:	goto yy560;
	}
yy831:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'W':
	case 'w':	goto yy899;
	default:	goto yy53;
	}
yy832:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'W':	goto yy899;
	case 'w':	goto yy901;
	default:	goto yy560;
	}
yy833:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy902;
	default:	goto yy53;
	}
yy834:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':	goto yy902;
	case 'a':	goto yy903;
	default:	goto yy560;
	}
yy835:
	++YYCURSOR;
	goto yy638;
yy836:
	++YYCURSOR;
	goto yy197;
yy837:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy904;
	default:	goto yy53;
	}
yy838:
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy840;
	case 'T':	goto yy905;
	case 'n':
	case 'r':	goto yy906;
	case 's':	goto yy907;
	case 't':	goto yy908;
	default:	goto yy474;
	}
yy839:
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '0':
	case '1':	goto yy840;
	case 'T':	goto yy905;
	case 'n':
	case 'r':	goto yy906;
	case 's':	goto yy907;
	case 't':	goto yy908;
	default:	goto yy474;
	}
yy840:
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case 'T':	goto yy905;
	case 'n':
	case 'r':	goto yy906;
	case 's':	goto yy907;
	case 't':	goto yy908;
	default:	goto yy474;
	}
yy841:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy909;
	case '1':
	case '2':	goto yy910;
	case '3':	goto yy911;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy840;
	default:	goto yy53;
	}
yy842:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '-':	goto yy795;
	case 'I':
	case 'i':	goto yy862;
	default:	goto yy505;
	}
yy843:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '-':	goto yy795;
	case 'U':
	case 'u':	goto yy863;
	default:	goto yy505;
	}
yy844:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '-':	goto yy795;
	case 'E':
	case 'e':	goto yy864;
	default:	goto yy505;
	}
yy845:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '-':	goto yy795;
	case 'R':
	case 'r':	goto yy865;
	default:	goto yy505;
	}
yy846:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '-':	goto yy795;
	case 'U':
	case 'u':	goto yy866;
	default:	goto yy505;
	}
yy847:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '-':	goto yy795;
	case 'Y':
	case 'y':	goto yy675;
	default:	goto yy505;
	}
yy848:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '-':	goto yy795;
	case 'E':
	case 'e':	goto yy675;
	default:	goto yy505;
	}
yy849:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '-':	goto yy795;
	case 'C':
	case 'c':	goto yy867;
	default:	goto yy505;
	}
yy850:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '-':	goto yy795;
	default:	goto yy505;
	}
yy851:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '-':	goto yy795;
	case 'O':
	case 'o':	goto yy868;
	default:	goto yy505;
	}
yy852:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '-':	goto yy795;
	case 'T':
	case 't':	goto yy844;
	default:	goto yy505;
	}
yy853:
	++YYCURSOR;
	goto yy775;
yy854:
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy857;
	case 'n':
	case 'r':	goto yy912;
	case 's':	goto yy913;
	case 't':	goto yy914;
	default:	goto yy855;
	}
yy855:
#line 1049 "real_world/parse_date.re"
	{
		DEBUG_OUTPUT("iso8601date | iso8601dateslash | dateslash");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
#line 21145 "real_world/parse_date.c"
yy856:
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '0':
	case '1':	goto yy857;
	case 'n':
	case 'r':	goto yy912;
	case 's':	goto yy913;
	case 't':	goto yy914;
	default:	goto yy855;
	}
yy857:
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case 'n':
	case 'r':	goto yy912;
	case 's':	goto yy913;
	case 't':	goto yy914;
	default:	goto yy855;
	}
yy858:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy915;
	case '1':
	case '2':	goto yy916;
	case '3':	goto yy917;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy857;
	default:	goto yy53;
	}
yy859:
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':	goto yy175;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy54;
	case 'D':
	case 'd':	goto yy177;
	case 'F':
	case 'f':	goto yy178;
	case 'H':
	case 'h':	goto yy72;
	case 'M':
	case 'm':	goto yy179;
	case 'S':
	case 's':	goto yy180;
	case 'T':	goto yy918;
	case 'W':
	case 'w':	goto yy82;
	case 'Y':
	case 'y':	goto yy84;
	case 't':	goto yy919;
	default:	goto yy860;
	}
yy860:
#line 1152 "real_world/parse_date.re"
	{
		DEBUG_OUTPUT("datenocolon");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NOCOLON;
	}
#line 21228 "real_world/parse_date.c"
yy861:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy920;
	case '1':
	case '2':	goto yy921;
	case '3':	goto yy922;
	default:	goto yy53;
	}
yy862:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'L':
	case 'l':	goto yy675;
	default:	goto yy53;
	}
yy863:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'S':
	case 's':	goto yy923;
	default:	goto yy53;
	}
yy864:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'M':
	case 'm':	goto yy868;
	default:	goto yy53;
	}
yy865:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'U':
	case 'u':	goto yy866;
	default:	goto yy53;
	}
yy866:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy924;
	default:	goto yy53;
	}
yy867:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'H':
	case 'h':	goto yy675;
	default:	goto yy53;
	}
yy868:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'B':
	case 'b':	goto yy925;
	default:	goto yy53;
	}
yy869:
	++YYCURSOR;
#line 1201 "real_world/parse_date.re"
	{
		timelib_sll w, d;
		DEBUG_OUTPUT("isoweekday");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		TIMELIB_HAVE_RELATIVE();
		
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		w = timelib_get_nr((char **) &ptr, 2);
		d = timelib_get_nr((char **) &ptr, 1);
		s->time->m = 1;
		s->time->d = 1;
		s->time->relative.d = timelib_daynr_from_weeknr(s->time->y, w, d);

		TIMELIB_DEINIT;
		return TIMELIB_ISO_WEEK;
	}
#line 21307 "real_world/parse_date.c"
yy871:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'H':
	case 'h':	goto yy926;
	default:	goto yy53;
	}
yy872:
	yych = *++YYCURSOR;
	switch (yych) {
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy927;
	default:	goto yy53;
	}
yy873:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy927;
	default:	goto yy53;
	}
yy874:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':	goto yy927;
	default:	goto yy53;
	}
yy875:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy929;
	default:	goto yy876;
	}
yy876:
#line 1239 "real_world/parse_date.re"
	{
		DEBUG_OUTPUT("pgtextshort");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_PG_TEXT;
	}
#line 21379 "real_world/parse_date.c"
yy877:
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':	goto yy930;
	case '(':	goto yy932;
	case '+':
	case '-':	goto yy933;
	case '.':
	case ':':	goto yy710;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy934;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy935;
	default:	goto yy586;
	}
yy878:
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':	goto yy930;
	case '(':	goto yy932;
	case '+':
	case '-':	goto yy933;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy934;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy935;
	default:	goto yy586;
	}
yy879:
	++YYCURSOR;
	goto yy803;
yy880:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'H':
	case 'h':	goto yy936;
	case 'N':
	case 'n':	goto yy937;
	default:	goto yy53;
	}
yy881:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy938;
	default:	goto yy53;
	}
yy882:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'T':
	case 't':	goto yy939;
	default:	goto yy53;
	}
yy883:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'H':
	case 'h':	goto yy802;
	default:	goto yy53;
	}
yy884:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'R':
	case 'r':	goto yy887;
	default:	goto yy53;
	}
yy885:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'N':
	case 'n':	goto yy940;
	default:	goto yy53;
	}
yy886:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'S':
	case 's':	goto yy887;
	default:	goto yy53;
	}
yy887:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'D':
	case 'd':	goto yy881;
	default:	goto yy53;
	}
yy888:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'E':
	case 'e':	goto yy886;
	default:	goto yy53;
	}
yy889:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '/':
	case '_':	goto yy259;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy559;
	default:	goto yy803;
	}
yy890:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'H':	goto yy936;
	case 'N':	goto yy937;
	case 'h':	goto yy941;
	case 'n':	goto yy942;
	default:	goto yy560;
	}
yy891:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':	goto yy938;
	case 'a':	goto yy943;
	default:	goto yy560;
	}
yy892:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'T':	goto yy939;
	case 't':	goto yy944;
	default:	goto yy560;
	}
yy893:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'H':	goto yy802;
	case 'h':	goto yy815;
	default:	goto yy560;
	}
yy894:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'R':	goto yy887;
	case 'r':	goto yy897;
	default:	goto yy560;
	}
yy895:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'N':	goto yy940;
	case 'n':	goto yy945;
	default:	goto yy560;
	}
yy896:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'S':	goto yy887;
	case 's':	goto yy897;
	default:	goto yy560;
	}
yy897:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'D':	goto yy881;
	case 'd':	goto yy891;
	default:	goto yy560;
	}
yy898:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'E':	goto yy886;
	case 'e':	goto yy896;
	default:	goto yy560;
	}
yy899:
	++YYCURSOR;
yy900:
#line 894 "real_world/parse_date.re"
	{
		DEBUG_OUTPUT("tomorrow");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_TIME();

		s->time->relative.d = 1;
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 21687 "real_world/parse_date.c"
yy901:
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '/':
	case '_':	goto yy259;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy559;
	default:	goto yy900;
	}
yy902:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'Y':
	case 'y':	goto yy946;
	default:	goto yy53;
	}
yy903:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'Y':	goto yy946;
	case 'y':	goto yy948;
	default:	goto yy560;
	}
yy904:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy949;
	default:	goto yy53;
	}
yy905:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':	goto yy950;
	case '2':	goto yy951;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy952;
	default:	goto yy53;
	}
yy906:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'd':	goto yy953;
	default:	goto yy53;
	}
yy907:
	yych = *++YYCURSOR;
	switch (yych) {
	case 't':	goto yy953;
	default:	goto yy53;
	}
yy908:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'h':	goto yy953;
	default:	goto yy53;
	}
yy909:
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '0':	goto yy840;
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy954;
	case 'T':	goto yy905;
	case 'n':
	case 'r':	goto yy906;
	case 's':	goto yy907;
	case 't':	goto yy908;
	default:	goto yy474;
	}
yy910:
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy954;
	case 'T':	goto yy905;
	case 'n':
	case 'r':	goto yy906;
	case 's':	goto yy907;
	case 't':	goto yy908;
	default:	goto yy474;
	}
yy911:
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '0':
	case '1':	goto yy954;
	case 'T':	goto yy905;
	case 'n':
	case 'r':	goto yy906;
	case 's':	goto yy907;
	case 't':	goto yy908;
	default:	goto yy474;
	}
yy912:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'd':	goto yy955;
	default:	goto yy53;
	}
yy913:
	yych = *++YYCURSOR;
	switch (yych) {
	case 't':	goto yy955;
	default:	goto yy53;
	}
yy914:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'h':	goto yy955;
	default:	goto yy53;
	}
yy915:
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '0':	goto yy857;
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy956;
	case 'n':
	case 'r':	goto yy912;
	case 's':	goto yy913;
	case 't':	goto yy914;
	default:	goto yy855;
	}
yy916:
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy956;
	case 'n':
	case 'r':	goto yy912;
	case 's':	goto yy913;
	case 't':	goto yy914;
	default:	goto yy855;
	}
yy917:
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '0':
	case '1':	goto yy956;
	case 'n':
	case 'r':	goto yy912;
	case 's':	goto yy913;
	case 't':	goto yy914;
	default:	goto yy855;
	}
yy918:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':	goto yy957;
	case '2':	goto yy958;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy959;
	case 'H':
	case 'h':	goto yy236;
	case 'U':
	case 'u':	goto yy237;
	default:	goto yy53;
	}
yy919:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':	goto yy960;
	case '2':	goto yy961;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy962;
	case 'H':
	case 'h':	goto yy236;
	case 'U':
	case 'u':	goto yy237;
	default:	goto yy53;
	}
yy920:
	yych = *++YYCURSOR;
	switch (yych) {
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy963;
	default:	goto yy53;
	}
yy921:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy963;
	default:	goto yy53;
	}
yy922:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':	goto yy963;
	default:	goto yy53;
	}
yy923:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'T':
	case 't':	goto yy675;
	default:	goto yy53;
	}
yy924:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'R':
	case 'r':	goto yy964;
	default:	goto yy53;
	}
yy925:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'E':
	case 'e':	goto yy965;
	default:	goto yy53;
	}
yy926:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'T':
	case 't':	goto yy362;
	default:	goto yy53;
	}
yy927:
	++YYCURSOR;
#line 1252 "real_world/parse_date.re"
	{
		DEBUG_OUTPUT("pgtextreverse");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_PG_TEXT;
	}
#line 22025 "real_world/parse_date.c"
yy929:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy966;
	default:	goto yy876;
	}
yy930:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 6) YYFILL(6);
	yych = *YYCURSOR;
	switch (yych) {
	case ' ':	goto yy930;
	case '(':	goto yy932;
	case '+':
	case '-':	goto yy933;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy934;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy935;
	default:	goto yy53;
	}
yy932:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy935;
	default:	goto yy53;
	}
yy933:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':	goto yy967;
	case '2':	goto yy968;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy969;
	default:	goto yy53;
	}
yy934:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy801;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy970;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy971;
	default:	goto yy586;
	}
yy935:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy801;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy970;
	default:	goto yy586;
	}
yy936:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'N':
	case 'n':	goto yy937;
	default:	goto yy53;
	}
yy937:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'I':
	case 'i':	goto yy972;
	default:	goto yy53;
	}
yy938:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'Y':
	case 'y':	goto yy879;
	default:	goto yy53;
	}
yy939:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'E':
	case 'e':	goto yy802;
	default:	goto yy53;
	}
yy940:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'D':
	case 'd':	goto yy802;
	default:	goto yy53;
	}
yy941:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'N':	goto yy937;
	case 'n':	goto yy942;
	default:	goto yy560;
	}
yy942:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'I':	goto yy972;
	case 'i':	goto yy973;
	default:	goto yy560;
	}
yy943:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'Y':	goto yy879;
	case 'y':	goto yy889;
	default:	goto yy560;
	}
yy944:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'E':	goto yy802;
	case 'e':	goto yy815;
	default:	goto yy560;
	}
yy945:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'D':	goto yy802;
	case 'd':	goto yy815;
	default:	goto yy560;
	}
yy946:
	++YYCURSOR;
yy947:
#line 851 "real_world/parse_date.re"
	{
		DEBUG_OUTPUT("yesterday");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_TIME();

		s->time->relative.d = -1;
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 22376 "real_world/parse_date.c"
yy948:
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '/':
	case '_':	goto yy259;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy559;
	default:	goto yy947;
	}
yy949:
	yych = *++YYCURSOR;
	switch (yych) {
	case ':':	goto yy974;
	default:	goto yy53;
	}
yy950:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy952;
	case ':':	goto yy975;
	default:	goto yy53;
	}
yy951:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':	goto yy952;
	case ':':	goto yy975;
	default:	goto yy53;
	}
yy952:
	yych = *++YYCURSOR;
	switch (yych) {
	case ':':	goto yy975;
	default:	goto yy53;
	}
yy953:
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case 'T':	goto yy905;
	default:	goto yy474;
	}
yy954:
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case 'T':	goto yy976;
	case 'n':
	case 'r':	goto yy906;
	case 's':	goto yy907;
	case 't':	goto yy908;
	default:	goto yy855;
	}
yy955:
	++YYCURSOR;
	goto yy855;
yy956:
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '/':	goto yy955;
	case 'n':
	case 'r':	goto yy912;
	case 's':	goto yy913;
	case 't':	goto yy914;
	default:	goto yy855;
	}
yy957:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy977;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy959;
	case ':':	goto yy978;
	default:	goto yy53;
	}
yy958:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':	goto yy977;
	case '4':
	case '5':	goto yy979;
	case ':':	goto yy978;
	default:	goto yy53;
	}
yy959:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy979;
	case ':':	goto yy978;
	default:	goto yy53;
	}
yy960:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy980;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy962;
	default:	goto yy53;
	}
yy961:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':	goto yy980;
	case '4':
	case '5':	goto yy979;
	default:	goto yy53;
	}
yy962:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy979;
	default:	goto yy53;
	}
yy963:
	yych = *++YYCURSOR;
	switch (yych) {
	case ' ':	goto yy981;
	default:	goto yy53;
	}
yy964:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'Y':
	case 'y':	goto yy675;
	default:	goto yy53;
	}
yy965:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'R':
	case 'r':	goto yy675;
	default:	goto yy53;
	}
yy966:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy982;
	default:	goto yy876;
	}
yy967:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy969;
	case ':':	goto yy983;
	default:	goto yy586;
	}
yy968:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':	goto yy969;
	case '4':
	case '5':	goto yy984;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy801;
	case ':':	goto yy983;
	default:	goto yy586;
	}
yy969:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy984;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy801;
	case ':':	goto yy983;
	default:	goto yy586;
	}
yy970:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy801;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy985;
	default:	goto yy586;
	}
yy971:
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy801;
	case '/':
	case '_':	goto yy986;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy985;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy987;
	default:	goto yy586;
	}
yy972:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'G':
	case 'g':	goto yy988;
	default:	goto yy53;
	}
yy973:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'G':	goto yy988;
	case 'g':	goto yy989;
	default:	goto yy560;
	}
yy974:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':	goto yy990;
	case '2':	goto yy991;
	default:	goto yy53;
	}
yy975:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy992;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy993;
	default:	goto yy53;
	}
yy976:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':	goto yy994;
	case '2':	goto yy995;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy952;
	default:	goto yy53;
	}
yy977:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy996;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy997;
	case ':':	goto yy978;
	default:	goto yy53;
	}
yy978:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy998;
	default:	goto yy53;
	}
yy979:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy997;
	default:	goto yy53;
	}
yy980:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy996;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy997;
	default:	goto yy53;
	}
yy981:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':	goto yy999;
	case '2':	goto yy1000;
	default:	goto yy53;
	}
yy982:
	++YYCURSOR;
	goto yy876;
yy983:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy984;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy801;
	default:	goto yy586;
	}
yy984:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy801;
	default:	goto yy586;
	}
yy985:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy801;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy1001;
	default:	goto yy586;
	}
yy986:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	switch (yych) {
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy1002;
	default:	goto yy53;
	}
yy987:
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy801;
	case '/':
	case '_':	goto yy986;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy1001;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy1003;
	default:	goto yy586;
	}
yy988:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'H':
	case 'h':	goto yy1004;
	default:	goto yy53;
	}
yy989:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'H':	goto yy1004;
	case 'h':	goto yy1005;
	default:	goto yy560;
	}
yy990:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1006;
	default:	goto yy53;
	}
yy991:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':	goto yy1006;
	default:	goto yy53;
	}
yy992:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy993;
	case ':':	goto yy1007;
	default:	goto yy53;
	}
yy993:
	yych = *++YYCURSOR;
	switch (yych) {
	case ':':	goto yy1007;
	default:	goto yy53;
	}
yy994:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1008;
	case ':':	goto yy975;
	default:	goto yy53;
	}
yy995:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':	goto yy1008;
	case ':':	goto yy975;
	default:	goto yy53;
	}
yy996:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy1007;
	case '6':	goto yy1009;
	case '7':
	case '8':
	case '9':	goto yy997;
	default:	goto yy53;
	}
yy997:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy1010;
	case '6':	goto yy1011;
	default:	goto yy53;
	}
yy998:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1012;
	default:	goto yy53;
	}
yy999:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1013;
	default:	goto yy53;
	}
yy1000:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':	goto yy1013;
	default:	goto yy53;
	}
yy1001:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy801;
	default:	goto yy586;
	}
yy1002:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	switch (yych) {
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy1014;
	default:	goto yy53;
	}
yy1003:
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy801;
	case '/':
	case '_':	goto yy986;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy1016;
	default:	goto yy586;
	}
yy1004:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'T':
	case 't':	goto yy802;
	default:	goto yy53;
	}
yy1005:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'T':	goto yy802;
	case 't':	goto yy815;
	default:	goto yy560;
	}
yy1006:
	yych = *++YYCURSOR;
	switch (yych) {
	case ':':	goto yy1018;
	default:	goto yy53;
	}
yy1007:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy1019;
	case '6':	goto yy1021;
	case '7':
	case '8':
	case '9':	goto yy1022;
	default:	goto yy53;
	}
yy1008:
	yych = *++YYCURSOR;
	switch (yych) {
	case ':':	goto yy1023;
	default:	goto yy53;
	}
yy1009:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy1019;
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy1010;
	case '6':	goto yy1011;
	default:	goto yy53;
	}
yy1010:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1022;
	default:	goto yy53;
	}
yy1011:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy1022;
	default:	goto yy53;
	}
yy1012:
	yych = *++YYCURSOR;
	switch (yych) {
	case ':':	goto yy997;
	default:	goto yy53;
	}
yy1013:
	yych = *++YYCURSOR;
	switch (yych) {
	case ':':	goto yy978;
	default:	goto yy53;
	}
yy1014:
	yyaccept = 16;
	YYMARKER = ++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	switch (yych) {
	case '/':
	case '_':	goto yy986;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy1014;
	default:	goto yy586;
	}
yy1016:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	switch (yych) {
	case '/':
	case '_':	goto yy986;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy1016;
	default:	goto yy53;
	}
yy1018:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy1024;
	default:	goto yy53;
	}
yy1019:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1022;
	default:	goto yy1020;
	}
yy1020:
#line 1164 "real_world/parse_date.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("xmlrpc | xmlrpcnocolon | soap | wddx | exif");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		s->time->s = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == '.') {
			s->time->f = timelib_get_frac_nr((char **) &ptr, 9);
			if (*ptr) { /* timezone is optional */
				s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
				s->errors += tz_not_found;
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_XMLRPC_SOAP;
	}
#line 23495 "real_world/parse_date.c"
yy1021:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy1022;
	default:	goto yy1020;
	}
yy1022:
	++YYCURSOR;
	goto yy1020;
yy1023:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy1025;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy993;
	default:	goto yy53;
	}
yy1024:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1026;
	default:	goto yy53;
	}
yy1025:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1027;
	case ':':	goto yy1007;
	default:	goto yy53;
	}
yy1026:
	yych = *++YYCURSOR;
	switch (yych) {
	case ':':	goto yy1028;
	default:	goto yy53;
	}
yy1027:
	yych = *++YYCURSOR;
	switch (yych) {
	case ':':	goto yy1029;
	default:	goto yy53;
	}
yy1028:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy1030;
	case '6':	goto yy1031;
	default:	goto yy53;
	}
yy1029:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy1032;
	case '6':	goto yy1033;
	case '7':
	case '8':
	case '9':	goto yy1022;
	default:	goto yy53;
	}
yy1030:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1034;
	default:	goto yy53;
	}
yy1031:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy1034;
	default:	goto yy53;
	}
yy1032:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1035;
	default:	goto yy1020;
	}
yy1033:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy1035;
	default:	goto yy1020;
	}
yy1034:
	yych = *++YYCURSOR;
	switch (yych) {
	case ' ':	goto yy1036;
	default:	goto yy53;
	}
yy1035:
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':	goto yy1038;
	default:	goto yy1020;
	}
yy1036:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 6) YYFILL(6);
	yych = *YYCURSOR;
	switch (yych) {
	case ' ':	goto yy1036;
	case '+':
	case '-':	goto yy1039;
	default:	goto yy53;
	}
yy1038:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1040;
	default:	goto yy53;
	}
yy1039:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':	goto yy1042;
	case '2':	goto yy1044;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1045;
	default:	goto yy53;
	}
yy1040:
	yyaccept = 26;
	YYMARKER = ++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 6) YYFILL(6);
	yych = *YYCURSOR;
	switch (yych) {
	case '+':
	case '-':	goto yy1046;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1040;
	default:	goto yy1020;
	}
yy1042:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1045;
	case ':':	goto yy1047;
	default:	goto yy1043;
	}
yy1043:
#line 1265 "real_world/parse_date.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("clf");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		s->time->s = timelib_get_nr((char **) &ptr, 2);
		s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
		s->errors += tz_not_found;
		TIMELIB_DEINIT;
		return TIMELIB_CLF;
	}
#line 23740 "real_world/parse_date.c"
yy1044:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':	goto yy1045;
	case '4':
	case '5':	goto yy1048;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1049;
	case ':':	goto yy1047;
	default:	goto yy1043;
	}
yy1045:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy1048;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1049;
	case ':':	goto yy1047;
	default:	goto yy1043;
	}
yy1046:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':	goto yy1050;
	case '2':	goto yy1051;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1052;
	default:	goto yy53;
	}
yy1047:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy1048;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1049;
	default:	goto yy1043;
	}
yy1048:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1049;
	default:	goto yy1043;
	}
yy1049:
	++YYCURSOR;
	goto yy1043;
yy1050:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1052;
	case ':':	goto yy1053;
	default:	goto yy1020;
	}
yy1051:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':	goto yy1052;
	case '4':
	case '5':	goto yy1019;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1022;
	case ':':	goto yy1053;
	default:	goto yy1020;
	}
yy1052:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy1019;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1022;
	case ':':	goto yy1053;
	default:	goto yy1020;
	}
yy1053:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy1019;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1022;
	default:	goto yy1020;
	}
}
#line 1412 "real_world/parse_date.re"

}

#line 23889 "real_world/parse_date.c"
#define YYMAXFILL 26
#line 1415 "real_world/parse_date.re"


timelib_time* timelib_strtotime(char *s, int len, int *errors, timelib_tzdb *tzdb)
{
	Scanner in;
	int t;
	char *e = s + len - 1;

	while (isspace(*s) && s < e) {
		s++;
	}
	while (isspace(*e) && e > s) {
		e--;
	}
	if (e - s < 1) {
		*errors = 1;
		in.time = timelib_time_ctor();
		in.time->y = in.time->d = in.time->m = in.time->h = in.time->i = in.time->s = in.time->f = in.time->z = in.time->dst = -1;
		in.time->is_localtime = in.time->zone_type = 0;
		return in.time;
	}
	e++;

	memset(&in, 0, sizeof(in));
	in.str = malloc((e - s) + YYMAXFILL);
	memset(in.str, 0, (e - s) + YYMAXFILL);
	memcpy(in.str, s, (e - s));
	in.lim = in.str + (e - s) + YYMAXFILL;
	in.cur = in.str;
	in.time = timelib_time_ctor();
	in.time->y = -1;
	in.time->d = -1;
	in.time->m = -1;
	in.time->h = -1;
	in.time->i = -1;
	in.time->s = -1;
	in.time->f = -1;
	in.time->z = -1;
	in.time->dst = -1;
	in.errors = 0;
	in.tzdb = tzdb;
	in.time->is_localtime = 0;
	in.time->zone_type = 0;

	do {
		t = scan(&in);
#ifdef DEBUG_PARSER
		printf("%d\n", t);
#endif
	} while(t != EOI);

	free(in.str);
	*errors = in.errors;
	return in.time;
}

void timelib_fill_holes(timelib_time *parsed, timelib_time *now, int options)
{
	if (!(options && TIMELIB_OVERRIDE_TIME) && parsed->have_date && !parsed->have_time) {
		parsed->h = 0;
		parsed->i = 0;
		parsed->s = 0;
		parsed->f = 0;
	}
	if (parsed->y == -1) parsed->y = now->y != -1 ? now->y : 0;
	if (parsed->d == -1) parsed->d = now->d != -1 ? now->d : 0;
	if (parsed->m == -1) parsed->m = now->m != -1 ? now->m : 0;
	if (parsed->h == -1) parsed->h = now->h != -1 ? now->h : 0;
	if (parsed->i == -1) parsed->i = now->i != -1 ? now->i : 0;
	if (parsed->s == -1) parsed->s = now->s != -1 ? now->s : 0;
	if (parsed->f == -1) parsed->f = now->f != -1 ? now->f : 0;
	if (parsed->z == -1) parsed->z = now->z != -1 ? now->z : 0;
	if (parsed->dst == -1) parsed->dst = now->dst != -1 ? now->dst : 0;

	if (!parsed->tz_abbr) {
		parsed->tz_abbr = now->tz_abbr ? strdup(now->tz_abbr) : NULL;
	}
	if (!parsed->tz_info) {
		parsed->tz_info = now->tz_info ? timelib_tzinfo_clone(now->tz_info) : NULL;
	}
	if (parsed->zone_type == 0 && now->zone_type != 0) {
		parsed->zone_type = now->zone_type;
/*		parsed->tz_abbr = now->tz_abbr ? strdup(now->tz_abbr) : NULL;
		parsed->tz_info = now->tz_info ? timelib_tzinfo_clone(now->tz_info) : NULL;
*/		parsed->is_localtime = 1;
	}
/*	timelib_dump_date(parsed, 2);
	timelib_dump_date(now, 2);
*/
}

char *timelib_timezone_id_from_abbr(const char *abbr, long gmtoffset, int isdst)
{
	timelib_tz_lookup_table *tp;

	tp = zone_search(abbr, gmtoffset, isdst);
	if (tp) {
		return (tp->full_tz_name);
	} else {
		return NULL;
	}
}

timelib_tz_lookup_table *timelib_timezone_abbreviations_list(void)
{
	return timelib_timezone_lookup;
}

#ifdef DEBUG_PARSER_STUB
int main(void)
{
	timelib_time time = timelib_strtotime("May 12");

	printf ("%04d-%02d-%02d %02d:%02d:%02d.%-5d %+04d %1d",
		time.y, time.m, time.d, time.h, time.i, time.s, time.f, time.z, time.dst);
	if (time.have_relative) {
		printf ("%3dY %3dM %3dD / %3dH %3dM %3dS", 
			time.relative.y, time.relative.m, time.relative.d, time.relative.h, time.relative.i, time.relative.s);
	}
	if (time.have_weekday_relative) {
		printf (" / %d", time.relative.weekday);
	}
	if (time.have_weeknr_day) {
		printf(" / %dW%d", time.relative.weeknr_day.weeknr, time.relative.weeknr_day.dayofweek);
	}
	return 0;				
}
#endif

/*
 * vim: syntax=c
 */
