/* system-segment-dictionary.c generated by valac 0.26.0.83-ed603, the Vala compiler
 * generated from system-segment-dictionary.vala, do not modify */

/*
 * Copyright (C) 2011-2014 Daiki Ueno <ueno@gnu.org>
 * Copyright (C) 2011-2014 Red Hat, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gee.h>


#define KKC_TYPE_DICTIONARY (kkc_dictionary_get_type ())
#define KKC_DICTIONARY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_DICTIONARY, KkcDictionary))
#define KKC_IS_DICTIONARY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_DICTIONARY))
#define KKC_DICTIONARY_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), KKC_TYPE_DICTIONARY, KkcDictionaryIface))

typedef struct _KkcDictionary KkcDictionary;
typedef struct _KkcDictionaryIface KkcDictionaryIface;

#define KKC_TYPE_SEGMENT_DICTIONARY (kkc_segment_dictionary_get_type ())
#define KKC_SEGMENT_DICTIONARY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_SEGMENT_DICTIONARY, KkcSegmentDictionary))
#define KKC_IS_SEGMENT_DICTIONARY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_SEGMENT_DICTIONARY))
#define KKC_SEGMENT_DICTIONARY_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), KKC_TYPE_SEGMENT_DICTIONARY, KkcSegmentDictionaryIface))

typedef struct _KkcSegmentDictionary KkcSegmentDictionary;
typedef struct _KkcSegmentDictionaryIface KkcSegmentDictionaryIface;

#define KKC_TYPE_CANDIDATE (kkc_candidate_get_type ())
#define KKC_CANDIDATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_CANDIDATE, KkcCandidate))
#define KKC_CANDIDATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_CANDIDATE, KkcCandidateClass))
#define KKC_IS_CANDIDATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_CANDIDATE))
#define KKC_IS_CANDIDATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_CANDIDATE))
#define KKC_CANDIDATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_CANDIDATE, KkcCandidateClass))

typedef struct _KkcCandidate KkcCandidate;
typedef struct _KkcCandidateClass KkcCandidateClass;

#define KKC_TYPE_SYSTEM_SEGMENT_DICTIONARY (kkc_system_segment_dictionary_get_type ())
#define KKC_SYSTEM_SEGMENT_DICTIONARY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_SYSTEM_SEGMENT_DICTIONARY, KkcSystemSegmentDictionary))
#define KKC_SYSTEM_SEGMENT_DICTIONARY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_SYSTEM_SEGMENT_DICTIONARY, KkcSystemSegmentDictionaryClass))
#define KKC_IS_SYSTEM_SEGMENT_DICTIONARY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_SYSTEM_SEGMENT_DICTIONARY))
#define KKC_IS_SYSTEM_SEGMENT_DICTIONARY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_SYSTEM_SEGMENT_DICTIONARY))
#define KKC_SYSTEM_SEGMENT_DICTIONARY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_SYSTEM_SEGMENT_DICTIONARY, KkcSystemSegmentDictionaryClass))

typedef struct _KkcSystemSegmentDictionary KkcSystemSegmentDictionary;
typedef struct _KkcSystemSegmentDictionaryClass KkcSystemSegmentDictionaryClass;
typedef struct _KkcSystemSegmentDictionaryPrivate KkcSystemSegmentDictionaryPrivate;

#define KKC_TYPE_ENCODING_CONVERTER (kkc_encoding_converter_get_type ())
#define KKC_ENCODING_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_ENCODING_CONVERTER, KkcEncodingConverter))
#define KKC_ENCODING_CONVERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_ENCODING_CONVERTER, KkcEncodingConverterClass))
#define KKC_IS_ENCODING_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_ENCODING_CONVERTER))
#define KKC_IS_ENCODING_CONVERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_ENCODING_CONVERTER))
#define KKC_ENCODING_CONVERTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_ENCODING_CONVERTER, KkcEncodingConverterClass))

typedef struct _KkcEncodingConverter KkcEncodingConverter;
typedef struct _KkcEncodingConverterClass KkcEncodingConverterClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_mapped_file_unref0(var) ((var == NULL) ? NULL : (var = (g_mapped_file_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _KkcDictionaryIface {
	GTypeInterface parent_iface;
	void (*reload) (KkcDictionary* self, GError** error);
	void (*save) (KkcDictionary* self, GError** error);
};

struct _KkcSegmentDictionaryIface {
	GTypeInterface parent_iface;
	gboolean (*lookup_candidates) (KkcSegmentDictionary* self, const gchar* midasi, gboolean okuri, KkcCandidate*** candidates, int* candidates_length1);
	gchar** (*complete) (KkcSegmentDictionary* self, const gchar* midasi, int* result_length1);
	gboolean (*select_candidate) (KkcSegmentDictionary* self, KkcCandidate* candidate);
	gboolean (*purge_candidate) (KkcSegmentDictionary* self, KkcCandidate* candidate);
};

struct _KkcSystemSegmentDictionary {
	GObject parent_instance;
	KkcSystemSegmentDictionaryPrivate * priv;
};

struct _KkcSystemSegmentDictionaryClass {
	GObjectClass parent_class;
};

struct _KkcSystemSegmentDictionaryPrivate {
	GFile* file;
	GMappedFile* mmap;
	gchar* etag;
	KkcEncodingConverter* converter;
	glong okuri_ari_offset;
	glong okuri_nasi_offset;
};

typedef enum  {
	KKC_DICTIONARY_ERROR_NOT_READABLE,
	KKC_DICTIONARY_ERROR_MALFORMED_INPUT
} KkcDictionaryError;
#define KKC_DICTIONARY_ERROR kkc_dictionary_error_quark ()

static gpointer kkc_system_segment_dictionary_parent_class = NULL;
static KkcDictionaryIface* kkc_system_segment_dictionary_kkc_dictionary_parent_iface = NULL;
static KkcSegmentDictionaryIface* kkc_system_segment_dictionary_kkc_segment_dictionary_parent_iface = NULL;

GType kkc_dictionary_get_type (void) G_GNUC_CONST;
GType kkc_candidate_get_type (void) G_GNUC_CONST;
GType kkc_segment_dictionary_get_type (void) G_GNUC_CONST;
GType kkc_system_segment_dictionary_get_type (void) G_GNUC_CONST;
GType kkc_encoding_converter_get_type (void) G_GNUC_CONST;
#define KKC_SYSTEM_SEGMENT_DICTIONARY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), KKC_TYPE_SYSTEM_SEGMENT_DICTIONARY, KkcSystemSegmentDictionaryPrivate))
enum  {
	KKC_SYSTEM_SEGMENT_DICTIONARY_DUMMY_PROPERTY
};
static gchar* kkc_system_segment_dictionary_read_line (KkcSystemSegmentDictionary* self, glong* offset);
static gchar* kkc_system_segment_dictionary_read_previous_line (KkcSystemSegmentDictionary* self, glong* pos, const gchar* line);
static gchar* kkc_system_segment_dictionary_read_next_line (KkcSystemSegmentDictionary* self, glong* pos, const gchar* line);
static gboolean kkc_system_segment_dictionary_read_until (KkcSystemSegmentDictionary* self, glong* offset, const gchar* line);
static void kkc_system_segment_dictionary_load (KkcSystemSegmentDictionary* self, GError** error);
GQuark kkc_dictionary_error_quark (void);
gchar* kkc_encoding_converter_extract_coding_system (const gchar* line);
KkcEncodingConverter* kkc_encoding_converter_new_from_coding_system (const gchar* coding, GError** error);
KkcEncodingConverter* kkc_encoding_converter_construct_from_coding_system (GType object_type, const gchar* coding, GError** error);
static void kkc_system_segment_dictionary_real_reload (KkcDictionary* base, GError** error);
static gboolean kkc_system_segment_dictionary_search_pos (KkcSystemSegmentDictionary* self, const gchar* midasi, glong start_offset, glong end_offset, GCompareFunc cmp, glong* pos, gchar** line, gint direction);
static gboolean kkc_system_segment_dictionary_real_lookup_candidates (KkcSegmentDictionary* base, const gchar* midasi, gboolean okuri, KkcCandidate*** candidates, int* candidates_length1);
gchar* kkc_encoding_converter_encode (KkcEncodingConverter* self, const gchar* internal_str, GError** error);
gchar* kkc_encoding_converter_decode (KkcEncodingConverter* self, const gchar* external_str, GError** error);
KkcCandidate** kkc_dictionary_utils_split_candidates (const gchar* midasi, gboolean okuri, const gchar* line, int* result_length1);
static gint kkc_system_segment_dictionary_strcmp_prefix (const gchar* a, const gchar* b);
static gchar** kkc_system_segment_dictionary_real_complete (KkcSegmentDictionary* base, const gchar* midasi, int* result_length1);
static gint _kkc_system_segment_dictionary_strcmp_prefix_gcompare_func (gconstpointer a, gconstpointer b);
KkcSystemSegmentDictionary* kkc_system_segment_dictionary_new (const gchar* path, const gchar* encoding, GError** error);
KkcSystemSegmentDictionary* kkc_system_segment_dictionary_construct (GType object_type, const gchar* path, const gchar* encoding, GError** error);
KkcEncodingConverter* kkc_encoding_converter_new (const gchar* encoding, GError** error);
KkcEncodingConverter* kkc_encoding_converter_construct (GType object_type, const gchar* encoding, GError** error);
static void kkc_system_segment_dictionary_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static gchar* kkc_system_segment_dictionary_read_line (KkcSystemSegmentDictionary* self, glong* offset) {
	gchar* result = NULL;
	glong _tmp0_ = 0L;
	GMappedFile* _tmp1_ = NULL;
	gsize _tmp2_ = 0UL;
	gchar* p = NULL;
	GMappedFile* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	glong _tmp5_ = 0L;
	glong _tmp11_ = 0L;
	GString* builder = NULL;
	GString* _tmp14_ = NULL;
	glong _offset = 0L;
	glong _tmp15_ = 0L;
	GString* _tmp25_ = NULL;
	const gchar* _tmp26_ = NULL;
	gchar* _tmp27_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = *offset;
	_tmp1_ = self->priv->mmap;
	_tmp2_ = g_mapped_file_get_length (_tmp1_);
	g_return_val_if_fail (((gsize) _tmp0_) < _tmp2_, NULL);
	_tmp3_ = self->priv->mmap;
	_tmp4_ = g_mapped_file_get_contents (_tmp3_);
	_tmp5_ = *offset;
	p = ((gchar*) _tmp4_) + _tmp5_;
	{
		gboolean _tmp6_ = FALSE;
		_tmp6_ = TRUE;
		while (TRUE) {
			glong _tmp9_ = 0L;
			gchar* _tmp10_ = NULL;
			if (!_tmp6_) {
				glong _tmp7_ = 0L;
				gchar* _tmp8_ = NULL;
				_tmp7_ = *offset;
				*offset = _tmp7_ - 1;
				_tmp8_ = p;
				p = _tmp8_ - 1;
			}
			_tmp6_ = FALSE;
			_tmp9_ = *offset;
			if (!(_tmp9_ > ((glong) 0))) {
				break;
			}
			_tmp10_ = p;
			if ((*_tmp10_) == '\n') {
				break;
			}
		}
	}
	_tmp11_ = *offset;
	if (_tmp11_ > ((glong) 0)) {
		glong _tmp12_ = 0L;
		gchar* _tmp13_ = NULL;
		_tmp12_ = *offset;
		*offset = _tmp12_ + 1;
		_tmp13_ = p;
		p = _tmp13_ + 1;
	}
	_tmp14_ = g_string_new ("");
	builder = _tmp14_;
	_tmp15_ = *offset;
	_offset = _tmp15_;
	{
		gboolean _tmp16_ = FALSE;
		_tmp16_ = TRUE;
		while (TRUE) {
			glong _tmp19_ = 0L;
			GMappedFile* _tmp20_ = NULL;
			gsize _tmp21_ = 0UL;
			gchar* _tmp22_ = NULL;
			GString* _tmp23_ = NULL;
			gchar* _tmp24_ = NULL;
			if (!_tmp16_) {
				glong _tmp17_ = 0L;
				gchar* _tmp18_ = NULL;
				_tmp17_ = _offset;
				_offset = _tmp17_ + 1;
				_tmp18_ = p;
				p = _tmp18_ + 1;
			}
			_tmp16_ = FALSE;
			_tmp19_ = _offset;
			_tmp20_ = self->priv->mmap;
			_tmp21_ = g_mapped_file_get_length (_tmp20_);
			if (!(((gsize) _tmp19_) < _tmp21_)) {
				break;
			}
			_tmp22_ = p;
			if ((*_tmp22_) == '\n') {
				break;
			}
			_tmp23_ = builder;
			_tmp24_ = p;
			g_string_append_c (_tmp23_, *_tmp24_);
		}
	}
	_tmp25_ = builder;
	_tmp26_ = _tmp25_->str;
	_tmp27_ = g_strdup (_tmp26_);
	result = _tmp27_;
	_g_string_free0 (builder);
	return result;
}


static gchar* kkc_system_segment_dictionary_read_previous_line (KkcSystemSegmentDictionary* self, glong* pos, const gchar* line) {
	gchar* result = NULL;
	glong _tmp0_ = 0L;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (line != NULL, NULL);
	_tmp0_ = *pos;
	if (_tmp0_ < ((glong) 2)) {
		result = NULL;
		return result;
	}
	_tmp1_ = *pos;
	*pos = _tmp1_ - 2;
	_tmp2_ = kkc_system_segment_dictionary_read_line (self, pos);
	result = _tmp2_;
	return result;
}


static gchar* kkc_system_segment_dictionary_read_next_line (KkcSystemSegmentDictionary* self, glong* pos, const gchar* line) {
	gchar* result = NULL;
	glong _tmp0_ = 0L;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	GMappedFile* _tmp4_ = NULL;
	gsize _tmp5_ = 0UL;
	glong _tmp6_ = 0L;
	const gchar* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gchar* _tmp10_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (line != NULL, NULL);
	_tmp0_ = *pos;
	_tmp1_ = line;
	_tmp2_ = strlen (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->mmap;
	_tmp5_ = g_mapped_file_get_length (_tmp4_);
	if (((gsize) ((_tmp0_ + _tmp3_) + 1)) >= _tmp5_) {
		result = NULL;
		return result;
	}
	_tmp6_ = *pos;
	_tmp7_ = line;
	_tmp8_ = strlen (_tmp7_);
	_tmp9_ = _tmp8_;
	*pos = _tmp6_ + (_tmp9_ + 1);
	_tmp10_ = kkc_system_segment_dictionary_read_line (self, pos);
	result = _tmp10_;
	return result;
}


static gboolean kkc_system_segment_dictionary_read_until (KkcSystemSegmentDictionary* self, glong* offset, const gchar* line) {
	gboolean result = FALSE;
	glong _tmp0_ = 0L;
	GMappedFile* _tmp1_ = NULL;
	gsize _tmp2_ = 0UL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (line != NULL, FALSE);
	_tmp0_ = *offset;
	_tmp1_ = self->priv->mmap;
	_tmp2_ = g_mapped_file_get_length (_tmp1_);
	g_return_val_if_fail (((gsize) _tmp0_) < _tmp2_, NULL);
	while (TRUE) {
		glong _tmp3_ = 0L;
		const gchar* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		GMappedFile* _tmp7_ = NULL;
		gsize _tmp8_ = 0UL;
		gchar* p = NULL;
		GMappedFile* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		glong _tmp11_ = 0L;
		gboolean _tmp12_ = FALSE;
		gchar* _tmp13_ = NULL;
		glong _tmp24_ = 0L;
		_tmp3_ = *offset;
		_tmp4_ = line;
		_tmp5_ = strlen (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = self->priv->mmap;
		_tmp8_ = g_mapped_file_get_length (_tmp7_);
		if (!(((gsize) (_tmp3_ + _tmp6_)) < _tmp8_)) {
			break;
		}
		_tmp9_ = self->priv->mmap;
		_tmp10_ = g_mapped_file_get_contents (_tmp9_);
		_tmp11_ = *offset;
		p = ((gchar*) _tmp10_) + _tmp11_;
		_tmp13_ = p;
		if ((*_tmp13_) == '\n') {
			gchar* _tmp14_ = NULL;
			const gchar* _tmp15_ = NULL;
			const gchar* _tmp16_ = NULL;
			gint _tmp17_ = 0;
			gint _tmp18_ = 0;
			gint _tmp19_ = 0;
			_tmp14_ = p;
			_tmp15_ = line;
			_tmp16_ = line;
			_tmp17_ = strlen (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = memcmp (_tmp14_ + 1, (void*) _tmp15_, (gsize) _tmp18_);
			_tmp12_ = _tmp19_ == 0;
		} else {
			_tmp12_ = FALSE;
		}
		if (_tmp12_) {
			glong _tmp20_ = 0L;
			const gchar* _tmp21_ = NULL;
			gint _tmp22_ = 0;
			gint _tmp23_ = 0;
			_tmp20_ = *offset;
			_tmp21_ = line;
			_tmp22_ = strlen (_tmp21_);
			_tmp23_ = _tmp22_;
			*offset = _tmp20_ + _tmp23_;
			result = TRUE;
			return result;
		}
		_tmp24_ = *offset;
		*offset = _tmp24_ + 1;
	}
	result = FALSE;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void kkc_system_segment_dictionary_load (KkcSystemSegmentDictionary* self, GError** error) {
	GMappedFile* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	GMappedFile* _tmp4_ = NULL;
	GMappedFile* _tmp5_ = NULL;
	GMappedFile* _tmp6_ = NULL;
	glong offset = 0L;
	gchar* line = NULL;
	gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gchar* coding = NULL;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	const gchar* _tmp21_ = NULL;
	glong _tmp24_ = 0L;
	gboolean _tmp25_ = FALSE;
	glong _tmp27_ = 0L;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->file;
	_tmp2_ = g_file_get_path (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_mapped_file_new (_tmp3_, FALSE, &_inner_error_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	_tmp0_ = _tmp5_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp6_ = _tmp0_;
	_tmp0_ = NULL;
	_g_mapped_file_unref0 (self->priv->mmap);
	self->priv->mmap = _tmp6_;
	offset = (glong) 0;
	_tmp7_ = kkc_system_segment_dictionary_read_line (self, &offset);
	line = _tmp7_;
	_tmp8_ = line;
	if (_tmp8_ == NULL) {
		GError* _tmp9_ = NULL;
		_tmp9_ = g_error_new_literal (KKC_DICTIONARY_ERROR, KKC_DICTIONARY_ERROR_MALFORMED_INPUT, "can't read the first line");
		_inner_error_ = _tmp9_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (line);
		_g_mapped_file_unref0 (_tmp0_);
		return;
	}
	_tmp10_ = line;
	_tmp11_ = kkc_encoding_converter_extract_coding_system (_tmp10_);
	coding = _tmp11_;
	_tmp12_ = coding;
	if (_tmp12_ != NULL) {
		{
			KkcEncodingConverter* _converter = NULL;
			const gchar* _tmp13_ = NULL;
			KkcEncodingConverter* _tmp14_ = NULL;
			KkcEncodingConverter* _tmp15_ = NULL;
			_tmp13_ = coding;
			_tmp14_ = kkc_encoding_converter_new_from_coding_system (_tmp13_, &_inner_error_);
			_converter = _tmp14_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch13_g_error;
			}
			_tmp15_ = _converter;
			if (_tmp15_ != NULL) {
				KkcEncodingConverter* _tmp16_ = NULL;
				KkcEncodingConverter* _tmp17_ = NULL;
				_tmp16_ = _converter;
				_tmp17_ = _g_object_ref0 (_tmp16_);
				_g_object_unref0 (self->priv->converter);
				self->priv->converter = _tmp17_;
			}
			_g_object_unref0 (_converter);
		}
		goto __finally13;
		__catch13_g_error:
		{
			GError* e = NULL;
			const gchar* _tmp18_ = NULL;
			GError* _tmp19_ = NULL;
			const gchar* _tmp20_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp18_ = coding;
			_tmp19_ = e;
			_tmp20_ = _tmp19_->message;
			g_warning ("system-segment-dictionary.vala:104: can't create converter from coding" \
" system %s: %s", _tmp18_, _tmp20_);
			_g_error_free0 (e);
		}
		__finally13:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (coding);
			_g_free0 (line);
			_g_mapped_file_unref0 (_tmp0_);
			return;
		}
	}
	_tmp21_ = line;
	if (g_strcmp0 (_tmp21_, ";; okuri-ari entries.") == 0) {
		offset = (glong) 0;
	} else {
		gboolean _tmp22_ = FALSE;
		_tmp22_ = kkc_system_segment_dictionary_read_until (self, &offset, ";; okuri-ari entries.\n");
		if (!_tmp22_) {
			GError* _tmp23_ = NULL;
			_tmp23_ = g_error_new_literal (KKC_DICTIONARY_ERROR, KKC_DICTIONARY_ERROR_MALFORMED_INPUT, "no okuri-ari boundary");
			_inner_error_ = _tmp23_;
			g_propagate_error (error, _inner_error_);
			_g_free0 (coding);
			_g_free0 (line);
			_g_mapped_file_unref0 (_tmp0_);
			return;
		}
	}
	_tmp24_ = offset;
	self->priv->okuri_ari_offset = _tmp24_;
	_tmp25_ = kkc_system_segment_dictionary_read_until (self, &offset, ";; okuri-nasi entries.\n");
	if (!_tmp25_) {
		GError* _tmp26_ = NULL;
		_tmp26_ = g_error_new_literal (KKC_DICTIONARY_ERROR, KKC_DICTIONARY_ERROR_MALFORMED_INPUT, "no okuri-nasi boundary");
		_inner_error_ = _tmp26_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (coding);
		_g_free0 (line);
		_g_mapped_file_unref0 (_tmp0_);
		return;
	}
	_tmp27_ = offset;
	self->priv->okuri_nasi_offset = _tmp27_;
	_g_free0 (coding);
	_g_free0 (line);
	_g_mapped_file_unref0 (_tmp0_);
}


/**
         * {@inheritDoc}
         */
static void kkc_system_segment_dictionary_real_reload (KkcDictionary* base, GError** error) {
	KkcSystemSegmentDictionary * self;
	gchar* attributes = NULL;
	gchar* _tmp0_ = NULL;
	GFileInfo* info = NULL;
	GFile* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GFileInfo* _tmp3_ = NULL;
	GFileInfo* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	GError * _inner_error_ = NULL;
	self = (KkcSystemSegmentDictionary*) base;
	_tmp0_ = g_strdup (G_FILE_ATTRIBUTE_ETAG_VALUE);
	attributes = _tmp0_;
	_tmp1_ = self->priv->file;
	_tmp2_ = attributes;
	_tmp3_ = g_file_query_info (_tmp1_, _tmp2_, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
	info = _tmp3_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (attributes);
		return;
	}
	_tmp4_ = info;
	_tmp5_ = g_file_info_get_etag (_tmp4_);
	_tmp6_ = self->priv->etag;
	if (g_strcmp0 (_tmp5_, _tmp6_) != 0) {
		GFileInfo* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		kkc_system_segment_dictionary_load (self, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (info);
			_g_free0 (attributes);
			return;
		}
		_tmp7_ = info;
		_tmp8_ = g_file_info_get_etag (_tmp7_);
		_tmp9_ = g_strdup (_tmp8_);
		_g_free0 (self->priv->etag);
		self->priv->etag = _tmp9_;
	}
	_g_object_unref0 (info);
	_g_free0 (attributes);
}


static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = needle;
	_tmp2_ = strstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_ = NULL;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	glong _tmp2_ = 0L;
	glong _tmp5_ = 0L;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_ = 0L;
	gboolean _tmp12_ = FALSE;
	glong _tmp13_ = 0L;
	glong _tmp16_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	gchar* _tmp21_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_ = 0L;
		glong _tmp7_ = 0L;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	g_return_val_if_fail (_tmp8_, NULL);
	_tmp13_ = end;
	if (_tmp13_ >= ((glong) 0)) {
		glong _tmp14_ = 0L;
		glong _tmp15_ = 0L;
		_tmp14_ = end;
		_tmp15_ = string_length;
		_tmp12_ = _tmp14_ <= _tmp15_;
	} else {
		_tmp12_ = FALSE;
	}
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp16_ = start;
	_tmp17_ = end;
	g_return_val_if_fail (_tmp16_ <= _tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	_tmp20_ = start;
	_tmp21_ = g_strndup (((gchar*) self) + _tmp18_, (gsize) (_tmp19_ - _tmp20_));
	result = _tmp21_;
	return result;
}


static gboolean kkc_system_segment_dictionary_search_pos (KkcSystemSegmentDictionary* self, const gchar* midasi, glong start_offset, glong end_offset, GCompareFunc cmp, glong* pos, gchar** line, gint direction) {
	glong _vala_pos = 0L;
	gchar* _vala_line = NULL;
	gboolean result = FALSE;
	glong offset = 0L;
	glong _tmp0_ = 0L;
	glong _tmp1_ = 0L;
	glong _tmp2_ = 0L;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (midasi != NULL, FALSE);
	_tmp0_ = start_offset;
	_tmp1_ = end_offset;
	_tmp2_ = start_offset;
	offset = _tmp0_ + ((_tmp1_ - _tmp2_) / 2);
	while (TRUE) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		GMappedFile* _tmp6_ = NULL;
		gsize _tmp7_ = 0UL;
		gchar* _line = NULL;
		gchar* _tmp8_ = NULL;
		gint index = 0;
		const gchar* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
		gint r = 0;
		GCompareFunc _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		gint _tmp15_ = 0;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		gint _tmp19_ = 0;
		gint _tmp20_ = 0;
		gint _tmp21_ = 0;
		gint _tmp25_ = 0;
		gint _tmp26_ = 0;
		glong _tmp32_ = 0L;
		glong _tmp33_ = 0L;
		glong _tmp34_ = 0L;
		_tmp3_ = start_offset;
		_tmp4_ = end_offset;
		if (!(_tmp3_ <= _tmp4_)) {
			break;
		}
		_tmp5_ = offset;
		_tmp6_ = self->priv->mmap;
		_tmp7_ = g_mapped_file_get_length (_tmp6_);
		_vala_assert (((gsize) _tmp5_) < _tmp7_, "offset < mmap.get_length ()");
		_tmp8_ = kkc_system_segment_dictionary_read_line (self, &offset);
		_line = _tmp8_;
		_tmp9_ = _line;
		_tmp10_ = string_index_of (_tmp9_, " ", 0);
		index = _tmp10_;
		_tmp11_ = index;
		if (_tmp11_ < 1) {
			const gchar* _tmp12_ = NULL;
			_tmp12_ = _line;
			g_warning ("system-segment-dictionary.vala:150: corrupted dictionary entry: %s", _tmp12_);
			_g_free0 (_line);
			break;
		}
		_tmp13_ = cmp;
		_tmp14_ = _line;
		_tmp15_ = index;
		_tmp16_ = string_slice (_tmp14_, (glong) 0, (glong) _tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = midasi;
		_tmp19_ = _tmp13_ (_tmp17_, _tmp18_);
		_tmp20_ = _tmp19_;
		_g_free0 (_tmp17_);
		r = _tmp20_;
		_tmp21_ = r;
		if (_tmp21_ == 0) {
			glong _tmp22_ = 0L;
			const gchar* _tmp23_ = NULL;
			gchar* _tmp24_ = NULL;
			_tmp22_ = offset;
			_vala_pos = _tmp22_;
			_tmp23_ = _line;
			_tmp24_ = g_strdup (_tmp23_);
			_g_free0 (_vala_line);
			_vala_line = _tmp24_;
			result = TRUE;
			_g_free0 (_line);
			if (pos) {
				*pos = _vala_pos;
			}
			if (line) {
				*line = _vala_line;
			} else {
				_g_free0 (_vala_line);
			}
			return result;
		}
		_tmp25_ = r;
		_tmp26_ = direction;
		if ((_tmp25_ * _tmp26_) > 0) {
			glong _tmp27_ = 0L;
			_tmp27_ = offset;
			end_offset = _tmp27_ - 2;
		} else {
			glong _tmp28_ = 0L;
			const gchar* _tmp29_ = NULL;
			gint _tmp30_ = 0;
			gint _tmp31_ = 0;
			_tmp28_ = offset;
			_tmp29_ = _line;
			_tmp30_ = strlen (_tmp29_);
			_tmp31_ = _tmp30_;
			start_offset = (_tmp28_ + _tmp31_) + 1;
		}
		_tmp32_ = start_offset;
		_tmp33_ = end_offset;
		_tmp34_ = start_offset;
		offset = _tmp32_ + ((_tmp33_ - _tmp34_) / 2);
		_g_free0 (_line);
	}
	_vala_pos = (glong) (-1);
	_g_free0 (_vala_line);
	_vala_line = NULL;
	result = FALSE;
	if (pos) {
		*pos = _vala_pos;
	}
	if (line) {
		*line = _vala_line;
	} else {
		_g_free0 (_vala_line);
	}
	return result;
}


/**
         * {@inheritDoc}
         */
static gboolean kkc_system_segment_dictionary_real_lookup_candidates (KkcSegmentDictionary* base, const gchar* midasi, gboolean okuri, KkcCandidate*** candidates, int* candidates_length1) {
	KkcSystemSegmentDictionary * self;
	KkcCandidate** _vala_candidates = NULL;
	int _vala_candidates_length1 = 0;
	gboolean result = FALSE;
	GMappedFile* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	glong start_offset = 0L;
	glong end_offset = 0L;
	gboolean _tmp3_ = FALSE;
	gchar* _midasi = NULL;
	glong pos = 0L;
	gchar* line = NULL;
	gint _tmp18_ = 0;
	gboolean _tmp19_ = FALSE;
	const gchar* _tmp20_ = NULL;
	glong _tmp21_ = 0L;
	glong _tmp22_ = 0L;
	GCompareFunc _tmp23_ = NULL;
	glong _tmp24_ = 0L;
	gchar* _tmp25_ = NULL;
	gboolean _tmp26_ = FALSE;
	KkcCandidate** _tmp51_ = NULL;
	GError * _inner_error_ = NULL;
	self = (KkcSystemSegmentDictionary*) base;
	g_return_val_if_fail (midasi != NULL, FALSE);
	_tmp0_ = self->priv->mmap;
	_tmp1_ = g_mapped_file_get_contents (_tmp0_);
	if (_tmp1_ == NULL) {
		KkcCandidate** _tmp2_ = NULL;
		_tmp2_ = g_new0 (KkcCandidate*, 0 + 1);
		_vala_candidates = (_vala_array_free (_vala_candidates, _vala_candidates_length1, (GDestroyNotify) g_object_unref), NULL);
		_vala_candidates = _tmp2_;
		_vala_candidates_length1 = 0;
		result = FALSE;
		if (candidates) {
			*candidates = _vala_candidates;
		} else {
			_vala_candidates = (_vala_array_free (_vala_candidates, _vala_candidates_length1, (GDestroyNotify) g_object_unref), NULL);
		}
		if (candidates_length1) {
			*candidates_length1 = _vala_candidates_length1;
		}
		return result;
	}
	_tmp3_ = okuri;
	if (_tmp3_) {
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		_tmp4_ = self->priv->okuri_ari_offset;
		start_offset = _tmp4_;
		_tmp5_ = self->priv->okuri_nasi_offset;
		end_offset = _tmp5_;
	} else {
		glong _tmp6_ = 0L;
		GMappedFile* _tmp7_ = NULL;
		gsize _tmp8_ = 0UL;
		_tmp6_ = self->priv->okuri_nasi_offset;
		start_offset = _tmp6_;
		_tmp7_ = self->priv->mmap;
		_tmp8_ = g_mapped_file_get_length (_tmp7_);
		end_offset = ((glong) _tmp8_) - 1;
	}
	{
		gchar* _tmp9_ = NULL;
		KkcEncodingConverter* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		_tmp10_ = self->priv->converter;
		_tmp11_ = midasi;
		_tmp12_ = kkc_encoding_converter_encode (_tmp10_, _tmp11_, &_inner_error_);
		_tmp9_ = _tmp12_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch14_g_error;
		}
		_tmp13_ = _tmp9_;
		_tmp9_ = NULL;
		_g_free0 (_midasi);
		_midasi = _tmp13_;
		_g_free0 (_tmp9_);
	}
	goto __finally14;
	__catch14_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp14_ = NULL;
		GError* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		KkcCandidate** _tmp17_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp14_ = midasi;
		_tmp15_ = e;
		_tmp16_ = _tmp15_->message;
		g_warning ("system-segment-dictionary.vala:196: can't encode %s: %s", _tmp14_, _tmp16_);
		_tmp17_ = g_new0 (KkcCandidate*, 0 + 1);
		_vala_candidates = (_vala_array_free (_vala_candidates, _vala_candidates_length1, (GDestroyNotify) g_object_unref), NULL);
		_vala_candidates = _tmp17_;
		_vala_candidates_length1 = 0;
		result = FALSE;
		_g_error_free0 (e);
		_g_free0 (_midasi);
		if (candidates) {
			*candidates = _vala_candidates;
		} else {
			_vala_candidates = (_vala_array_free (_vala_candidates, _vala_candidates_length1, (GDestroyNotify) g_object_unref), NULL);
		}
		if (candidates_length1) {
			*candidates_length1 = _vala_candidates_length1;
		}
		return result;
	}
	__finally14:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (_midasi);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp19_ = okuri;
	if (_tmp19_) {
		_tmp18_ = -1;
	} else {
		_tmp18_ = 1;
	}
	_tmp20_ = _midasi;
	_tmp21_ = start_offset;
	_tmp22_ = end_offset;
	_tmp23_ = g_strcmp0;
	_tmp26_ = kkc_system_segment_dictionary_search_pos (self, _tmp20_, _tmp21_, _tmp22_, _tmp23_, &_tmp24_, &_tmp25_, _tmp18_);
	pos = _tmp24_;
	_g_free0 (line);
	line = _tmp25_;
	if (_tmp26_) {
		gint index = 0;
		const gchar* _tmp27_ = NULL;
		gint _tmp28_ = 0;
		gchar* _line = NULL;
		gint _tmp29_ = 0;
		_tmp27_ = line;
		_tmp28_ = string_index_of (_tmp27_, " ", 0);
		index = _tmp28_;
		_tmp29_ = index;
		if (_tmp29_ > 0) {
			const gchar* _tmp46_ = NULL;
			gboolean _tmp47_ = FALSE;
			const gchar* _tmp48_ = NULL;
			gint _tmp49_ = 0;
			KkcCandidate** _tmp50_ = NULL;
			{
				gchar* _tmp30_ = NULL;
				KkcEncodingConverter* _tmp31_ = NULL;
				const gchar* _tmp32_ = NULL;
				gint _tmp33_ = 0;
				const gchar* _tmp34_ = NULL;
				gint _tmp35_ = 0;
				gint _tmp36_ = 0;
				gchar* _tmp37_ = NULL;
				gchar* _tmp38_ = NULL;
				gchar* _tmp39_ = NULL;
				gchar* _tmp40_ = NULL;
				gchar* _tmp41_ = NULL;
				_tmp31_ = self->priv->converter;
				_tmp32_ = line;
				_tmp33_ = index;
				_tmp34_ = line;
				_tmp35_ = strlen (_tmp34_);
				_tmp36_ = _tmp35_;
				_tmp37_ = string_slice (_tmp32_, (glong) _tmp33_, (glong) _tmp36_);
				_tmp38_ = _tmp37_;
				_tmp39_ = kkc_encoding_converter_decode (_tmp31_, _tmp38_, &_inner_error_);
				_tmp40_ = _tmp39_;
				_g_free0 (_tmp38_);
				_tmp30_ = _tmp40_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					goto __catch15_g_error;
				}
				_tmp41_ = _tmp30_;
				_tmp30_ = NULL;
				_g_free0 (_line);
				_line = _tmp41_;
				_g_free0 (_tmp30_);
			}
			goto __finally15;
			__catch15_g_error:
			{
				GError* e = NULL;
				const gchar* _tmp42_ = NULL;
				GError* _tmp43_ = NULL;
				const gchar* _tmp44_ = NULL;
				KkcCandidate** _tmp45_ = NULL;
				e = _inner_error_;
				_inner_error_ = NULL;
				_tmp42_ = line;
				_tmp43_ = e;
				_tmp44_ = _tmp43_->message;
				g_warning ("system-segment-dictionary.vala:216: can't decode line %s: %s", _tmp42_, _tmp44_);
				_tmp45_ = g_new0 (KkcCandidate*, 0 + 1);
				_vala_candidates = (_vala_array_free (_vala_candidates, _vala_candidates_length1, (GDestroyNotify) g_object_unref), NULL);
				_vala_candidates = _tmp45_;
				_vala_candidates_length1 = 0;
				result = FALSE;
				_g_error_free0 (e);
				_g_free0 (_line);
				_g_free0 (line);
				_g_free0 (_midasi);
				if (candidates) {
					*candidates = _vala_candidates;
				} else {
					_vala_candidates = (_vala_array_free (_vala_candidates, _vala_candidates_length1, (GDestroyNotify) g_object_unref), NULL);
				}
				if (candidates_length1) {
					*candidates_length1 = _vala_candidates_length1;
				}
				return result;
			}
			__finally15:
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_free0 (_line);
				_g_free0 (line);
				_g_free0 (_midasi);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
			_tmp46_ = midasi;
			_tmp47_ = okuri;
			_tmp48_ = _line;
			_tmp50_ = kkc_dictionary_utils_split_candidates (_tmp46_, _tmp47_, _tmp48_, &_tmp49_);
			_vala_candidates = (_vala_array_free (_vala_candidates, _vala_candidates_length1, (GDestroyNotify) g_object_unref), NULL);
			_vala_candidates = _tmp50_;
			_vala_candidates_length1 = _tmp49_;
			result = TRUE;
			_g_free0 (_line);
			_g_free0 (line);
			_g_free0 (_midasi);
			if (candidates) {
				*candidates = _vala_candidates;
			} else {
				_vala_candidates = (_vala_array_free (_vala_candidates, _vala_candidates_length1, (GDestroyNotify) g_object_unref), NULL);
			}
			if (candidates_length1) {
				*candidates_length1 = _vala_candidates_length1;
			}
			return result;
		}
		_g_free0 (_line);
	}
	_tmp51_ = g_new0 (KkcCandidate*, 0 + 1);
	_vala_candidates = (_vala_array_free (_vala_candidates, _vala_candidates_length1, (GDestroyNotify) g_object_unref), NULL);
	_vala_candidates = _tmp51_;
	_vala_candidates_length1 = 0;
	result = FALSE;
	_g_free0 (line);
	_g_free0 (_midasi);
	if (candidates) {
		*candidates = _vala_candidates;
	} else {
		_vala_candidates = (_vala_array_free (_vala_candidates, _vala_candidates_length1, (GDestroyNotify) g_object_unref), NULL);
	}
	if (candidates_length1) {
		*candidates_length1 = _vala_candidates_length1;
	}
	return result;
}


static gint kkc_system_segment_dictionary_strcmp_prefix (const gchar* a, const gchar* b) {
	gint result = 0;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GCompareFunc _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = a;
	_tmp1_ = b;
	_tmp2_ = g_str_has_prefix (_tmp0_, _tmp1_);
	if (_tmp2_) {
		result = 0;
		return result;
	}
	_tmp3_ = g_strcmp0;
	_tmp4_ = a;
	_tmp5_ = b;
	_tmp6_ = _tmp3_ (_tmp4_, _tmp5_);
	result = _tmp6_;
	return result;
}


/**
         * {@inheritDoc}
         */
static gint _kkc_system_segment_dictionary_strcmp_prefix_gcompare_func (gconstpointer a, gconstpointer b) {
	gint result;
	result = kkc_system_segment_dictionary_strcmp_prefix ((const gchar*) a, (const gchar*) b);
	return result;
}


static gchar** kkc_system_segment_dictionary_real_complete (KkcSegmentDictionary* base, const gchar* midasi, int* result_length1) {
	KkcSystemSegmentDictionary * self;
	gchar** result = NULL;
	GMappedFile* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GeeArrayList* completion = NULL;
	GeeArrayList* _tmp4_ = NULL;
	glong start_offset = 0L;
	glong end_offset = 0L;
	glong _tmp5_ = 0L;
	GMappedFile* _tmp6_ = NULL;
	gsize _tmp7_ = 0UL;
	gchar* _midasi = NULL;
	glong pos = 0L;
	gchar* line = NULL;
	const gchar* _tmp20_ = NULL;
	glong _tmp21_ = 0L;
	glong _tmp22_ = 0L;
	glong _tmp23_ = 0L;
	gchar* _tmp24_ = NULL;
	gboolean _tmp25_ = FALSE;
	GeeArrayList* _tmp87_ = NULL;
	gint _tmp88_ = 0;
	gpointer* _tmp89_ = NULL;
	gchar** _tmp90_ = NULL;
	gint _tmp90__length1 = 0;
	GError * _inner_error_ = NULL;
	self = (KkcSystemSegmentDictionary*) base;
	g_return_val_if_fail (midasi != NULL, NULL);
	_tmp0_ = self->priv->mmap;
	_tmp1_ = g_mapped_file_get_contents (_tmp0_);
	if (_tmp1_ == NULL) {
		gchar** _tmp2_ = NULL;
		gchar** _tmp3_ = NULL;
		gint _tmp3__length1 = 0;
		_tmp2_ = g_new0 (gchar*, 0 + 1);
		_tmp3_ = _tmp2_;
		_tmp3__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp3__length1;
		}
		result = _tmp3_;
		return result;
	}
	_tmp4_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	completion = _tmp4_;
	_tmp5_ = self->priv->okuri_nasi_offset;
	start_offset = _tmp5_;
	_tmp6_ = self->priv->mmap;
	_tmp7_ = g_mapped_file_get_length (_tmp6_);
	end_offset = ((glong) _tmp7_) - 1;
	{
		gchar* _tmp8_ = NULL;
		KkcEncodingConverter* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		_tmp9_ = self->priv->converter;
		_tmp10_ = midasi;
		_tmp11_ = kkc_encoding_converter_encode (_tmp9_, _tmp10_, &_inner_error_);
		_tmp8_ = _tmp11_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch16_g_error;
		}
		_tmp12_ = _tmp8_;
		_tmp8_ = NULL;
		_g_free0 (_midasi);
		_midasi = _tmp12_;
		_g_free0 (_tmp8_);
	}
	goto __finally16;
	__catch16_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp13_ = NULL;
		GError* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		GeeArrayList* _tmp16_ = NULL;
		gint _tmp17_ = 0;
		gpointer* _tmp18_ = NULL;
		gchar** _tmp19_ = NULL;
		gint _tmp19__length1 = 0;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp13_ = midasi;
		_tmp14_ = e;
		_tmp15_ = _tmp14_->message;
		g_warning ("system-segment-dictionary.vala:254: can't decode %s: %s", _tmp13_, _tmp15_);
		_tmp16_ = completion;
		_tmp18_ = gee_collection_to_array ((GeeCollection*) _tmp16_, &_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp19__length1 = _tmp17_;
		if (result_length1) {
			*result_length1 = _tmp19__length1;
		}
		result = _tmp19_;
		_g_error_free0 (e);
		_g_free0 (_midasi);
		_g_object_unref0 (completion);
		return result;
	}
	__finally16:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (_midasi);
		_g_object_unref0 (completion);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp20_ = _midasi;
	_tmp21_ = start_offset;
	_tmp22_ = end_offset;
	_tmp25_ = kkc_system_segment_dictionary_search_pos (self, _tmp20_, _tmp21_, _tmp22_, _kkc_system_segment_dictionary_strcmp_prefix_gcompare_func, &_tmp23_, &_tmp24_, 1);
	pos = _tmp23_;
	_g_free0 (line);
	line = _tmp24_;
	if (_tmp25_) {
		glong _pos = 0L;
		glong _tmp26_ = 0L;
		gchar* _line = NULL;
		const gchar* _tmp27_ = NULL;
		gchar* _tmp28_ = NULL;
		glong _tmp57_ = 0L;
		const gchar* _tmp58_ = NULL;
		gchar* _tmp59_ = NULL;
		_tmp26_ = pos;
		_pos = _tmp26_;
		_tmp27_ = line;
		_tmp28_ = g_strdup (_tmp27_);
		_line = _tmp28_;
		{
			gboolean _tmp29_ = FALSE;
			_tmp29_ = TRUE;
			while (TRUE) {
				gint index = 0;
				const gchar* _tmp37_ = NULL;
				gint _tmp38_ = 0;
				gint _tmp39_ = 0;
				if (!_tmp29_) {
					gboolean _tmp30_ = FALSE;
					const gchar* _tmp31_ = NULL;
					gchar* _tmp32_ = NULL;
					const gchar* _tmp33_ = NULL;
					_tmp31_ = line;
					_tmp32_ = kkc_system_segment_dictionary_read_previous_line (self, &pos, _tmp31_);
					_g_free0 (line);
					line = _tmp32_;
					_tmp33_ = line;
					if (_tmp33_ != NULL) {
						const gchar* _tmp34_ = NULL;
						const gchar* _tmp35_ = NULL;
						gboolean _tmp36_ = FALSE;
						_tmp34_ = line;
						_tmp35_ = _midasi;
						_tmp36_ = g_str_has_prefix (_tmp34_, _tmp35_);
						_tmp30_ = _tmp36_;
					} else {
						_tmp30_ = FALSE;
					}
					if (!_tmp30_) {
						break;
					}
				}
				_tmp29_ = FALSE;
				_tmp37_ = line;
				_tmp38_ = string_index_of (_tmp37_, " ", 0);
				index = _tmp38_;
				_tmp39_ = index;
				if (_tmp39_ < 0) {
					const gchar* _tmp40_ = NULL;
					_tmp40_ = line;
					g_warning ("system-segment-dictionary.vala:274: corrupted dictionary entry: %s", _tmp40_);
				} else {
					gchar* completed = NULL;
					const gchar* _tmp41_ = NULL;
					gint _tmp42_ = 0;
					gchar* _tmp43_ = NULL;
					gboolean _tmp44_ = FALSE;
					const gchar* _tmp45_ = NULL;
					const gchar* _tmp46_ = NULL;
					_tmp41_ = line;
					_tmp42_ = index;
					_tmp43_ = string_slice (_tmp41_, (glong) 0, (glong) _tmp42_);
					completed = _tmp43_;
					_tmp45_ = completed;
					_tmp46_ = _midasi;
					if (g_strcmp0 (_tmp45_, _tmp46_) != 0) {
						const gchar* _tmp47_ = NULL;
						gboolean _tmp48_ = FALSE;
						_tmp47_ = completed;
						_tmp48_ = g_str_has_suffix (_tmp47_, ">");
						_tmp44_ = !_tmp48_;
					} else {
						_tmp44_ = FALSE;
					}
					if (_tmp44_) {
						{
							gchar* decoded = NULL;
							KkcEncodingConverter* _tmp49_ = NULL;
							const gchar* _tmp50_ = NULL;
							gchar* _tmp51_ = NULL;
							GeeArrayList* _tmp52_ = NULL;
							const gchar* _tmp53_ = NULL;
							_tmp49_ = self->priv->converter;
							_tmp50_ = completed;
							_tmp51_ = kkc_encoding_converter_decode (_tmp49_, _tmp50_, &_inner_error_);
							decoded = _tmp51_;
							if (G_UNLIKELY (_inner_error_ != NULL)) {
								goto __catch17_g_error;
							}
							_tmp52_ = completion;
							_tmp53_ = decoded;
							gee_abstract_list_insert ((GeeAbstractList*) _tmp52_, 0, _tmp53_);
							_g_free0 (decoded);
						}
						goto __finally17;
						__catch17_g_error:
						{
							GError* e = NULL;
							const gchar* _tmp54_ = NULL;
							GError* _tmp55_ = NULL;
							const gchar* _tmp56_ = NULL;
							e = _inner_error_;
							_inner_error_ = NULL;
							_tmp54_ = line;
							_tmp55_ = e;
							_tmp56_ = _tmp55_->message;
							g_warning ("system-segment-dictionary.vala:285: can't decode line %s: %s", _tmp54_, _tmp56_);
							_g_error_free0 (e);
						}
						__finally17:
						if (G_UNLIKELY (_inner_error_ != NULL)) {
							_g_free0 (completed);
							_g_free0 (_line);
							_g_free0 (line);
							_g_free0 (_midasi);
							_g_object_unref0 (completion);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					_g_free0 (completed);
				}
			}
		}
		_tmp57_ = _pos;
		pos = _tmp57_;
		_tmp58_ = _line;
		_tmp59_ = g_strdup (_tmp58_);
		_g_free0 (line);
		line = _tmp59_;
		while (TRUE) {
			gboolean _tmp60_ = FALSE;
			const gchar* _tmp61_ = NULL;
			gchar* _tmp62_ = NULL;
			const gchar* _tmp63_ = NULL;
			gint index = 0;
			const gchar* _tmp67_ = NULL;
			gint _tmp68_ = 0;
			gint _tmp69_ = 0;
			_tmp61_ = line;
			_tmp62_ = kkc_system_segment_dictionary_read_next_line (self, &pos, _tmp61_);
			_g_free0 (line);
			line = _tmp62_;
			_tmp63_ = line;
			if (_tmp63_ != NULL) {
				const gchar* _tmp64_ = NULL;
				const gchar* _tmp65_ = NULL;
				gboolean _tmp66_ = FALSE;
				_tmp64_ = line;
				_tmp65_ = _midasi;
				_tmp66_ = g_str_has_prefix (_tmp64_, _tmp65_);
				_tmp60_ = _tmp66_;
			} else {
				_tmp60_ = FALSE;
			}
			if (!_tmp60_) {
				break;
			}
			_tmp67_ = line;
			_tmp68_ = string_index_of (_tmp67_, " ", 0);
			index = _tmp68_;
			_tmp69_ = index;
			if (_tmp69_ < 0) {
				const gchar* _tmp70_ = NULL;
				_tmp70_ = line;
				g_warning ("system-segment-dictionary.vala:300: corrupted dictionary entry: %s", _tmp70_);
			} else {
				gchar* completed = NULL;
				const gchar* _tmp71_ = NULL;
				gint _tmp72_ = 0;
				gchar* _tmp73_ = NULL;
				gboolean _tmp74_ = FALSE;
				const gchar* _tmp75_ = NULL;
				const gchar* _tmp76_ = NULL;
				_tmp71_ = line;
				_tmp72_ = index;
				_tmp73_ = string_slice (_tmp71_, (glong) 0, (glong) _tmp72_);
				completed = _tmp73_;
				_tmp75_ = completed;
				_tmp76_ = _midasi;
				if (g_strcmp0 (_tmp75_, _tmp76_) != 0) {
					const gchar* _tmp77_ = NULL;
					gboolean _tmp78_ = FALSE;
					_tmp77_ = completed;
					_tmp78_ = g_str_has_suffix (_tmp77_, ">");
					_tmp74_ = !_tmp78_;
				} else {
					_tmp74_ = FALSE;
				}
				if (_tmp74_) {
					{
						gchar* decoded = NULL;
						KkcEncodingConverter* _tmp79_ = NULL;
						const gchar* _tmp80_ = NULL;
						gchar* _tmp81_ = NULL;
						GeeArrayList* _tmp82_ = NULL;
						const gchar* _tmp83_ = NULL;
						_tmp79_ = self->priv->converter;
						_tmp80_ = completed;
						_tmp81_ = kkc_encoding_converter_decode (_tmp79_, _tmp80_, &_inner_error_);
						decoded = _tmp81_;
						if (G_UNLIKELY (_inner_error_ != NULL)) {
							goto __catch18_g_error;
						}
						_tmp82_ = completion;
						_tmp83_ = decoded;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp82_, _tmp83_);
						_g_free0 (decoded);
					}
					goto __finally18;
					__catch18_g_error:
					{
						GError* e = NULL;
						const gchar* _tmp84_ = NULL;
						GError* _tmp85_ = NULL;
						const gchar* _tmp86_ = NULL;
						e = _inner_error_;
						_inner_error_ = NULL;
						_tmp84_ = line;
						_tmp85_ = e;
						_tmp86_ = _tmp85_->message;
						g_warning ("system-segment-dictionary.vala:311: can't decode line %s: %s", _tmp84_, _tmp86_);
						_g_error_free0 (e);
					}
					__finally18:
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						_g_free0 (completed);
						_g_free0 (_line);
						_g_free0 (line);
						_g_free0 (_midasi);
						_g_object_unref0 (completion);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_g_free0 (completed);
			}
		}
		_g_free0 (_line);
	}
	_tmp87_ = completion;
	_tmp89_ = gee_collection_to_array ((GeeCollection*) _tmp87_, &_tmp88_);
	_tmp90_ = _tmp89_;
	_tmp90__length1 = _tmp88_;
	if (result_length1) {
		*result_length1 = _tmp90__length1;
	}
	result = _tmp90_;
	_g_free0 (line);
	_g_free0 (_midasi);
	_g_object_unref0 (completion);
	return result;
}


/**
         * Create a new SystemSegmentDictionary.
         *
         * @param path a path to the file
         * @param encoding encoding of the file (default EUC-JP)
         *
         * @return a new FileDictionary
         * @throws GLib.Error if opening the file is failed
         */
KkcSystemSegmentDictionary* kkc_system_segment_dictionary_construct (GType object_type, const gchar* path, const gchar* encoding, GError** error) {
	KkcSystemSegmentDictionary * self = NULL;
	const gchar* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	KkcEncodingConverter* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	KkcEncodingConverter* _tmp5_ = NULL;
	KkcEncodingConverter* _tmp6_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (path != NULL, NULL);
	g_return_val_if_fail (encoding != NULL, NULL);
	self = (KkcSystemSegmentDictionary*) g_object_new (object_type, NULL);
	_tmp0_ = path;
	_tmp1_ = g_file_new_for_path (_tmp0_);
	_g_object_unref0 (self->priv->file);
	self->priv->file = _tmp1_;
	_tmp2_ = g_strdup ("");
	_g_free0 (self->priv->etag);
	self->priv->etag = _tmp2_;
	_tmp4_ = encoding;
	_tmp5_ = kkc_encoding_converter_new (_tmp4_, &_inner_error_);
	_tmp3_ = _tmp5_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (self);
		return NULL;
	}
	_tmp6_ = _tmp3_;
	_tmp3_ = NULL;
	_g_object_unref0 (self->priv->converter);
	self->priv->converter = _tmp6_;
	kkc_system_segment_dictionary_load (self, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (_tmp3_);
		_g_object_unref0 (self);
		return NULL;
	}
	_g_object_unref0 (_tmp3_);
	return self;
}


KkcSystemSegmentDictionary* kkc_system_segment_dictionary_new (const gchar* path, const gchar* encoding, GError** error) {
	return kkc_system_segment_dictionary_construct (KKC_TYPE_SYSTEM_SEGMENT_DICTIONARY, path, encoding, error);
}


static void kkc_system_segment_dictionary_class_init (KkcSystemSegmentDictionaryClass * klass) {
	kkc_system_segment_dictionary_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (KkcSystemSegmentDictionaryPrivate));
	G_OBJECT_CLASS (klass)->finalize = kkc_system_segment_dictionary_finalize;
}


static void kkc_system_segment_dictionary_kkc_dictionary_interface_init (KkcDictionaryIface * iface) {
	kkc_system_segment_dictionary_kkc_dictionary_parent_iface = g_type_interface_peek_parent (iface);
	iface->reload = (void (*)(KkcDictionary*, GError**)) kkc_system_segment_dictionary_real_reload;
}


static void kkc_system_segment_dictionary_kkc_segment_dictionary_interface_init (KkcSegmentDictionaryIface * iface) {
	kkc_system_segment_dictionary_kkc_segment_dictionary_parent_iface = g_type_interface_peek_parent (iface);
	iface->lookup_candidates = (gboolean (*)(KkcSegmentDictionary*, const gchar*, gboolean, KkcCandidate***, int*)) kkc_system_segment_dictionary_real_lookup_candidates;
	iface->complete = (gchar** (*)(KkcSegmentDictionary*, const gchar*, int*)) kkc_system_segment_dictionary_real_complete;
}


static void kkc_system_segment_dictionary_instance_init (KkcSystemSegmentDictionary * self) {
	self->priv = KKC_SYSTEM_SEGMENT_DICTIONARY_GET_PRIVATE (self);
}


static void kkc_system_segment_dictionary_finalize (GObject* obj) {
	KkcSystemSegmentDictionary * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, KKC_TYPE_SYSTEM_SEGMENT_DICTIONARY, KkcSystemSegmentDictionary);
	_g_object_unref0 (self->priv->file);
	_g_mapped_file_unref0 (self->priv->mmap);
	_g_free0 (self->priv->etag);
	_g_object_unref0 (self->priv->converter);
	G_OBJECT_CLASS (kkc_system_segment_dictionary_parent_class)->finalize (obj);
}


/**
     * Read-only file based implementation of Dictionary.
     */
GType kkc_system_segment_dictionary_get_type (void) {
	static volatile gsize kkc_system_segment_dictionary_type_id__volatile = 0;
	if (g_once_init_enter (&kkc_system_segment_dictionary_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (KkcSystemSegmentDictionaryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) kkc_system_segment_dictionary_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (KkcSystemSegmentDictionary), 0, (GInstanceInitFunc) kkc_system_segment_dictionary_instance_init, NULL };
		static const GInterfaceInfo kkc_dictionary_info = { (GInterfaceInitFunc) kkc_system_segment_dictionary_kkc_dictionary_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo kkc_segment_dictionary_info = { (GInterfaceInitFunc) kkc_system_segment_dictionary_kkc_segment_dictionary_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType kkc_system_segment_dictionary_type_id;
		kkc_system_segment_dictionary_type_id = g_type_register_static (G_TYPE_OBJECT, "KkcSystemSegmentDictionary", &g_define_type_info, 0);
		g_type_add_interface_static (kkc_system_segment_dictionary_type_id, KKC_TYPE_DICTIONARY, &kkc_dictionary_info);
		g_type_add_interface_static (kkc_system_segment_dictionary_type_id, KKC_TYPE_SEGMENT_DICTIONARY, &kkc_segment_dictionary_info);
		g_once_init_leave (&kkc_system_segment_dictionary_type_id__volatile, kkc_system_segment_dictionary_type_id);
	}
	return kkc_system_segment_dictionary_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



