%top {
/* Must come first for _LARGE_FILE_API on AIX. */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/*
 * Must come first to avoid warnings on Windows.
 *
 * Flex-generated scanners may only include <inttypes.h> if __STDC_VERSION__
 * is defined with a value >= 199901, meaning "full C99", and MSVC may not
 * define it with that value, because it isn't 100% C99-compliant, even
 * though it has an <inttypes.h> capable of defining everything the Flex
 * scanner needs.
 *
 * We, however, will include it if we know we have an MSVC version that has
 * it; this means that we may define the INTn_MAX and UINTn_MAX values in
 * scanner.c, and then include <stdint.h>, which may define them differently
 * (same value, but different string of characters), causing compiler warnings.
 *
 * If we include it here, and they're defined, that'll prevent scanner.c
 * from defining them.  So we include <pcap/pcap-inttypes.h>, to get
 * <inttypes.h> if we have it.
 */
#include <pcap/pcap-inttypes.h>

#include "diag-control.h"
}

/*
 * We want a reentrant scanner.
 */
%option reentrant

/*
 * And we need to pass the compiler state to the scanner.
 */
%option extra-type="compiler_state_t *"

/*
 * We don't use input, so don't generate code for it.
 */
%option noinput

/*
 * We don't use unput, so don't generate code for it.
 */
%option nounput

/*
 * We don't read from the terminal.
 */
%option never-interactive

/*
 * We want to stop processing when we get to the end of the input.
 */
%option noyywrap

/*
 * We want to generate code that can be used by a reentrant parser
 * generated by Bison or Berkeley YACC.
 */
%option bison-bridge

%{
/*
 * Copyright (c) 1988, 1989, 1990, 1991, 1992, 1993, 1994, 1995, 1996, 1997
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that: (1) source code distributions
 * retain the above copyright notice and this paragraph in its entirety, (2)
 * distributions including binary code include the above copyright notice and
 * this paragraph in its entirety in the documentation or other materials
 * provided with the distribution, and (3) all advertising materials mentioning
 * features or use of this software display the following acknowledgement:
 * ``This product includes software developed by the University of California,
 * Lawrence Berkeley Laboratory and its contributors.'' Neither the name of
 * the University nor the names of its contributors may be used to endorse
 * or promote products derived from this software without specific prior
 * written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include <ctype.h>
#include <string.h>

#include "pcap-int.h"

#include "gencode.h"

#include "grammar.h"

/*
 * Earlier versions of Flex don't declare these, so we declare them
 * ourselves to squelch warnings.
 */
int pcap_get_column(yyscan_t);
void pcap_set_column(int, yyscan_t);

#ifdef INET6

#ifdef _WIN32
#include <winsock2.h>
#include <ws2tcpip.h>
/*
 * To quote the MSDN page for getaddrinfo() at
 *
 *    https://msdn.microsoft.com/en-us/library/windows/desktop/ms738520(v=vs.85).aspx
 *
 * "Support for getaddrinfo on Windows 2000 and older versions
 * The getaddrinfo function was added to the Ws2_32.dll on Windows XP and
 * later. To execute an application that uses this function on earlier
 * versions of Windows, then you need to include the Ws2tcpip.h and
 * Wspiapi.h files. When the Wspiapi.h include file is added, the
 * getaddrinfo function is defined to the WspiapiGetAddrInfo inline
 * function in the Wspiapi.h file. At runtime, the WspiapiGetAddrInfo
 * function is implemented in such a way that if the Ws2_32.dll or the
 * Wship6.dll (the file containing getaddrinfo in the IPv6 Technology
 * Preview for Windows 2000) does not include getaddrinfo, then a
 * version of getaddrinfo is implemented inline based on code in the
 * Wspiapi.h header file. This inline code will be used on older Windows
 * platforms that do not natively support the getaddrinfo function."
 *
 * We use getaddrinfo(), so we include Wspiapi.h here.
 */
#include <wspiapi.h>
#else /* _WIN32 */
#include <sys/socket.h>	/* for "struct sockaddr" in "struct addrinfo" */
#include <netdb.h>	/* for "struct addrinfo" */
#endif /* _WIN32 */

/* Workaround for AIX 4.3 */
#if !defined(AI_NUMERICHOST)
#define AI_NUMERICHOST 0x04
#endif

#endif /*INET6*/

#include <pcap/namedb.h>
#include "grammar.h"

#ifdef HAVE_OS_PROTO_H
#include "os-proto.h"
#endif

static int stoi(char *);
static inline int xdtoi(int);

/*
 * Disable diagnostics in the code generated by Flex.
 */
DIAG_OFF_FLEX

%}

N		([0-9]+|(0X|0x)[0-9A-Fa-f]+)
B		([0-9A-Fa-f][0-9A-Fa-f]?)
B2		([0-9A-Fa-f][0-9A-Fa-f][0-9A-Fa-f][0-9A-Fa-f])
W		([0-9A-Fa-f][0-9A-Fa-f]?[0-9A-Fa-f]?[0-9A-Fa-f]?)

%a 18400
%o 21500
%e 7600
%k 4550
%p 27600
%n 2000

V680		{W}:{W}:{W}:{W}:{W}:{W}:{W}:{W}

V670		::{W}:{W}:{W}:{W}:{W}:{W}:{W}
V671		{W}::{W}:{W}:{W}:{W}:{W}:{W}
V672		{W}:{W}::{W}:{W}:{W}:{W}:{W}
V673		{W}:{W}:{W}::{W}:{W}:{W}:{W}
V674		{W}:{W}:{W}:{W}::{W}:{W}:{W}
V675		{W}:{W}:{W}:{W}:{W}::{W}:{W}
V676		{W}:{W}:{W}:{W}:{W}:{W}::{W}
V677		{W}:{W}:{W}:{W}:{W}:{W}:{W}::

V660		::{W}:{W}:{W}:{W}:{W}:{W}
V661		{W}::{W}:{W}:{W}:{W}:{W}
V662		{W}:{W}::{W}:{W}:{W}:{W}
V663		{W}:{W}:{W}::{W}:{W}:{W}
V664		{W}:{W}:{W}:{W}::{W}:{W}
V665		{W}:{W}:{W}:{W}:{W}::{W}
V666		{W}:{W}:{W}:{W}:{W}:{W}::

V650		::{W}:{W}:{W}:{W}:{W}
V651		{W}::{W}:{W}:{W}:{W}
V652		{W}:{W}::{W}:{W}:{W}
V653		{W}:{W}:{W}::{W}:{W}
V654		{W}:{W}:{W}:{W}::{W}
V655		{W}:{W}:{W}:{W}:{W}::

V640		::{W}:{W}:{W}:{W}
V641		{W}::{W}:{W}:{W}
V642		{W}:{W}::{W}:{W}
V643		{W}:{W}:{W}::{W}
V644		{W}:{W}:{W}:{W}::

V630		::{W}:{W}:{W}
V631		{W}::{W}:{W}
V632		{W}:{W}::{W}
V633		{W}:{W}:{W}::

V620		::{W}:{W}
V621		{W}::{W}
V622		{W}:{W}::

V610		::{W}
V611		{W}::

V600		::

V6604		{W}:{W}:{W}:{W}:{W}:{W}:{N}\.{N}\.{N}\.{N}

V6504		::{W}:{W}:{W}:{W}:{W}:{N}\.{N}\.{N}\.{N}
V6514		{W}::{W}:{W}:{W}:{W}:{N}\.{N}\.{N}\.{N}
V6524		{W}:{W}::{W}:{W}:{W}:{N}\.{N}\.{N}\.{N}
V6534		{W}:{W}:{W}::{W}:{W}:{N}\.{N}\.{N}\.{N}
V6544		{W}:{W}:{W}:{W}::{W}:{N}\.{N}\.{N}\.{N}
V6554		{W}:{W}:{W}:{W}:{W}::{N}\.{N}\.{N}\.{N}

V6404		::{W}:{W}:{W}:{W}:{N}\.{N}\.{N}\.{N}
V6414		{W}::{W}:{W}:{W}:{N}\.{N}\.{N}\.{N}
V6424		{W}:{W}::{W}:{W}:{N}\.{N}\.{N}\.{N}
V6434		{W}:{W}:{W}::{W}:{N}\.{N}\.{N}\.{N}
V6444		{W}:{W}:{W}:{W}::{N}\.{N}\.{N}\.{N}

V6304		::{W}:{W}:{W}:{N}\.{N}\.{N}\.{N}
V6314		{W}::{W}:{W}:{N}\.{N}\.{N}\.{N}
V6324		{W}:{W}::{W}:{N}\.{N}\.{N}\.{N}
V6334		{W}:{W}:{W}::{N}\.{N}\.{N}\.{N}

V6204		::{W}:{W}:{N}\.{N}\.{N}\.{N}
V6214		{W}::{W}:{N}\.{N}\.{N}\.{N}
V6224		{W}:{W}::{N}\.{N}\.{N}\.{N}

V6104		::{W}:{N}\.{N}\.{N}\.{N}
V6114		{W}::{N}\.{N}\.{N}\.{N}

V6004		::{N}\.{N}\.{N}\.{N}


V6		({V680}|{V670}|{V671}|{V672}|{V673}|{V674}|{V675}|{V676}|{V677}|{V660}|{V661}|{V662}|{V663}|{V664}|{V665}|{V666}|{V650}|{V651}|{V652}|{V653}|{V654}|{V655}|{V640}|{V641}|{V642}|{V643}|{V644}|{V630}|{V631}|{V632}|{V633}|{V620}|{V621}|{V622}|{V610}|{V611}|{V600}|{V6604}|{V6504}|{V6514}|{V6524}|{V6534}|{V6544}|{V6554}|{V6404}|{V6414}|{V6424}|{V6434}|{V6444}|{V6304}|{V6314}|{V6324}|{V6334}|{V6204}|{V6214}|{V6224}|{V6104}|{V6114}|{V6004})

MAC		({B}:{B}:{B}:{B}:{B}:{B}|{B}\-{B}\-{B}\-{B}\-{B}\-{B}|{B}\.{B}\.{B}\.{B}\.{B}\.{B}|{B2}\.{B2}\.{B2}|{B2}{3})



%%
dst		return DST;
src		return SRC;

link|ether|ppp|slip  return LINK;
fddi|tr|wlan	return LINK;
arp		return ARP;
rarp		return RARP;
ip		return IP;
sctp		return SCTP;
tcp		return TCP;
udp		return UDP;
icmp		return ICMP;
igmp		return IGMP;
igrp		return IGRP;
pim		return PIM;
vrrp		return VRRP;
carp		return CARP;
radio		return RADIO;

ip6		return IPV6;
icmp6		return ICMPV6;
ah		return AH;
esp		return ESP;

atalk		return ATALK;
aarp		return AARP;
decnet		return DECNET;
lat		return LAT;
sca		return SCA;
moprc		return MOPRC;
mopdl		return MOPDL;

iso		return ISO;
esis		return ESIS;
es-is		return ESIS;
isis		return ISIS;
is-is		return ISIS;
l1              return L1;
l2              return L2;
iih             return IIH;
lsp             return LSP;
snp             return SNP;
csnp            return CSNP;
psnp            return PSNP;

clnp		return CLNP;

stp		return STP;

ipx		return IPX;

netbeui		return NETBEUI;

host		return HOST;
net		return NET;
mask		return NETMASK;
port		return PORT;
portrange	return PORTRANGE;
proto		return PROTO;
protochain	return PROTOCHAIN;

gateway		return GATEWAY;

type		return TYPE;
subtype		return SUBTYPE;
direction|dir	return DIR;
address1|addr1	return ADDR1;
address2|addr2	return ADDR2;
address3|addr3	return ADDR3;
address4|addr4	return ADDR4;
ra		return RA;
ta		return TA;

less		return LESS;
greater		return GREATER;
byte		return CBYTE;
broadcast	return TK_BROADCAST;
multicast	return TK_MULTICAST;

and|"&&"	return AND;
or|"||"		return OR;
not		return '!';

len|length	return LEN;
inbound		return INBOUND;
outbound	return OUTBOUND;

vlan		return VLAN;
mpls		return MPLS;
pppoed		return PPPOED;
pppoes		return PPPOES;
geneve		return GENEVE;

lane		return LANE;
llc		return LLC;
metac		return METAC;
bcc		return BCC;
oam		return OAM;
oamf4		return OAMF4;
oamf4ec		return OAMF4EC;
oamf4sc		return OAMF4SC;
sc		return SC;
ilmic		return ILMIC;
vpi		return VPI;
vci		return VCI;
connectmsg	return CONNECTMSG;
metaconnect	return METACONNECT;

on|ifname	return PF_IFNAME;
rset|ruleset	return PF_RSET;
rnr|rulenum	return PF_RNR;
srnr|subrulenum	return PF_SRNR;
reason		return PF_REASON;
action		return PF_ACTION;

fisu		return FISU;
lssu		return LSSU;
lsu		return LSSU;
msu		return MSU;
hfisu		return HFISU;
hlssu		return HLSSU;
hmsu		return HMSU;
sio		return SIO;
opc		return OPC;
dpc		return DPC;
sls		return SLS;
hsio		return HSIO;
hopc		return HOPC;
hdpc		return HDPC;
hsls		return HSLS;

[ \r\n\t]		;
[+\-*/%:\[\]!<>()&|\^=]	return yytext[0];
">="			return GEQ;
"<="			return LEQ;
"!="			return NEQ;
"=="			return '=';
"<<"			return LSH;
">>"			return RSH;
${B}			{ yylval->s = sdup(yyextra, yytext); return AID; }
{MAC}			{ yylval->s = sdup(yyextra, yytext); return EID; }
{N}			{ yylval->i = stoi((char *)yytext); return NUM; }
({N}\.{N})|({N}\.{N}\.{N})|({N}\.{N}\.{N}\.{N})	{
			yylval->s = sdup(yyextra, (char *)yytext); return HID; }
{V6}			{
#ifdef INET6
			  struct addrinfo hints, *res;
			  memset(&hints, 0, sizeof(hints));
			  hints.ai_family = AF_INET6;
			  hints.ai_flags = AI_NUMERICHOST;
			  if (getaddrinfo(yytext, NULL, &hints, &res)) {
				bpf_set_error(yyextra, "bogus IPv6 address %s", yytext);
				yylval->s = NULL;
			  } else {
				freeaddrinfo(res);
				yylval->s = sdup(yyextra, (char *)yytext);
			  }
#else
			  bpf_set_error(yyextra, "IPv6 address %s not supported", yytext);
			  yylval->s = NULL;
#endif /*INET6*/
			  return HID6;
			}
{B}:+({B}:+)+		{ bpf_set_error(yyextra, "bogus ethernet address %s", yytext); yylval->s = NULL; return EID; }
icmptype		{ yylval->i = 0; return NUM; }
icmpcode		{ yylval->i = 1; return NUM; }
icmp-echoreply		{ yylval->i = 0; return NUM; }
icmp-unreach		{ yylval->i = 3; return NUM; }
icmp-sourcequench	{ yylval->i = 4; return NUM; }
icmp-redirect		{ yylval->i = 5; return NUM; }
icmp-echo		{ yylval->i = 8; return NUM; }
icmp-routeradvert	{ yylval->i = 9; return NUM; }
icmp-routersolicit	{ yylval->i = 10; return NUM; }
icmp-timxceed		{ yylval->i = 11; return NUM; }
icmp-paramprob		{ yylval->i = 12; return NUM; }
icmp-tstamp		{ yylval->i = 13; return NUM; }
icmp-tstampreply	{ yylval->i = 14; return NUM; }
icmp-ireq		{ yylval->i = 15; return NUM; }
icmp-ireqreply		{ yylval->i = 16; return NUM; }
icmp-maskreq		{ yylval->i = 17; return NUM; }
icmp-maskreply		{ yylval->i = 18; return NUM; }

icmp6type       { yylval->i = 0; return NUM; }
icmp6code       { yylval->i = 1; return NUM; }

icmp6-echo      { yylval->i = 128; return NUM; }
icmp6-echoreply { yylval->i = 129; return NUM; }
icmp6-multicastlistenerquery    { yylval->i = 130; return NUM; }
icmp6-multicastlistenerreportv1 { yylval->i = 131; return NUM; }
icmp6-multicastlistenerdone     { yylval->i = 132; return NUM; }
icmp6-routersolicit   { yylval->i = 133; return NUM; }
icmp6-routeradvert    { yylval->i = 134; return NUM; }
icmp6-neighborsolicit { yylval->i = 135; return NUM; }
icmp6-neighboradvert  { yylval->i = 136; return NUM; }
icmp6-redirect    { yylval->i = 137; return NUM; }
icmp6-routerrenum { yylval->i = 138; return NUM; }
icmp6-nodeinformationquery      { yylval->i = 139; return NUM; }
icmp6-nodeinformationresponse   { yylval->i = 140; return NUM; }
icmp6-ineighbordiscoverysolicit { yylval->i = 141; return NUM; }
icmp6-ineighbordiscoveryadvert  { yylval->i = 142; return NUM; }
icmp6-multicastlistenerreportv2 { yylval->i = 143; return NUM; }
icmp6-homeagentdiscoveryrequest { yylval->i = 144; return NUM; }
icmp6-homeagentdiscoveryreply   { yylval->i = 145; return NUM; }
icmp6-mobileprefixsolicit       { yylval->i = 146; return NUM; }
icmp6-mobileprefixadvert        { yylval->i = 147; return NUM; }
icmp6-certpathsolicit           { yylval->i = 148; return NUM; }
icmp6-certpathadvert            { yylval->i = 149; return NUM; }
icmp6-multicastrouteradvert     { yylval->i = 151; return NUM; }
icmp6-multicastroutersolicit    { yylval->i = 152; return NUM; }
icmp6-multicastrouterterm       { yylval->i = 153; return NUM; }

tcpflags		{ yylval->i = 13; return NUM; }
tcp-fin			{ yylval->i = 0x01; return NUM; }
tcp-syn			{ yylval->i = 0x02; return NUM; }
tcp-rst			{ yylval->i = 0x04; return NUM; }
tcp-push		{ yylval->i = 0x08; return NUM; }
tcp-ack			{ yylval->i = 0x10; return NUM; }
tcp-urg			{ yylval->i = 0x20; return NUM; }
tcp-ece			{ yylval->i = 0x40; return NUM; }
tcp-cwr			{ yylval->i = 0x80; return NUM; }
[A-Za-z0-9]([-_.A-Za-z0-9]*[.A-Za-z0-9])? {
			 yylval->s = sdup(yyextra, (char *)yytext); return ID; }
"\\"[^ !()\n\t]+	{ yylval->s = sdup(yyextra, (char *)yytext + 1); return ID; }
.			{ return LEX_ERROR; }
%%

/*
 * Turn diagnostics back on, so we check the code that we've written.
 */
DIAG_ON_FLEX

/* Hex digit to integer. */
static inline int
xdtoi(int c)
{
	if (isdigit(c))
		return c - '0';
	else if (islower(c))
		return c - 'a' + 10;
	else
		return c - 'A' + 10;
}

/*
 * Convert string to integer.  Just like atoi(), but checks for
 * preceding 0x or 0 and uses hex or octal instead of decimal.
 */
static int
stoi(char *s)
{
	int base = 10;
	int n = 0;

	if (*s == '0') {
		if (s[1] == 'x' || s[1] == 'X') {
			s += 2;
			base = 16;
		}
		else {
			base = 8;
			s += 1;
		}
	}
	while (*s)
		n = n * base + xdtoi(*s++);

	return n;
}
