/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jdbc4;

import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.DataSource;
import virtuoso.jdbc4.VirtuosoConnection;
import virtuoso.jdbc4.VirtuosoException;

public class VirtuosoDataSource
implements DataSource,
Referenceable,
Serializable {
    protected String dataSourceName = "VirtuosoDataSourceName";
    protected String description;
    protected String serverName = "localhost";
    protected String portNumber = "1111";
    protected String databaseName;
    protected String user = "dba";
    protected String password = "dba";
    protected String charSet;
    protected int loginTimeout = 0;
    protected String pwdclear;
    protected String certificate;
    protected String certificatepass;
    protected String keystorepass;
    protected String keystorepath;
    protected String provider;
    protected int fbs = 0;
    protected int sendbs = 0;
    protected int recvbs = 0;
    protected boolean roundrobin = false;
    protected boolean usepstmtpool = false;
    protected int pstmtpoolsize = 0;
    protected transient PrintWriter logWriter;
    static final String n_dataSourceName = "dataSourceName";
    static final String n_description = "description";
    static final String n_serverName = "serverName";
    static final String n_portNumber = "portNumber";
    static final String n_databaseName = "databaseName";
    static final String n_user = "user";
    static final String n_password = "password";
    static final String n_charSet = "charSet";
    static final String n_loginTimeout = "loginTimeout";
    static final String n_pwdclear = "pwdclear";
    static final String n_certificate = "certificate";
    static final String n_certificatepass = "certificatepass";
    static final String n_keystorepass = "keystorepass";
    static final String n_keystorepath = "keystorepath";
    static final String n_provider = "provider";
    static final String n_fbs = "fbs";
    static final String n_sendbs = "sendbs";
    static final String n_recvbs = "recvbs";
    static final String n_roundrobin = "roundrobin";
    static final String n_usepstmtpool = "usepstmtpool";
    static final String n_pstmtpoolsize = "pstmtpoolsize";

    protected void addProperties(Reference reference) {
        if (this.dataSourceName != null) {
            reference.add(new StringRefAddr(n_dataSourceName, this.dataSourceName));
        }
        if (this.description != null) {
            reference.add(new StringRefAddr(n_description, this.description));
        }
        if (this.serverName != null) {
            reference.add(new StringRefAddr(n_serverName, this.serverName));
        }
        if (this.portNumber != null) {
            reference.add(new StringRefAddr(n_portNumber, this.portNumber));
        }
        if (this.databaseName != null) {
            reference.add(new StringRefAddr(n_databaseName, this.databaseName));
        }
        if (this.user != null) {
            reference.add(new StringRefAddr(n_user, this.user));
        }
        if (this.password != null) {
            reference.add(new StringRefAddr(n_password, this.password));
        }
        if (this.loginTimeout != 0) {
            reference.add(new StringRefAddr(n_loginTimeout, String.valueOf(this.loginTimeout)));
        }
        if (this.charSet != null) {
            reference.add(new StringRefAddr(n_charSet, this.charSet));
        }
        if (this.pwdclear != null) {
            reference.add(new StringRefAddr(n_pwdclear, this.pwdclear));
        }
        if (this.certificate != null) {
            reference.add(new StringRefAddr(n_certificate, this.certificate));
        }
        if (this.certificatepass != null) {
            reference.add(new StringRefAddr(n_certificatepass, this.certificatepass));
        }
        if (this.keystorepass != null) {
            reference.add(new StringRefAddr(n_keystorepass, this.keystorepass));
        }
        if (this.keystorepath != null) {
            reference.add(new StringRefAddr(n_keystorepath, this.keystorepath));
        }
        if (this.provider != null) {
            reference.add(new StringRefAddr(n_provider, this.provider));
        }
        if (this.fbs != 0) {
            reference.add(new StringRefAddr(n_fbs, String.valueOf(this.fbs)));
        }
        if (this.sendbs != 0) {
            reference.add(new StringRefAddr(n_sendbs, String.valueOf(this.sendbs)));
        }
        if (this.recvbs != 0) {
            reference.add(new StringRefAddr(n_recvbs, String.valueOf(this.recvbs)));
        }
        reference.add(new StringRefAddr(n_roundrobin, String.valueOf(this.roundrobin)));
        reference.add(new StringRefAddr(n_usepstmtpool, String.valueOf(this.usepstmtpool)));
        if (this.pstmtpoolsize != 0) {
            reference.add(new StringRefAddr(n_pstmtpoolsize, String.valueOf(this.pstmtpoolsize)));
        }
    }

    @Override
    public Reference getReference() throws NamingException {
        Reference reference = new Reference(this.getClass().getName(), "virtuoso.jdbc4.VirtuosoDataSourceFactory", null);
        this.addProperties(reference);
        return reference;
    }

    protected Properties createConnProperties() {
        Properties properties = new Properties();
        String string = this.serverName;
        if (this.serverName.indexOf(58) == -1 && this.serverName.indexOf(44) == -1 && this.portNumber != "1111") {
            string = string + ":" + this.portNumber;
        }
        properties.setProperty("_vhost", string);
        if (this.databaseName != null) {
            properties.setProperty("database", this.databaseName);
        }
        if (this.user != null) {
            properties.setProperty(n_user, this.user);
        }
        if (this.password != null) {
            properties.setProperty(n_password, this.password);
        }
        if (this.loginTimeout != 0) {
            properties.setProperty("timeout", String.valueOf(this.loginTimeout));
        }
        if (this.charSet != null) {
            properties.setProperty("charset", this.charSet);
        }
        if (this.pwdclear != null) {
            properties.setProperty(n_pwdclear, this.pwdclear);
        }
        if (this.certificate != null) {
            properties.setProperty(n_certificate, this.certificate);
        }
        if (this.certificatepass != null) {
            properties.setProperty(n_certificatepass, this.certificatepass);
        }
        if (this.keystorepass != null) {
            properties.setProperty(n_keystorepass, this.keystorepass);
        }
        if (this.keystorepath != null) {
            properties.setProperty(n_keystorepath, this.keystorepath);
        }
        if (this.provider != null) {
            properties.setProperty(n_provider, this.provider);
        }
        if (this.fbs != 0) {
            properties.setProperty(n_fbs, String.valueOf(this.fbs));
        }
        if (this.sendbs != 0) {
            properties.setProperty(n_sendbs, String.valueOf(this.sendbs));
        }
        if (this.recvbs != 0) {
            properties.setProperty(n_recvbs, String.valueOf(this.recvbs));
        }
        if (this.roundrobin) {
            properties.setProperty(n_roundrobin, "1");
        }
        if (this.usepstmtpool) {
            properties.setProperty(n_usepstmtpool, "1");
        }
        if (this.pstmtpoolsize != 0) {
            properties.setProperty(n_pstmtpoolsize, String.valueOf(this.pstmtpoolsize));
        }
        return properties;
    }

    protected String create_url_key(String string, Properties properties) {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append(string);
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            stringBuffer.append(string2);
            stringBuffer.append('=');
            stringBuffer.append(properties.getProperty(string2));
            stringBuffer.append('/');
        }
        return stringBuffer.toString();
    }

    protected String create_url() {
        String string = "jdbc:virtuoso://" + this.serverName;
        if (this.serverName.indexOf(58) == -1 && this.serverName.indexOf(44) == -1 && this.portNumber != "1111") {
            string = string + ":" + this.portNumber;
        }
        return string;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(null, null);
    }

    @Override
    public Connection getConnection(String string, String string2) throws SQLException {
        String string3 = this.create_url();
        Properties properties = this.createConnProperties();
        if (this.user != null) {
            properties.setProperty(n_user, this.user);
        }
        if (string2 != null) {
            properties.setProperty(n_password, string2);
        }
        return new VirtuosoConnection(string3, "localhost", 1111, properties);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.logWriter;
    }

    @Override
    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        this.logWriter = printWriter;
    }

    @Override
    public void setLoginTimeout(int n) throws SQLException {
        this.loginTimeout = n;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.loginTimeout;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String string) {
        this.dataSourceName = string;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setServerName(String string) {
        this.serverName = string;
    }

    public String getServerName() {
        return this.serverName;
    }

    public int getPortNumber() {
        return Integer.parseInt(this.portNumber);
    }

    public void setPortNumber(int n) {
        this.portNumber = String.valueOf(n);
    }

    public void setUser(String string) {
        this.user = string;
    }

    public String getUser() {
        return this.user;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public String getPassword() {
        return this.password;
    }

    public void setDatabaseName(String string) {
        this.databaseName = string;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setCharset(String string) {
        this.charSet = string;
    }

    public String getCharset() {
        return this.charSet;
    }

    public void setPwdClear(String string) {
        this.pwdclear = string;
    }

    public String getPwdClear() {
        return this.pwdclear;
    }

    public void setCertificate(String string) {
        this.certificate = string;
    }

    public String getCertificate() {
        return this.certificate;
    }

    public void setCertificatepass(String string) {
        this.certificatepass = string;
    }

    public String getCertificatepass() {
        return this.certificatepass;
    }

    public void setKeystorepass(String string) {
        this.keystorepass = string;
    }

    public String getKeystorepass() {
        return this.keystorepass;
    }

    public void setKeystorepath(String string) {
        this.keystorepath = string;
    }

    public String getKeystorepath() {
        return this.keystorepath;
    }

    public void setProvider(String string) {
        this.provider = string;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setFbs(int n) {
        this.fbs = n;
    }

    public int getFbs() {
        return this.fbs;
    }

    public void setSendbs(int n) {
        this.sendbs = n;
    }

    public int getSendbs() {
        return this.sendbs;
    }

    public void setRecvbs(int n) {
        this.recvbs = n;
    }

    public int getRecvbs() {
        return this.recvbs;
    }

    public void setRoundrobin(boolean bl) {
        this.roundrobin = bl;
    }

    public boolean getRoundrobin() {
        return this.roundrobin;
    }

    public void setUsepstmtpool(boolean bl) {
        this.usepstmtpool = bl;
    }

    public boolean getUsepstmtpool() {
        return this.usepstmtpool;
    }

    public void setPstmtpoolsize(int n) {
        this.pstmtpoolsize = n;
    }

    public int getPstmtpoolsize() {
        return this.pstmtpoolsize;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        try {
            return clazz.cast(this);
        }
        catch (ClassCastException classCastException) {
            throw new VirtuosoException("Unable to unwrap to " + clazz.toString(), 0);
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return clazz.isInstance(this);
    }
}

