#!/usr/bin/env python

import sys
import random
import string

def main():
    print "# generated by tokudb_fast_update_blobs_with_varchar.py"
    print "source include/have_tokudb.inc;"
    print "source include/have_innodb.inc;"
    print "set default_storage_engine='tokudb';"
    print "disable_warnings;"
    print "drop table if exists t;"
    print "enable_warnings;"

    nrows = 10

    blob_types = [ 'tinyblob', 'blob', 'mediumblob', 'longblob' ]
    for a in blob_types:
        for b in blob_types:
            for c in blob_types:
                for n in [ 'null', 'not null' ]:
                    for v in [ 'varchar(32)', 'varchar(256)' ]:
                        test_blobs([ a, b, c ] , v, n, nrows)
    return 0

def test_blobs(cols, v, n, nrows):
    print "create table tt (id bigint unsigned primary key,"
    print "    v0 %s %s," % (v, n)
    for i in range(len(cols)):
        if i < len(cols)-1:
            print "    b%d %s %s," % (i, cols[i], n)
        else:
            print "    b%d %s %s" % (i, cols[i], n)
    print ") engine=tokudb;"

    for id in range(1,nrows):
        if n == 'null':
            print "insert into tt (id) values (%d);" % (id)
        else:
            print "insert into tt values (%d,'','','','');" % (id)

    print "create table ti like tt;"
    print "alter table ti engine=innodb;"
    print "insert into ti select * from tt;"

    for id in range(1,nrows):
        for i in range(3):
            long_str = ''.join(random.choice(string.ascii_uppercase + string.digits) for x in range(random.randint(1,32)))
            print "update noar tt set v%d='%s' where id=%d;" % (0, long_str, id)
            print "update noar ti set v%d='%s' where id=%d;" % (0, long_str, id)

            long_str = ''.join(random.choice(string.ascii_uppercase + string.digits) for x in range(random.randint(1,32)))
            print "update noar tt set b%d='%s' where id=%d;" % (i, long_str, id)
            print "update noar ti set b%d='%s' where id=%d;" % (i, long_str, id)

    print "let $diff_tables = test.tt, test.ti;"
    print "source include/diff_tables.inc;"

    print "drop table tt, ti;"

sys.exit(main())
