.\" Man page for man (and the former manpath)
.\"
.\" Copyright (c) 1990, 1991, John W. Eaton.
.\"
.\" You may distribute under the terms of the GNU General Public
.\" License as specified in the README file that comes with the man 1.0
.\" distribution.  
.\"
.\" John W. Eaton
.\" jwe@che.utexas.edu
.\" Department of Chemical Engineering
.\" The University of Texas at Austin
.\" Austin, Texas  78712
.\"
.\" Many changes - aeb
.\"
.\" Tumaczenie - 950322 Rafa Maszkowski <rzm@pdi.net>
.\" 960619 - aktualizacja -K
.\" 20011102 - aktualizacja do wersji z man-1.5i2, czciowo w oparciu
.\"            o alternatywne tumaczenie PB z PTM - AMK
.\"
.TH man 1 "2 wrzenia 1995"
.LO 1
.SH NAZWA
man \- formatowanie i wywietlanie dostpnych stron podrcznika man
.br
manpath \- wyznaczanie cieki poszukiwania stron podrcznika odpowiedniej dla
danego uytkownika
.SH SKADNIA
.TP 4
.B man
.RB [ \-adfhkKtwW ]
.RB [ \-m
.IR system ]
.RB [ \-p
.IR acuch_znakw ]
.RB [\-C
.IR plik_konfiguracyjny ]
.RB [ \-M
.IR cieka ]
.RB [ \-P
.IR pager ]
.RB [ \-S
.IR lista_rozdziaw ]
.RI [ rozdzia ]
.IR nazwa ...
.SH OPIS
.B man
formatuje i wywietla dostpne w systemie strony podrcznika man.
.\" Ta wersja sprawdza zmienne rodowiskowe
.\" .B MANPATH
.\" i
.\" .BR (MAN)PAGER ,
.\" wic moesz mie swj wasny zestaw stron podrcznika man i wybra do ich
.\" wywietlania ulubiony program.
Jeeli zostanie podany
.IR rozdzia ,
.B man
sprawdza tylko ten rozdzia podrcznika.
.\" Uywajc opcji lub zmiennych rodowiskowych moesz take poda porzdek,
.\" w jakim naley przeszukiwa rozdziay oraz jakie preprocesory powinny
.\" zosta uyte do wstpnego przetworzenia stron.
Jeeli
.I nazwa
zawiera znak /, to man prbuje najpierw znale podany plik, wic mona np.
wyda polecenie
.B "man ./foo.5"
a nawet
.B "man /cd/foo/bar.1.gz\fR.\fP"
.PP
Niej znajdziesz informacje, gdzie
.B man
szuka plikw stron podrcznika.

.SH OPCJE
.TP
.B \-\^C " plik_konfiguracyjny"
Okrela plik konfiguracyjny, ktrego naley uy. Domylnym jest
.BR @man_config_file@ .
(Zobacz
.BR man.conf (5).)
.TP
.B \-\^M " cieka"
Okrela list katalogw, w ktrych bd szukane strony podrcznika man.
Katalogi naley rozdziela dwukropkami. Pusta lista jest rwnoznaczna z nie
podaniem tej opcji. Zobacz
.BR "CIEKA PRZESZUKIWANIA DLA STRON PODRCZNIKA" .
.TP
.B \-\^P " pager"
Okrela, ktry pager ma zosta uyty.  Jeeli podana jest ta opcja,
ignorowana jest zmienna rodowiskowa
.BR MANPAGER ,
ktrej uycie z kolei powoduje zignorowanie zmiennej rodowiskowej
.BR PAGER .
Domylnie
.B man
uywa
.BR @pager@ .
.TP
.B \-\^S " lista_rozdziaw"
Rozdzielona dwukropkami lista rozdziaw podrcznika, ktre maj by
przeszukane. Jeeli podana jest ta opcja, zmienna rodowiskowa
.B MANSECT
jest ignorowana.
.TP
.B \-\^a
Domylnie man koczy dziaanie po wywietleniu pierwszej znalezionej
strony. Podanie tej opcji powoduje wywietlenie wszystkich stron
podrcznika, ktre pasuj do
.BR nazwa , 
a nie tylko pierwszej.
.TP
.B \-\^c
Przeformatowuje rdow stron podrcznika, nawet jeeli istnieje aktualna
strona cat. Moe to by istotne, jeeli strona cat jest sformatowana
dla ekranu z inn liczb kolumn.
.TP
.B \-\^d
Zamiast stron podrcznika wywietla mnstwo informacji diagnostycznych.
.TP
.B \-\^D
Wywietla zarwno stron podrcznika jak i informacje diagnostyczne.
.TP
.B \-\^f
Rwnowane
.BR whatis .
.TP
.B \-\^h
Wywietla krtk informacj pomocy i koczy prac.
.TP
.B \-\^k
Rwnowane
.BR apropos .
.TP
.B \-\^K
Szuka podanego acucha znakw we *wszystkich* stronach podrcznika. Uwaga:
bdzie to prawdopodobnie bardzo powolne! Podanie rozdziaw pomaga
przyspieszy szukanie. (Dla oglnej orientacji: na mojej maszynie zajmuje to
ok. minuty na kade 500 stron podrcznika.)
.TP
.B \-\^m " system"
Podanie alternatywnego zestawu stron podrcznika, odpowiedniego dla
systemu o podanej nazwie.
.TP
.B \-\^p " acuch_znakw"
Podanie listy nazw preprocesorw, ktore zostan uruchomione przed
.B nroff
i
.BR troff .
Nie wszystkie intalacje maj peny zestaw preprocesorw.
Niektre z nich oraz oznaczajce je litery to:
eqn (e), grap (g), pic (p), tbl (t), vgrind (v), refer (r).
Podanie tej opcji powoduje zignorowanie zmiennej rodowiskowej
.BR MANROFFSEQ .
.TP
.B \-\^t
Sformatuj stron podrcznika za pomoc
.BR @troff@ ,
a wynik wylij na
.B stdout
(standardowe wyjcie).
Moe by konieczne przepuszczenie wyniku z
.B @troff@
przez jaki filtr przed wydrukowaniem.
.TP
.B \-\^w \fRlub\fP \-\-path
Nie wywietlaj stron podrcznika, podaj tylko gdzie znajduj si pliki, ktre
byyby sformatowane i wywietlone. Jeeli nie podano adnych argumentw:
wywietla (na stdout) list katalogw, w ktrych
.B man
poszukuje stron podrcznika. Jeeli
.B manpath
jest dowizaniem man to "manpath" jest rwnowane "man --path".
.TP
.B \-\^W
Podobne do \-\^w, lecz podaje nazwy plikw, kad w osobnej linii, bez
dodatkowych informacji. Przydaje si w poleceniach powoki, np.
.ft CW
.B "man -aW man | xargs ls -l"
.ft

.SH "STRONY CAT"
Man bdzie prbowa zachowa sformatowane strony podrcznika aby
skrci czas potrzebny na sformatowanie ich po raz kolejny,
kiedy te strony bd znowu potrzebne.
Tradycyjnie, sformatowane wersje stron podrcznika z katalogu DIR/manX s
zachowywane w DIR/catX, ale mona te w pliku
.BR @man_config_file@
okreli inne zasady.
Strony cat nie s tworzone, jeeli wymagany katalog nie istnieje.
.PP
Moliwe jest uczynienie programu
.B man
suidowym na uytkownika man. Wtedy, jeli katalogi cat maj waciciela man
i prawa dostpu 0755 (zapisywalne tylko przez uytkownika man), a pliki cat
maj waciciela man i prawa dostpu 0644 lub 0444 (zapisywalne przez
uytkownika man lub przez nikogo), to aden zwyky uytkownik nie moe
zmienia stron cat lub umieszcza w katalogach cat innych plikw. Jeeli
.B man
nie jest suidowy to katalog cat powinien mie prawa dostpu 0777,
o ile wszyscy uytkownicy powinni mie moliwo pozostawiania tam stron cat.
.PP
Opcja
.B \-c
wymusza przeformatowanie strony nawet jeeli istnieje ju odpowiednia strona
cat.


.SH "CIEKA PRZESZUKIWANIA DLA STRON PODRCZNIKA"
.B man
stosuje wymyln metod poszukiwania plikw stron podrcznika, opart na
opcjach wywoania, zmiennych rodowiskowych, pliku konfiguracyjnym
.B @man_config_file@
oraz na pewnych wbudowanych konwencjach i heurystyce.
.PP
Najpierw, gdy argument
.I nazwa
polecenia
.B man
zawiera ukonik
.RB ( / ),
.B man
zakada, e jest on nazw waciwego pliku i nie prowadzi poszukiwania.
.PP
Ale zazwyczaj, gdy
.I nazwa
nie zawiera ukonika,
.B man
poszukuje pliku, ktry mgby stanowi stron podrcznika o zadanym temacie,
w rnych katalogach.
.PP
Jeli zostanie podana opcja
.BI "-M " cieka\fR,
to
.I cieka
jest rozdzielon dwukropkami list przeszukiwanych przez program
.B man
katalogw.
.PP
Gdy opcja
.B -M
nie zostanie podana, ale zostanie zdefiniowana zmienna rodowiskowa
.BR MANPATH ,
warto tej zmiennej stanowi list przeszukiwanych przez program
.B man
katalogw.
.PP
Jeli cieka nie zostanie podana w sposb jawny ani za pomoc
.B -M
ani poprzez
.BR MANPATH ,
.B man
rozwija swoj wasn ciek w oparciu o zawarto pliku konfiguracyjnego
.BR @man_config_file@ .
Instrukcje
.B MANPATH
w pliku konfiguracyjnym okrelaj poszczeglne katalogi wczane do cieki
przeszukiwania.
.PP
Ponadto, instrukcje
.B MANPATH_MAP
dodaj do cieki przeszukiwania katalogi zalene od cieki przeszukiwania
dla polece (tzn. zawartej w zmiennej rodowiskowej
.B PATH
).
Instrukcja
.B MANPATH_MAP
dodaje do cieki przeszukiwania dla stron podrcznika po jednym katalogu dla
kadego katalogu zawartego w ciece przeszukiwania dla polece.
.B man
przeglda zmienn
.B PATH
i dodaje odpowiednie katalogi do cieki przeszukiwania dla stron podrcznika.
Zatem przy waciwym uyciu
.BR MANPATH_MAP ,
po wydaniu polecenia
.BR "man xyz" ,
otrzyma si stron podrcznika dla programu, ktry zostaby uruchomiony
poprzez wydanie polecenia
.BR xyz .
.PP
Dodatkowo, dla kadego katalogu w ciece przeszukiwania dla polece
(bdziemy go nazywa "katalogiem polece"), dla ktrego
.I nie
ma instrukcji
.BR MANPATH_MAP ,
.B man
automatycznie poszukuje "bliskiego" katalogu stron podrcznika jako
podkatalogu waciwego katalogu polece lub w katalogu nadrzdnym dla katalogu
polece.
.PP
Mona wyczy automatyczne "bliskie" przeszukiwania doczajc instrukcj
.B NOAUTOPATH
do
.BR @man_config_file@ .
.PP
Jak opisano powyej, w kadym z katalogw cieki przeszukiwania
.B man
poszukuje pliku o nazwie
.IB tytu . rozdzia\fR,
z opcjonalnym przyrostkiem dla numeru rozdziau i moliwym przyrostkiem
kompresji. Jeli nie znajdzie takiego pliku, bdzie szuka w podkatalogach 
o nazwach
.BI man N
i
.BI cat N\fR,
gdzie
.I N
jest numerem rozdziau podrcznika.
Jeli plik znajduje si w podkatalogu
.BIR cat N ,
.B man
zakada, e jest to sformatowany plik strony podrcznika (cat page). 
W przeciwnym przypadku,
.B man
zakada, e jest ona niesformatowana. W obu przypadkach, jeli nazwa pliku
zawiera znany przyrostek kompresji (jak
.BR .gz ),
.B man
zakada, e jest ona spakowania gzipem.
.PP
Aby zobaczy, gdzie (lub czy)
.B man
znajdzie stron podrcznika o okrelonym tytule, naley posuyc si opcj
.BR "--path " ( -w ).

.SH "RODOWISKO"
.TP
.B MANPL
Jeli zmienna
.B MANPL
jest zdefinowana, to jej warto jest uywana do okrelenia dugoci strony.
W przeciwnym przypadku, caa strona podrcznika bdzie stanowi jedn (dug)
stron.
.TP
.B MANROFFSEQ
Jeli zmienna
.B MANROFFSEQ
jest zdefinowana, to jej warto jest uywana do zdefinowania zestawu
preprocesorw uruchamianych przed
.B nroff
i
.BR troff .
Domylnie strony s przepuszczane przez preprocesor tbl przed uyciem nroff.
.TP
.B MANSECT
Jeli zmienna
.B MANSECT
jest zdefiniowana, to jej warto jest uywana do okrelenia jakie rozdziay
podrcznika powinny zosta przeszukane.
.TP
.B MANWIDTH
Jeli zmienna
.B MANWIDTH
jest zdefiniowana, to jej warto jest uywana jako szeroko wywietlanych
stron podrcznika man. W przeciwnym wypadku, strony bd wywietlane na caej
szerokoci ekranu.
.TP
.B MANPAGER
Jeli zmienna
.B MANPAGER
jest zdefiniowana, to jej warto jest uywana jako nazwa programu do
wywietlania strony podrcznika man. Jeli nie jest zdefiniowana, to uywana
jest zmienna
.BR PAGER .
Jeeli ta rwnie nie ma nadanej wartoci, to uywany jest
.BR @pager@ .
.TP
.B LANG
Jeli zmienna
.B LANG
jest zdefiniowana, to jej warto okrela nazw podkatalogu, w ktrym man
najpierw bdzie szuka stron podrcznika. Zatem polecenie `LANG=pl man 1 co'
(w sh lub bash) spowoduje, e man bdzie szuka strony "co"
w .../pl/man1/co.1, a nastpnie, jeeli takiego pliku nie znajdzie,
w .../man1/co.1, gdzie ... jest katalogiem ze cieki przeszukiwania.
.TP
.B "NLSPATH, LC_MESSAGES, LANG"
Zmienne rodowiskowe
.B NLSPATH
i
.B LC_MESSAGES
(lub
.BR LANG ,
jeeli ta druga nie istnieje)
steruj przeszukiwaniem katalogw z komunikatami.
(Komunikaty angielskie s wkompilowane, wic dla angielskiego taki
katalog nie jest potrzebny.)
Zauwa, e programy takie jak
.BR col(1) ,
woane przez man, rwnie uywaj np. LC_TYPE.
.TP
.B PATH
.B PATH
pomaga okreli ciek przeszukiwania dla plikw stron podrcznika.
Zobacz
.BR "CIEKA PRZESZUKIWANIA DLA STRON PODRCZNIKA" .
.TP
.B SYSTEM
.B SYSTEM
jest uywana do pobierania domylnej alternatywnej nazwy systemu (do uywania
razem z opcj
.BR \-m ). 
.SH "ZOBACZ TAKE"
apropos(1), whatis(1), less(1), groff(1), man.conf(5).
.SH BDY
Opcja
.B \-t
dziaa tylko jeeli jest zainstalowany jaki program dziaajcy jak troff.
.br
Jeeli zamiast mylnikw pojawi si migajce \e255 lub <AD>, to naley
ustawi w rodowisku uytkownika `LESSCHARSET=latin1'.
.SH ZAKOCZENIE
Jeli do pliku
.IR .emacs
uytkownika dodana zostanie linia

  (global-set-key [(f1)] (lambda () (interactive) (manual-entry (current-word))))

to nacinicie F1 spowoduje wywietlenie strony podrcznika dla funkcji
bibliotecznej, na ktrej ustawiony jest kursor.
.LP
Aby uzyska czysto tekstow wersj strony podrcznika, bez cofni
i podkrele, naley wyda polecenie

  # man co | col -b > co.mantxt

